/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Document;
import org.icepdf.ri.util.Parse;
import org.icepdf.ri.util.Resources;

public class PropertiesManager {
    private static final Logger logger = Logger.getLogger(PropertiesManager.class.toString());
    private static final String DEFAULT_HOME_DIR = ".icesoft/icepdf_viewer";
    private static final String LOCK_FILE = "_syslock";
    private static final String USER_FILENAME = "pdfviewerri.properties";
    private static final String BACKUP_FILENAME = "old_pdfviewerri.properties";
    private static final String DEFAULT_PROP_FILE = "ICEpdfDefault.properties";
    private static final String DEFAULT_PROP_FILE_PATH = "org/icepdf/ri/viewer/res/";
    public static final String DEFAULT_MESSAGE_BUNDLE = "org.icepdf.ri.resources.MessageBundle";
    private static final String PROPERTY_DEFAULT_FILE_PATH = "application.defaultFilePath";
    private static final String PROPERTY_DEFAULT_URL = "application.defaultURL";
    public static final String PROPERTY_DIVIDER_LOCATION = "application.divider.location";
    public static final String PROPERTY_DEFAULT_PAGEFIT = "document.pagefitMode";
    public static final String PROPERTY_PRINT_MEDIA_SIZE_WIDTH = "document.print.mediaSize.width";
    public static final String PROPERTY_PRINT_MEDIA_SIZE_HEIGHT = "document.print.mediaSize.height";
    public static final String PROPERTY_PRINT_MEDIA_SIZE_UNIT = "document.print.mediaSize.unit";
    public static final String SYSPROPERTY_HIGHLIGHT_COLOR = "org.icepdf.core.views.page.text.highlightColor";
    public static final String PROPERTY_SHOW_TOOLBAR_UTILITY = "application.toolbar.show.utility";
    public static final String PROPERTY_SHOW_TOOLBAR_PAGENAV = "application.toolbar.show.pagenav";
    public static final String PROPERTY_SHOW_TOOLBAR_ZOOM = "application.toolbar.show.zoom";
    public static final String PROPERTY_SHOW_TOOLBAR_FIT = "application.toolbar.show.fit";
    public static final String PROPERTY_SHOW_TOOLBAR_ROTATE = "application.toolbar.show.rotate";
    public static final String PROPERTY_SHOW_TOOLBAR_TOOL = "application.toolbar.show.tool";
    public static final String PROPERTY_SHOW_TOOLBAR_ANNOTATION = "application.toolbar.show.annotation";
    public static final String PROPERTY_SHOW_STATUSBAR = "application.statusbar";
    public static final String PROPERTY_SHOW_STATUSBAR_STATUSLABEL = "application.statusbar.show.statuslabel";
    public static final String PROPERTY_SHOW_STATUSBAR_VIEWMODE = "application.statusbar.show.viewmode";
    public static final String PROPERTY_SHOW_UTILITY_OPEN = "application.toolbar.show.utility.open";
    public static final String PROPERTY_SHOW_UTILITY_SAVE = "application.toolbar.show.utility.save";
    public static final String PROPERTY_SHOW_UTILITY_PRINT = "application.toolbar.show.utility.print";
    public static final String PROPERTY_SHOW_UTILITY_SEARCH = "application.toolbar.show.utility.search";
    public static final String PROPERTY_SHOW_UTILITY_UPANE = "application.toolbar.show.utility.upane";
    public static final String PROPERTY_HIDE_UTILITYPANE = "application.utilitypane.hide";
    public static final String PROPERTY_SHOW_UTILITYPANE_BOOKMARKS = "application.utilitypane.show.bookmarks";
    public static final String PROPERTY_SHOW_UTILITYPANE_SEARCH = "application.utilitypane.show.search";
    public static final String PROPERTY_SHOW_UTILITYPANE_THUMBNAILS = "application.utilitypane.show.thumbs";
    public static final String PROPERTY_SHOW_UTILITYPANE_LAYERS = "application.utilitypane.show.layers";
    public static final String PROPERTY_SHOW_UTILITYPANE_ANNOTATION = "application.utilitypane.show.annotation";
    public static final String PROPERTY_SHOW_UTILITYPANE_ANNOTATION_FLAGS = "application.utilitypane.show.annotation.flags";
    public static final String PROPERTY_UTILITYPANE_THUMBNAILS_ZOOM = "application.utilitypane.thumbnail.zoom";
    public static final String PROPERTY_DEFAULT_ZOOM_LEVEL = "application.zoom.factor.default";
    public static final String PROPERTY_ZOOM_RANGES = "application.zoom.range.default";
    public static final String PROPERTY_SHOW_KEYBOARD_SHORTCUTS = "application.menuitem.show.keyboard.shortcuts";
    public static final String PROPERTY_VIEWPREF_HIDETOOLBAR = "application.viewerpreferences.hidetoolbar";
    public static final String PROPERTY_VIEWPREF_HIDEMENUBAR = "application.viewerpreferences.hidemenubar";
    public static final String PROPERTY_VIEWPREF_FITWINDOW = "application.viewerpreferences.fitwindow";
    String versionName = Document.getLibraryVersion();
    private boolean unrecoverableError = true;
    Properties sysProps;
    private ResourceBundle messageBundle;
    File userHome;
    private File dataDir;
    private File lockDir;
    private File propertyFile;
    private Date myLastModif = new Date();
    private Properties props;
    private Properties defaultProps;
    private boolean userRejectedCreatingLocalDataDir;
    private boolean thisExecutionTriedCreatingLocalDataDir;

    public PropertiesManager(Properties sysProps, ResourceBundle messageBundle) {
        this(sysProps, new Properties(), messageBundle);
    }

    public PropertiesManager(Properties sysProps, Properties props, ResourceBundle messageBundle) {
        this.sysProps = sysProps;
        this.messageBundle = messageBundle;
        if (!this.setupDefaultProperties()) {
            return;
        }
        if (props != null) {
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.props.setProperty(key, props.getProperty(key));
            }
        }
        this.setupHomeDir(null);
        this.loadProperties();
        this.recordMofifTime();
        this.setupLock();
        this.unrecoverableError = false;
    }

    public PropertiesManager(Properties sysProps, String propPath, ResourceBundle messageBundle) {
        this.sysProps = sysProps;
        this.messageBundle = messageBundle;
        if (!this.setupDefaultProperties()) {
            return;
        }
        if (propPath != null) {
            this.propertyFile = new File(propPath);
            this.loadProperties();
        }
        this.setupHomeDir(null);
        this.recordMofifTime();
        this.setupLock();
        if (propPath == null) {
            this.loadProperties();
        }
        this.unrecoverableError = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setupDefaultProperties() {
        this.defaultProps = new Properties();
        try {
            InputStream in = this.getResourceAsStream(DEFAULT_PROP_FILE_PATH, DEFAULT_PROP_FILE);
            try {
                this.defaultProps.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException ex) {
            if (this.getBoolean("application.showLocalStorageDialogs", true)) {
                Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.session.readError", DEFAULT_PROP_FILE);
            }
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Error loading default properties cache", ex);
            }
            return false;
        }
        this.props = this.defaultProps;
        return true;
    }

    boolean hasUserRejectedCreatingLocalDataDir() {
        return this.userRejectedCreatingLocalDataDir;
    }

    void setUserRejectedCreatingLocalDataDir() {
        this.userRejectedCreatingLocalDataDir = true;
    }

    boolean unrecoverableError() {
        return this.unrecoverableError;
    }

    private boolean ownLock() {
        return this.lockDir != null;
    }

    private void setupHomeDir(String homeString) {
        if (homeString == null) {
            homeString = this.sysProps.getProperty("swingri.home");
        }
        if (homeString != null) {
            this.dataDir = new File(homeString);
        } else {
            this.userHome = new File(this.sysProps.getProperty("user.home"));
            String dataDirStr = this.props.getProperty("application.datadir", DEFAULT_HOME_DIR);
            this.dataDir = new File(this.userHome, dataDirStr);
        }
        if (!this.dataDir.isDirectory()) {
            String path = this.dataDir.getAbsolutePath();
            boolean create = false;
            this.setUserRejectedCreatingLocalDataDir();
            if (!create) {
                this.dataDir = null;
            } else {
                this.dataDir.mkdirs();
                if (!this.dataDir.isDirectory()) {
                    if (this.getBoolean("application.showLocalStorageDialogs", true)) {
                        Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.failedCreation", this.dataDir.getAbsolutePath());
                    }
                    this.dataDir = null;
                }
                this.thisExecutionTriedCreatingLocalDataDir = true;
            }
        }
    }

    private void setupLock() {
        if (this.dataDir == null) {
            this.lockDir = null;
        } else {
            File dir = new File(this.dataDir, LOCK_FILE);
            if (!dir.mkdir()) {
                dir.delete();
                if (!dir.mkdir()) {
                    dir = null;
                    if (this.getBoolean("application.showLocalStorageDialogs", true)) {
                        Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.session.nolock", LOCK_FILE);
                    }
                }
            }
            this.lockDir = dir;
        }
    }

    private boolean checkPropertyFileValid(File toCheck) {
        return toCheck != null && toCheck.exists() && toCheck.canRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadProperties() {
        block8: {
            if (!this.checkPropertyFileValid(this.propertyFile) && this.dataDir != null) {
                this.propertyFile = new File(this.dataDir, USER_FILENAME);
            }
            if (this.checkPropertyFileValid(this.propertyFile)) {
                try {
                    FileInputStream in = new FileInputStream(this.propertyFile);
                    try {
                        this.props.load(in);
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException ex) {
                    if (this.getBoolean("application.showLocalStorageDialogs", true)) {
                        Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.session.readError", this.propertyFile.getAbsolutePath());
                    }
                    if (!logger.isLoggable(Level.WARNING)) break block8;
                    logger.log(Level.WARNING, "Error loading properties cache", ex);
                }
            }
        }
    }

    public synchronized void saveAndEnd() {
        if (this.dataDir != null) {
            this.saveProperties();
            this.lockDir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveProperties() {
        block15: {
            if (this.ownLock()) {
                long lastModified = this.propertyFile.lastModified();
                boolean saveIt = true;
                if (this.thisExecutionTriedCreatingLocalDataDir) {
                    saveIt = true;
                } else if (this.getBoolean("application.showLocalStorageDialogs", true)) {
                    if (lastModified == 0L) {
                        saveIt = Resources.showConfirmDialog(null, this.messageBundle, "manager.properties.title", "manager.properties.deleted", this.propertyFile.getAbsolutePath());
                    } else if (this.myLastModif.before(new Date(lastModified))) {
                        saveIt = Resources.showConfirmDialog(null, this.messageBundle, "manager.properties.title", "manager.properties.modified", this.myLastModif);
                    }
                }
                if (!saveIt) {
                    return;
                }
                try {
                    FileOutputStream out = new FileOutputStream(this.propertyFile);
                    try {
                        this.props.store(out, "-- ICEpdf properties --");
                    }
                    finally {
                        out.close();
                    }
                    this.recordMofifTime();
                }
                catch (IOException ex) {
                    if (this.getBoolean("application.showLocalStorageDialogs", true)) {
                        Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.saveError", ex);
                    }
                    if (!logger.isLoggable(Level.WARNING)) break block15;
                    logger.log(Level.WARNING, "Error saving properties cache", ex);
                }
            }
        }
    }

    private void recordMofifTime() {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(new Date());
        c.set(12, c.get(12) + 1);
        c.set(13, 0);
        this.myLastModif = new Date(c.getTime().getTime() / 1000L * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean backupProperties() {
        boolean result;
        block7: {
            result = false;
            if (this.ownLock()) {
                File backupFile = new File(this.dataDir, BACKUP_FILENAME);
                try {
                    FileOutputStream out = new FileOutputStream(backupFile);
                    try {
                        this.props.store(out, "-- ICEbrowser properties backup --");
                        result = true;
                    }
                    finally {
                        out.close();
                    }
                }
                catch (IOException ex) {
                    if (this.getBoolean("application.showLocalStorageDialogs", true)) {
                        Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.saveError", ex);
                    }
                    if (!logger.isLoggable(Level.WARNING)) break block7;
                    logger.log(Level.WARNING, "Error saving properties cache", ex);
                }
            }
        }
        return result;
    }

    public void set(String propertyName, String value) {
        this.props.put(propertyName, value);
    }

    public void remove(String propertyName) {
        this.props.remove(propertyName);
    }

    public String getString(String propertyName, String defaultValue) {
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            return value.trim();
        }
        value = (String)this.defaultProps.get(propertyName);
        if (value != null) {
            return value.trim();
        }
        return defaultValue;
    }

    public String getString(String propertyName) {
        String value = this.getString(propertyName, null);
        if (value == null) {
            Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.missingProperty", propertyName, value);
        }
        return value;
    }

    public int getInt(String propertyName, int defaultValue) {
        Integer result = this.getIntImpl(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public int getInt(String propertyName) {
        Integer result = this.getIntImpl(propertyName);
        if (result == null) {
            Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.missingProperty", propertyName, result);
            return 0;
        }
        return result;
    }

    private Integer getIntImpl(String propertyName) {
        Integer result;
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            result = Parse.parseInteger(value, this.messageBundle);
            if (result != null) {
                return result;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            result = Parse.parseInteger(value, null);
            if (result != null) {
                return result;
            }
            Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.brokenProperty ", propertyName, value);
        }
        return null;
    }

    public void setInt(String propertyName, int value) {
        this.set(propertyName, Integer.toString(value));
    }

    public double getDouble(String propertyName, double defaultValue) {
        Double result = this.getDoubleImpl(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public double getDouble(String propertyName) {
        Double result = this.getDoubleImpl(propertyName);
        if (result == null) {
            Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.missingProperty", propertyName, result);
            return 0.0;
        }
        return result;
    }

    public float getFloat(String propertyName) {
        Float result = this.getFloatImpl(propertyName);
        if (result == null) {
            Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.missingProperty", propertyName, result);
            return 0.0f;
        }
        return result.floatValue();
    }

    private Double getDoubleImpl(String propertyName) {
        Double result;
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            result = Parse.parseDouble(value, this.messageBundle);
            if (result != null) {
                return result;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            result = Parse.parseDouble(value, this.messageBundle);
            if (result != null) {
                return result;
            }
            Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.brokenProperty ", propertyName, value);
        }
        return null;
    }

    private Float getFloatImpl(String propertyName) {
        Float result;
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            result = Parse.parseFloat(value, this.messageBundle);
            if (result != null) {
                return result;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            result = Parse.parseFloat(value, this.messageBundle);
            if (result != null) {
                return result;
            }
            Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.brokenProperty ", propertyName, value);
        }
        return null;
    }

    public void setDouble(String propertyName, double value) {
        this.set(propertyName, Double.toString(value));
    }

    public void setFloat(String propertyName, float value) {
        this.set(propertyName, Float.toString(value));
    }

    public long getLong(String propertyName, long defaultValue) {
        Long result = this.getLongImpl(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public long getLong(String propertyName) {
        Long result = this.getLongImpl(propertyName);
        if (result == null) {
            Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.missingProperty", propertyName, result);
            return 0L;
        }
        return result;
    }

    private Long getLongImpl(String propertyName) {
        Long result;
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            result = Parse.parseLong(value, this.messageBundle);
            if (result != null) {
                return result;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            result = Parse.parseLong(value, null);
            if (result != null) {
                return result;
            }
            Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.brokenProperty ", propertyName, value);
        }
        return null;
    }

    public void setLong(String propertyName, long value) {
        this.set(propertyName, Long.toString(value));
    }

    public boolean getBoolean(String propertyName, boolean defaultValue) {
        Boolean result = this.getBooleanImpl(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result == Boolean.TRUE;
    }

    public boolean getBoolean(String propertyName) {
        Boolean result = this.getBooleanImpl(propertyName);
        if (result == null) {
            Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.missingProperty", propertyName, result);
        }
        return result == Boolean.TRUE;
    }

    private Boolean getBooleanImpl(String propertyName) {
        Boolean result;
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            result = Parse.parseBoolean(value, this.messageBundle);
            if (result != null) {
                return result;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            result = Parse.parseBoolean(value, null);
            if (result != null) {
                return result;
            }
            Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.brokenProperty ", propertyName, value);
        }
        return null;
    }

    public void setBoolean(String propertyName, boolean value) {
        this.set(propertyName, value ? "true" : "false");
    }

    public String getSystemEncoding() {
        return new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
    }

    public String getLookAndFeel(String propertyName, String defaultValue) {
        String result;
        String value = (String)this.props.get(propertyName);
        if (value != null) {
            result = Parse.parseLookAndFeel(value, this.messageBundle);
            if (result != null) {
                return result;
            }
            this.props.remove(propertyName);
        }
        if ((value = (String)this.defaultProps.get(propertyName)) != null) {
            result = Parse.parseLookAndFeel(value, null);
            if (result != null) {
                return result;
            }
            this.defaultProps.remove(propertyName);
            Resources.showMessageDialog(null, 0, this.messageBundle, "manager.properties.title", "manager.properties.lafError", value);
        }
        return defaultValue;
    }

    public String getDefaultFilePath() {
        return this.getString(PROPERTY_DEFAULT_FILE_PATH, null);
    }

    public String getDefaultURL() {
        return this.getString(PROPERTY_DEFAULT_URL, null);
    }

    public void setDefaultFilePath(String defaultFilePath) {
        if (defaultFilePath == null) {
            this.remove(PROPERTY_DEFAULT_FILE_PATH);
        } else {
            this.set(PROPERTY_DEFAULT_FILE_PATH, defaultFilePath);
        }
    }

    public void setDefaultURL(String defaultURL) {
        if (defaultURL == null) {
            this.remove(PROPERTY_DEFAULT_URL);
        } else {
            this.set(PROPERTY_DEFAULT_URL, defaultURL);
        }
    }

    public InputStream getResourceAsStream(String prefix, String resourcePath) {
        InputStream result;
        int colon = resourcePath.indexOf(58);
        if (colon >= 0 && resourcePath.lastIndexOf(colon - 1, 47) < 0) {
            try {
                return new URL(resourcePath).openStream();
            }
            catch (IOException e) {
                return null;
            }
        }
        resourcePath = PropertiesManager.makeResPath(prefix, resourcePath);
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl != null && (result = cl.getResourceAsStream(resourcePath)) != null) {
            return result;
        }
        return ClassLoader.getSystemResourceAsStream(resourcePath);
    }

    public static String makeResPath(String prefix, String base_name) {
        if (base_name.length() != 0 && base_name.charAt(0) == '/') {
            return base_name.substring(1, base_name.length());
        }
        if (prefix == null) {
            return base_name;
        }
        return prefix + base_name;
    }

    public static boolean checkAndStoreBooleanProperty(PropertiesManager properties, String propertyName) {
        return PropertiesManager.checkAndStoreBooleanProperty(properties, propertyName, true);
    }

    public static boolean checkAndStoreBooleanProperty(PropertiesManager properties, String propertyName, boolean defaultVal) {
        if (properties == null) {
            return defaultVal;
        }
        boolean returnValue = properties.getBoolean(propertyName, defaultVal);
        properties.setBoolean(propertyName, returnValue);
        return returnValue;
    }

    public static double checkAndStoreDoubleProperty(PropertiesManager properties, String propertyName) {
        return PropertiesManager.checkAndStoreDoubleProperty(properties, propertyName, 1.0);
    }

    public static double checkAndStoreDoubleProperty(PropertiesManager properties, String propertyName, double defaultVal) {
        if (properties == null) {
            return defaultVal;
        }
        double returnValue = properties.getDouble(propertyName, defaultVal);
        properties.setDouble(propertyName, returnValue);
        return returnValue;
    }

    public static int checkAndStoreIntegerProperty(PropertiesManager properties, String propertyName) {
        return PropertiesManager.checkAndStoreIntegerProperty(properties, propertyName, 1);
    }

    public static int checkAndStoreIntegerProperty(PropertiesManager properties, String propertyName, int defaultVal) {
        if (properties == null) {
            return defaultVal;
        }
        int returnValue = properties.getInt(propertyName, defaultVal);
        properties.setInt(propertyName, returnValue);
        return returnValue;
    }

    public static float[] checkAndStoreFloatArrayProperty(PropertiesManager properties, String propertyName, float[] defaultVal) {
        if (properties == null || properties.props == null) {
            return defaultVal;
        }
        String propertyString = properties.props.getProperty(propertyName);
        float[] toReturn = defaultVal;
        try {
            if (propertyString != null && propertyString.trim().length() > 0) {
                String[] split = propertyString.split(",");
                toReturn = new float[split.length];
                for (int i = 0; i < split.length; ++i) {
                    try {
                        toReturn[i] = Float.parseFloat(split[i]);
                        continue;
                    }
                    catch (NumberFormatException failedValue) {
                        // empty catch block
                    }
                }
            } else {
                StringBuilder commaBuffer = new StringBuilder(defaultVal.length * 2);
                for (int i = 0; i < defaultVal.length; ++i) {
                    commaBuffer.append(defaultVal[i]);
                    if (i + 1 >= defaultVal.length) continue;
                    commaBuffer.append(",");
                }
                properties.set(propertyName, commaBuffer.toString());
            }
        }
        catch (Exception failedProperty) {
            // empty catch block
        }
        return toReturn;
    }
}

