/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.fonts.FontManager;
import org.icepdf.ri.util.Parse;
import org.icepdf.ri.util.PropertiesManager;
import org.icepdf.ri.util.Resources;

public class FontPropertiesManager {
    private static final Logger logger = Logger.getLogger(FontPropertiesManager.class.toString());
    private static final String DEFAULT_HOME_DIR = ".icesoft/icepdf_viewer";
    private static final String LOCK_FILE = "_syslock";
    private static final String USER_FILENAME = "pdfviewerfontcache.properties";
    private FontManager fontManager;
    String versionName = Document.getLibraryVersion();
    private Properties sysProps;
    private PropertiesManager props;
    private Properties fontProps;
    File userHome;
    private File dataDir;
    private File lockDir;
    private File propertyFile;
    private ResourceBundle messageBundle;

    public FontPropertiesManager(PropertiesManager appProps, Properties sysProps, ResourceBundle messageBundle) {
        this.sysProps = sysProps;
        this.props = appProps;
        this.fontProps = new Properties();
        this.messageBundle = messageBundle;
        this.fontManager = FontManager.getInstance();
        this.setupHomeDir(null);
        this.recordMofifTime();
        this.setupLock();
        this.loadProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadProperties() {
        if (this.dataDir != null) {
            this.propertyFile = new File(this.dataDir, USER_FILENAME);
            if (this.propertyFile.exists()) {
                try {
                    FileInputStream in = new FileInputStream(this.propertyFile);
                    try {
                        this.fontProps.load(in);
                        this.fontManager.setFontProperties(this.fontProps);
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException ex) {
                    if (this.getBoolean("application.showLocalStorageDialogs", true)) {
                        Resources.showMessageDialog(null, 0, this.messageBundle, "fontManager.properties.title", "manager.properties.session.readError", ex);
                    }
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "Error loading font properties cache", ex);
                    }
                }
                catch (IllegalArgumentException e) {
                    this.setupDefaultProperties();
                    this.saveProperties();
                }
            } else {
                this.setupDefaultProperties();
                this.saveProperties();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveProperties() {
        block8: {
            if (this.ownLock()) {
                try {
                    FileOutputStream out = new FileOutputStream(this.propertyFile);
                    try {
                        this.fontProps.store(out, "-- ICEpf Font properties --");
                    }
                    finally {
                        out.close();
                    }
                    this.recordMofifTime();
                }
                catch (IOException ex) {
                    if (this.getBoolean("application.showLocalStorageDialogs", true)) {
                        Resources.showMessageDialog(null, 0, this.messageBundle, "fontManager.properties.title", "manager.properties.saveError", ex);
                    }
                    if (!logger.isLoggable(Level.WARNING)) break block8;
                    logger.log(Level.WARNING, "Error saving font properties cache", ex);
                }
            }
        }
    }

    private boolean ownLock() {
        return this.lockDir != null;
    }

    private void recordMofifTime() {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(new Date());
        c.set(12, c.get(12) + 1);
        c.set(13, 0);
    }

    private void setupLock() {
        if (this.dataDir == null) {
            this.lockDir = null;
        } else {
            File dir = new File(this.dataDir, LOCK_FILE);
            if (!dir.mkdir()) {
                dir.delete();
                if (!dir.mkdir()) {
                    dir = null;
                    if (this.getBoolean("application.showLocalStorageDialogs", true)) {
                        Resources.showMessageDialog(null, 0, this.messageBundle, "fontManager.properties.title", "manager.properties.session.nolock", LOCK_FILE);
                    }
                }
            }
            this.lockDir = dir;
        }
    }

    private boolean setupDefaultProperties() {
        this.fontProps = new Properties();
        try {
            this.fontManager.readSystemFonts(null);
            this.fontProps = this.fontManager.getFontProperties();
        }
        catch (Exception ex) {
            if (this.getBoolean("application.showLocalStorageDialogs", true)) {
                Resources.showMessageDialog(null, 0, this.messageBundle, "fontManager.properties.title", "manager.properties.session.readError", ex);
            }
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Error loading default properties", ex);
            }
            return false;
        }
        return true;
    }

    private void setupHomeDir(String homeString) {
        if (homeString == null) {
            homeString = this.sysProps.getProperty("swingri.home");
        }
        if (homeString != null) {
            this.dataDir = new File(homeString);
        } else {
            this.userHome = new File(this.sysProps.getProperty("user.home"));
            String dataDirStr = this.props.getString("application.datadir", DEFAULT_HOME_DIR);
            this.dataDir = new File(this.userHome, dataDirStr);
        }
        if (!this.dataDir.isDirectory()) {
            boolean create;
            String path = this.dataDir.getAbsolutePath();
            if (this.props.hasUserRejectedCreatingLocalDataDir()) {
                create = false;
            } else if (this.getBoolean("application.showLocalStorageDialogs", true)) {
                create = Resources.showConfirmDialog(null, this.messageBundle, "fontManager.properties.title", "manager.properties.createNewDirectory", path);
                if (!create) {
                    this.props.setUserRejectedCreatingLocalDataDir();
                }
            } else {
                create = true;
            }
            if (!create) {
                this.dataDir = null;
            } else {
                this.dataDir.mkdirs();
                if (!this.dataDir.isDirectory()) {
                    if (this.getBoolean("application.showLocalStorageDialogs", true)) {
                        Resources.showMessageDialog(null, 0, this.messageBundle, "fontManager.properties.title", "manager.properties.failedCreation", this.dataDir.getAbsolutePath());
                    }
                    this.dataDir = null;
                }
            }
        }
    }

    public boolean getBoolean(String propertyName, boolean defaultValue) {
        Boolean result = this.getBooleanImpl(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result == Boolean.TRUE;
    }

    private Boolean getBooleanImpl(String propertyName) {
        Boolean result;
        String value = this.props.getString(propertyName);
        if (value != null) {
            result = Parse.parseBoolean(value, this.messageBundle);
            if (result != null) {
                return result;
            }
            this.props.remove(propertyName);
        }
        if ((value = this.props.getString(propertyName)) != null) {
            result = Parse.parseBoolean(value, null);
            if (result != null) {
                return result;
            }
            this.throwBrokenDefault(propertyName, value);
        }
        return null;
    }

    private void throwBrokenDefault(String propertyName, String value) {
        throw new IllegalStateException("Broken default property '" + propertyName + "' value: '" + value + "'");
    }
}

