/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.icepdf.core.events.PaintPageEvent;
import org.icepdf.core.events.PaintPageListener;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.annotations.FreeTextAnnotation;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.search.DocumentSearchController;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.tools.TextSelectionPageHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.DocumentView;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.FreeTextAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;

public class PageViewComponentImpl
extends AbstractPageViewComponent
implements PaintPageListener,
FocusListener,
ComponentListener {
    private static final Logger logger = Logger.getLogger(PageViewComponentImpl.class.toString());
    private static Color pageColor;
    private static boolean enablePageLoadingProxy;
    private PageTree pageTree;
    private JScrollPane parentScrollPane;
    private int previousScrollValue;
    private int pageIndex;
    private Rectangle pageSize = new Rectangle();
    private Rectangle defaultPageSize = new Rectangle();
    private boolean isPageSizeCalculated = false;
    private float currentZoom;
    private float currentRotation;
    private SoftReference<Image> bufferedPageImageReference;
    private Rectangle bufferedPageImageBounds = new Rectangle();
    private Timer isDirtyTimer;
    private PageInitializer pageInitializer;
    private PagePainter pagePainter;
    private final Object paintCopyAreaLock = new Object();
    private boolean disposing = false;
    private Rectangle clipBounds;
    private Rectangle oldClipBounds;
    private boolean inited;
    private static double verticalScaleFactor;
    private static double horizontalScaleFactor;
    private static int dirtyTimerInterval;
    private static int scrollInitThreshold;
    private static GraphicsConfiguration gc;

    public PageViewComponentImpl(DocumentViewModel documentViewModel, PageTree pageTree, int pageNumber, JScrollPane parentScrollPane) {
        this(documentViewModel, pageTree, pageNumber, parentScrollPane, 0, 0);
    }

    public PageViewComponentImpl(DocumentViewModel documentViewModel, PageTree pageTree, int pageNumber, JScrollPane parentScrollPane, int width, int height) {
        this.setFocusable(true);
        this.addFocusListener(this);
        this.documentViewModel = documentViewModel;
        this.parentScrollPane = parentScrollPane;
        this.currentRotation = documentViewModel.getViewRotation();
        this.currentZoom = documentViewModel.getViewRotation();
        this.pageTree = pageTree;
        this.pageIndex = pageNumber;
        this.clipBounds = new Rectangle();
        this.oldClipBounds = new Rectangle();
        this.bufferedPageImageReference = new SoftReference<Object>(null);
        if (width == 0 && height == 0) {
            this.calculatePageSize(this.pageSize);
            this.isPageSizeCalculated = true;
        } else {
            this.pageSize.setSize(width, height);
            this.defaultPageSize.setSize(width, height);
        }
    }

    @Override
    public void addAnnotation(AnnotationComponent annotation) {
        if (this.annotationComponents == null) {
            this.annotationComponents = new ArrayList();
        }
        this.annotationComponents.add(annotation);
        if (annotation instanceof PopupAnnotationComponent) {
            this.add((Component)((AbstractAnnotationComponent)annotation), JLayeredPane.POPUP_LAYER);
        } else {
            this.add((Component)((AbstractAnnotationComponent)annotation), JLayeredPane.DEFAULT_LAYER);
        }
    }

    @Override
    public void removeAnnotation(AnnotationComponent annotationComp) {
        this.annotationComponents.remove(annotationComp);
        this.remove((AbstractAnnotationComponent)annotationComp);
    }

    @Override
    public void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.addPageRepaintListener();
        DirtyTimerAction dirtyTimerAction = new DirtyTimerAction(this);
        this.isDirtyTimer = new Timer(dirtyTimerInterval, dirtyTimerAction);
        this.isDirtyTimer.setInitialDelay(0);
        this.pageInitializer = new PageInitializer(this);
        this.pagePainter = new PagePainter();
    }

    @Override
    public void invalidatePage() {
        Page page = this.pageTree.getPage(this.pageIndex);
        page.getLibrary().disposeFontResources();
        page.resetInitializedState();
        this.currentZoom = -1.0f;
        this.pagePainter.setIsBufferDirty(true);
    }

    @Override
    public void invalidatePageBuffer() {
        this.currentZoom = -1.0f;
    }

    @Override
    public void dispose() {
        Image pageBufferImage;
        this.disposing = true;
        if (this.isDirtyTimer != null) {
            this.isDirtyTimer.stop();
        }
        this.removeComponentListener(this);
        this.removeMouseMotionListener(this.currentToolHandler);
        this.removeMouseListener(this.currentToolHandler);
        this.removeFocusListener(this);
        this.removePageRepaintListener();
        if (this.bufferedPageImageReference != null && (pageBufferImage = this.bufferedPageImageReference.get()) != null) {
            pageBufferImage.flush();
        }
        if (this.annotationComponents != null) {
            int max = this.annotationComponents.size();
            for (int i = 0; i < max; ++i) {
                ((AnnotationComponent)this.annotationComponents.get(i)).dispose();
            }
        }
        this.inited = false;
    }

    @Override
    public Page getPage() {
        return this.pageTree.getPage(this.pageIndex);
    }

    @Override
    public void setDocumentViewCallback(DocumentView parentDocumentView) {
        this.parentDocumentView = parentDocumentView;
        this.documentViewController = this.parentDocumentView.getParentViewController();
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.pageSize.getSize();
    }

    @Override
    public void invalidate() {
        this.calculateRoughPageSize(this.pageSize);
        if (this.pagePainter != null) {
            this.pagePainter.setIsBufferDirty(true);
        }
        super.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics gg) {
        if (!this.inited) {
            this.init();
        }
        if (!this.isPageSizeCalculated) {
            this.calculatePageSize(this.pageSize);
            this.pagePainter.setIsBufferDirty(true);
        } else if (this.isPageStateDirty()) {
            this.calculatePageSize(this.pageSize);
        }
        Graphics2D g = (Graphics2D)gg.create(0, 0, this.pageSize.width, this.pageSize.height);
        g.setColor(pageColor);
        g.fillRect(0, 0, this.pageSize.width, this.pageSize.height);
        if (enablePageLoadingProxy && this.isPageIntersectViewport() && !this.isDirtyTimer.isRunning()) {
            this.isDirtyTimer.start();
        } else if (!enablePageLoadingProxy && this.isPageIntersectViewport() && (this.isPageStateDirty() || this.isBufferDirty())) {
            this.pageInitializer.run();
            this.pagePainter.run();
        }
        if (this.parentScrollPane == null) {
            this.oldClipBounds.setBounds(this.clipBounds);
            this.clipBounds.setBounds(g.getClipBounds());
            if (this.oldClipBounds.width == 0 && this.oldClipBounds.height == 0) {
                this.oldClipBounds.setBounds(this.clipBounds);
            }
        }
        if (this.bufferedPageImageReference != null) {
            Image pageBufferImage = this.bufferedPageImageReference.get();
            if (pageBufferImage != null && !this.isPageStateDirty()) {
                Object object = this.paintCopyAreaLock;
                synchronized (object) {
                    g.drawImage(pageBufferImage, this.bufferedPageImageBounds.x, this.bufferedPageImageBounds.y, this);
                }
            } else {
                this.currentZoom = -1.0f;
                if (!this.isDirtyTimer.isRunning()) {
                    this.isDirtyTimer.start();
                }
            }
            this.paintAnnotations(g);
            Page currentPage = this.getPage();
            if (currentPage != null && currentPage.isInitiated()) {
                PageText pageText = currentPage.getViewText();
                DocumentSearchController searchController = this.documentViewController.getParentController().getDocumentSearchController();
                if (searchController.isSearchHighlightRefreshNeeded(this.pageIndex, pageText)) {
                    searchController.searchHighlightPage(this.pageIndex);
                }
                if (this.documentViewModel.isSelectAll()) {
                    this.documentViewModel.addSelectedPageText(this);
                    pageText.selectAll();
                }
                TextSelectionPageHandler.paintSelectedText(g, this, this.documentViewModel);
            }
            if (this.currentToolHandler != null) {
                this.currentToolHandler.paintTool(g);
            }
        }
    }

    private void paintAnnotations(Graphics g) {
        Page currentPage = this.getPage();
        if (currentPage != null && currentPage.isInitiated() && this.annotationComponents != null) {
            Graphics2D gg2 = (Graphics2D)g;
            AffineTransform prePaintTransform = gg2.getTransform();
            Color oldColor = gg2.getColor();
            Stroke oldStroke = gg2.getStroke();
            AffineTransform at = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
            gg2.transform(at);
            boolean notSelectTool = this.documentViewModel.getViewToolMode() != 6;
            int max = this.annotationComponents.size();
            for (int i = 0; i < max; ++i) {
                AnnotationComponent annotation = (AnnotationComponent)this.annotationComponents.get(i);
                if (!((Component)((Object)annotation)).isVisible() || annotation.getAnnotation() instanceof FreeTextAnnotation && ((FreeTextAnnotationComponent)annotation).isActive()) continue;
                annotation.getAnnotation().render(gg2, 1, this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom(), annotation.hasFocus() && notSelectTool);
            }
            gg2.setColor(oldColor);
            gg2.setStroke(oldStroke);
            gg2.setTransform(prePaintTransform);
        }
    }

    @Override
    public void clearSelectedText() {
        Page currentPage = this.getPage();
        if (currentPage.getViewText() != null) {
            currentPage.getViewText().clearSelected();
        }
    }

    @Override
    public void setSelectionRectangle(Point cursorLocation, Rectangle selection) {
        if (this.currentToolHandler instanceof SelectionBoxHandler) {
            ((SelectionBoxHandler)((Object)this.currentToolHandler)).setSelectionRectangle(cursorLocation, selection);
        }
    }

    @Override
    public void clearSelectionRectangle() {
        if (this.currentToolHandler instanceof SelectionBoxHandler) {
            ((SelectionBoxHandler)((Object)this.currentToolHandler)).clearRectangle(this);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        int oldCurrentPage = this.documentViewModel.getViewCurrentPageIndex();
        this.documentViewModel.setViewCurrentPageIndex(this.pageIndex);
        this.documentViewController.firePropertyChange("documentCurrentPage", oldCurrentPage, this.pageIndex);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private void calculateRoughPageSize(Rectangle pageSize) {
        float width = this.defaultPageSize.width;
        float height = this.defaultPageSize.height;
        float totalRotation = this.documentViewModel.getViewRotation();
        if (totalRotation != 0.0f && totalRotation != 180.0f) {
            if (totalRotation == 90.0f || totalRotation == 270.0f) {
                float temp = width;
                width = height;
                height = temp;
            } else {
                AffineTransform at = new AffineTransform();
                double radians = Math.toRadians(totalRotation);
                at.rotate(radians);
                Rectangle2D.Double boundingBox = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                Point2D.Double src = new Point2D.Double();
                Point2D.Double dst = new Point2D.Double();
                src.setLocation(0.0, height);
                at.transform(src, dst);
                boundingBox.add(dst);
                src.setLocation(width, height);
                at.transform(src, dst);
                boundingBox.add(dst);
                src.setLocation(0.0, 0.0);
                at.transform(src, dst);
                boundingBox.add(dst);
                src.setLocation(width, 0.0);
                at.transform(src, dst);
                boundingBox.add(dst);
                width = (float)boundingBox.getWidth();
                height = (float)boundingBox.getHeight();
            }
        }
        pageSize.setSize((int)(width * this.documentViewModel.getViewZoom()), (int)(height * this.documentViewModel.getViewZoom()));
    }

    private void calculatePageSize(Rectangle pageSize) {
        if (this.pageTree != null) {
            Page currentPage = this.pageTree.getPage(this.pageIndex);
            if (currentPage != null) {
                pageSize.setSize(currentPage.getSize(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom()).toDimension());
                this.defaultPageSize.setSize(currentPage.getSize(this.documentViewModel.getPageBoundary(), 0.0f, 1.0f).toDimension());
            }
            this.isPageSizeCalculated = true;
        }
    }

    private boolean isBufferDirty() {
        if (this.disposing) {
            return false;
        }
        if (this.pageSize.height <= this.clipBounds.height && this.pageSize.width <= this.clipBounds.width) {
            return false;
        }
        Rectangle tempClipBounds = new Rectangle(this.clipBounds);
        if (this.parentScrollPane != null) {
            tempClipBounds.setBounds(this.parentScrollPane.getViewport().getViewRect());
        }
        Rectangle pageBounds = this.documentViewModel.getPageBounds(this.pageIndex);
        Rectangle normalizedBounds = new Rectangle(this.bufferedPageImageBounds);
        normalizedBounds.x += pageBounds.x;
        normalizedBounds.y += pageBounds.y;
        return !normalizedBounds.contains(pageBounds.intersection(tempClipBounds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createBufferedPageImage(Page page, PagePainter pagePainter) {
        if (this.disposing) {
            return;
        }
        boolean isPageStateDirty = this.isPageStateDirty();
        this.currentRotation = this.documentViewModel.getViewRotation();
        this.currentZoom = this.documentViewModel.getViewZoom();
        Image pageBufferImage = this.bufferedPageImageReference.get();
        if (isPageStateDirty && pageBufferImage != null) {
            pageBufferImage.flush();
        }
        Rectangle oldBufferedPageImageBounds = new Rectangle(this.bufferedPageImageBounds);
        Rectangle pageBounds = this.documentViewModel.getPageBounds(this.pageIndex);
        if (this.parentScrollPane != null) {
            this.oldClipBounds.setBounds(this.clipBounds);
            this.clipBounds.setBounds(this.parentScrollPane.getViewport().getViewRect());
            if (this.oldClipBounds.width == 0 && this.oldClipBounds.height == 0) {
                this.oldClipBounds.setBounds(this.clipBounds);
            }
        }
        this.bufferedPageImageBounds.setBounds(pageBounds.intersection(this.clipBounds));
        if (this.pageSize.width <= this.clipBounds.width) {
            this.bufferedPageImageBounds.x = 0;
            this.bufferedPageImageBounds.width = this.pageSize.width;
        } else {
            if (horizontalScaleFactor > 1.0) {
                double width = (double)this.clipBounds.width * horizontalScaleFactor / 2.0;
                this.bufferedPageImageBounds.x = (int)((double)this.clipBounds.x - width);
                this.bufferedPageImageBounds.width = (int)((double)this.clipBounds.width + width * 2.0);
            } else {
                this.bufferedPageImageBounds.width = this.clipBounds.width;
            }
            this.bufferedPageImageBounds.x -= pageBounds.x;
        }
        if (this.pageSize.height <= this.clipBounds.height) {
            this.bufferedPageImageBounds.y = 0;
            this.bufferedPageImageBounds.height = this.clipBounds.height;
        } else {
            if (verticalScaleFactor > 1.0) {
                double height = (double)this.clipBounds.height * verticalScaleFactor / 2.0;
                this.bufferedPageImageBounds.y = (int)((double)this.clipBounds.y - height);
                this.bufferedPageImageBounds.height = (int)((double)this.clipBounds.height + height * 2.0);
            } else {
                this.bufferedPageImageBounds.height = this.clipBounds.height;
            }
            this.bufferedPageImageBounds.y -= pageBounds.y;
        }
        if (isPageStateDirty || pageBufferImage == null) {
            if (pageBufferImage != null) {
                pageBufferImage.flush();
            }
            if (gc == null) {
                gc = this.getGraphicsConfiguration();
            }
            if (gc != null && this.isShowing()) {
                pageBufferImage = gc.createCompatibleImage(this.bufferedPageImageBounds.width, this.bufferedPageImageBounds.height);
                Graphics g = pageBufferImage.getGraphics();
                g.setColor(pageColor);
                g.fillRect(0, 0, this.pageSize.width, this.pageSize.height);
            }
            this.bufferedPageImageReference = new SoftReference<Image>(pageBufferImage);
            pagePainter.setIsBufferDirty(false);
        }
        if (this.bufferedPageImageBounds.x < 0) {
            this.bufferedPageImageBounds.x = 0;
        }
        if (this.bufferedPageImageBounds.x + this.bufferedPageImageBounds.width > this.pageSize.width) {
            this.bufferedPageImageBounds.width = this.pageSize.width - this.bufferedPageImageBounds.x;
        }
        if (this.bufferedPageImageBounds.y < 0) {
            this.bufferedPageImageBounds.y = 0;
        }
        if (this.bufferedPageImageBounds.y + this.bufferedPageImageBounds.height > this.pageSize.height) {
            this.bufferedPageImageBounds.height = this.pageSize.height - this.bufferedPageImageBounds.y;
        }
        if (pageBufferImage != null) {
            Graphics2D imageGraphics = (Graphics2D)pageBufferImage.getGraphics();
            imageGraphics.setClip(new Rectangle(0, 0, this.bufferedPageImageBounds.width, this.bufferedPageImageBounds.height));
            int xTrans = 0 - this.bufferedPageImageBounds.x;
            int yTrans = 0 - this.bufferedPageImageBounds.y;
            Object object = this.paintCopyAreaLock;
            synchronized (object) {
                Rectangle normalizedClipBounds = new Rectangle(this.clipBounds);
                normalizedClipBounds.x -= pageBounds.x;
                normalizedClipBounds.y -= pageBounds.y;
                if (!pagePainter.isLastPaintDirty() && pagePainter.isBufferDirty() && this.bufferedPageImageBounds.intersects(oldBufferedPageImageBounds)) {
                    Rectangle copyRect = this.bufferedPageImageBounds.intersection(oldBufferedPageImageBounds);
                    copyRect = copyRect.intersection(normalizedClipBounds);
                    int xTransOld = 0 - oldBufferedPageImageBounds.x;
                    int yTransOld = 0 - oldBufferedPageImageBounds.y;
                    int dx = oldBufferedPageImageBounds.x - this.bufferedPageImageBounds.x;
                    int dy = oldBufferedPageImageBounds.y - this.bufferedPageImageBounds.y;
                    imageGraphics.copyArea(copyRect.x + xTransOld, copyRect.y + yTransOld, copyRect.width, copyRect.height, dx, dy);
                    Area copyArea = new Area(copyRect);
                    Area bufferArea = new Area(this.bufferedPageImageBounds);
                    bufferArea.subtract(copyArea);
                    imageGraphics.translate(xTrans, yTrans);
                    imageGraphics.setClip(bufferArea);
                    imageGraphics.translate(-xTrans, -yTrans);
                } else {
                    imageGraphics.translate(xTrans, yTrans);
                    imageGraphics.setClip(this.bufferedPageImageBounds);
                    imageGraphics.translate(-xTrans, -yTrans);
                }
                imageGraphics.translate(xTrans, yTrans);
                imageGraphics.setColor(pageColor);
                imageGraphics.fillRect(this.bufferedPageImageBounds.x, this.bufferedPageImageBounds.y, this.bufferedPageImageBounds.width, this.bufferedPageImageBounds.height);
            }
            if (page != null) {
                page.paint(imageGraphics, 1, this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom(), false, false);
                if (pagePainter.isStopPaintingRequested()) {
                    pagePainter.setIsLastPaintDirty(true);
                    pagePainter.setIsBufferDirty(true);
                } else {
                    pagePainter.setIsLastPaintDirty(false);
                    pagePainter.setIsBufferDirty(false);
                }
                Runnable doSwingWork = new Runnable(){

                    @Override
                    public void run() {
                        if (!PageViewComponentImpl.this.disposing) {
                            PageViewComponentImpl.this.repaint();
                        }
                    }
                };
                SwingUtilities.invokeLater(doSwingWork);
            }
            imageGraphics.dispose();
        }
    }

    private void addPageRepaintListener() {
        Page currentPage = this.pageTree.getPage(this.pageIndex);
        if (currentPage != null) {
            currentPage.addPaintPageListener(this);
        }
    }

    private void removePageRepaintListener() {
        Page currentPage;
        if (this.inited && (currentPage = this.pageTree.getPage(this.pageIndex)) != null) {
            currentPage.removePaintPageListener(this);
        }
    }

    private boolean isPageStateDirty() {
        boolean tmp = this.currentZoom != this.documentViewModel.getViewZoom() || this.currentRotation != this.documentViewModel.getViewRotation() || this.oldClipBounds.width != this.clipBounds.width || this.oldClipBounds.height != this.clipBounds.height;
        return tmp;
    }

    private boolean isPageIntersectViewport() {
        Rectangle pageBounds = this.documentViewModel.getPageBounds(this.pageIndex);
        return pageBounds != null && this.isShowing() && pageBounds.intersects(this.parentScrollPane.getViewport().getViewRect());
    }

    @Override
    public void paintPage(PaintPageEvent event) {
        Object source = event.getSource();
        Page page = this.pageTree.getPage(this.pageIndex);
        if (page.equals(source)) {
            Runnable doSwingWork = new Runnable(){

                @Override
                public void run() {
                    if (!PageViewComponentImpl.this.disposing) {
                        PageViewComponentImpl.this.repaint();
                    }
                }
            };
            SwingUtilities.invokeLater(doSwingWork);
        }
    }

    static {
        try {
            String color = Defs.sysProperty("org.icepdf.core.views.page.paper.color", "#FFFFFF");
            int colorValue = ColorUtil.convertColor(color);
            pageColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("FFFFFF", 16));
        }
        catch (NumberFormatException e) {
            logger.warning("Error reading page paper color.");
        }
        enablePageLoadingProxy = Defs.booleanProperty("org.icepdf.core.views.page.proxy", true);
        dirtyTimerInterval = 5;
        scrollInitThreshold = 150;
        try {
            verticalScaleFactor = Double.parseDouble(Defs.sysProperty("org.icepdf.core.views.buffersize.vertical", "1.015"));
            horizontalScaleFactor = Double.parseDouble(Defs.sysProperty("org.icepdf.core.views.buffersize.horizontal", "1.015"));
        }
        catch (NumberFormatException e) {
            logger.warning("Error reading buffered scale factor");
        }
        try {
            dirtyTimerInterval = Defs.intProperty("org.icepdf.core.views.dirtytimer.interval", 5);
        }
        catch (NumberFormatException e) {
            logger.log(Level.FINE, "Error reading dirty timer interval");
        }
        try {
            scrollInitThreshold = Defs.intProperty("org.icepdf.core.views.scroll.initThreshold", 150);
        }
        catch (NumberFormatException e) {
            logger.log(Level.FINE, "Error reading dirty timer interval");
        }
    }

    private class DirtyTimerAction
    implements ActionListener {
        private AbstractPageViewComponent pageComponent;
        private Page page;

        private DirtyTimerAction(AbstractPageViewComponent pageComponent) {
            this.pageComponent = pageComponent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PageViewComponentImpl.this.disposing || !PageViewComponentImpl.this.isPageIntersectViewport()) {
                PageViewComponentImpl.this.isDirtyTimer.stop();
                this.page = null;
                if (PageViewComponentImpl.this.pagePainter.isRunning()) {
                    PageViewComponentImpl.this.pagePainter.stopPaintingPage();
                    PageViewComponentImpl.this.currentZoom = -1.0f;
                }
                return;
            }
            if (!PageViewComponentImpl.this.disposing && PageViewComponentImpl.this.isPageIntersectViewport()) {
                boolean isBufferDirty = PageViewComponentImpl.this.pagePainter.isBufferDirty() || PageViewComponentImpl.this.isBufferDirty();
                int diff = Math.abs(PageViewComponentImpl.this.previousScrollValue - PageViewComponentImpl.this.parentScrollPane.getVerticalScrollBar().getValue());
                PageViewComponentImpl.this.previousScrollValue = PageViewComponentImpl.this.parentScrollPane.getVerticalScrollBar().getValue();
                if (PageViewComponentImpl.this.parentScrollPane != null && diff > scrollInitThreshold) {
                    return;
                }
                this.page = PageViewComponentImpl.this.pageTree.getPage(PageViewComponentImpl.this.pageIndex);
                if (isBufferDirty && this.page != null && !this.page.isInitiated() && !PageViewComponentImpl.this.pageInitializer.isRunning() && !PageViewComponentImpl.this.pageInitializer.hasBeenQueued()) {
                    PageViewComponentImpl.this.pageInitializer.setHasBeenQueued(true);
                    PageViewComponentImpl.this.pageInitializer.setPage(this.page);
                    Library.execute(PageViewComponentImpl.this.pageInitializer);
                }
                boolean tmp = !PageViewComponentImpl.this.pageInitializer.isRunning() && this.page != null && this.page.isInitiated() && !PageViewComponentImpl.this.pagePainter.isRunning() && !PageViewComponentImpl.this.pagePainter.hasBeenQueued();
                boolean bl = isBufferDirty = PageViewComponentImpl.this.pagePainter.isBufferDirty() || PageViewComponentImpl.this.isBufferDirty();
                if (this.page != null && tmp && (PageViewComponentImpl.this.isPageStateDirty() || isBufferDirty)) {
                    PageViewComponentImpl.this.pagePainter.setPage(this.page);
                    PageViewComponentImpl.this.pagePainter.setHasBeenQueued(true);
                    PageViewComponentImpl.this.pagePainter.setIsBufferDirty(isBufferDirty);
                    Library.executePainter(PageViewComponentImpl.this.pagePainter);
                }
                if (this.page != null && !PageViewComponentImpl.this.pageInitializer.isRunning() && this.page.isInitiated() && !PageViewComponentImpl.this.pagePainter.hasBeenQueued() && PageViewComponentImpl.this.pagePainter.isRunning() && PageViewComponentImpl.this.isPageStateDirty()) {
                    PageViewComponentImpl.this.pagePainter.stopPaintingPage();
                }
            }
        }
    }

    private class PageInitializer
    implements Runnable {
        private boolean isRunning;
        private final Object isRunningLock = new Object();
        private AbstractPageViewComponent pageComponent;
        private boolean hasBeenQueued;
        private Page page;

        private PageInitializer(AbstractPageViewComponent pageComponent) {
            this.pageComponent = pageComponent;
        }

        private void setPage(Page page) {
            this.page = page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.isRunningLock;
            synchronized (object) {
                this.isRunning = true;
            }
            try {
                this.page = PageViewComponentImpl.this.pageTree.getPage(PageViewComponentImpl.this.pageIndex);
                this.page.init();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PageViewComponentImpl.this.refreshAnnotationComponents(PageInitializer.this.page);
                        PageInitializer.this.page = null;
                    }
                });
                if (PageViewComponentImpl.this.documentViewController.getAnnotationCallback() != null) {
                    PageViewComponentImpl.this.documentViewController.getAnnotationCallback().pageAnnotationsInitialized(this.page);
                }
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Error initiating page: " + PageViewComponentImpl.this.pageIndex, e);
                this.hasBeenQueued = true;
                return;
            }
            object = this.isRunningLock;
            synchronized (object) {
                PageViewComponentImpl.this.pageInitializer.setHasBeenQueued(false);
                this.isRunning = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasBeenQueued() {
            Object object = this.isRunningLock;
            synchronized (object) {
                return this.hasBeenQueued;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setHasBeenQueued(boolean hasBeenQueued) {
            Object object = this.isRunningLock;
            synchronized (object) {
                this.hasBeenQueued = hasBeenQueued;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            Object object = this.isRunningLock;
            synchronized (object) {
                return this.isRunning;
            }
        }
    }

    public class PagePainter
    implements Runnable {
        private boolean isRunning;
        private boolean isLastPaintDirty;
        private boolean isBufferyDirty;
        private boolean isStopRequested;
        private Page page;
        private final Object isRunningLock = new Object();
        private boolean hasBeenQueued;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean isLastPaintDirty() {
            Object object = this.isRunningLock;
            synchronized (object) {
                return this.isLastPaintDirty;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setIsLastPaintDirty(boolean isDirty) {
            Object object = this.isRunningLock;
            synchronized (object) {
                this.isLastPaintDirty = isDirty;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setIsBufferDirty(boolean isDirty) {
            Object object = this.isRunningLock;
            synchronized (object) {
                this.isBufferyDirty = isDirty;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isBufferDirty() {
            Object object = this.isRunningLock;
            synchronized (object) {
                return this.isBufferyDirty;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isStopPaintingRequested() {
            Object object = this.isRunningLock;
            synchronized (object) {
                return this.isStopRequested;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void stopPaintingPage() {
            Object object = this.isRunningLock;
            synchronized (object) {
                this.isStopRequested = true;
                this.isLastPaintDirty = true;
                PageViewComponentImpl.this.getPage().requestInterrupt();
            }
        }

        public void setPage(Page page) {
            this.page = page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.isRunningLock;
            synchronized (object) {
                this.isRunning = true;
                this.hasBeenQueued = false;
            }
            try {
                Runnable doSwingWork;
                if (PageViewComponentImpl.this.isPageStateDirty()) {
                    doSwingWork = new Runnable(){

                        @Override
                        public void run() {
                            PageViewComponentImpl.this.invalidate();
                            PageViewComponentImpl.this.validate();
                        }
                    };
                    SwingUtilities.invokeLater(doSwingWork);
                }
                PageViewComponentImpl.this.createBufferedPageImage(this.page, this);
                PageViewComponentImpl.this.refreshAnnotationComponents(this.page);
                this.isBufferyDirty = false;
                this.page = null;
                if (PageViewComponentImpl.this.isPageStateDirty()) {
                    doSwingWork = new Runnable(){

                        @Override
                        public void run() {
                            PageViewComponentImpl.this.repaint();
                        }
                    };
                    SwingUtilities.invokeLater(doSwingWork);
                }
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Error creating buffer, page: " + PageViewComponentImpl.this.pageIndex, e);
                PageViewComponentImpl.this.currentZoom = -1.0f;
            }
            object = this.isRunningLock;
            synchronized (object) {
                this.isStopRequested = false;
                this.isRunning = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasBeenQueued() {
            Object object = this.isRunningLock;
            synchronized (object) {
                return this.hasBeenQueued;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setHasBeenQueued(boolean hasBeenQueued) {
            Object object = this.isRunningLock;
            synchronized (object) {
                this.hasBeenQueued = hasBeenQueued;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            Object object = this.isRunningLock;
            synchronized (object) {
                return this.isRunning;
            }
        }
    }
}

