/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.icepdf.ri.common.KeyListenerPageChanger;
import org.icepdf.ri.common.MouseWheelListenerPageChanger;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModelImpl;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.PageViewDecorator;

public class OnePageView
extends AbstractDocumentView {
    protected JScrollPane documentScrollpane;
    protected boolean disposing;
    protected JPanel pagesPanel;
    protected Object pageChangerListener;
    protected KeyListenerPageChanger keyListenerPageChanger;

    public OnePageView(DocumentViewController documentDocumentViewController, JScrollPane documentScrollpane, DocumentViewModelImpl documentViewModel) {
        super(documentDocumentViewController, documentScrollpane, documentViewModel);
        this.documentScrollpane = documentScrollpane;
        this.buildGUI();
        if (this.documentViewController.getParentController() instanceof SwingController) {
            this.pageChangerListener = MouseWheelListenerPageChanger.install((SwingController)this.documentViewController.getParentController(), this.documentScrollpane, this);
            this.keyListenerPageChanger = KeyListenerPageChanger.install((SwingController)this.documentViewController.getParentController(), this.documentScrollpane, this);
        }
    }

    private void buildGUI() {
        this.pagesPanel = new JPanel();
        this.pagesPanel.setBackground(backgroundColor);
        GridLayout gridLayout = new GridLayout(0, 1, horizontalSpace, verticalSpace);
        this.pagesPanel.setLayout(gridLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(layoutInserts, layoutInserts, layoutInserts, layoutInserts);
        gbc.gridwidth = 0;
        this.updateDocumentView();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.pagesPanel, gbc);
    }

    @Override
    public void updateDocumentView() {
        List<AbstractPageViewComponent> pageComponents = this.documentViewModel.getPageComponents();
        if (pageComponents != null) {
            PageViewComponent pageViewComponent = pageComponents.get(this.documentViewModel.getViewCurrentPageIndex());
            if (pageViewComponent != null) {
                this.pagesPanel.removeAll();
                pageViewComponent.setDocumentViewCallback(this);
                this.pagesPanel.add(new PageViewDecorator((AbstractPageViewComponent)pageViewComponent));
                pageViewComponent.invalidate();
            }
            this.documentScrollpane.revalidate();
            for (AbstractPageViewComponent pageViewCom : pageComponents) {
                if (pageViewCom == null) continue;
                pageViewCom.setDocumentViewCallback(this);
            }
        }
    }

    @Override
    public int getNextPageIncrement() {
        return 1;
    }

    @Override
    public int getPreviousPageIncrement() {
        return 1;
    }

    @Override
    public void dispose() {
        this.disposing = true;
        if (this.pageChangerListener != null) {
            MouseWheelListenerPageChanger.uninstall(this.documentScrollpane, this.pageChangerListener);
        }
        if (this.keyListenerPageChanger != null) {
            this.keyListenerPageChanger.uninstall();
        }
        this.pagesPanel.removeAll();
        this.pagesPanel.invalidate();
        super.dispose();
    }

    @Override
    public Dimension getDocumentSize() {
        float pageViewWidth = 0.0f;
        float pageViewHeight = 0.0f;
        if (this.pagesPanel != null) {
            int count = this.pagesPanel.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component comp = this.pagesPanel.getComponent(i);
                if (!(comp instanceof PageViewDecorator)) continue;
                PageViewDecorator pvd = (PageViewDecorator)comp;
                Dimension dim = pvd.getPreferredSize();
                pageViewWidth = dim.width;
                pageViewHeight = dim.height;
                break;
            }
        }
        float currentZoom = this.documentViewModel.getViewZoom();
        pageViewWidth = Math.abs(pageViewWidth / currentZoom);
        pageViewHeight = Math.abs(pageViewHeight / currentZoom);
        return new Dimension((int)(pageViewWidth += (float)(AbstractDocumentView.horizontalSpace * 2)), (int)(pageViewHeight += (float)(AbstractDocumentView.verticalSpace * 2)));
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle clipBounds = g.getClipBounds();
        g.setColor(backgroundColor);
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        super.paintComponent(g);
    }
}

