/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.core.pobjects.annotations.LineAnnotation;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;

public class LineAnnotationHandler
extends SelectionBoxHandler
implements ToolHandler {
    private static final Logger logger;
    protected static BasicStroke stroke;
    protected static Color lineColor;
    protected static Color internalColor;
    protected static Name startLineEnding;
    protected static Name endLineEnding;
    protected Point2D startOfLine;
    protected Point2D endOfLine;
    protected BorderStyle borderStyle = new BorderStyle();

    public LineAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        super(documentViewController, pageViewComponent, documentViewModel);
        startLineEnding = LineAnnotation.LINE_END_NONE;
        endLineEnding = LineAnnotation.LINE_END_NONE;
    }

    @Override
    public void paintTool(Graphics g) {
        if (this.startOfLine != null && this.endOfLine != null) {
            Graphics2D gg = (Graphics2D)g;
            Color oldColor = gg.getColor();
            Stroke oldStroke = gg.getStroke();
            g.setColor(lineColor);
            gg.setStroke(stroke);
            g.drawLine((int)this.startOfLine.getX(), (int)this.startOfLine.getY(), (int)this.endOfLine.getX(), (int)this.endOfLine.getY());
            g.setColor(oldColor);
            gg.setStroke(oldStroke);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startOfLine = e.getPoint();
        int x = e.getX();
        int y = e.getY();
        this.currentRect = new Rectangle(x, y, 0, 0);
        this.updateDrawableRect(this.pageViewComponent.getWidth(), this.pageViewComponent.getHeight());
        this.pageViewComponent.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.endOfLine = e.getPoint();
        this.updateSelectionSize(e, this.pageViewComponent);
        this.rectToDraw.setRect(this.rectToDraw.getX() - 8.0, this.rectToDraw.getY() - 8.0, this.rectToDraw.getWidth() + 16.0, this.rectToDraw.getHeight() + 16.0);
        Rectangle tBbox = this.convertToPageSpace();
        LineAnnotation annotation = (LineAnnotation)AnnotationFactory.buildAnnotation(this.documentViewModel.getDocument().getPageTree().getLibrary(), Annotation.SUBTYPE_LINE, tBbox);
        annotation.setStartArrow(startLineEnding);
        annotation.setEndArrow(endLineEnding);
        annotation.setStartOfLine(this.startOfLine);
        annotation.setEndOfLine(this.endOfLine);
        annotation.setBorderStyle(this.borderStyle);
        annotation.setColor(lineColor);
        annotation.setInteriorColor(internalColor);
        annotation.setContents(annotation.getSubType().toString());
        annotation.setCreationDate(PDate.formatDateTime(new Date()));
        annotation.setTitleText(System.getProperty("user.name"));
        annotation.setBBox(tBbox);
        annotation.resetAppearanceStream(this.getPageTransform());
        AbstractAnnotationComponent comp = AnnotationComponentFactory.buildAnnotationComponent(annotation, this.documentViewController, this.pageViewComponent, this.documentViewModel);
        Rectangle bbox = new Rectangle(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width, this.rectToDraw.height);
        comp.setBounds(bbox);
        comp.refreshAnnotationRect();
        if (this.documentViewController.getAnnotationCallback() != null) {
            AnnotationCallback annotationCallback = this.documentViewController.getAnnotationCallback();
            annotationCallback.newAnnotation(this.pageViewComponent, comp);
        }
        this.documentViewController.getParentController().setDocumentToolMode(6);
        this.clearRectangle(this.pageViewComponent);
        this.endOfLine = null;
        this.startOfLine = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateSelectionSize(e, this.pageViewComponent);
        this.endOfLine = e.getPoint();
        this.pageViewComponent.repaint();
    }

    protected Rectangle convertToPageSpace() {
        Page currentPage = this.pageViewComponent.getPage();
        AffineTransform at = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            logger.log(Level.FINE, "Error converting to page space.", e);
        }
        Rectangle tBbox = new Rectangle(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width, this.rectToDraw.height);
        tBbox = at.createTransformedShape(tBbox).getBounds();
        this.startOfLine = at.transform(this.startOfLine, null);
        this.endOfLine = at.transform(this.endOfLine, null);
        return tBbox;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    @Override
    public void setSelectionRectangle(Point cursorLocation, Rectangle selection) {
    }

    static {
        block5: {
            int colorValue;
            String color;
            block4: {
                logger = Logger.getLogger(LineAnnotationHandler.class.toString());
                stroke = new BasicStroke(1.0f, 0, 0, 1.0f);
                try {
                    color = Defs.sysProperty("org.icepdf.core.views.page.annotation.line.stroke.color", "#ff0000");
                    colorValue = ColorUtil.convertColor(color);
                    lineColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("ff0000", 16));
                }
                catch (NumberFormatException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.warning("Error reading line Annotation stroke colour");
                }
            }
            try {
                color = Defs.sysProperty("org.icepdf.core.views.page.annotation.line.fill.color", "#ff0000");
                colorValue = ColorUtil.convertColor(color);
                internalColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("ff0000", 16));
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.warning("Error reading line Annotation fill colour");
            }
        }
        startLineEnding = LineAnnotation.LINE_END_NONE;
        endLineEnding = LineAnnotation.LINE_END_NONE;
    }
}

