/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.FreeTextAnnotation;
import org.icepdf.ri.common.tools.LineAnnotationHandler;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;

public class FreeTextAnnotationHandler
extends SelectionBoxHandler
implements ToolHandler {
    private static final Logger logger = Logger.getLogger(LineAnnotationHandler.class.toString());

    public FreeTextAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        super(documentViewController, pageViewComponent, documentViewModel);
    }

    @Override
    public void setSelectionRectangle(Point cursorLocation, Rectangle selection) {
    }

    @Override
    public void paintTool(Graphics g) {
        FreeTextAnnotationHandler.paintSelectionBox(g, this.rectToDraw);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateSelectionSize(e, this.pageViewComponent);
        if (this.rectToDraw.getWidth() < 5.0 || this.rectToDraw.getHeight() < 5.0) {
            this.rectToDraw.setSize(new Dimension(15, 25));
        }
        Rectangle tBbox = this.convertToPageSpace(this.rectToDraw).getBounds();
        FreeTextAnnotation annotation = (FreeTextAnnotation)AnnotationFactory.buildAnnotation(this.documentViewModel.getDocument().getPageTree().getLibrary(), Annotation.SUBTYPE_FREE_TEXT, tBbox);
        annotation.setCreationDate(PDate.formatDateTime(new Date()));
        annotation.setTitleText(System.getProperty("user.name"));
        annotation.setFontSize(24);
        annotation.setFontName("Helvetica");
        annotation.setContents(" ");
        AbstractAnnotationComponent comp = AnnotationComponentFactory.buildAnnotationComponent(annotation, this.documentViewController, this.pageViewComponent, this.documentViewModel);
        comp.setBounds(this.rectToDraw);
        comp.refreshAnnotationRect();
        if (this.documentViewController.getAnnotationCallback() != null) {
            AnnotationCallback annotationCallback = this.documentViewController.getAnnotationCallback();
            annotationCallback.newAnnotation(this.pageViewComponent, comp);
        }
        comp.requestFocus();
        this.documentViewController.getParentController().setDocumentToolMode(6);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateSelectionSize(e, this.pageViewComponent);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }
}

