/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.CircleAnnotation;
import org.icepdf.ri.common.tools.SquareAnnotationHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;

public class CircleAnnotationHandler
extends SquareAnnotationHandler {
    public CircleAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        super(documentViewController, pageViewComponent, documentViewModel);
    }

    @Override
    public void paintTool(Graphics g) {
        if (this.rectangle != null) {
            Ellipse2D.Double circle = new Ellipse2D.Double(this.rectangle.getMinX(), this.rectangle.getMinY(), this.rectangle.getWidth(), this.rectangle.getHeight());
            Graphics2D gg = (Graphics2D)g;
            Color oldColor = gg.getColor();
            Stroke oldStroke = gg.getStroke();
            gg.setStroke(stroke);
            gg.setColor(lineColor);
            gg.draw(circle);
            g.setColor(oldColor);
            gg.setStroke(oldStroke);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateSelectionSize(e, this.pageViewComponent);
        this.rectangle = this.convertToPageSpace(this.rectangle);
        this.rectToDraw.setRect(this.rectToDraw.getX() - 3.0, this.rectToDraw.getY() - 3.0, this.rectToDraw.getWidth() + 6.0, this.rectToDraw.getHeight() + 6.0);
        Rectangle tBbox = this.convertToPageSpace(this.rectToDraw);
        CircleAnnotation annotation = (CircleAnnotation)AnnotationFactory.buildAnnotation(this.documentViewModel.getDocument().getPageTree().getLibrary(), Annotation.SUBTYPE_CIRCLE, tBbox);
        annotation.setColor(lineColor);
        if (annotation.isFillColor()) {
            annotation.setFillColor(internalColor);
        }
        annotation.setRectangle(this.rectangle);
        annotation.setBorderStyle(this.borderStyle);
        annotation.setBBox(tBbox);
        annotation.resetAppearanceStream(this.getPageTransform());
        AbstractAnnotationComponent comp = AnnotationComponentFactory.buildAnnotationComponent(annotation, this.documentViewController, this.pageViewComponent, this.documentViewModel);
        Rectangle bbox = new Rectangle(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width, this.rectToDraw.height);
        comp.setBounds(bbox);
        comp.refreshAnnotationRect();
        if (this.documentViewController.getAnnotationCallback() != null) {
            AnnotationCallback annotationCallback = this.documentViewController.getAnnotationCallback();
            annotationCallback.newAnnotation(this.pageViewComponent, comp);
        }
        this.documentViewController.getParentController().setDocumentToolMode(6);
        this.rectangle = null;
        this.clearRectangle(this.pageViewComponent);
    }
}

