/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.Thumbnail;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.SwingController;

public class PageThumbnailComponent
extends JComponent
implements MouseListener {
    private static final Logger logger = Logger.getLogger(PageThumbnailComponent.class.toString());
    private float thumbNailZoom;
    private JScrollPane parentScrollPane;
    private PageTree pageTree;
    private int pageIndex;
    private boolean initiatedThumbnailGeneration;
    private Rectangle pageSize = new Rectangle();
    private boolean isPageSizeCalculated = false;
    private SwingController controller;
    private SoftReference<Image> bufferedPageImageReference;
    private boolean disposing = false;
    private boolean inited;

    public PageThumbnailComponent(SwingController controller, JScrollPane parentScrollPane, PageTree pageTree, int pageNumber, float thumbNailZoom) {
        this(controller, parentScrollPane, pageTree, pageNumber, 0, 0, thumbNailZoom);
    }

    public PageThumbnailComponent(SwingController controller, JScrollPane parentScrollPane, PageTree pageTree, int pageNumber, int width, int height, float thumbNailZoom) {
        this.parentScrollPane = parentScrollPane;
        this.pageTree = pageTree;
        this.pageIndex = pageNumber;
        this.controller = controller;
        this.thumbNailZoom = thumbNailZoom;
        this.addMouseListener(this);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.bufferedPageImageReference = new SoftReference<Object>(null);
        if (width == 0 && height == 0) {
            this.calculatePageSize(this.pageSize);
            this.isPageSizeCalculated = true;
        } else {
            this.pageSize.setSize(width, height);
        }
    }

    public void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
    }

    public void dispose() {
        Image pageBufferImage;
        this.disposing = true;
        this.removeMouseListener(this);
        if (this.bufferedPageImageReference != null && (pageBufferImage = this.bufferedPageImageReference.get()) != null) {
            pageBufferImage.flush();
        }
        this.inited = false;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.pageSize.getSize();
    }

    @Override
    public void paintComponent(Graphics gg) {
        if (!this.inited) {
            this.init();
        }
        if (this.controller != null && this.controller.getCurrentPageNumber() == this.pageIndex) {
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 3));
        } else {
            this.setBorder(null);
        }
        if (!this.isPageSizeCalculated) {
            this.calculatePageSize(this.pageSize);
            this.invalidate();
        }
        Graphics2D g = (Graphics2D)gg.create(0, 0, this.pageSize.width, this.pageSize.height);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.pageSize.width, this.pageSize.height);
        Page page = this.pageTree.getPage(this.pageIndex);
        if (this.bufferedPageImageReference.get() != null) {
            g.drawImage(this.bufferedPageImageReference.get(), 0, 0, null);
        } else if (page != null && page.getThumbnail() != null) {
            Thumbnail thumbNail = page.getThumbnail();
            this.bufferedPageImageReference = new SoftReference<BufferedImage>(thumbNail.getImage());
            g.drawImage((Image)thumbNail.getImage(), 0, 0, null);
        }
        if (this.bufferedPageImageReference.get() == null && !this.initiatedThumbnailGeneration) {
            if (this.parentScrollPane != null && this.parentScrollPane.getVerticalScrollBar().getValueIsAdjusting()) {
                return;
            }
            this.initiatedThumbnailGeneration = true;
            Library.executePainter(new PagePainter());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.controller != null) {
            this.controller.showPage(this.pageIndex);
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void calculatePageSize(Rectangle pageSize) {
        Page currentPage;
        if (this.pageTree != null && (currentPage = this.pageTree.getPage(this.pageIndex)) != null) {
            if (currentPage.getThumbnail() != null) {
                pageSize.setSize(currentPage.getThumbnail().getDimension());
            } else {
                pageSize.setSize(currentPage.getSize(2, 0.0f, this.thumbNailZoom).toDimension());
            }
        }
    }

    class PagePainter
    implements Runnable {
        PagePainter() {
        }

        @Override
        public void run() {
            if (PageThumbnailComponent.this.pageTree != null) {
                BufferedImage image = new BufferedImage(((PageThumbnailComponent)PageThumbnailComponent.this).pageSize.width, ((PageThumbnailComponent)PageThumbnailComponent.this).pageSize.height, 2);
                Graphics2D imageGraphics = image.createGraphics();
                Page page = PageThumbnailComponent.this.pageTree.getPage(PageThumbnailComponent.this.pageIndex);
                page.init();
                if (page != null) {
                    page.paint(imageGraphics, 1, 2, 0.0f, PageThumbnailComponent.this.thumbNailZoom, true, false);
                }
                PageThumbnailComponent.this.bufferedPageImageReference = new SoftReference<BufferedImage>(image);
                PageThumbnailComponent.this.initiatedThumbnailGeneration = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PageThumbnailComponent.this.parentScrollPane.repaint();
                    }
                });
            }
        }
    }
}

