/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.views.AbstractDocumentView;

public class KeyListenerPageChanger
extends KeyAdapter {
    private SwingController controller;
    private JScrollPane scroll;
    private AbstractDocumentView documentView;
    private boolean changingPage;

    public static KeyListenerPageChanger install(SwingController c, JScrollPane s, AbstractDocumentView documentView) {
        KeyListenerPageChanger listener = null;
        if (c != null && s != null) {
            listener = new KeyListenerPageChanger(c, s, documentView);
            s.addKeyListener(listener);
        }
        return listener;
    }

    public void uninstall() {
        if (this.scroll != null) {
            this.scroll.removeKeyListener(this);
        }
    }

    protected KeyListenerPageChanger(SwingController c, JScrollPane s, AbstractDocumentView documentView) {
        this.controller = c;
        this.scroll = s;
        this.documentView = documentView;
        this.changingPage = false;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int value;
        if (this.changingPage) {
            return;
        }
        int deltaPage = 0;
        JScrollBar visibleVerticalScrollBar = this.scroll.getVerticalScrollBar() != null && this.scroll.getVerticalScrollBar().isVisible() ? this.scroll.getVerticalScrollBar() : null;
        int keyCode = e.getKeyCode();
        if (keyCode == 34 || keyCode == 40) {
            if (visibleVerticalScrollBar != null) {
                int max;
                int extent;
                value = visibleVerticalScrollBar.getModel().getValue();
                if (value + (extent = visibleVerticalScrollBar.getModel().getExtent()) >= (max = visibleVerticalScrollBar.getModel().getMaximum())) {
                    deltaPage = this.documentView.getNextPageIncrement();
                }
            } else {
                deltaPage = this.documentView.getNextPageIncrement();
            }
        } else if (keyCode == 33 || keyCode == 38) {
            if (visibleVerticalScrollBar != null) {
                value = visibleVerticalScrollBar.getModel().getValue();
                if (value <= 0) {
                    deltaPage = -this.documentView.getPreviousPageIncrement();
                }
            } else {
                deltaPage = -this.documentView.getPreviousPageIncrement();
            }
        } else if (keyCode == 36) {
            deltaPage = -this.controller.getCurrentPageNumber();
        } else if (keyCode == 35) {
            deltaPage = this.controller.getDocument().getNumberOfPages() - this.controller.getCurrentPageNumber() - 1;
        }
        if (deltaPage == 0) {
            return;
        }
        int newPage = this.controller.getCurrentPageNumber() + deltaPage;
        if (this.controller.getDocument() == null) {
            return;
        }
        if (newPage < 0) {
            deltaPage = -this.controller.getCurrentPageNumber();
        }
        if (newPage >= this.controller.getDocument().getNumberOfPages()) {
            deltaPage = this.controller.getDocument().getNumberOfPages() - this.controller.getCurrentPageNumber() - 1;
        }
        if (deltaPage == 0) {
            return;
        }
        this.changingPage = true;
        final int dp = deltaPage;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KeyListenerPageChanger.this.changingPage = false;
                KeyListenerPageChanger.this.controller.goToDeltaPage(dp);
            }
        });
    }
}

