/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

public class ICCBased
extends PColorSpace {
    private static final Logger logger = Logger.getLogger(ICCBased.class.toString());
    public static final Name ICCBASED_KEY = new Name("ICCBased");
    public static final Name N_KEY = new Name("N");
    int numcomp;
    PColorSpace alternate;
    Stream stream;
    ColorSpace colorSpace;
    private float[] lastInput;
    private Color lastOutput;

    public ICCBased(Library l, Stream h) {
        super(l, h.getEntries());
        this.numcomp = h.getInt(N_KEY);
        switch (this.numcomp) {
            case 1: {
                this.alternate = new DeviceGray(l, null);
                break;
            }
            case 3: {
                this.alternate = new DeviceRGB(l, null);
                break;
            }
            case 4: {
                this.alternate = new DeviceCMYK(l, null);
            }
        }
        this.stream = h;
    }

    @Override
    public synchronized void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        byte[] in = null;
        try {
            this.stream.init();
            in = this.stream.getDecodedStreamBytes(0);
            if (logger.isLoggable(Level.FINEST)) {
                String content = Utils.convertByteArrayToByteString(in);
                logger.finest("Content = " + content);
            }
            if (in != null) {
                ICC_Profile profile = ICC_Profile.getInstance(in);
                this.colorSpace = new ICC_ColorSpace(profile);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error Processing ICCBased Colour Profile", e);
        }
    }

    public PColorSpace getAlternate() {
        return this.alternate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Color getColor(float[] f, boolean fillAndStroke) {
        this.init();
        if (this.colorSpace != null) {
            try {
                ICCBased iCCBased = this;
                synchronized (iCCBased) {
                    if (this.lastOutput != null && this.lastInput != null && f != null && this.lastInput.length == f.length) {
                        boolean matches = true;
                        int num = this.lastInput.length;
                        for (int i = num - 1; i >= 0; --i) {
                            if (f[i] == this.lastInput[i]) continue;
                            matches = false;
                            break;
                        }
                        if (matches) {
                            return this.lastOutput;
                        }
                    }
                    int n = this.colorSpace.getNumComponents();
                    float[] fvalue = new float[n];
                    int fLength = f.length;
                    int toCopy = n;
                    if (fLength < toCopy) {
                        toCopy = fLength;
                    }
                    for (int i = 0; i < toCopy; ++i) {
                        float curr = f[fLength - 1 - i];
                        if (curr < 0.0f) {
                            curr = 0.0f;
                        } else if (curr > 1.0f) {
                            curr = 1.0f;
                        }
                        fvalue[i] = curr;
                    }
                    float[] frgbvalue = this.colorSpace.toRGB(fvalue);
                    int value = 0xFF000000 | ((int)(frgbvalue[0] * 255.0f) & 0xFF) << 16 | ((int)(frgbvalue[1] * 255.0f) & 0xFF) << 8 | (int)(frgbvalue[2] * 255.0f) & 0xFF;
                    Color c = new Color(value);
                    if (this.lastInput == null || this.lastInput.length != fLength) {
                        this.lastInput = new float[fLength];
                    }
                    for (int i = fLength - 1; i >= 0; --i) {
                        this.lastInput[i] = f[i];
                    }
                    this.lastOutput = c;
                    return c;
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error getting ICCBased colour", e);
            }
        }
        return this.alternate.getColor(f);
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    @Override
    public int getNumComponents() {
        return this.numcomp;
    }
}

