/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.OptionalContentGroup;
import org.icepdf.core.pobjects.OptionalContentMembership;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;

public class OptionalContent
extends Dictionary {
    private Map<Reference, OptionalContentGroup> groups;
    public static final Name OCGs_KEY = new Name("OCGs");
    public static final Name OC_KEY = new Name("OC");
    public static final Name D_KEY = new Name("D");
    public static final Name BASE_STATE_KEY = new Name("BaseState");
    public static final Name INTENT_KEY = new Name("Intent");
    public static final Name AS_KEY = new Name("AS");
    public static final Name ORDER_KEY = new Name("Order");
    public static final Name LIST_MODE_KEY = new Name("ListMode");
    public static final Name RBGROUPS_KEY = new Name("RBGroups");
    public static final Name LOCKED_KEY = new Name("Locked");
    public static final Name OFF_VALUE = new Name("OFF");
    public static final Name ON_vALUE = new Name("ON");
    public static final Name UNCHANGED_KEY = new Name("Unchanged");
    public static final Name VIEW_VALUE = new Name("View");
    public static final Name DESIGN_VALUE = new Name("Design");
    public static final Name NONE_OC_FLAG = new Name("marked");
    private Name baseState = ON_vALUE;
    private List<Name> intent = Arrays.asList(VIEW_VALUE);
    private List<Object> order;
    private List<Object> rbGroups;

    public OptionalContent(Library l, HashMap h) {
        super(l, h);
        this.groups = new HashMap<Reference, OptionalContentGroup>();
    }

    @Override
    public void init() {
        Object dObj;
        if (this.inited) {
            return;
        }
        Object ogcs = this.library.getObject(this.entries, OCGs_KEY);
        if (ogcs instanceof List) {
            List ogcList = (List)ogcs;
            for (Object object : ogcList) {
                Reference ref;
                Object ocgObj;
                if (!(object instanceof Reference) || !((ocgObj = this.library.getObject(ref = (Reference)object)) instanceof OptionalContentGroup)) continue;
                OptionalContentGroup ogc = (OptionalContentGroup)ocgObj;
                this.groups.put(ref, ogc);
            }
        }
        if ((dObj = this.library.getObject(this.entries, D_KEY)) instanceof HashMap) {
            List orderedOCs;
            boolean isBaseOn;
            List toggle;
            HashMap configurationDictionary = (HashMap)dObj;
            Object tmp = this.library.getName(configurationDictionary, BASE_STATE_KEY);
            if (tmp != null && tmp instanceof Name) {
                this.baseState = tmp;
            }
            if ((toggle = (isBaseOn = this.baseState.equals(ON_vALUE)) ? this.library.getArray(configurationDictionary, OFF_VALUE) : this.library.getArray(configurationDictionary, ON_vALUE)) != null) {
                for (Object obj : toggle) {
                    OptionalContentGroup ocg = this.groups.get(obj);
                    if (ocg == null) continue;
                    if (isBaseOn) {
                        ocg.setVisible(false);
                        continue;
                    }
                    ocg.setVisible(true);
                }
            }
            if ((tmp = this.library.getName(configurationDictionary, INTENT_KEY)) != null) {
                if (tmp instanceof Name) {
                    this.intent = Arrays.asList((Name)tmp);
                } else if (tmp instanceof List) {
                    this.intent = (List)tmp;
                }
            }
            if ((tmp = this.library.getObject(configurationDictionary, ORDER_KEY)) != null && tmp instanceof List && (orderedOCs = (List)tmp).size() > 0) {
                this.order = new ArrayList<Object>(orderedOCs.size());
                this.order = this.parseOrderArray(orderedOCs, null);
            }
            if ((tmp = this.library.getObject(configurationDictionary, RBGROUPS_KEY)) != null && tmp instanceof List && (orderedOCs = (List)tmp).size() > 0) {
                this.rbGroups = new ArrayList<Object>(orderedOCs.size());
                this.rbGroups = this.parseOrderArray(orderedOCs, null);
            }
        }
        this.inited = true;
    }

    private List<Object> parseOrderArray(List<Object> rawOrder, OptionalContentGroup parent) {
        ArrayList<Object> order = new ArrayList<Object>(5);
        OptionalContentGroup group = null;
        for (Object obj : rawOrder) {
            if (obj instanceof Reference) {
                OptionalContentGroup refObject = this.getOCGs((Reference)obj);
                if (refObject != null) {
                    group = refObject;
                    if (parent != null && !parent.isVisible()) {
                        group.setVisible(false);
                    }
                    order.add(group);
                } else {
                    obj = this.library.getObject((Reference)obj);
                }
            }
            if (obj instanceof List) {
                parent = group;
                order.add(this.parseOrderArray((List)obj, parent));
                continue;
            }
            if (!(obj instanceof StringObject)) continue;
            order.add(Utils.convertStringObject(this.library, (StringObject)obj));
        }
        return order;
    }

    public boolean isVisible(Reference ocgRef) {
        Object object = this.library.getObject(ocgRef);
        if (object instanceof OptionalContentGroup) {
            return this.isVisible((OptionalContentGroup)object);
        }
        if (object instanceof OptionalContentMembership) {
            return this.isVisible((OptionalContentMembership)object);
        }
        return false;
    }

    public boolean isVisible(OptionalContentGroup ocg) {
        return this.groups.containsKey(ocg.getPObjectReference());
    }

    public boolean isVisible(OptionalContentMembership ocmd) {
        ocmd.init();
        return ocmd.isVisible();
    }

    public boolean isVisible(Object object) {
        if (object instanceof Reference) {
            return this.isVisible((Reference)object);
        }
        if (object instanceof OptionalContentGroup) {
            return this.isVisible((OptionalContentGroup)object);
        }
        if (object instanceof OptionalContentMembership) {
            return this.isVisible((OptionalContentMembership)object);
        }
        return true;
    }

    public List<Object> getOrder() {
        return this.order;
    }

    public List<Name> getIntent() {
        return this.intent;
    }

    public int getGroupsSize() {
        return this.groups.size();
    }

    public List<Object> getRbGroups() {
        return this.rbGroups;
    }

    public OptionalContentGroup getOCGs(Reference reference) {
        return this.groups.get(reference);
    }
}

