/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableByteArrayInputStream;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;

public class ObjectStream
extends Stream {
    private static final Logger logger = Logger.getLogger(Form.class.toString());
    public static final Name N_KEY = new Name("N");
    public static final Name FIRST_KEY = new Name("First");
    private boolean init;
    private SeekableInput decodedStream;
    private int[] objectNumbers;
    private long[] objectOffset;

    public ObjectStream(Library l, HashMap h, SeekableInputConstrainedWrapper streamInputWrapper) {
        super(l, h, streamInputWrapper);
    }

    @Override
    public synchronized void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        int numObjects = this.library.getInt(this.entries, N_KEY);
        long firstObjectsOffset = this.library.getLong(this.entries, FIRST_KEY);
        this.decodedStream = new SeekableByteArrayInputStream(this.getDecodedStreamBytes(0));
        this.objectNumbers = new int[numObjects];
        this.objectOffset = new long[numObjects];
        try {
            Parser parser = new Parser(this.decodedStream);
            for (int i = 0; i < numObjects; ++i) {
                this.objectNumbers[i] = parser.getIntSurroundedByWhitespace();
                this.objectOffset[i] = parser.getLongSurroundedByWhitespace() + firstObjectsOffset;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error loading object stream instance: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object loadObject(Library library, int objectIndex) {
        this.init();
        if (this.objectNumbers == null || this.objectOffset == null || this.objectNumbers.length != this.objectOffset.length || objectIndex < 0 || objectIndex >= this.objectNumbers.length) {
            return null;
        }
        try {
            Reference ref;
            int objectNumber = this.objectNumbers[objectIndex];
            long position = this.objectOffset[objectIndex];
            this.decodedStream.beginThreadAccess();
            this.decodedStream.seekAbsolute(position);
            Parser parser = new Parser(this.decodedStream, 1);
            Object ob = parser.getObject(library);
            if (ob == null) {
                ref = new Reference(objectNumber, 0);
                PObject pObject = parser.addPObject(library, ref);
                ob = pObject.getObject();
            } else if (!(ob instanceof PObject)) {
                ref = new Reference(objectNumber, 0);
                library.addObject(ob, ref);
            }
            if (ob != null && ob instanceof Dictionary) {
                ((Dictionary)ob).setPObjectReference(new Reference(objectNumber, 0));
            }
            Object object = ob;
            return object;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error loading PDF object.", e);
            Object var4_6 = null;
            return var4_6;
        }
        finally {
            this.decodedStream.endThreadAccess();
        }
    }
}

