/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.IOException;
import java.io.InputStream;
import org.icepdf.core.io.SeekableInput;

public class SeekableInputConstrainedWrapper
extends InputStream {
    private SeekableInput streamDataInput;
    private long filePositionOfStreamData;
    private long lengthOfStreamData;
    private long filePositionBeforeUse;
    private boolean usedYet;

    public SeekableInputConstrainedWrapper(SeekableInput in, long offset, long length) {
        this.streamDataInput = in;
        this.filePositionOfStreamData = offset;
        this.lengthOfStreamData = length;
        this.filePositionBeforeUse = 0L;
        this.usedYet = false;
    }

    private void ensureReadyOnFirstUse() throws IOException {
        if (this.usedYet) {
            return;
        }
        this.usedYet = true;
        this.filePositionBeforeUse = this.streamDataInput.getAbsolutePosition();
        this.streamDataInput.seekAbsolute(this.filePositionOfStreamData);
    }

    private long getBytesRemaining() throws IOException {
        long absPos = this.streamDataInput.getAbsolutePosition();
        if (absPos < this.filePositionOfStreamData) {
            return -1L;
        }
        long end = this.filePositionOfStreamData + this.lengthOfStreamData;
        return end - absPos;
    }

    @Override
    public int read() throws IOException {
        this.ensureReadyOnFirstUse();
        long remain = this.getBytesRemaining();
        if (remain <= 0L) {
            return -1;
        }
        return this.streamDataInput.read();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        this.ensureReadyOnFirstUse();
        long remain = this.getBytesRemaining();
        if (remain <= 0L) {
            return -1;
        }
        length = (int)Math.min(Math.min(remain, (long)length), Integer.MAX_VALUE);
        return this.streamDataInput.read(buffer, offset, length);
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureReadyOnFirstUse();
        long remain = this.getBytesRemaining();
        if (remain <= 0L) {
            return -1L;
        }
        n = (int)Math.min(Math.min(remain, n), Integer.MAX_VALUE);
        return this.streamDataInput.skip(n);
    }

    public void seekAbsolute(long absolutePosition) throws IOException {
        this.ensureReadyOnFirstUse();
        if (absolutePosition < 0L) {
            throw new IOException("Attempt to absolutely seek to negative location: " + absolutePosition);
        }
        this.streamDataInput.seekAbsolute(absolutePosition += this.filePositionOfStreamData);
    }

    public void seekRelative(long relativeOffset) throws IOException {
        this.ensureReadyOnFirstUse();
        long pos = this.streamDataInput.getAbsolutePosition();
        if ((pos += relativeOffset) < this.filePositionOfStreamData) {
            pos = this.filePositionOfStreamData;
        }
        this.streamDataInput.seekAbsolute(pos);
    }

    public void seekEnd() throws IOException {
        this.ensureReadyOnFirstUse();
        this.streamDataInput.seekAbsolute(this.filePositionOfStreamData + this.lengthOfStreamData);
    }

    public long getAbsolutePosition() throws IOException {
        this.ensureReadyOnFirstUse();
        long absolutePosition = this.getAbsolutePosition();
        return absolutePosition -= this.filePositionOfStreamData;
    }

    public long getLength() {
        return this.lengthOfStreamData;
    }

    public InputStream getInputStream() {
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" ( ");
        sb.append("pos=").append(this.filePositionOfStreamData).append(", ");
        sb.append("len=").append(this.lengthOfStreamData).append(", ");
        sb.append("posToRestore=").append(this.filePositionBeforeUse).append(", ");
        sb.append(" ) ");
        sb.append(": ");
        if (this.streamDataInput == null) {
            sb.append("null ");
        } else {
            sb.append(this.streamDataInput.toString());
        }
        return sb.toString();
    }
}

