/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.printpdf;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Vector;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;
import se.sjobeck.geometra.printpdf.PDFWriter;

public abstract class AbstractPDFWriter
implements PDFWriter {
    protected float width = 0.0f;
    protected float height = 0.0f;
    protected float area_opacity = 0.0f;
    protected float line_opacity = 0.0f;
    protected float text_opacity = 0.0f;
    protected int textSize = 10;
    protected boolean blackTextOnly = false;
    ROTATION rot;

    @Override
    public void setOpacity(int area_opacity, int line_opacity, int text_opacity) {
        this.area_opacity = (float)area_opacity * 0.01f;
        this.line_opacity = (float)line_opacity * 0.01f;
        this.text_opacity = (float)text_opacity * 0.01f;
    }

    @Override
    public void setOpacity(int area_opacity, int line_opacity, int text_opacity, int textSize, boolean nurSchwartz) {
        this.setOpacity(area_opacity, line_opacity, text_opacity);
        this.textSize = textSize;
        this.blackTextOnly = nurSchwartz;
    }

    @Override
    public abstract void printPDF_pages_only(List<GeometraDrawingImpl> var1, String var2, String var3, ROTATION var4);

    protected Point2D rotateMe(Point2D p2d) {
        Point2D.Float p = new Point2D.Float();
        switch (this.rot) {
            case LowerLeft: {
                ((Point2D)p).setLocation(p2d.getX(), p2d.getY());
                break;
            }
            case LowerRight: {
                ((Point2D)p).setLocation((double)this.width - p2d.getX(), p2d.getY());
                break;
            }
            case UpperLeft: {
                ((Point2D)p).setLocation(p2d.getX(), (double)this.height - p2d.getY());
                break;
            }
            case UpperRight: {
                ((Point2D)p).setLocation((double)this.width - p2d.getX(), (double)this.height - p2d.getY());
                break;
            }
            case MirrorLowerLeft: {
                ((Point2D)p).setLocation(p2d.getY(), p2d.getX());
                break;
            }
            case MirrorLowerRight: {
                ((Point2D)p).setLocation((double)this.width - p2d.getY(), p2d.getX());
                break;
            }
            case MirrorUpperLeft: {
                ((Point2D)p).setLocation(p2d.getY(), (double)this.height - p2d.getX());
                break;
            }
            case MirrorUpperRight: {
                ((Point2D)p).setLocation((double)this.width - p2d.getY(), (double)this.height - p2d.getX());
            }
        }
        return p;
    }

    protected void setRotation(int i) {
        switch (i) {
            case 0: {
                this.rot = ROTATION.LowerLeft;
                break;
            }
            case 1: {
                this.rot = ROTATION.LowerRight;
                break;
            }
            case 2: {
                this.rot = ROTATION.UpperLeft;
                break;
            }
            case 3: {
                this.rot = ROTATION.UpperRight;
                break;
            }
            case 4: {
                this.rot = ROTATION.MirrorLowerLeft;
                break;
            }
            case 5: {
                this.rot = ROTATION.MirrorLowerRight;
                break;
            }
            case 6: {
                this.rot = ROTATION.MirrorUpperLeft;
                break;
            }
            case 7: {
                this.rot = ROTATION.MirrorUpperRight;
            }
        }
    }

    protected Color getColor(int i) {
        Color color = Color.BLACK;
        switch (i) {
            case 0: {
                color = Color.BLUE;
                break;
            }
            case 1: {
                color = Color.CYAN;
                break;
            }
            case 2: {
                color = Color.GREEN;
                break;
            }
            case 3: {
                color = Color.MAGENTA;
                break;
            }
            case 4: {
                color = Color.ORANGE;
                break;
            }
            case 5: {
                color = Color.PINK;
                break;
            }
            case 6: {
                color = Color.RED;
                break;
            }
            case 7: {
                color = Color.YELLOW;
            }
        }
        return color;
    }

    protected class GeometraDrawingImplSorter {
        private Vector<GeometraDrawingImpl> myDrawings = new Vector();
        private BlueprintPage page = null;
        private int sidNummer = -1;
        private GeometraDrawingImplSorter next = null;

        protected GeometraDrawingImplSorter() {
        }

        public void insert(GeometraDrawingImpl in) {
            BlueprintPage page1 = in.getParent();
            if (this.page == null) {
                this.page = page1;
                this.myDrawings.add(in);
                Blueprint parent = this.page.getParent();
                for (int i = 0; i < parent.getNumberOfPages(); ++i) {
                    if (!this.page.equals(parent.getPage(i))) continue;
                    this.sidNummer = i;
                    break;
                }
            } else if (page1.equals(this.page)) {
                this.myDrawings.add(in);
            } else if (this.next == null) {
                this.next = new GeometraDrawingImplSorter();
                this.next.insert(in);
            } else {
                this.next.insert(in);
            }
        }

        public Vector<GeometraDrawingImpl> getDrawings() {
            return this.myDrawings;
        }

        public GeometraDrawingImplSorter getNext() {
            return this.next;
        }

        public int getSidnummer() {
            return this.sidNummer;
        }
    }

    protected class MyPoint {
        public float x = 0.0f;
        public float y = 0.0f;

        public MyPoint(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }

    public static enum ROTATION {
        LowerLeft,
        LowerRight,
        UpperLeft,
        UpperRight,
        MirrorLowerLeft,
        MirrorLowerRight,
        MirrorUpperLeft,
        MirrorUpperRight;

    }
}

