/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataListener;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.blueprint.GeometraManager;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.datastructures.drawings.DotDrawing;
import se.sjobeck.geometra.datastructures.drawings.LineDrawing;
import se.sjobeck.geometra.datastructures.drawings.SmartDrawing;
import se.sjobeck.geometra.datastructures.drawings.SquareDrawing;
import se.sjobeck.geometra.datastructures.drawings.TotalDrawing;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.panels.ButtonPane;
import se.sjobeck.geometra.gui.panels.GeometraButton;
import se.sjobeck.images.IconLoader;

public class TotalDrawingJPanel
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel creationPanel = new JPanel();
    private final JPanel buttonPane = new JPanel();
    private final JComboBox sortBox = new JComboBox();
    private final JLabel sortLabel = new JLabel(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOTALDRAWING_WINDOW_SORT_BY") + ":");
    private final GeometraManager geoManager = GeometraManager.getInstance();
    private final TreePanel leftPanel = new TreePanel(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOTALDRAWING_WINDOW_LEFT_LABEL"), true);
    private final TreePanel rightPanel = new TreePanel(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOTALDRAWING_WINDOW_RIGHT_LABEL"), false);
    private JButton firstButton;
    private JButton secondButton;
    private EmptyListModel emptyModel;
    private JTextField creationField;
    private JButton creationButton;
    private JButton cancelButton;
    final ActionListener cancel = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            TotalDrawingJPanel.this.setVisible(false);
        }
    };
    final ActionListener totalDrawingCreator = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            TotalDrawingJPanel.this.emptyModel = (EmptyListModel)TotalDrawingJPanel.this.rightPanel.getModel();
            String totalName = TotalDrawingJPanel.this.creationField.getText();
            if (totalName == null || totalName.length() <= 0) {
                return;
            }
            TotalDrawing td = new TotalDrawing(TotalDrawingJPanel.this.emptyModel.getTotalDrawings());
            td.setDescription(GeometraManager.getInstance().getValidName(totalName));
            GeometraSubject.getInstance().add(td, this);
            TotalDrawingJPanel.this.setVisible(false);
        }
    };
    final ActionListener listManipulater = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource().equals(TotalDrawingJPanel.this.firstButton)) {
                GeometraCollection<GeometraDrawing> selectedDrawings = TotalDrawingJPanel.this.leftPanel.getSelectedDrawings();
                TotalDrawingJPanel.this.addFromLeftToRight(selectedDrawings);
            } else if (event.getSource().equals(TotalDrawingJPanel.this.secondButton)) {
                GeometraCollection<GeometraDrawing> selectedDrawings = TotalDrawingJPanel.this.rightPanel.getSelectedDrawings();
                TotalDrawingJPanel.this.addFromRightToLeft(selectedDrawings);
            }
        }
    };
    private final ActionListener sortBoxListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource().equals(TotalDrawingJPanel.this.sortBox)) {
                JComboBox box = (JComboBox)event.getSource();
                Object ob = box.getSelectedItem();
                TotalDrawingJPanel.this.sortItemsBy(ob);
            }
        }
    };

    public TotalDrawingJPanel() {
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setPreferredSize(new Dimension(420, 320));
        this.setMinimumSize(new Dimension(420, 320));
        this.setMaximumSize(new Dimension(420, 320));
        this.setResizable(false);
        this.createCreationPane();
        this.createButtonPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.leftPanel, "West");
        this.add((Component)this.rightPanel, "East");
        this.add((Component)this.buttonPane, "Center");
        this.add((Component)this.creationPanel, "South");
    }

    private void createButtonPane() {
        this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 3));
        ImageIcon first = ButtonPane.createIcon("left.png");
        this.firstButton = new GeometraButton(first);
        this.firstButton.addActionListener(this.listManipulater);
        ImageIcon second = ButtonPane.createIcon("right.png");
        this.secondButton = new GeometraButton(second);
        this.secondButton.addActionListener(this.listManipulater);
        this.buttonPane.add(Box.createRigidArea(new Dimension(0, 100)));
        this.buttonPane.add(this.firstButton);
        this.buttonPane.add(Box.createRigidArea(new Dimension(0, 10)));
        this.buttonPane.add(this.secondButton);
        this.buttonPane.add(Box.createRigidArea(new Dimension(0, 100)));
    }

    private void addFromLeftToRight(GeometraCollection<GeometraDrawing> selectedDrawings) {
        if (selectedDrawings.size() == 0) {
            return;
        }
        this.rightPanel.addDrawings(selectedDrawings);
        this.leftPanel.removeDrawings(selectedDrawings);
    }

    private void addFromRightToLeft(GeometraCollection<GeometraDrawing> selectedDrawings) {
        this.leftPanel.addDrawings(selectedDrawings);
        this.rightPanel.removeDrawings(selectedDrawings);
    }

    private void createCreationPane() {
        this.creationPanel.setLayout(new GridLayout(2, 1));
        JLabel creationLabel = new JLabel(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_NAME_SINGLE") + ":");
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new FlowLayout(3));
        this.creationField = new JTextField(15);
        this.creationButton = new GeometraButton(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_CREATE"));
        this.creationButton.addActionListener(this.totalDrawingCreator);
        this.cancelButton = new GeometraButton(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(this.cancel);
        infoPanel.add(creationLabel);
        infoPanel.add(this.creationField);
        infoPanel.add(this.creationButton);
        infoPanel.add(this.cancelButton);
        JPanel sortPanel = new JPanel();
        sortPanel.add(this.sortLabel);
        sortPanel.add(this.sortBox);
        this.sortBox.addActionListener(this.sortBoxListener);
        this.creationPanel.add(sortPanel);
        this.creationPanel.add(infoPanel);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.leftPanel.updateModel();
            this.rightPanel.updateModel();
        }
        if (visible) {
            this.setLocationRelativeTo(Geometra.GEOMETRA_FRAME);
        }
        super.setVisible(visible);
    }

    private void sortItemsBy(Object ob) {
        this.leftPanel.filterList(ob);
    }

    private class TotalDrawingCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private final String ABSOLUTEPATHSTR = "/se/sjobeck/geometra/gui/panels/jtreeicons/";
        private final Icon squareIcon = IconLoader.getIcon("/se/sjobeck/geometra/gui/panels/jtreeicons/Area.png");
        private final Icon lineIcon = IconLoader.getIcon("/se/sjobeck/geometra/gui/panels/jtreeicons/Line.png");
        private final Icon pdfIcon = ButtonPane.createIcon("pdf.gif");
        private final Icon smartDrawingIcon = ButtonPane.createIcon("smart.png");
        private JLabel currentCell = new JLabel();
        protected Border noFocusBorder = new EmptyBorder(15, 1, 1, 1);
        protected TitledBorder focusBorder = new TitledBorder(LineBorder.createGrayLineBorder(), "Focused");

        private TotalDrawingCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            this.currentCell = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (value instanceof Blueprint) {
                this.currentCell.setIcon(this.pdfIcon);
                this.currentCell.setText(((Blueprint)value).getDescription());
            } else if (value instanceof GeometraDrawing) {
                GeometraDrawing gd = (GeometraDrawing)value;
                this.currentCell.setText(gd.getDescription());
                if (gd instanceof SquareDrawing) {
                    this.currentCell.setIcon(this.squareIcon);
                } else if (gd instanceof LineDrawing) {
                    this.currentCell.setIcon(this.lineIcon);
                } else if (gd instanceof SmartDrawing) {
                    this.currentCell.setIcon(this.smartDrawingIcon);
                }
            }
            return this.currentCell;
        }
    }

    public abstract class AbstractTotalDrawingModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;

        @Override
        public abstract Object getElementAt(int var1);

        @Override
        public abstract int getSize();

        public abstract void addDrawings(GeometraCollection<GeometraDrawing> var1);

        public abstract void removeDrawings(GeometraCollection<GeometraDrawing> var1);
    }

    private class TotalDrawingListModel
    extends AbstractTotalDrawingModel {
        private static final long serialVersionUID = 1L;
        private GeometraCollection<GeometraDrawing> dataModel;

        private TotalDrawingListModel() {
            this.dataModel = TotalDrawingJPanel.this.geoManager.getTotalDrawings();
        }

        @Override
        public Object getElementAt(int index) {
            if (index < this.dataModel.size()) {
                return this.dataModel.get(index);
            }
            return null;
        }

        public void filterList(Object ob) {
            this.dataModel = TotalDrawingJPanel.this.geoManager.getTotalDrawings();
            GeometraCollection<Object> newModel = new GeometraCollection();
            if (ob instanceof Blueprint) {
                Blueprint bp = (Blueprint)ob;
                for (GeometraDrawing gd : this.dataModel) {
                    if (!gd.getParent().getParent().equals(bp)) continue;
                    newModel.add(gd);
                }
            } else if (ob instanceof BlueprintPage) {
                BlueprintPage page = (BlueprintPage)ob;
                for (GeometraDrawing gd : this.dataModel) {
                    if (!gd.getParent().equals(page)) continue;
                    newModel.add(gd);
                }
            } else if (ob instanceof String) {
                if (ob.equals(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_ALL"))) {
                    newModel = this.dataModel;
                } else if (ob.equals(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_LINE"))) {
                    for (GeometraDrawing gd : this.dataModel) {
                        if (!(gd instanceof LineDrawing)) continue;
                        newModel.add(gd);
                    }
                } else if (ob.equals(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_SQUARE"))) {
                    for (GeometraDrawing gd : this.dataModel) {
                        if (!(gd instanceof SquareDrawing)) continue;
                        newModel.add(gd);
                    }
                } else if (ob.equals(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_SMART"))) {
                    for (GeometraDrawing gd : this.dataModel) {
                        if (!(gd instanceof SmartDrawing)) continue;
                        newModel.add(gd);
                    }
                } else if (ob.equals(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_DOT"))) {
                    for (GeometraDrawing gd : this.dataModel) {
                        if (!(gd instanceof DotDrawing)) continue;
                        newModel.add(gd);
                    }
                }
            }
            this.dataModel = newModel;
            for (GeometraDrawing gd : TotalDrawingJPanel.this.emptyModel.getTotalDrawings()) {
                this.dataModel.remove(gd);
            }
            this.fireContentsChanged(this, 0, this.dataModel.size() - 1);
        }

        public List<Object> getFilterObjects() {
            ArrayList<Object> objectList = new ArrayList<Object>();
            objectList.add(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("STR_ALL"));
            objectList.add(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_LINE"));
            objectList.add(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_SQUARE"));
            objectList.add(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_SMART"));
            objectList.add(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_DOT"));
            for (GeometraDrawing gd : this.dataModel) {
                Blueprint bp = gd.getParent().getParent();
                BlueprintPage page = gd.getParent();
                if (!objectList.contains(bp)) {
                    objectList.add(bp);
                }
                if (objectList.contains(page)) continue;
                objectList.add(page);
            }
            return objectList;
        }

        @Override
        public int getSize() {
            return this.dataModel.size();
        }

        @Override
        public void addDrawings(GeometraCollection<GeometraDrawing> coll) {
            this.dataModel.addAll(coll);
            this.fireContentsChanged(this, 0, this.dataModel.size() - 1);
        }

        @Override
        public void removeDrawings(GeometraCollection<GeometraDrawing> drawings) {
            for (GeometraDrawing gd : drawings) {
                if (!this.dataModel.contains(gd)) continue;
                this.dataModel.remove(gd);
            }
            this.fireContentsChanged(this, 0, this.dataModel.size() - 1);
        }
    }

    private class EmptyListModel
    extends AbstractTotalDrawingModel {
        private static final long serialVersionUID = 1L;
        private final GeometraCollection<GeometraDrawing> dataModel;

        private EmptyListModel() {
            this.dataModel = new GeometraCollection(TotalDrawingJPanel.this.geoManager.getTotalDrawingListSize());
        }

        @Override
        public Object getElementAt(int index) {
            if (index < this.dataModel.size()) {
                return this.dataModel.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.dataModel.size();
        }

        @Override
        public void addDrawings(GeometraCollection<GeometraDrawing> drawings) {
            for (GeometraDrawing gd : drawings) {
                this.dataModel.add(gd);
            }
            this.fireContentsChanged(this, 0, this.dataModel.size() - 1);
        }

        public GeometraCollection<GeometraDrawing> getTotalDrawings() {
            return this.dataModel;
        }

        @Override
        public void removeDrawings(GeometraCollection<GeometraDrawing> drawings) {
            for (GeometraDrawing gd : drawings) {
                if (!this.dataModel.contains(gd)) continue;
                this.dataModel.remove(gd);
            }
            this.fireContentsChanged(this, 0, this.dataModel.size() - 1);
        }
    }

    private class ComboBoxFilterModel
    implements ComboBoxModel {
        private final List<ListDataListener> listenerList = new ArrayList<ListDataListener>();
        private final List<Object> dataModel;
        private Object selectedItem = null;

        protected ComboBoxFilterModel(List<Object> dataModel) {
            this.dataModel = dataModel;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public void setSelectedItem(Object selectedItem) {
            this.selectedItem = selectedItem;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listenerList.add(l);
        }

        @Override
        public Object getElementAt(int index) {
            return this.dataModel.get(index);
        }

        @Override
        public int getSize() {
            return this.dataModel.size();
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listenerList.remove(l);
        }
    }

    private class TreePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final Dimension scrollDimension = new Dimension(160, 210);
        private JList list;
        private final JScrollPane pane;

        public AbstractTotalDrawingModel getModel() {
            return (AbstractTotalDrawingModel)this.list.getModel();
        }

        public void filterList(Object ob) {
            if (this.list.getModel() instanceof TotalDrawingListModel) {
                TotalDrawingListModel model = (TotalDrawingListModel)this.list.getModel();
                model.filterList(ob);
            }
        }

        public void updateModel() {
            if (this.list.getModel() instanceof TotalDrawingListModel) {
                TotalDrawingListModel model = new TotalDrawingListModel();
                this.list.setModel(model);
                List<Object> al = model.getFilterObjects();
                TotalDrawingJPanel.this.sortBox.setModel(new ComboBoxFilterModel(al));
            } else if (this.list.getModel() instanceof EmptyListModel) {
                TotalDrawingJPanel.this.emptyModel = new EmptyListModel();
                this.list.setModel(TotalDrawingJPanel.this.emptyModel);
            }
        }

        public void removeDrawings(GeometraCollection<GeometraDrawing> selectedDrawings) {
            AbstractTotalDrawingModel model = (AbstractTotalDrawingModel)this.list.getModel();
            model.removeDrawings(selectedDrawings);
        }

        public void addDrawings(GeometraCollection<GeometraDrawing> selectedDrawings) {
            AbstractTotalDrawingModel model = (AbstractTotalDrawingModel)this.list.getModel();
            model.addDrawings(selectedDrawings);
        }

        public TreePanel(String title, boolean isMain) {
            if (isMain) {
                TotalDrawingListModel model = new TotalDrawingListModel();
                this.list = new JList();
                this.list.setModel(model);
                List<Object> al = model.getFilterObjects();
                TotalDrawingJPanel.this.sortBox.setModel(new ComboBoxFilterModel(al));
            } else {
                TotalDrawingJPanel.this.emptyModel = new EmptyListModel();
                this.list = new JList(TotalDrawingJPanel.this.emptyModel);
            }
            this.list.setCellRenderer(new TotalDrawingCellRenderer());
            this.setLayout(new BorderLayout());
            this.pane = new JScrollPane(this.list);
            this.pane.setPreferredSize(this.scrollDimension);
            this.add((Component)this.pane, "Center");
            this.setBorder(new TitledBorder(title));
        }

        public GeometraCollection<GeometraDrawing> getSelectedDrawings() {
            GeometraCollection<GeometraDrawing> selectionList = new GeometraCollection<GeometraDrawing>();
            int[] selections = this.list.getSelectedIndices();
            ListModel model = this.list.getModel();
            for (int i = 0; i < selections.length; ++i) {
                selectionList.add((GeometraDrawing)model.getElementAt(selections[i]));
            }
            return selectionList;
        }
    }
}

