/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.tree.TreePath;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import org.icepdf.ri.common.views.painting.drawings.ScaleDrawing;
import se.sjobeck.geometra.datastructures.GeometraProperties;
import se.sjobeck.geometra.datastructures.GeometraUtilities;
import se.sjobeck.geometra.datastructures.blueprint.GeometraManager;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFBlueprint;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFPage;
import se.sjobeck.geometra.datastructures.blueprint.ProjectFile;
import se.sjobeck.geometra.datastructures.blueprint.observer.BlueprintSubject;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.datastructures.blueprint.observer.Observer;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;
import se.sjobeck.geometra.datastructures.drawings.GeometraScale;
import se.sjobeck.geometra.datastructures.drawings.SmartDrawing;
import se.sjobeck.geometra.datastructures.drawings.TotalDrawing;
import se.sjobeck.geometra.export.ExportListener;
import se.sjobeck.geometra.export.ExportSchema;
import se.sjobeck.geometra.export.StructuredExport;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.panels.JTreePDFPane;
import se.sjobeck.geometra.gui.panels.OptionDialog2;
import se.sjobeck.geometra.gui.panels.VinkelDialog;
import se.sjobeck.geometra.gui.panels.datastructures.GeometraDocument;
import se.sjobeck.geometra.gui.panels.datastructures.ToolBarDocument;
import se.sjobeck.gui.DialogCreator;
import se.sjobeck.images.IconFactory;
import se.sjobeck.images.IconLoader;

public class ToolbarDimensions2
extends JToolBar
implements Observer {
    private static final long serialVersionUID = 1L;
    private final ImageIcon icon = IconLoader.getIcon("/se/sjobeck/geometra/gui/panels/toolbar/icons/exportAll.png");
    private static final int TEXTFIELD1 = 5;
    private static final int TEXTFIELD2 = 7;
    private JTreePDFPane treePane;
    private OptionDialog2 od;
    private final GeometraManager geoManager = GeometraManager.getInstance();
    private boolean h\u00f6jdtextfield_senast = false;
    private JButton antalButton;
    private JTextField antalTextField2;
    private JCheckBox antaljCheckBox;
    private JButton areaButton;
    private JTextField areaTextField1;
    private JTextField areaTextField2;
    private JCheckBox areajCheckBox;
    private JButton exportAllButton;
    private Box.Filler filler2;
    private JTextField h\u00f6jdTextField;
    private JCheckBox h\u00f6jdjCheckBox;
    private JButton jButton1;
    private JPanel jPanel1;
    private JButton l\u00e4ngdButton;
    private JTextField l\u00e4ngdTextField1;
    private JTextField l\u00e4ngdTextField2;
    private JCheckBox l\u00e4ngdjCheckBox;
    private JButton volymButton;
    private JTextField volymTextField1;
    private JTextField volymTextField2;
    private JCheckBox volymjCheckBox;
    private JButton v\u00e4ggytaButton;
    private JTextField v\u00e4ggytaTextField1;
    private JTextField v\u00e4ggytaTextField2;
    private JCheckBox v\u00e4ggytajCheckBox;
    KeyListener inputListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent event) {
            JTextField jt;
            if (event.getSource() instanceof JTextField && (jt = (JTextField)event.getSource()).getText().length() == 1 && event.getKeyCode() == 8) {
                jt.setText("");
                ToolbarDimensions2.this.updateValues(jt);
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
            JTextField jt;
            if (event.getSource() instanceof JTextField && (jt = (JTextField)event.getSource()).getText().length() >= 0) {
                int keyCode = event.getKeyCode();
                if (keyCode == 17 || keyCode == 37 || keyCode == 39 || keyCode == 226 || keyCode == 227) {
                    event.consume();
                } else if (keyCode == 8) {
                    ToolbarDimensions2.this.updateValues(jt);
                } else {
                    ToolbarDimensions2.this.updateValues(jt);
                }
            }
        }
    };

    public void setJTreePDFPane(JTreePDFPane treePane) {
        this.treePane = treePane;
    }

    public void setOptionDialog2(OptionDialog2 od) {
        this.od = od;
    }

    public ToolbarDimensions2() {
        this.initComponents();
        this.removeAll();
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this.jPanel1, gbc);
        GeometraSubject.getInstance().addObserver(this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.h\u00f6jdjCheckBox = new JCheckBox();
        this.h\u00f6jdTextField = new JTextField();
        this.exportAllButton = new JButton();
        this.areajCheckBox = new JCheckBox();
        this.areaTextField1 = new JTextField();
        this.areaTextField2 = new JTextField();
        this.l\u00e4ngdjCheckBox = new JCheckBox();
        this.l\u00e4ngdTextField1 = new JTextField();
        this.l\u00e4ngdTextField2 = new JTextField();
        this.volymjCheckBox = new JCheckBox();
        this.volymTextField1 = new JTextField();
        this.volymTextField2 = new JTextField();
        this.v\u00e4ggytaTextField1 = new JTextField();
        this.v\u00e4ggytaTextField2 = new JTextField();
        this.v\u00e4ggytajCheckBox = new JCheckBox();
        this.antaljCheckBox = new JCheckBox();
        this.antalTextField2 = new JTextField();
        this.areaButton = new JButton();
        this.l\u00e4ngdButton = new JButton();
        this.volymButton = new JButton();
        this.v\u00e4ggytaButton = new JButton();
        this.antalButton = new JButton();
        this.jButton1 = new JButton();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.jPanel1.setRequestFocusEnabled(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.h\u00f6jdjCheckBox.setSelected(true);
        this.h\u00f6jdjCheckBox.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_TOOLBAR_HEIGHT"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 3, 1, 3);
        this.jPanel1.add((Component)this.h\u00f6jdjCheckBox, gridBagConstraints);
        this.h\u00f6jdTextField.setColumns(5);
        this.h\u00f6jdTextField.setDocument(new GeometraDocument("0123456789,.#"));
        this.h\u00f6jdTextField.setMinimumSize(new Dimension(12, 22));
        this.h\u00f6jdTextField.setPreferredSize(new Dimension(60, 22));
        this.h\u00f6jdTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ToolbarDimensions2.this.h\u00f6jdTextFieldKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                ToolbarDimensions2.this.h\u00f6jdTextFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 3);
        this.jPanel1.add((Component)this.h\u00f6jdTextField, gridBagConstraints);
        this.exportAllButton.setIcon(this.icon);
        this.exportAllButton.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLBARDIM2_EXPORTBUTTON"));
        this.exportAllButton.setMargin(new Insets(0, 0, 0, 0));
        this.exportAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolbarDimensions2.this.exportAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 3, 5, 3);
        this.jPanel1.add((Component)this.exportAllButton, gridBagConstraints);
        this.areajCheckBox.setSelected(true);
        this.areajCheckBox.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_TOOLBAR_AREA"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 3, 0, 3);
        this.jPanel1.add((Component)this.areajCheckBox, gridBagConstraints);
        this.areaTextField1.setColumns(5);
        this.areaTextField1.setDocument(new ToolBarDocument());
        this.areaTextField1.setMinimumSize(new Dimension(12, 22));
        this.areaTextField1.setPreferredSize(new Dimension(60, 22));
        this.areaTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ToolbarDimensions2.this.areaTextField1KeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                ToolbarDimensions2.this.areaTextField1KeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 3);
        this.jPanel1.add((Component)this.areaTextField1, gridBagConstraints);
        this.areaTextField2.setEditable(false);
        this.areaTextField2.setColumns(7);
        this.areaTextField2.setMinimumSize(new Dimension(32, 22));
        this.areaTextField2.setPreferredSize(new Dimension(60, 22));
        this.areaTextField2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolbarDimensions2.this.areaTextField2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 3);
        this.jPanel1.add((Component)this.areaTextField2, gridBagConstraints);
        this.l\u00e4ngdjCheckBox.setSelected(true);
        this.l\u00e4ngdjCheckBox.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_TOOLBAR_LENGTH"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 3, 0, 3);
        this.jPanel1.add((Component)this.l\u00e4ngdjCheckBox, gridBagConstraints);
        this.l\u00e4ngdTextField1.setColumns(5);
        this.l\u00e4ngdTextField1.setDocument(new ToolBarDocument());
        this.l\u00e4ngdTextField1.setMinimumSize(new Dimension(12, 22));
        this.l\u00e4ngdTextField1.setPreferredSize(new Dimension(60, 22));
        this.l\u00e4ngdTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ToolbarDimensions2.this.l\u00e4ngdTextField1KeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                ToolbarDimensions2.this.l\u00e4ngdTextField1KeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 3);
        this.jPanel1.add((Component)this.l\u00e4ngdTextField1, gridBagConstraints);
        this.l\u00e4ngdTextField2.setEditable(false);
        this.l\u00e4ngdTextField2.setColumns(7);
        this.l\u00e4ngdTextField2.setMinimumSize(new Dimension(12, 22));
        this.l\u00e4ngdTextField2.setPreferredSize(new Dimension(60, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 3);
        this.jPanel1.add((Component)this.l\u00e4ngdTextField2, gridBagConstraints);
        this.volymjCheckBox.setSelected(true);
        this.volymjCheckBox.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_TOOLBAR_VOLUME"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 3, 0, 3);
        this.jPanel1.add((Component)this.volymjCheckBox, gridBagConstraints);
        this.volymTextField1.setColumns(5);
        this.volymTextField1.setDocument(new ToolBarDocument());
        this.volymTextField1.setMinimumSize(new Dimension(12, 22));
        this.volymTextField1.setPreferredSize(new Dimension(60, 22));
        this.volymTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ToolbarDimensions2.this.volymTextField1KeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                ToolbarDimensions2.this.volymTextField1KeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 3);
        this.jPanel1.add((Component)this.volymTextField1, gridBagConstraints);
        this.volymTextField2.setEditable(false);
        this.volymTextField2.setColumns(7);
        this.volymTextField2.setMinimumSize(new Dimension(12, 22));
        this.volymTextField2.setPreferredSize(new Dimension(60, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 3);
        this.jPanel1.add((Component)this.volymTextField2, gridBagConstraints);
        this.v\u00e4ggytaTextField1.setColumns(5);
        this.v\u00e4ggytaTextField1.setDocument(new ToolBarDocument());
        this.v\u00e4ggytaTextField1.setMinimumSize(new Dimension(12, 22));
        this.v\u00e4ggytaTextField1.setPreferredSize(new Dimension(60, 22));
        this.v\u00e4ggytaTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ToolbarDimensions2.this.v\u00e4ggytaTextField1KeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                ToolbarDimensions2.this.v\u00e4ggytaTextField1KeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 3);
        this.jPanel1.add((Component)this.v\u00e4ggytaTextField1, gridBagConstraints);
        this.v\u00e4ggytaTextField2.setEditable(false);
        this.v\u00e4ggytaTextField2.setColumns(7);
        this.v\u00e4ggytaTextField2.setMinimumSize(new Dimension(12, 22));
        this.v\u00e4ggytaTextField2.setPreferredSize(new Dimension(60, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 3);
        this.jPanel1.add((Component)this.v\u00e4ggytaTextField2, gridBagConstraints);
        this.v\u00e4ggytajCheckBox.setSelected(true);
        this.v\u00e4ggytajCheckBox.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("LABEL_TOOLBAR_WALLSURFACE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 3, 0, 3);
        this.jPanel1.add((Component)this.v\u00e4ggytajCheckBox, gridBagConstraints);
        this.antaljCheckBox.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_NUMBER_OF_DRAWINGS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 3, 0, 3);
        this.jPanel1.add((Component)this.antaljCheckBox, gridBagConstraints);
        this.antalTextField2.setEditable(false);
        this.antalTextField2.setColumns(7);
        this.antalTextField2.setMinimumSize(new Dimension(12, 22));
        this.antalTextField2.setPreferredSize(new Dimension(60, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 3);
        this.jPanel1.add((Component)this.antalTextField2, gridBagConstraints);
        this.areaButton.setIcon(this.icon);
        this.areaButton.setMargin(new Insets(0, 0, 0, 0));
        this.areaButton.setMaximumSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.areaButton.setMinimumSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.areaButton.setPreferredSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.areaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolbarDimensions2.this.areaButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.areaButton, gridBagConstraints);
        this.l\u00e4ngdButton.setIcon(this.icon);
        this.l\u00e4ngdButton.setMargin(new Insets(0, 0, 0, 0));
        this.l\u00e4ngdButton.setMaximumSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.l\u00e4ngdButton.setMinimumSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.l\u00e4ngdButton.setPreferredSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.l\u00e4ngdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolbarDimensions2.this.l\u00e4ngdButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.l\u00e4ngdButton, gridBagConstraints);
        this.volymButton.setIcon(this.icon);
        this.volymButton.setMargin(new Insets(0, 0, 0, 0));
        this.volymButton.setMaximumSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.volymButton.setMinimumSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.volymButton.setPreferredSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.volymButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolbarDimensions2.this.volymButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.volymButton, gridBagConstraints);
        this.v\u00e4ggytaButton.setIcon(this.icon);
        this.v\u00e4ggytaButton.setMargin(new Insets(0, 0, 0, 0));
        this.v\u00e4ggytaButton.setMaximumSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.v\u00e4ggytaButton.setMinimumSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.v\u00e4ggytaButton.setPreferredSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.v\u00e4ggytaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolbarDimensions2.this.v\u00e4ggytaButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.v\u00e4ggytaButton, gridBagConstraints);
        this.antalButton.setIcon(this.icon);
        this.antalButton.setMargin(new Insets(0, 0, 0, 0));
        this.antalButton.setMaximumSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.antalButton.setMinimumSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.antalButton.setPreferredSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        this.antalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolbarDimensions2.this.antalButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.antalButton, gridBagConstraints);
        this.jButton1.setText(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLBARDIM2_TILT_BUTTON"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolbarDimensions2.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jPanel1.add((Component)this.filler2, new GridBagConstraints());
        this.add(this.jPanel1);
    }

    private void areaTextField2ActionPerformed(ActionEvent evt) {
    }

    private void exportAllButtonActionPerformed(ActionEvent evt) {
        StructuredExport structuredExport = StructuredExport.createStructuredExport(this.areajCheckBox.isSelected(), this.l\u00e4ngdjCheckBox.isSelected(), this.h\u00f6jdjCheckBox.isSelected(), this.volymjCheckBox.isSelected(), this.v\u00e4ggytajCheckBox.isSelected(), this.antaljCheckBox.isSelected());
        LinkedList<GeometraDrawing> values = new LinkedList<GeometraDrawing>();
        if (this.treePane.getSelectedPaths() == null) {
            this.addValues(values, this.treePane.getTreeModel().getRoot());
        } else {
            for (TreePath path : this.treePane.getSelectedPaths()) {
                this.addValues(values, path.getLastPathComponent());
            }
        }
        if (this.od.getSelectedExportListener() == null) {
            this.chooseExportListener();
        }
        this.od.getSelectedExportListener().export(values, structuredExport);
    }

    private void chooseExportListener() {
        String message = "Error no ExportListener selected. please select one";
        Object[] obj = this.od.getAllPossibleExportListener();
        Object object = obj[0];
        int k = JOptionPane.showOptionDialog(this, message, "", 0, 3, IconFactory.getIcon(Color.GREEN), obj, object);
        this.od.setSelectedExportListener(k);
    }

    private void h\u00f6jdTextFieldKeyPressed(KeyEvent evt) {
        this.keyPressed(evt);
        this.h\u00f6jdtextfield_senast = true;
    }

    private void h\u00f6jdTextFieldKeyReleased(KeyEvent evt) {
        this.keyReleased(evt);
        this.h\u00f6jdtextfield_senast = true;
    }

    private void areaTextField1KeyPressed(KeyEvent evt) {
        this.keyPressed(evt);
        this.h\u00f6jdtextfield_senast = false;
    }

    private void areaTextField1KeyReleased(KeyEvent evt) {
        this.keyReleased(evt);
        this.h\u00f6jdtextfield_senast = false;
    }

    private void l\u00e4ngdTextField1KeyPressed(KeyEvent evt) {
        this.keyPressed(evt);
        this.h\u00f6jdtextfield_senast = false;
    }

    private void l\u00e4ngdTextField1KeyReleased(KeyEvent evt) {
        this.keyReleased(evt);
        this.h\u00f6jdtextfield_senast = false;
    }

    private void volymTextField1KeyPressed(KeyEvent evt) {
        this.keyPressed(evt);
        this.h\u00f6jdtextfield_senast = false;
    }

    private void volymTextField1KeyReleased(KeyEvent evt) {
        this.keyReleased(evt);
        this.h\u00f6jdtextfield_senast = false;
    }

    private void v\u00e4ggytaTextField1KeyPressed(KeyEvent evt) {
        this.keyPressed(evt);
        this.h\u00f6jdtextfield_senast = false;
    }

    private void v\u00e4ggytaTextField1KeyReleased(KeyEvent evt) {
        this.keyReleased(evt);
        this.h\u00f6jdtextfield_senast = false;
    }

    private void antalButtonActionPerformed(ActionEvent evt) {
        String temp = this.antalTextField2.getText();
        this.export(temp);
    }

    private void areaButtonActionPerformed(ActionEvent evt) {
        String temp = this.areaTextField2.getText();
        this.export(temp);
    }

    private void l\u00e4ngdButtonActionPerformed(ActionEvent evt) {
        String temp = this.l\u00e4ngdTextField2.getText();
        this.export(temp);
    }

    private void volymButtonActionPerformed(ActionEvent evt) {
        String temp = this.volymTextField2.getText();
        this.export(temp);
    }

    private void v\u00e4ggytaButtonActionPerformed(ActionEvent evt) {
        String temp = this.v\u00e4ggytaTextField2.getText();
        this.export(temp);
    }

    private void checkOverWrite(JTextField jt, String formula) {
        String message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLBARDIM2_OVERWRITE_FORMULA");
        boolean skrivover = false;
        if (jt.getText().length() > 0) {
            if (DialogCreator.showConfirm(this, message, " ")) {
                skrivover = true;
            }
        } else {
            skrivover = true;
        }
        if (skrivover) {
            jt.setText(formula);
            this.updateValues(jt);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        VinkelDialog vd = new VinkelDialog((Frame)Geometra.GEOMETRA_FRAME, true);
        vd.setVisible(true);
        if (vd.isOk()) {
            String formula = vd.getFormula();
            String message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TOOLBARDIM2_OVERWRITE_FORMULA");
            if (vd.isArea()) {
                this.checkOverWrite(this.areaTextField1, formula);
            }
            if (vd.isLength()) {
                this.checkOverWrite(this.l\u00e4ngdTextField1, formula);
            }
            if (vd.isVolume()) {
                this.checkOverWrite(this.volymTextField1, formula);
            }
            if (vd.isWall()) {
                this.checkOverWrite(this.v\u00e4ggytaTextField1, formula);
            }
        }
    }

    private void export(String in) {
        if (this.od.getSelectedExportListener() == null) {
            this.chooseExportListener();
        }
        StringBuilder sb = new StringBuilder();
        for (char ch : in.toCharArray()) {
            if (!Character.isDigit(ch) && ch != '.' && ch != ',') continue;
            sb.append(ch);
        }
        ExportListener selectedExportListener = this.od.getSelectedExportListener();
        if (selectedExportListener instanceof ExportSchema) {
            ExportSchema el = (ExportSchema)selectedExportListener;
            ExportSchema.CopyPaste cp = el.getCp();
            String text = sb.toString();
            StringBuffer sb_0 = new StringBuffer();
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if ("0123456789".indexOf(c) <= -1) {
                    c = el.getDecimalSign().charAt(0);
                }
                sb_0.append(c);
            }
            cp.copy_paste(sb_0.toString());
        }
    }

    public void keyPressed(KeyEvent event) {
        JTextField jt;
        if (event.getSource() instanceof JTextField && (jt = (JTextField)event.getSource()).getText().length() == 1 && event.getKeyCode() == 8) {
            jt.setText("");
            this.updateValues(jt);
        }
    }

    public void keyReleased(KeyEvent event) {
        JTextField jt;
        if (event.getSource() instanceof JTextField && (jt = (JTextField)event.getSource()).getText().length() >= 0) {
            int keyCode = event.getKeyCode();
            if (keyCode == 17 || keyCode == 37 || keyCode == 39 || keyCode == 226 || keyCode == 227) {
                event.consume();
            } else if (keyCode == 8) {
                this.updateValues(jt);
            } else {
                this.updateValues(jt);
            }
        }
    }

    private void updateValues(JTextField textField) {
        String result = textField.getText();
        if (textField.equals(this.l\u00e4ngdTextField1)) {
            this.geoManager.updateModField(result, 2);
        } else if (textField.equals(this.volymTextField1)) {
            this.geoManager.updateModField(result, 1);
        } else if (textField.equals(this.areaTextField1)) {
            this.geoManager.updateModField(result, 3);
        } else if (textField.equals(this.v\u00e4ggytaTextField1)) {
            this.geoManager.updateModField(result, 0);
        } else if (textField.equals(this.h\u00f6jdTextField)) {
            double d;
            this.geoManager.updateHeight(result);
            try {
                d = GeometraUtilities.solveExpression(result);
            }
            catch (Exception e) {
                d = GeometraProperties.getDrawingHeight();
            }
            GeometraProperties.setDrawingHeight(d);
        }
        if (this.h\u00f6jdtextfield_senast) {
            this.h\u00f6jdTextField.grabFocus();
        }
    }

    private void addValues(List<GeometraDrawing> values, Object candidate) {
        if (candidate instanceof GeometraDrawingImpl) {
            GeometraDrawingImpl gd = (GeometraDrawingImpl)candidate;
            if (!(gd instanceof GeometraScale)) {
                values.add(gd);
            }
        } else if (candidate instanceof IcePDFPage) {
            IcePDFPage page = (IcePDFPage)candidate;
            for (GeometraDrawing gd : page.getDrawings()) {
                this.addValues(values, gd);
            }
        } else if (candidate instanceof IcePDFBlueprint) {
            IcePDFBlueprint pdf = (IcePDFBlueprint)candidate;
            int numberOfPages = pdf.getNumberOfPages();
            for (int i = 0; i < numberOfPages; ++i) {
                this.addValues(values, pdf.getPage(i));
            }
        } else {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("se/sjobeck/Geometra").getString("MESSAGE_CHOOSE_A_DRAWING"), null, 1, IconFactory.getIcon(Color.green));
        }
    }

    @Override
    public void update(BlueprintSubject.Action action, Object object, Object source) {
        if (!(source instanceof ToolbarDimensions2) && !action.equals((Object)BlueprintSubject.Action.REPAINT)) {
            switch (action) {
                case REMOVE: {
                    this.clearTextFields();
                    break;
                }
                case SCALEDRAWING_UPDATE: {
                    this.setToolBarEnabled(false);
                    this.updateResults(this.geoManager.getActiveDrawings(), action);
                    break;
                }
                default: {
                    if (source instanceof ProjectFile) break;
                    this.updateResults(object, action);
                }
            }
        }
    }

    private void updateResults(GeometraDrawing gd, BlueprintSubject.Action action) {
        GeometraCollection<GeometraDrawing> geoVector = new GeometraCollection<GeometraDrawing>();
        geoVector.add(gd);
        this.updateResults(geoVector, action);
    }

    private void updateResults(Object object, BlueprintSubject.Action action) {
        if (object == null) {
            this.updateResults((GeometraCollection<GeometraDrawing>)null, action);
        } else if (object instanceof GeometraDrawing) {
            GeometraDrawing gd = (GeometraDrawing)object;
            this.updateResults(gd, action);
        } else if (object instanceof GeometraCollection) {
            GeometraCollection geoVector = (GeometraCollection)object;
            this.updateResults(geoVector, action);
        }
    }

    private void clearTextFields() {
        this.areaTextField1.setText("");
        this.areaTextField2.setText("");
        this.l\u00e4ngdTextField1.setText("");
        this.l\u00e4ngdTextField2.setText("");
        this.volymTextField1.setText("");
        this.volymTextField2.setText("");
        this.v\u00e4ggytaTextField1.setText("");
        this.v\u00e4ggytaTextField2.setText("");
        this.antalTextField2.setText("");
    }

    private void setToolBarEnabled(boolean b) {
        this.h\u00f6jdTextField.setEnabled(b);
        this.areaTextField1.setEnabled(b);
        this.l\u00e4ngdTextField1.setEnabled(b);
        this.volymTextField1.setEnabled(b);
        this.v\u00e4ggytaTextField1.setEnabled(b);
        this.antalTextField2.setEnabled(b);
        this.jButton1.setEnabled(b);
    }

    private Double getResult(Double value, String mod) {
        if (!(value == null || value.isNaN() || value.isInfinite() || mod == null || mod.isEmpty())) {
            try {
                value = GeometraUtilities.solveExpression(value.toString() + mod);
            }
            catch (Exception e) {
                return Double.NaN;
            }
        }
        return value;
    }

    private void setTextFields(GeometraDrawingImpl gdi) {
        this.areaTextField1.setText(gdi.getAreaMod());
        this.areaTextField2.setText(Geometra.standardFormat.format(this.getResult(gdi.getArea(), gdi.getAreaMod())));
        this.l\u00e4ngdTextField1.setText(gdi.getDistanceMod());
        this.l\u00e4ngdTextField2.setText(Geometra.standardFormat.format(this.getResult(gdi.getDistance(), gdi.getDistanceMod())));
        this.volymTextField1.setText(gdi.getVolumeMod());
        this.volymTextField2.setText(Geometra.standardFormat.format(this.getResult(gdi.getVolume(), gdi.getVolumeMod())));
        this.v\u00e4ggytaTextField1.setText(gdi.getWallSurfaceMod());
        this.v\u00e4ggytaTextField2.setText(Geometra.standardFormat.format(this.getResult(gdi.getWallSurface(), gdi.getWallSurfaceMod())));
        this.antalTextField2.setText(Geometra.standardFormat.format(gdi.numberOfDrawings()));
    }

    private void setTextFields(GeometraCollection<GeometraDrawing> activeDrawings) {
        double area = 0.0;
        double l\u00e4ngd = 0.0;
        double volym = 0.0;
        double v\u00e4ggyta = 0.0;
        int antal = 0;
        for (GeometraDrawing gd : activeDrawings) {
            area += this.getResult(gd.getArea(), gd.getAreaMod()).doubleValue();
            l\u00e4ngd += this.getResult(gd.getDistance(), gd.getDistanceMod()).doubleValue();
            volym += this.getResult(gd.getVolume(), gd.getVolumeMod()).doubleValue();
            v\u00e4ggyta += this.getResult(gd.getWallSurface(), gd.getWallSurfaceMod()).doubleValue();
            antal += ((GeometraDrawingImpl)gd).numberOfDrawings();
        }
        this.areaTextField1.setText("");
        this.areaTextField2.setText(Geometra.standardFormat.format(area));
        this.l\u00e4ngdTextField1.setText("");
        this.l\u00e4ngdTextField2.setText(Geometra.standardFormat.format(l\u00e4ngd));
        this.volymTextField1.setText("");
        this.volymTextField2.setText(Geometra.standardFormat.format(volym));
        this.v\u00e4ggytaTextField1.setText("");
        this.v\u00e4ggytaTextField2.setText(Geometra.standardFormat.format(v\u00e4ggyta));
        this.antalTextField2.setText(Geometra.standardFormat.format(antal));
    }

    private String findHeight(GeometraCollection<GeometraDrawing> activeDrawings) {
        String ret = "##";
        if (activeDrawings == null) {
            return ret;
        }
        double referenceHeight = activeDrawings.get(0).getHeight();
        for (GeometraDrawing gd : activeDrawings) {
            if (gd.getHeight() == referenceHeight) continue;
            return ret;
        }
        return Double.toString(referenceHeight);
    }

    private void setHeightEnabled(boolean isEnabled) {
        this.h\u00f6jdTextField.setEnabled(isEnabled);
    }

    private void updateResults(GeometraCollection<GeometraDrawing> activeDrawings, BlueprintSubject.Action action) {
        if (activeDrawings == null || activeDrawings.size() == 0) {
            this.clearTextFields();
            return;
        }
        if (activeDrawings.size() == 1) {
            GeometraDrawing gd = activeDrawings.get(0);
            this.setTextFields((GeometraDrawingImpl)gd);
        } else {
            this.setTextFields(activeDrawings);
        }
        if (action.equals((Object)BlueprintSubject.Action.SELECT)) {
            this.h\u00f6jdTextField.setText(this.findHeight(activeDrawings));
        }
        for (GeometraDrawing gd : activeDrawings) {
            if (!(gd instanceof ScaleDrawing)) continue;
            this.setToolBarEnabled(false);
            return;
        }
        for (GeometraDrawing gd : activeDrawings) {
            if (!(gd instanceof TotalDrawing) && !(gd instanceof SmartDrawing)) continue;
            this.setHeightEnabled(false);
            return;
        }
        this.setHeightEnabled(true);
        if (activeDrawings.size() > 1) {
            this.setToolBarEnabled(false);
            this.setHeightEnabled(true);
        } else {
            this.setToolBarEnabled(true);
        }
    }
}

