/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.drawings;

import java.util.List;
import se.sjobeck.geometra.datastructures.GeometraUtilities;
import se.sjobeck.geometra.datastructures.drawings.HoleDrawing;
import se.sjobeck.geometra.datastructures.drawings.SquareDrawing;

public class HoleDrawingCalculator {
    private static double getResult(String expression) {
        double resultFromMath = 0.0;
        if (expression.length() != 0) {
            try {
                resultFromMath = GeometraUtilities.solveExpression(expression);
            }
            catch (Exception e) {
                e.getCause();
                return -1.0;
            }
        }
        return resultFromMath;
    }

    protected static double getArea(SquareDrawing sd) {
        double result = 0.0;
        List<HoleDrawing> children = sd.getChildren();
        for (HoleDrawing hd : children) {
            result += HoleDrawingCalculator.getResult(hd.getArea() + hd.getAreaMod());
        }
        return result;
    }

    protected static double getWallsurface(SquareDrawing sd) {
        double result = 0.0;
        List<HoleDrawing> children = sd.getChildren();
        for (HoleDrawing hd : children) {
            result += HoleDrawingCalculator.getResult(hd.getWallSurface() + hd.getWallSurfaceMod());
        }
        return result;
    }

    protected static double getVolume(SquareDrawing sd) {
        double result = 0.0;
        List<HoleDrawing> children = sd.getChildren();
        for (HoleDrawing hd : children) {
            result += HoleDrawingCalculator.getResult(hd.getVolume() + hd.getVolumeMod());
        }
        return result;
    }

    protected static double getDistance(SquareDrawing sd) {
        double result = 0.0;
        List<HoleDrawing> children = sd.getChildren();
        for (HoleDrawing hd : children) {
            result += HoleDrawingCalculator.getResult(hd.getDistance() + hd.getDistanceMod());
        }
        return result;
    }
}

