/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.network2;

import java.io.File;
import se.sjobeck.gui.DialogCreator;
import se.sjobeck.network2.ClientThread;
import se.sjobeck.network2.FromServerMessage;
import se.sjobeck.network2.Message;
import se.sjobeck.util.StaticHelpers;

public class NetWorkFileSender {
    public static synchronized FromServerMessage sendMessage(Message type, Object ... arg) {
        switch (type) {
            case WriteFile: {
                return NetWorkFileSender.sendWriteFile(type, arg);
            }
            case SendGeometraFile: {
                return NetWorkFileSender.sendGeometraFile(type, arg);
            }
            case SendEkalkylFileContent: {
                return NetWorkFileSender.sendEkalkylFileContent(type, arg);
            }
        }
        return (FromServerMessage)ClientThread.sendMessage(type, arg);
    }

    private static synchronized FromServerMessage sendWriteFile(Message type, Object ... arg) {
        File file = (File)arg[0];
        byte[] data = (byte[])arg[1];
        long crc_client = StaticHelpers.getCRC(data);
        long crc_server = -1L;
        while (true) {
            FromServerMessage svar = (FromServerMessage)ClientThread.sendMessage(type, arg);
            crc_server = ((FromServerMessage)ClientThread.sendMessage(Message.GetCRC, file)).getLong();
            if (crc_client == crc_server) {
                return svar;
            }
            DialogCreator.showError("CRC check on client and server failed, will try to send again", "network error");
        }
    }

    private static synchronized FromServerMessage sendGeometraFile(Message type, Object ... arg) {
        String[] sokvag = (String[])arg[0];
        byte[] data = (byte[])arg[1];
        String filnamn = sokvag[sokvag.length - 1];
        StringBuffer temp = new StringBuffer();
        temp.append(sokvag[0]);
        for (int i = 1; i < sokvag.length - 1; ++i) {
            temp.append(File.separator);
            temp.append(sokvag[i]);
        }
        String projektnamn = temp.toString();
        long crc_client = StaticHelpers.getCRC(data);
        long crc_server = -1L;
        while (true) {
            FromServerMessage svar = (FromServerMessage)ClientThread.sendMessage(type, arg);
            FromServerMessage fsm = (FromServerMessage)ClientThread.sendMessage(Message.GetGeometraCRC, filnamn, projektnamn);
            String crc = fsm.getString();
            crc_server = Long.parseLong(crc);
            if (crc_client == crc_server) {
                return svar;
            }
            DialogCreator.showError("CRC check on client and server failed, will try to send again", "network error");
        }
    }

    private static synchronized FromServerMessage sendEkalkylFileContent(Message type, Object ... arg) {
        byte[] data = (byte[])arg[1];
        long crc_client = StaticHelpers.getCRC(data);
        while (true) {
            FromServerMessage svar = (FromServerMessage)ClientThread.sendMessage(type, arg);
            FromServerMessage fsm = (FromServerMessage)ClientThread.sendMessage(Message.GetEkalkylCRC, arg);
            long crc_server = fsm.getLong();
            if (crc_client == crc_server) {
                return svar;
            }
            DialogCreator.showError("CRC check on client and server failed, will try to send again", "network error");
        }
    }
}

