/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui.multilinetable2;

import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class TextAreaRenderer
extends JTextPane
implements TableCellRenderer {
    static final long serialVersionUID = 0L;
    protected final DefaultTableCellRenderer adaptee = new DefaultTableCellRenderer();
    private static final Map<JTable, Map<Integer, Map<Integer, Integer>>> cellSizes = new HashMap<JTable, Map<Integer, Map<Integer, Integer>>>();
    public static final Observable delegateObserver = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            super.setChanged();
            super.notifyObservers(arg);
        }
    };
    private static final Color alternativeBackground = new Color(250, 245, 245);
    private static final Color notEditableBackground = new Color(255, 207, 187);

    public TextAreaRenderer() {
    }

    public TextAreaRenderer(int HorizontalAlignment) {
        SimpleAttributeSet standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(standard, HorizontalAlignment);
        this.getStyledDocument().setParagraphAttributes(0, 0, standard, false);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        this.adaptee.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
        this.setForeground(this.adaptee.getForeground());
        if (isSelected) {
            if (table.isCellEditable(row, column)) {
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setBackground(notEditableBackground);
            }
        } else if (row % 2 == 0) {
            super.setBackground(this.adaptee.getBackground());
        } else {
            super.setBackground(alternativeBackground);
        }
        this.setBorder(this.adaptee.getBorder());
        this.setFont(this.adaptee.getFont());
        this.setText(this.adaptee.getText());
        TableColumnModel columnModel = table.getColumnModel();
        this.setSize(columnModel.getColumn(column).getWidth(), 100000);
        int height_wanted = (int)this.getPreferredSize().getHeight();
        this.addSize(table, row, column, height_wanted);
        height_wanted = TextAreaRenderer.findTotalMaximumRowSize(table, row);
        if (height_wanted != table.getRowHeight(row)) {
            try {
                table.setRowHeight(row, height_wanted);
                delegateObserver.notifyObservers(table);
            }
            catch (IllegalArgumentException e) {
                System.out.println("IllegalArgumenException on (" + row + ", " + column + ") on " + table);
            }
        }
        return this;
    }

    private void addSize(JTable table, int row, int column, int height) {
        Map<Integer, Integer> rowheights;
        Map<Integer, Map<Integer, Integer>> rows = cellSizes.get(table);
        if (rows == null) {
            rows = new HashMap<Integer, Map<Integer, Integer>>();
            cellSizes.put(table, rows);
        }
        if ((rowheights = rows.get(row)) == null) {
            rowheights = new HashMap<Integer, Integer>();
            rows.put(row, rowheights);
        }
        rowheights.put(column, height);
    }

    protected static int findTotalMaximumRowSize(JTable table, int row) {
        int maximum_height = 0;
        Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn tc = columns.nextElement();
            TableCellRenderer cellRenderer = tc.getCellRenderer();
            if (!(cellRenderer instanceof TextAreaRenderer)) continue;
            TextAreaRenderer tar = (TextAreaRenderer)cellRenderer;
            maximum_height = Math.max(maximum_height, tar.findMaximumRowSize(table, row));
        }
        return maximum_height;
    }

    private int findMaximumRowSize(JTable table, int row) {
        Map<Integer, Map<Integer, Integer>> rows = cellSizes.get(table);
        if (rows == null) {
            return 0;
        }
        Map<Integer, Integer> rowheights = rows.get(row);
        if (rowheights == null) {
            return 0;
        }
        int maximum_height = 0;
        for (Map.Entry<Integer, Integer> it : rowheights.entrySet()) {
            maximum_height = Math.max(maximum_height, it.getValue());
        }
        return maximum_height;
    }
}

