/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui.dndtree;

import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import se.sjobeck.gui.dndtree.AbstractTreeTransferHandler;
import se.sjobeck.gui.dndtree.DNDTree;

public class DefaultTreeTransferHandler
extends AbstractTreeTransferHandler {
    public DefaultTreeTransferHandler(DNDTree tree, int action) {
        super(tree, action, true);
    }

    @Override
    public boolean canPerformAction(DNDTree target, DefaultMutableTreeNode draggedNode, int action, Point location) {
        return false;
    }

    public static DefaultMutableTreeNode makeDeepCopy(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode copy = new DefaultMutableTreeNode(node.getUserObject());
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            copy.add(DefaultTreeTransferHandler.makeDeepCopy((DefaultMutableTreeNode)e.nextElement()));
        }
        return copy;
    }

    @Override
    public boolean executeDrop(DNDTree target, DefaultMutableTreeNode draggedNode, DefaultMutableTreeNode newParentNode, int index, Vector expandedStates, int action) {
        if (action == 1) {
            DefaultMutableTreeNode newNode = DefaultTreeTransferHandler.makeDeepCopy(draggedNode);
            target.expandPath(new TreePath(newParentNode.getPath()));
            ((DefaultTreeModel)target.getModel()).insertNodeInto(newNode, newParentNode, index);
            TreePath treePath = new TreePath(newNode.getPath());
            int i = 0;
            Enumeration<TreeNode> enumeration = newNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode element = (DefaultMutableTreeNode)enumeration.nextElement();
                TreePath path = new TreePath(element.getPath());
                if (((Boolean)expandedStates.get(i)).booleanValue()) {
                    target.expandPath(path);
                }
                ++i;
            }
            target.scrollPathToVisible(treePath);
            target.setSelectionPath(treePath);
            return true;
        }
        if (action == 2) {
            TreePath oldParentPath = new TreePath(((DefaultMutableTreeNode)draggedNode.getParent()).getPath());
            draggedNode.removeFromParent();
            target.expandPath(new TreePath(newParentNode.getPath()));
            if (index > newParentNode.getChildCount()) {
                index = newParentNode.getChildCount();
            }
            ((DefaultTreeModel)target.getModel()).insertNodeInto(draggedNode, newParentNode, index);
            TreePath treePath = new TreePath(draggedNode.getPath());
            int i = 0;
            Enumeration<TreeNode> enumeration = draggedNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode element = (DefaultMutableTreeNode)enumeration.nextElement();
                TreePath path = new TreePath(element.getPath());
                if (((Boolean)expandedStates.get(i)).booleanValue()) {
                    target.expandPath(path);
                }
                ++i;
            }
            target.scrollPathToVisible(treePath);
            target.setSelectionPath(treePath);
            return true;
        }
        return false;
    }
}

