/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import se.sjobeck.gui.BackgroundImagePanel;
import se.sjobeck.gui.GenericComboBoxModel;
import se.sjobeck.network2.ApplicationType;
import se.sjobeck.network2.ClientStatus;
import se.sjobeck.network2.ClientThread;
import se.sjobeck.util.StaticHelpers;

public class StartupScreen
extends JFrame {
    static final long serialVersionUID = 0L;
    private BufferedImage image;
    private boolean okPressed = false;
    private final ListCellRenderer localeRenderer = new DefaultListCellRenderer(){
        public static final long serialVersionUID = 0L;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Locale locale = (Locale)value;
            return super.getListCellRendererComponent((JList<?>)list, locale.getDisplayName(), index, isSelected, cellHasFocus);
        }
    };
    private final GenericComboBoxModel<Locale> localeModel;
    private static final Handler logHandler = new Handler(){

        @Override
        public void publish(LogRecord record) {
            if (record.getLevel() == Level.INFO) {
                StartupScreen.message(record.getMessage());
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    };
    private static StartupScreen instance;
    private JList applicationList;
    private JPanel dummy;
    private JPanel empty;
    private JPanel imagePanel;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JComboBox languageSelector;
    private JPanel logInPanel;
    public JPasswordField losen;
    public JTextField namn;
    private JProgressBar progressBar;
    private JCheckBox spara;
    private JPanel startAppsPanel;

    private static StartupScreen getInstance() {
        if (instance == null) {
            throw new IllegalArgumentException(ResourceBundle.getBundle("se/sjobeck/Bibliotek").getString("startupscreen_getInstance_error"));
        }
        return instance;
    }

    public static void init(BufferedImage img, ApplicationType appType, Image icon) {
        StartupScreen.init(img, appType);
        instance.setIconImage(icon);
    }

    public static void init(BufferedImage img, ApplicationType appType) {
        instance = new StartupScreen(img);
        StaticHelpers.center(instance);
        instance.setVisible(true);
        Logger.getLogger("se.sjobeck.gui").finest(ResourceBundle.getBundle("se/sjobeck/Bibliotek").getString("init_logmessage") + appType);
        ClientThread.setApplicationType(appType);
    }

    public static void setMaximum(int max) {
        StartupScreen.getInstance().progressBar.setMaximum(max);
    }

    public static void message(String s) {
        StartupScreen.getInstance().progressBar.setString(s);
        StartupScreen.increment();
    }

    public static void increment() {
        StartupScreen.getInstance().progressBar.setValue(StartupScreen.getInstance().progressBar.getValue() + 1);
    }

    public static void setText(String msg) {
        StartupScreen.getInstance().setTitle(msg);
    }

    public static Handler getLogHandler() {
        return logHandler;
    }

    public static void nullify() {
        StartupScreen.getInstance().setVisible(false);
        StartupScreen.getInstance().dispose();
        instance = null;
    }

    public static void temporaryHide() {
        if (instance != null && instance.isVisible()) {
            instance.setVisible(false);
        }
    }

    public static void temporaryUnhide() {
        if (instance != null && !instance.isVisible()) {
            instance.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performLogin() {
        Logger.getLogger("se.sjobeck.gui").entering("StartupScreen", "performLogin()");
        Preferences startup = Preferences.userNodeForPackage(StartupScreen.class);
        StartupScreen.getInstance().namn.setText(startup.get("userName", ""));
        StartupScreen.getInstance().spara.setSelected(startup.getBoolean("savePassword", false));
        if (startup.getBoolean("savePassword", false)) {
            StartupScreen.getInstance().losen.setText(startup.get("password", ""));
        }
        StartupScreen.getInstance().getRootPane().setDefaultButton(StartupScreen.getInstance().jButton1);
        ClientStatus state = ClientStatus.NotConnected;
        do {
            StartupScreen.getInstance().setVisible(true);
            ((CardLayout)StartupScreen.getInstance().dummy.getLayout()).show(StartupScreen.getInstance().dummy, "login");
            StartupScreen startupScreen = StartupScreen.getInstance();
            synchronized (startupScreen) {
                StartupScreen.getInstance().okPressed = false;
                while (!StartupScreen.getInstance().okPressed) {
                    try {
                        StartupScreen.getInstance().wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            Logger.getLogger("se.sjobeck.network2").finest("Checking application type: " + ClientThread.getApplicationType());
            state = ClientThread.reconnect();
            switch (state) {
                case NoLicense: {
                    StaticHelpers.warn(ResourceBundle.getBundle("se/sjobeck/Bibliotek").getString("error_NoLicence") + ClientThread.getApplicationType());
                    break;
                }
                case NoFreeLicense: {
                    StaticHelpers.warn(ResourceBundle.getBundle("se/sjobeck/Bibliotek").getString("error_NoFreeLicenses"));
                    break;
                }
                case LicenseExpired: {
                    StaticHelpers.warn(ResourceBundle.getBundle("se/sjobeck/Bibliotek").getString("error_LicenseExpired"));
                    break;
                }
                case BadCredentials: {
                    StaticHelpers.warn(ResourceBundle.getBundle("se/sjobeck/Bibliotek").getString("error_BadCredentials"), StartupScreen.getInstance());
                    break;
                }
                case NotConnected: {
                    StaticHelpers.warn(ResourceBundle.getBundle("se/sjobeck/Bibliotek").getString("error_NotConnected"));
                }
            }
        } while (state != ClientStatus.LoggedIn);
        Logger.getLogger("se.sjobeck.gui").exiting("StartupScreen", "performLogin()");
    }

    private StartupScreen() {
        this((BufferedImage)null);
        throw new IllegalStateException();
    }

    private StartupScreen(BufferedImage img) {
        this.image = img;
        ArrayList<Locale> localeList = new ArrayList<Locale>();
        localeList.add(new Locale("nl", "NL"));
        localeList.add(new Locale("sv", "SE"));
        localeList.add(new Locale("no", "NO"));
        localeList.add(new Locale("da", "DK"));
        localeList.add(Locale.UK);
        localeList.add(Locale.US);
        this.localeModel = new GenericComboBoxModel(true);
        this.localeModel.setSelectedItem(Locale.getDefault());
        this.localeModel.setListData(localeList);
        Locale.setDefault(this.localeModel.getSelectedItem());
        this.initComponents();
    }

    private void initComponents() {
        this.imagePanel = new BackgroundImagePanel(this.image, BackgroundImagePanel.RenderingStyle.ACTUAL);
        this.progressBar = new JProgressBar();
        this.dummy = new JPanel();
        this.empty = new JPanel();
        this.logInPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.namn = new JTextField();
        this.jLabel2 = new JLabel();
        this.losen = new JPasswordField();
        this.spara = new JCheckBox();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel5 = new JLabel();
        this.languageSelector = new JComboBox();
        this.startAppsPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.applicationList = new JList();
        this.setDefaultCloseOperation(0);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.imagePanel.setLayout(new GridBagLayout());
        this.progressBar.setStringPainted(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.imagePanel.add((Component)this.progressBar, gridBagConstraints);
        this.dummy.setOpaque(false);
        this.dummy.setLayout(new CardLayout());
        this.empty.setOpaque(false);
        this.dummy.add((Component)this.empty, "empty");
        this.logInPanel.setOpaque(false);
        this.logInPanel.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("se/sjobeck/Bibliotek");
        this.jLabel1.setText(bundle.getString("username"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.logInPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.namn.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                StartupScreen.this.namnmarkeraText(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                StartupScreen.this.namncheckSave(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.logInPanel.add((Component)this.namn, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.logInPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.losen.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                StartupScreen.this.losenmarkeraText(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.logInPanel.add((Component)this.losen, gridBagConstraints);
        this.spara.setText(bundle.getString("savePassword"));
        this.spara.setActionCommand(bundle.getString("savePassword"));
        this.spara.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.logInPanel.add((Component)this.spara, gridBagConstraints);
        this.jButton1.setText(bundle.getString("OK"));
        this.jButton1.setOpaque(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartupScreen.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.logInPanel.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setText(bundle.getString("cancel"));
        this.jButton2.setOpaque(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartupScreen.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.logInPanel.add((Component)this.jButton2, gridBagConstraints);
        this.jLabel5.setText(bundle.getString("language"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.logInPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.languageSelector.setModel(this.localeModel);
        this.languageSelector.setRenderer(this.localeRenderer);
        this.languageSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StartupScreen.this.languageSelectorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.logInPanel.add((Component)this.languageSelector, gridBagConstraints);
        this.dummy.add((Component)this.logInPanel, "login");
        this.startAppsPanel.setLayout(new GridBagLayout());
        this.jLabel3.setText(bundle.getString("userRealName"));
        this.startAppsPanel.add((Component)this.jLabel3, new GridBagConstraints());
        this.jLabel4.setText("jLabel4");
        this.startAppsPanel.add((Component)this.jLabel4, new GridBagConstraints());
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(bundle.getString("applications")));
        this.applicationList.setModel(new AbstractListModel(){
            private static final long serialVersionUID = 3333333333335L;
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.applicationList);
        this.startAppsPanel.add((Component)this.jScrollPane1, new GridBagConstraints());
        this.dummy.add((Component)this.startAppsPanel, "card4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.imagePanel.add((Component)this.dummy, gridBagConstraints);
        this.getContentPane().add((Component)this.imagePanel, "Center");
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private String transformLoginName(String name) {
        return name.toLowerCase().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton1ActionPerformed(ActionEvent evt) {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        prefs.put("userName", this.transformLoginName(this.namn.getText()));
        if (this.spara.isEnabled() && this.spara.isSelected()) {
            prefs.putBoolean("savePassword", true);
            prefs.put("password", new String(this.losen.getPassword()));
        } else {
            prefs.putBoolean("savePassword", false);
        }
        byte[] sha1hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            String password = new String(this.losen.getPassword());
            md.update(password.getBytes("UTF-8"), 0, password.length());
            sha1hash = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        assert (sha1hash != null);
        assert (sha1hash.length == 20);
        try {
            ClientThread.setCredentials(this.transformLoginName(this.namn.getText()).getBytes("UTF-8"), sha1hash);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ((CardLayout)StartupScreen.getInstance().dummy.getLayout()).show(this.dummy, "empty");
        StartupScreen startupScreen = StartupScreen.getInstance();
        synchronized (startupScreen) {
            StartupScreen.getInstance().okPressed = true;
            StartupScreen.getInstance().notifyAll();
        }
    }

    private void losenmarkeraText(FocusEvent evt) {
        ((JTextField)evt.getSource()).selectAll();
    }

    private void namncheckSave(FocusEvent evt) {
    }

    private void namnmarkeraText(FocusEvent evt) {
        ((JTextField)evt.getSource()).selectAll();
    }

    private void languageSelectorActionPerformed(ActionEvent evt) {
        Locale.setDefault(this.localeModel.getSelectedItem());
        ResourceBundle bundle = ResourceBundle.getBundle("se/sjobeck/Bibliotek");
        this.jLabel1.setText(bundle.getString("username"));
        this.jLabel2.setText(bundle.getString("password"));
        this.spara.setText(bundle.getString("savePassword"));
        this.jButton1.setText(bundle.getString("OK"));
        this.jButton2.setText(bundle.getString("cancel"));
        this.jLabel5.setText(bundle.getString("language"));
        this.jLabel3.setText(bundle.getString("userRealName"));
        this.jLabel5.setText(bundle.getString("language"));
    }
}

