/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import se.sjobeck.datastructures.FormelDim;
import se.sjobeck.datastructures.StalprofilDim;
import se.sjobeck.datastructures.kalkylering.Stalprofil;
import se.sjobeck.gui.FormelProvider;
import se.sjobeck.gui.GenericComboBoxModel;
import se.sjobeck.gui.ShapeIcon;
import se.sjobeck.util.StaticHelpers;

public class StalprofilTab
extends JPanel
implements FormelProvider {
    private static final long serialVersionUID = 0L;
    private List<JToggleButton> knappar;
    private GenericComboBoxModel<Stalprofil> formatModel;
    private JPanel buttonPanel;
    private JComboBox format;
    private JTextPane jTextPane1;
    private JToggleButton jToggleButton1;
    private JToggleButton jToggleButton10;
    private JToggleButton jToggleButton11;
    private JToggleButton jToggleButton12;
    private JToggleButton jToggleButton13;
    private JToggleButton jToggleButton14;
    private JToggleButton jToggleButton15;
    private JToggleButton jToggleButton16;
    private JToggleButton jToggleButton2;
    private JToggleButton jToggleButton3;
    private JToggleButton jToggleButton4;
    private JToggleButton jToggleButton5;
    private JToggleButton jToggleButton6;
    private JToggleButton jToggleButton7;
    private JToggleButton jToggleButton8;
    private JToggleButton jToggleButton9;
    private JTextField mantelYta;
    private JLabel mantelYtaLabel;
    private ButtonGroup profiler;

    public StalprofilTab() {
        this.initComponents();
        this.knappar = Arrays.asList(this.jToggleButton1, this.jToggleButton2, this.jToggleButton3, this.jToggleButton4, this.jToggleButton5, this.jToggleButton6, this.jToggleButton7, this.jToggleButton8, this.jToggleButton9, this.jToggleButton10, this.jToggleButton11, this.jToggleButton12, this.jToggleButton13, this.jToggleButton14, this.jToggleButton15, this.jToggleButton16);
        this.formatModel = new GenericComboBoxModel(true);
        this.format.setModel(this.formatModel);
        ListIterator<JToggleButton> it = this.knappar.listIterator();
        for (Kategori kat : Kategori.values()) {
            this.initToggleButton((JToggleButton)it.next(), kat);
        }
    }

    private void initToggleButton(JToggleButton b, Kategori typ) {
        b.setText(StalprofilTab.getDescription(typ));
        b.setIcon(StalprofilTab.buildIcon(typ));
        final List<Stalprofil> list = StalprofilTab.buildSt\u00e5lprofilList(typ);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StalprofilTab.this.formatModel.setListData(list);
                StalprofilTab.this.mantelYta.setText("");
            }
        });
    }

    private void initComponents() {
        this.profiler = new ButtonGroup();
        this.format = new JComboBox();
        this.mantelYtaLabel = new JLabel();
        this.mantelYta = new JTextField();
        this.jTextPane1 = new JTextPane();
        this.buttonPanel = new JPanel();
        this.jToggleButton1 = new JToggleButton();
        this.jToggleButton3 = new JToggleButton();
        this.jToggleButton11 = new JToggleButton();
        this.jToggleButton15 = new JToggleButton();
        this.jToggleButton13 = new JToggleButton();
        this.jToggleButton5 = new JToggleButton();
        this.jToggleButton2 = new JToggleButton();
        this.jToggleButton7 = new JToggleButton();
        this.jToggleButton6 = new JToggleButton();
        this.jToggleButton8 = new JToggleButton();
        this.jToggleButton12 = new JToggleButton();
        this.jToggleButton10 = new JToggleButton();
        this.jToggleButton9 = new JToggleButton();
        this.jToggleButton4 = new JToggleButton();
        this.jToggleButton14 = new JToggleButton();
        this.jToggleButton16 = new JToggleButton();
        this.setLayout(new GridBagLayout());
        this.format.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StalprofilTab.this.formatActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.format, gridBagConstraints);
        this.mantelYtaLabel.setHorizontalAlignment(4);
        this.mantelYtaLabel.setText("Mantelyta");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.mantelYtaLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.mantelYta, gridBagConstraints);
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setText("F\u00f6rklaringar:\n\n/3 = tresidig exponering\n/i = ingjuten\nProfildimensioner anges i mm\nMantelyta anges i meter\n\nOBS! V\u00e4rdet f\u00f6r mantelytan kan \u00e4ndras");
        this.jTextPane1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jTextPane1, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.profiler.add(this.jToggleButton1);
        this.jToggleButton1.setText("*");
        this.jToggleButton1.setHorizontalTextPosition(0);
        this.jToggleButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton1.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton1, gridBagConstraints);
        this.profiler.add(this.jToggleButton3);
        this.jToggleButton3.setText("*");
        this.jToggleButton3.setHorizontalTextPosition(0);
        this.jToggleButton3.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton3.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton3, gridBagConstraints);
        this.profiler.add(this.jToggleButton11);
        this.jToggleButton11.setText("*");
        this.jToggleButton11.setHorizontalTextPosition(0);
        this.jToggleButton11.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton11.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton11, gridBagConstraints);
        this.profiler.add(this.jToggleButton15);
        this.jToggleButton15.setText("*");
        this.jToggleButton15.setHorizontalTextPosition(0);
        this.jToggleButton15.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton15.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton15, gridBagConstraints);
        this.profiler.add(this.jToggleButton13);
        this.jToggleButton13.setText("*");
        this.jToggleButton13.setHorizontalTextPosition(0);
        this.jToggleButton13.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton13.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton13, gridBagConstraints);
        this.profiler.add(this.jToggleButton5);
        this.jToggleButton5.setText("*");
        this.jToggleButton5.setHorizontalTextPosition(0);
        this.jToggleButton5.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton5.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton5, gridBagConstraints);
        this.profiler.add(this.jToggleButton2);
        this.jToggleButton2.setText("*");
        this.jToggleButton2.setHorizontalTextPosition(0);
        this.jToggleButton2.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton2.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton2, gridBagConstraints);
        this.profiler.add(this.jToggleButton7);
        this.jToggleButton7.setText("*");
        this.jToggleButton7.setHorizontalTextPosition(0);
        this.jToggleButton7.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton7.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton7, gridBagConstraints);
        this.profiler.add(this.jToggleButton6);
        this.jToggleButton6.setText("*");
        this.jToggleButton6.setHorizontalTextPosition(0);
        this.jToggleButton6.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton6.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton6, gridBagConstraints);
        this.profiler.add(this.jToggleButton8);
        this.jToggleButton8.setText("*");
        this.jToggleButton8.setHorizontalTextPosition(0);
        this.jToggleButton8.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton8.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton8, gridBagConstraints);
        this.profiler.add(this.jToggleButton12);
        this.jToggleButton12.setText("*");
        this.jToggleButton12.setHorizontalTextPosition(0);
        this.jToggleButton12.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton12.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton12, gridBagConstraints);
        this.profiler.add(this.jToggleButton10);
        this.jToggleButton10.setText("*");
        this.jToggleButton10.setHorizontalTextPosition(0);
        this.jToggleButton10.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton10.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton10, gridBagConstraints);
        this.profiler.add(this.jToggleButton9);
        this.jToggleButton9.setText("*");
        this.jToggleButton9.setHorizontalTextPosition(0);
        this.jToggleButton9.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton9.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton9, gridBagConstraints);
        this.profiler.add(this.jToggleButton4);
        this.jToggleButton4.setText("*");
        this.jToggleButton4.setHorizontalTextPosition(0);
        this.jToggleButton4.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton4.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton4, gridBagConstraints);
        this.profiler.add(this.jToggleButton14);
        this.jToggleButton14.setText("*");
        this.jToggleButton14.setHorizontalTextPosition(0);
        this.jToggleButton14.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton14.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton14, gridBagConstraints);
        this.profiler.add(this.jToggleButton16);
        this.jToggleButton16.setText("*");
        this.jToggleButton16.setHorizontalTextPosition(0);
        this.jToggleButton16.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton16.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.jToggleButton16, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void formatActionPerformed(ActionEvent evt) {
        if (this.format.getSelectedIndex() > 0) {
            double mantelValue = ((Stalprofil)this.format.getSelectedItem()).getMantelyta();
            this.mantelYta.setText(StaticHelpers.format2Dec(mantelValue));
        }
    }

    @Override
    public boolean closeOk() {
        if (this.format.getSelectedIndex() > 0) {
            double mantelValue = StaticHelpers.parseDouble(this.mantelYta.getText());
            if (Double.isNaN(mantelValue)) {
                StaticHelpers.warn("'" + this.mantelYta.getText() + "' \u00e4r inte ett giltigt v\u00e4rde!");
                this.mantelYta.setText(StaticHelpers.format(mantelValue));
                return false;
            }
            return true;
        }
        StaticHelpers.warn("Du m\u00e5ste v\u00e4lja n\u00e5gon storlek!");
        return false;
    }

    public double getAckYta() {
        double mantelValue = StaticHelpers.parseDouble(this.mantelYta.getText());
        if (mantelValue < 0.1) {
            return 0.3;
        }
        if (mantelValue < 0.3) {
            return 0.45;
        }
        if (mantelValue < 0.5) {
            return 0.6;
        }
        return mantelValue;
    }

    public String getEnhet() {
        return "lpm";
    }

    public String getFormula() {
        return this.format.getSelectedItem().toString();
    }

    public double getMatYta() {
        return StaticHelpers.parseDouble(this.mantelYta.getText());
    }

    public double getMisc() {
        return 0.0;
    }

    @Override
    public FormelDim getFormelDim() {
        StalprofilDim formel = new StalprofilDim("Formel", this.getFormula(), this.getEnhet(), "En genererad formel \u00e4r dimension", this.getAckYta(), this.getMatYta());
        int selected = 0;
        for (JToggleButton b : this.knappar) {
            if (!b.isSelected()) continue;
            selected = this.knappar.indexOf(b);
        }
        formel.setState(selected, this.format.getSelectedIndex(), this.mantelYta.getText());
        return formel;
    }

    @Override
    public void setState(FormelDim fd) {
        StalprofilDim dim = (StalprofilDim)fd;
        this.knappar.get(dim.getTyp()).doClick();
        this.format.setSelectedIndex(dim.getFormat_());
        this.mantelYta.setText(dim.getYta());
    }

    private static Icon buildIcon(Kategori kat) {
        switch (kat) {
            case FYRKANTST\u00c5NG: {
                return new ShapeIcon(new Rectangle(0, 0, 10, 1), 50, 50, true);
            }
            case HEA_BALK: {
                return new ShapeIcon(StalprofilTab.createBalk(96.0f, 100.0f, 8.0f, 5.0f, 1.0f), 50, 50, true);
            }
            case HEB_BALK: {
                return new ShapeIcon(StalprofilTab.createBalk(100.0f, 100.0f, 10.0f, 6.0f, 1.0f), 50, 50, true);
            }
            case HEM_BALK: {
                return new ShapeIcon(StalprofilTab.createBalk(120.0f, 106.0f, 20.0f, 12.0f, 1.0f), 50, 50, true);
            }
            case I_BALK: 
            case IPE_BALK: {
                Shape tempShape = StalprofilTab.createBalk(80.0f, 46.0f, 5.2f, 3.8f, 5.0f);
                return new ShapeIcon(tempShape, 50, 50, true);
            }
            case KKR_H\u00c5LPROFILER: 
            case VKR_H\u00c5LPROFILER: {
                Area kkrProfil = new Area(new RoundRectangle2D.Float(0.0f, 0.0f, 40.0f, 60.0f, 5.0f, 5.0f));
                kkrProfil.subtract(new Area(new RoundRectangle2D.Float(5.0f, 5.0f, 30.0f, 50.0f, 5.0f, 5.0f)));
                return new ShapeIcon(kkrProfil, 50, 50, true);
            }
            case L_ST\u00c5L: {
                GeneralPath l = new GeneralPath();
                l.moveTo(0.0f, 0.0f);
                l.lineTo(2.5f, 0.0f);
                l.lineTo(5.0f, 2.5f);
                l.lineTo(5.0f, 16.5f);
                l.curveTo(5.0f, 20.0f, 5.0f, 20.0f, 8.5f, 20.0f);
                l.lineTo(22.5f, 20.0f);
                l.lineTo(25.0f, 22.5f);
                l.lineTo(25.0f, 25.0f);
                l.lineTo(0.0f, 25.0f);
                l.closePath();
                return new ShapeIcon(l, 50, 50, true);
            }
            case PLATTST\u00c5NG: {
                return new ShapeIcon(new Rectangle(0, 0, 40, 6), 50, 50, true);
            }
            case RHS_H\u00c5LPROFILER: {
                Area rhs = new Area(new RoundRectangle2D.Float(0.0f, 0.0f, 88.9f, 88.9f, 10.0f, 10.0f));
                rhs.subtract(new Area(new RoundRectangle2D.Float(4.9f, 4.9f, 79.1f, 79.1f, 10.0f, 10.0f)));
                return new ShapeIcon(rhs, 50, 50, true);
            }
            case RUNDST\u00c5NG: {
                return new ShapeIcon(new Ellipse2D.Double(0.0, 0.0, 10.0, 10.0), 50, 50, true);
            }
            case R\u00d6R: {
                Area a = new Area(new Ellipse2D.Double(0.0, 0.0, 10.0, 10.0));
                a.subtract(new Area(new Ellipse2D.Double(1.0, 1.0, 8.0, 8.0)));
                return new ShapeIcon(a, 50, 50, true);
            }
            case T_ST\u00c5NG: {
                GeneralPath t = new GeneralPath();
                t.moveTo(0.0f, 100.0f);
                t.lineTo(100.0f, 100.0f);
                t.curveTo(100.0f, 89.0f, 100.0f, 89.0f, 94.5f, 89.0f);
                t.lineTo(61.0f, 89.0f);
                t.curveTo(55.5f, 89.0f, 55.5f, 89.0f, 55.5f, 78.0f);
                t.lineTo(55.5f, 3.0f);
                t.curveTo(55.5f, 0.0f, 44.5f, 0.0f, 44.5f, 3.0f);
                t.lineTo(44.5f, 78.0f);
                t.curveTo(44.5f, 89.0f, 44.5f, 89.0f, 39.0f, 89.0f);
                t.lineTo(5.5f, 89.0f);
                t.curveTo(0.0f, 89.0f, 0.0f, 89.0f, 0.0f, 100.0f);
                t.closePath();
                return new ShapeIcon(t, 50, 50, true);
            }
            case UNP_BALK: {
                GeneralPath unp = new GeneralPath();
                unp.moveTo(0.0f, 0.0f);
                unp.lineTo(45.0f, 0.0f);
                unp.lineTo(45.0f, 4.0f);
                unp.curveTo(45.0f, 8.0f, 45.0f, 8.0f, 41.0f, 8.0f);
                unp.lineTo(14.0f, 8.0f);
                unp.curveTo(6.0f, 8.0f, 6.0f, 8.0f, 6.0f, 12.0f);
                unp.lineTo(6.0f, 64.0f);
                unp.curveTo(6.0f, 72.0f, 6.0f, 72.0f, 14.0f, 72.0f);
                unp.lineTo(41.0f, 72.0f);
                unp.curveTo(45.0f, 72.0f, 45.0f, 72.0f, 45.0f, 76.0f);
                unp.lineTo(45.0f, 80.0f);
                unp.lineTo(0.0f, 80.0f);
                unp.closePath();
                return new ShapeIcon(unp, 50, 50, true);
            }
            case UPE_BALK: {
                GeneralPath upe = new GeneralPath();
                upe.moveTo(0.0f, 0.0f);
                upe.lineTo(50.0f, 0.0f);
                upe.lineTo(50.0f, 7.0f);
                upe.lineTo(14.0f, 7.0f);
                upe.curveTo(4.0f, 7.0f, 4.0f, 7.0f, 4.0f, 17.0f);
                upe.lineTo(4.0f, 63.0f);
                upe.curveTo(4.0f, 73.0f, 4.0f, 73.0f, 14.0f, 73.0f);
                upe.lineTo(50.0f, 73.0f);
                upe.lineTo(50.0f, 80.0f);
                upe.lineTo(0.0f, 80.0f);
                upe.closePath();
                return new ShapeIcon(upe, 50, 50, true);
            }
        }
        throw new IllegalArgumentException("Bad category");
    }

    private static String getDescription(Kategori kat) {
        switch (kat) {
            case FYRKANTST\u00c5NG: {
                return "Fyrkantsst\u00e5ng";
            }
            case HEA_BALK: {
                return "HEA-Balk";
            }
            case HEB_BALK: {
                return "HEB-Balk";
            }
            case HEM_BALK: {
                return "HEM-Balk";
            }
            case IPE_BALK: {
                return "IPE-Balk";
            }
            case I_BALK: {
                return "I-Balk";
            }
            case KKR_H\u00c5LPROFILER: {
                return "KKR-H\u00e5lprofiler";
            }
            case L_ST\u00c5L: {
                return "L-St\u00e5l";
            }
            case PLATTST\u00c5NG: {
                return "Plattst\u00e5ng";
            }
            case RHS_H\u00c5LPROFILER: {
                return "RHS H\u00e5lprofiler";
            }
            case RUNDST\u00c5NG: {
                return "Rundst\u00e5ng";
            }
            case R\u00d6R: {
                return "R\u00f6r";
            }
            case T_ST\u00c5NG: {
                return "T-St\u00e5ng";
            }
            case UNP_BALK: {
                return "UNP-Balk";
            }
            case UPE_BALK: {
                return "UPE-Balk";
            }
            case VKR_H\u00c5LPROFILER: {
                return "VKR H\u00e5lprofiler";
            }
        }
        throw new IllegalArgumentException("Bad category");
    }

    /*
     * Opcode count of 17419 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static List<Stalprofil> buildSt\u00e5lprofilList(Kategori kat) {
        switch (kat) {
            case FYRKANTST\u00c5NG: {
                return Arrays.asList(new Stalprofil("Fyrkantst\u00e5ng 6", 0.02), new Stalprofil("Fyrkantst\u00e5ng 8", 0.03), new Stalprofil("Fyrkantst\u00e5ng 10", 0.04), new Stalprofil("Fyrkantst\u00e5ng 12", 0.04), new Stalprofil("Fyrkantst\u00e5ng 14", 0.05), new Stalprofil("Fyrkantst\u00e5ng 15", 0.06), new Stalprofil("Fyrkantst\u00e5ng 16", 0.06), new Stalprofil("Fyrkantst\u00e5ng 18", 0.07), new Stalprofil("Fyrkantst\u00e5ng 20", 0.08), new Stalprofil("Fyrkantst\u00e5ng 22", 0.08), new Stalprofil("Fyrkantst\u00e5ng 25", 0.1), new Stalprofil("Fyrkantst\u00e5ng 30", 0.12), new Stalprofil("Fyrkantst\u00e5ng 32", 0.12), new Stalprofil("Fyrkantst\u00e5ng 35", 0.14), new Stalprofil("Fyrkantst\u00e5ng 40", 0.16), new Stalprofil("Fyrkantst\u00e5ng 45", 0.18), new Stalprofil("Fyrkantst\u00e5ng 50", 0.2), new Stalprofil("Fyrkantst\u00e5ng 55", 0.22), new Stalprofil("Fyrkantst\u00e5ng 60", 0.24), new Stalprofil("Fyrkantst\u00e5ng 65", 0.26), new Stalprofil("Fyrkantst\u00e5ng 70", 0.28), new Stalprofil("Fyrkantst\u00e5ng 75", 0.3), new Stalprofil("Fyrkantst\u00e5ng 80", 0.32), new Stalprofil("Fyrkantst\u00e5ng 90", 0.36), new Stalprofil("Fyrkantst\u00e5ng 100", 0.4), new Stalprofil("Fyrkantst\u00e5ng 110", 0.44), new Stalprofil("Fyrkantst\u00e5ng 115", 0.46), new Stalprofil("Fyrkantst\u00e5ng 120", 0.48), new Stalprofil("Fyrkantst\u00e5ng 125", 0.5), new Stalprofil("Fyrkantst\u00e5ng 150", 0.6), new Stalprofil("Fyrkantst\u00e5ng 180", 0.72), new Stalprofil("Fyrkantst\u00e5ng 200", 0.8), new Stalprofil("Fyrkantst\u00e5ng 225", 0.9));
            }
            case HEA_BALK: {
                return Arrays.asList(new Stalprofil("HEA100", 0.58), new Stalprofil("HEA120", 0.69), new Stalprofil("HEA140", 0.81), new Stalprofil("HEA160", 0.93), new Stalprofil("HEA180", 1.05), new Stalprofil("HEA200", 1.16), new Stalprofil("HEA220", 1.28), new Stalprofil("HEA240", 1.41), new Stalprofil("HEA260", 1.52), new Stalprofil("HEA280", 1.64), new Stalprofil("HEA300", 1.76), new Stalprofil("HEA320", 1.8), new Stalprofil("HEA340", 1.84), new Stalprofil("HEA360", 1.88), new Stalprofil("HEA400", 1.95), new Stalprofil("HEA450", 2.05), new Stalprofil("HEA500", 2.15), new Stalprofil("HEA550", 2.25), new Stalprofil("HEA600", 2.35), new Stalprofil("HEA650", 2.45), new Stalprofil("HEA700", 2.55), new Stalprofil("HEA800", 2.75), new Stalprofil("HEA900", 2.94), new Stalprofil("HEA1000", 3.14), new Stalprofil("HEA100/3", 0.48), new Stalprofil("HEA120/3", 0.57), new Stalprofil("HEA140/3", 0.67), new Stalprofil("HEA160/3", 0.77), new Stalprofil("HEA180/3", 0.87), new Stalprofil("HEA200/3", 0.96), new Stalprofil("HEA220/3", 1.06), new Stalprofil("HEA240/3", 1.17), new Stalprofil("HEA260/3", 1.26), new Stalprofil("HEA280/3", 1.36), new Stalprofil("HEA300/3", 1.46), new Stalprofil("HEA320/3", 1.5), new Stalprofil("HEA340/3", 1.54), new Stalprofil("HEA360/3", 1.58), new Stalprofil("HEA400/3", 1.65), new Stalprofil("HEA450/3", 1.75), new Stalprofil("HEA500/3", 1.85), new Stalprofil("HEA550/3", 1.95), new Stalprofil("HEA600/3", 2.05), new Stalprofil("HEA650/3", 2.15), new Stalprofil("HEA700/3", 2.25), new Stalprofil("HEA800/3", 2.45), new Stalprofil("HEA900/3", 2.65), new Stalprofil("HEA1000/3", 2.84), new Stalprofil("HEA100/i", 0.11), new Stalprofil("HEA120/i", 0.13), new Stalprofil("HEA140/i", 0.15), new Stalprofil("HEA160/i", 0.17), new Stalprofil("HEA180/i", 0.19), new Stalprofil("HEA200/i", 0.21), new Stalprofil("HEA220/i", 0.23), new Stalprofil("HEA240/i", 0.24), new Stalprofil("HEA260/i", 0.27), new Stalprofil("HEA280/i", 0.29), new Stalprofil("HEA300/i", 0.31), new Stalprofil("HEA320/i", 0.31), new Stalprofil("HEA340/i", 0.31), new Stalprofil("HEA360/i", 0.32), new Stalprofil("HEA400/i", 0.32), new Stalprofil("HEA450/i", 0.32), new Stalprofil("HEA500/i", 0.32), new Stalprofil("HEA550/i", 0.32), new Stalprofil("HEA600/i", 0.32), new Stalprofil("HEA650/i", 0.32), new Stalprofil("HEA700/i", 0.32), new Stalprofil("HEA800/i", 0.33), new Stalprofil("HEA900/i", 0.33), new Stalprofil("HEA1000/i", 0.33));
            }
            case HEB_BALK: {
                return Arrays.asList(new Stalprofil("HEB100", 0.58), new Stalprofil("HEB120", 0.7), new Stalprofil("HEB140", 0.82), new Stalprofil("HEB160", 0.94), new Stalprofil("HEB180", 1.06), new Stalprofil("HEB200", 1.18), new Stalprofil("HEB220", 1.3), new Stalprofil("HEB240", 1.42), new Stalprofil("HEB260", 1.54), new Stalprofil("HEB280", 1.65), new Stalprofil("HEB300", 1.77), new Stalprofil("HEB320", 1.81), new Stalprofil("HEB340", 1.85), new Stalprofil("HEB360", 1.89), new Stalprofil("HEB400", 1.97), new Stalprofil("HEB450", 2.07), new Stalprofil("HEB500", 2.17), new Stalprofil("HEB550", 2.27), new Stalprofil("HEB600", 2.36), new Stalprofil("HEB650", 2.46), new Stalprofil("HEB700", 2.56), new Stalprofil("HEB800", 2.76), new Stalprofil("HEB900", 2.96), new Stalprofil("HEB1000", 3.16), new Stalprofil("HEB100/3", 0.48), new Stalprofil("HEB120/3", 0.58), new Stalprofil("HEB140/3", 0.68), new Stalprofil("HEB160/3", 0.78), new Stalprofil("HEB180/3", 0.88), new Stalprofil("HEB200/3", 0.98), new Stalprofil("HEB220/3", 1.08), new Stalprofil("HEB240/3", 1.18), new Stalprofil("HEB260/3", 1.28), new Stalprofil("HEB280/3", 1.37), new Stalprofil("HEB300/3", 1.47), new Stalprofil("HEB320/3", 1.51), new Stalprofil("HEB340/3", 1.55), new Stalprofil("HEB360/3", 1.59), new Stalprofil("HEB400/3", 1.67), new Stalprofil("HEB450/3", 1.77), new Stalprofil("HEB500/3", 1.870000004768371), new Stalprofil("HEB550/3", 1.970000028610229), new Stalprofil("HEB600/3", 2.05999994277954), new Stalprofil("HEB650/3", 2.160000085830688), new Stalprofil("HEB700/3", 2.25999999046325), new Stalprofil("HEB800/3", 2.460000038146972), new Stalprofil("HEB900/3", 2.660000085830688), new Stalprofil("HEB1000/3", 2.85999989509582), new Stalprofil("HEB100/i", 0.1099999994039535), new Stalprofil("HEB120/i", 0.1299999952316284), new Stalprofil("HEB140/i", 0.1500000059604644), new Stalprofil("HEB160/i", 0.1700000017881393), new Stalprofil("HEB180/i", 0.189999997615814), new Stalprofil("HEB200/i", 0.209999993443489), new Stalprofil("HEB220/i", 0.2300000041723251), new Stalprofil("HEB240/i", 0.2599999904632568), new Stalprofil("HEB260/i", 0.280000001192092), new Stalprofil("HEB280/i", 0.3000000119209289), new Stalprofil("HEB300/i", 0.319999992847442), new Stalprofil("HEB320/i", 0.319999992847442), new Stalprofil("HEB340/i", 0.319999992847442), new Stalprofil("HEB360/i", 0.319999992847442), new Stalprofil("HEB400/i", 0.319999992847442), new Stalprofil("HEB450/i", 0.319999992847442), new Stalprofil("HEB500/i", 0.319999992847442), new Stalprofil("HEB550/i", 0.3300000131130218), new Stalprofil("HEB600/i", 0.3300000131130218), new Stalprofil("HEB650/i", 0.3300000131130218), new Stalprofil("HEB700/i", 0.3300000131130218), new Stalprofil("HEB800/i", 0.3300000131130218), new Stalprofil("HEB900/i", 0.3300000131130218), new Stalprofil("HEB1000/i", 0.3300000131130218));
            }
            case HEM_BALK: {
                return Arrays.asList(new Stalprofil("HEM100", 0.639999985694885), new Stalprofil("HEM120", 0.7), new Stalprofil("HEM140", 0.870000004768371), new Stalprofil("HEM160", 0.990000009536743), new Stalprofil("HEM180", 1.110000014305114), new Stalprofil("HEM200", 1.230000019073486), new Stalprofil("HEM220", 1.35000002384185), new Stalprofil("HEM240", 1.490000009536743), new Stalprofil("HEM260", 1.610000014305114), new Stalprofil("HEM280", 1.730000019073486), new Stalprofil("HEM300", 1.870000004768371), new Stalprofil("HEM320", 1.90999996662139), new Stalprofil("HEM340", 1.94000005722045), new Stalprofil("HEM360", 1.980000019073486), new Stalprofil("HEM400", 2.04999995231628), new Stalprofil("HEM450", 2.14000010490417), new Stalprofil("HEM500", 2.230000019073486), new Stalprofil("HEM550", 2.31999993324279), new Stalprofil("HEM600", 2.410000085830688), new Stalprofil("HEM650", 2.50999999046325), new Stalprofil("HEM700", 2.599999904632568), new Stalprofil("HEM800", 2.789999961853027), new Stalprofil("HEM900", 2.980000019073486), new Stalprofil("HEM1000", 3.1800000667572), new Stalprofil("HEM100/3", 0.52999997138977), new Stalprofil("HEM120/3", 0.629999995231628), new Stalprofil("HEM140/3", 0.730000019073486), new Stalprofil("HEM160/3", 0.829999983310699), new Stalprofil("HEM180/3", 0.9200000166893), new Stalprofil("HEM200/3", 1.019999980926513), new Stalprofil("HEM220/3", 1.120000004768371), new Stalprofil("HEM240/3", 1.240000009536743), new Stalprofil("HEM260/3", 1.3400000333786), new Stalprofil("HEM280/3", 1.44000005722045), new Stalprofil("HEM300/3", 1.55999994277954), new Stalprofil("HEM320/3", 1.60000002384185), new Stalprofil("HEM340/3", 1.629999995231628), new Stalprofil("HEM360/3", 1.669999957084655), new Stalprofil("HEM400/3", 1.740000009536743), new Stalprofil("HEM450/3", 1.830000042915344), new Stalprofil("HEM500/3", 1.919999957084655), new Stalprofil("HEM550/3", 2.019999980926513), new Stalprofil("HEM600/3", 2.10999989509582), new Stalprofil("HEM650/3", 2.20000004768371), new Stalprofil("HEM700/3", 2.29999995231628), new Stalprofil("HEM800/3", 2.49000000953674), new Stalprofil("HEM900/3", 2.6800000667572), new Stalprofil("HEM1000/3", 2.88000011444091), new Stalprofil("HEM100/i", 0.1299999952316284), new Stalprofil("HEM120/i", 0.1500000059604644), new Stalprofil("HEM140/i", 0.1700000017881393), new Stalprofil("HEM160/i", 0.189999997615814), new Stalprofil("HEM180/i", 0.209999993443489), new Stalprofil("HEM200/i", 0.2300000041723251), new Stalprofil("HEM220/i", 0.2), new Stalprofil("HEM240/i", 0.280000001192092), new Stalprofil("HEM260/i", 0.3000000119209289), new Stalprofil("HEM280/i", 0.319999992847442), new Stalprofil("HEM300/i", 0.349999994039535), new Stalprofil("HEM320/i", 0.349999994039535), new Stalprofil("HEM340/i", 0.349999994039535), new Stalprofil("HEM360/i", 0.349999994039535), new Stalprofil("HEM400/i", 0.340000003576278), new Stalprofil("HEM450/i", 0.340000003576278), new Stalprofil("HEM500/i", 0.340000003576278), new Stalprofil("HEM550/i", 0.340000003576278), new Stalprofil("HEM600/i", 0.340000003576278), new Stalprofil("HEM650/i", 0.340000003576278), new Stalprofil("HEM700/i", 0.340000003576278), new Stalprofil("HEM800/i", 0.340000003576278), new Stalprofil("HEM900/i", 0.340000003576278), new Stalprofil("HEM1000/i", 0.340000003576278));
            }
            case IPE_BALK: {
                return Arrays.asList(new Stalprofil("IPE80", 0.3300000131130218), new Stalprofil("IPE100", 0.409999996423721), new Stalprofil("IPE120", 0.4799999892711639), new Stalprofil("IPE140", 0.560000002384185), new Stalprofil("IPE160", 0.629999995231628), new Stalprofil("IPE180", 0.709999978542327), new Stalprofil("IPE200", 0.77999997138977), new Stalprofil("IPE220", 0.860000014305114), new Stalprofil("IPE240", 0.939999997615814), new Stalprofil("IPE270", 1.05999994277954), new Stalprofil("IPE300", 1.179999947547912), new Stalprofil("IPE330", 1.27999997138977), new Stalprofil("IPE360", 1.379999995231628), new Stalprofil("IPE400", 1.0), new Stalprofil("IPE450", 1.639999985694885), new Stalprofil("IPE500", 1.77999997138977), new Stalprofil("IPE550", 1.90999996662139), new Stalprofil("IPE600", 2.04999995231628), new Stalprofil("IPE80/3", 0.2899999916553497), new Stalprofil("IPE100/3", 0.349999994039535), new Stalprofil("IPE120/3", 0.4199999868869781), new Stalprofil("IPE140/3", 0.4900000095367431), new Stalprofil("IPE160/3", 0.55000001192092), new Stalprofil("IPE180/3", 0.620000004768371), new Stalprofil("IPE200/3", 0.680000007152557), new Stalprofil("IPE220/3", 0.7), new Stalprofil("IPE240/3", 0.819999992847442), new Stalprofil("IPE270/3", 0.930000007152557), new Stalprofil("IPE300/3", 1.02999997138977), new Stalprofil("IPE330/3", 1.120000004768371), new Stalprofil("IPE360/3", 1.210000038146972), new Stalprofil("IPE400/3", 1.320000052452087), new Stalprofil("IPE450/3", 1.450000047683715), new Stalprofil("IPE500/3", 1.580000042915344), new Stalprofil("IPE550/3", 1.700000047683715), new Stalprofil("IPE600/3", 1.830000042915344));
            }
            case I_BALK: {
                return Arrays.asList(new Stalprofil("I100x50x4,5", 0.400000005960464), new Stalprofil("I120x58x5,1", 0.469999998807907), new Stalprofil("I140x66x5,7", 0.540000021457672), new Stalprofil("I160x74x6,3", 0.610000014305114), new Stalprofil("I180x82x6,9", 0.680000007152557), new Stalprofil("I200x90x7,5", 0.759999990463256), new Stalprofil("I80x42x3,9", 0.319999992847442), new Stalprofil("I100x50x4,5/3", 0.349999994039535), new Stalprofil("I120x58x5,1/3", 0.409999996423721), new Stalprofil("I140x66x5,7/3", 0.469999998807907), new Stalprofil("I160x74x6,3/3", 0.540000021457672), new Stalprofil("I180x82x6,9/3", 0.600000023841857), new Stalprofil("I200x90x7,5/3", 0.6700000166893), new Stalprofil("I80x42x3,9/3", 0.280000001192092), new Stalprofil("I100x50x4,5/i", 0.050000000745058), new Stalprofil("I120x58x5,1/i", 0.0599999986588954), new Stalprofil("I140x66x5,7/i", 0.0700000002980232), new Stalprofil("I160x74x6,3/i", 0.0799999982118606), new Stalprofil("I180x82x6,9/i", 0.0900000035762786), new Stalprofil("I200x90x7,5/i", 0.1000000014901161), new Stalprofil("I80x42x3,9/i", 0.050000000745058));
            }
            case KKR_H\u00c5LPROFILER: {
                return Arrays.asList(new Stalprofil("KKR100x100x10,0/3", 0.3000000119209289), new Stalprofil("KKR100x100x3,0/3", 0.3000000119209289), new Stalprofil("KKR100x100x4,0/3", 0.3000000119209289), new Stalprofil("KKR100x100x5,0/3", 0.3000000119209289), new Stalprofil("KKR100x100x6,0/3", 0.3000000119209289), new Stalprofil("KKR100x100x6,3/3", 0.3000000119209289), new Stalprofil("KKR100x100x8,0/3", 0.3000000119209289), new Stalprofil("KKR100x40x4,0/3", 0.2399999946355819), new Stalprofil("KKR100x50x3,0/3", 0.2), new Stalprofil("KKR100x50x4,0/3", 0.2), new Stalprofil("KKR100x50x5,0/3", 0.2), new Stalprofil("KKR100x50x6,0/3", 0.2), new Stalprofil("KKR100x50x6,3/3", 0.2), new Stalprofil("KKR100x60x3,0/3", 0.2599999904632568), new Stalprofil("KKR100x60x4,0/3", 0.2599999904632568), new Stalprofil("KKR100x60x5,0/3", 0.2599999904632568), new Stalprofil("KKR100x60x6,0/3", 0.2599999904632568), new Stalprofil("KKR100x60x6,3/3", 0.2599999904632568), new Stalprofil("KKR100x80x4,0/3", 0.280000001192092), new Stalprofil("KKR100x80x5,0/3", 0.280000001192092), new Stalprofil("KKR120x120x10,0/3", 0.3600000143051147), new Stalprofil("KKR120x120x4,0/3", 0.3600000143051147), new Stalprofil("KKR120x120x5,0/3", 0.3600000143051147), new Stalprofil("KKR120x120x6,0/3", 0.3600000143051147), new Stalprofil("KKR120x120x6,3/3", 0.3600000143051147), new Stalprofil("KKR120x120x8,0/3", 0.3600000143051147), new Stalprofil("KKR120x60x4,0/3", 0.3000000119209289), new Stalprofil("KKR120x60x5,0/3", 0.3000000119209289), new Stalprofil("KKR120x60x6,0/3", 0.3000000119209289), new Stalprofil("KKR120x60x6,3/3", 0.3000000119209289), new Stalprofil("KKR120x80x4,0/3", 0.319999992847442), new Stalprofil("KKR120x80x5,0/3", 0.319999992847442), new Stalprofil("KKR120x80x6,0/3", 0.319999992847442), new Stalprofil("KKR120x80x6,3/3", 0.319999992847442), new Stalprofil("KKR120x80x8,0/3", 0.319999992847442), new Stalprofil("KKR140x140x10,0/3", 0.4199999868869781), new Stalprofil("KKR140x140x5,0/3", 0.4199999868869781), new Stalprofil("KKR140x140x6,0/3", 0.4199999868869781), new Stalprofil("KKR140x140x6,3/3", 0.4199999868869781), new Stalprofil("KKR140x140x8,0/3", 0.4199999868869781), new Stalprofil("KKR140x70x4,0/3", 0.349999994039535), new Stalprofil("KKR140x70x5,0/3", 0.349999994039535), new Stalprofil("KKR140x70x6,3/3", 0.349999994039535), new Stalprofil("KKR140x80x4,0/3", 0.3600000143051147), new Stalprofil("KKR140x80x6,0/3", 0.3600000143051147), new Stalprofil("KKR140x80x6,3/3", 0.3600000143051147), new Stalprofil("KKR150x100x10,0/3", 0.400000005960464), new Stalprofil("KKR150x100x4,0/3", 0.400000005960464), new Stalprofil("KKR150x100x5,0/3", 0.400000005960464), new Stalprofil("KKR150x100x6,0/3", 0.400000005960464), new Stalprofil("KKR150x100x6,3/3", 0.400000005960464), new Stalprofil("KKR150x100x8,0/3", 0.400000005960464), new Stalprofil("KKR150x150x10,0/3", 0.449999988079071), new Stalprofil("KKR150x150x5,0/3", 0.449999988079071), new Stalprofil("KKR150x150x6,0/3", 0.449999988079071), new Stalprofil("KKR150x150x6,3/3", 0.449999988079071), new Stalprofil("KKR150x150x8,0/3", 0.449999988079071), new Stalprofil("KKR160x160x10,0/3", 0.4799999892711639), new Stalprofil("KKR160x160x6,0/3", 0.4799999892711639), new Stalprofil("KKR160x160x6,3/3", 0.4799999892711639), new Stalprofil("KKR160x160x8,0/3", 0.4799999892711639), new Stalprofil("KKR160x80x4,0/3", 0.400000005960464), new Stalprofil("KKR160x80x5,0/3", 0.400000005960464), new Stalprofil("KKR160x80x6,0/3", 0.400000005960464), new Stalprofil("KKR160x80x6,3/3", 0.400000005960464), new Stalprofil("KKR160x80x8,0/3", 0.400000005960464), new Stalprofil("KKR180x100x10,0/3", 0.4600000083446502), new Stalprofil("KKR180x100x6,0/3", 0.4600000083446502), new Stalprofil("KKR180x100x6,3/3", 0.4600000083446502), new Stalprofil("KKR180x100x8,0/3", 0.4600000083446502), new Stalprofil("KKR180x180x10,0/3", 0.540000021457672), new Stalprofil("KKR180x180x12,5/3", 0.540000021457672), new Stalprofil("KKR180x180x6,0/3", 0.540000021457672), new Stalprofil("KKR180x180x6,3/3", 0.540000021457672), new Stalprofil("KKR180x180x8,0/3", 0.540000021457672), new Stalprofil("KKR200x100x10,0/3", 0.0), new Stalprofil("KKR200x100x4,0/3", 0.0), new Stalprofil("KKR200x100x5,0/3", 0.0), new Stalprofil("KKR200x100x6,0/3", 0.0), new Stalprofil("KKR200x100x6,3/3", 0.0), new Stalprofil("KKR200x100x8,0/3", 0.0), new Stalprofil("KKR200x120x10,0/3", 0.519999980926513), new Stalprofil("KKR200x120x6,0/3", 0.519999980926513), new Stalprofil("KKR200x120x6,3/3", 0.519999980926513), new Stalprofil("KKR200x120x8,0/3", 0.519999980926513), new Stalprofil("KKR200x200x10,0/3", 0.600000023841857), new Stalprofil("KKR200x200x12,5/3", 0.600000023841857), new Stalprofil("KKR200x200x6,0/3", 0.600000023841857), new Stalprofil("KKR200x200x6,3/3", 0.600000023841857), new Stalprofil("KKR200x200x8,0/3", 0.600000023841857), new Stalprofil("KKR220x120x10,0/3", 0.560000002384185), new Stalprofil("KKR220x120x6,0/3", 0.560000002384185), new Stalprofil("KKR220x120x6,3/3", 0.560000002384185), new Stalprofil("KKR220x120x8,0/3", 0.560000002384185), new Stalprofil("KKR220x220x10,0/3", 0.660000026226043), new Stalprofil("KKR220x220x6,0/3", 0.660000026226043), new Stalprofil("KKR220x220x6,3/3", 0.660000026226043), new Stalprofil("KKR220x220x8,0/3", 0.660000026226043), new Stalprofil("KKR250x150x10,0/3", 0.649999976158142), new Stalprofil("KKR250x150x12,5/3", 0.649999976158142), new Stalprofil("KKR250x150x6,0/3", 0.649999976158142), new Stalprofil("KKR250x150x6,3/3", 0.649999976158142), new Stalprofil("KKR250x150x8,0/3", 0.649999976158142), new Stalprofil("KKR250x250x10,0/3", 0.7), new Stalprofil("KKR250x250x12,5/3", 0.7), new Stalprofil("KKR250x250x6,0/3", 0.7), new Stalprofil("KKR250x250x6,3/3", 0.7), new Stalprofil("KKR250x250x8,0/3", 0.7), new Stalprofil("KKR25x25x3,0/3", 0.0700000002980232), new Stalprofil("KKR300x200x10,0/3", 0.80000001192092), new Stalprofil("KKR300x200x12,5/3", 0.80000001192092), new Stalprofil("KKR300x200x6,0/3", 0.80000001192092), new Stalprofil("KKR300x200x6,3/3", 0.80000001192092), new Stalprofil("KKR300x200x8,0/3", 0.80000001192092), new Stalprofil("KKR300x300x10,0/3", 0.899999976158142), new Stalprofil("KKR300x300x12,5/3", 0.899999976158142), new Stalprofil("KKR300x300x8,0/3", 0.899999976158142), new Stalprofil("KKR30x30x3,0/3", 0.0900000035762786), new Stalprofil("KKR400x200x12,0/3", 1.0), new Stalprofil("KKR400x200x12,5/3", 1.0), new Stalprofil("KKR400x200x6,0/3", 1.0), new Stalprofil("KKR400x200x6,3/3", 1.0), new Stalprofil("KKR400x200x8,0/3", 1.0), new Stalprofil("KKR40x30x3,0/3", 0.1099999994039535), new Stalprofil("KKR40x40x2,5/3", 0.1199999973177909), new Stalprofil("KKR40x40x3,0/3", 0.1199999973177909), new Stalprofil("KKR40x40x4,0/3", 0.1199999973177909), new Stalprofil("KKR50x25x3,0/3", 0.1199999973177909), new Stalprofil("KKR50x30x2,5/3", 0.1299999952316284), new Stalprofil("KKR50x30x3,0/3", 0.1299999952316284), new Stalprofil("KKR50x30x4,0/3", 0.1299999952316284), new Stalprofil("KKR50x50x3,0/3", 0.1500000059604644), new Stalprofil("KKR50x50x4,0/3", 0.1500000059604644), new Stalprofil("KKR50x50x5,0/3", 0.1500000059604644), new Stalprofil("KKR60x40x3,0/3", 0.159999996423721), new Stalprofil("KKR60x40x4,0/3", 0.159999996423721), new Stalprofil("KKR60x40x5,0/3", 0.159999996423721), new Stalprofil("KKR60x60x3,0/3", 0.1800000071525573), new Stalprofil("KKR60x60x4,0/3", 0.1800000071525573), new Stalprofil("KKR60x60x5,0/3", 0.1800000071525573), new Stalprofil("KKR70x40x4,0/3", 0.1800000071525573), new Stalprofil("KKR70x70x3,0/3", 0.209999993443489), new Stalprofil("KKR70x70x4,0/3", 0.209999993443489), new Stalprofil("KKR70x70x5,0/3", 0.209999993443489), new Stalprofil("KKR80x40x3,0/3", 0.2000000029802322), new Stalprofil("KKR80x40x4,0/3", 0.2000000029802322), new Stalprofil("KKR80x40x5,0/3", 0.2000000029802322), new Stalprofil("KKR80x50x3,0/3", 0.209999993443489), new Stalprofil("KKR80x50x4,0/3", 0.209999993443489), new Stalprofil("KKR80x50x5,0/3", 0.209999993443489), new Stalprofil("KKR80x60x3,0/3", 0.219999998807907), new Stalprofil("KKR80x60x4,0/3", 0.219999998807907), new Stalprofil("KKR80x60x5,0/3", 0.219999998807907), new Stalprofil("KKR80x80x3,0/3", 0.2399999946355819), new Stalprofil("KKR80x80x4,0/3", 0.2399999946355819), new Stalprofil("KKR80x80x5,0/3", 0.2399999946355819), new Stalprofil("KKR80x80x6,3/3", 0.2399999946355819), new Stalprofil("KKR90x50x4,0/3", 0.2300000041723251), new Stalprofil("KKR90x50x5,0/3", 0.2300000041723251), new Stalprofil("KKR90x90x3,0/3", 0.270000010728836), new Stalprofil("KKR90x90x4,0/3", 0.270000010728836), new Stalprofil("KKR90x90x5,0/3", 0.270000010728836), new Stalprofil("KKR90x90x6,0/3", 0.270000010728836), new Stalprofil("KKR90x90x6,3/3", 0.270000010728836), new Stalprofil("KKR100x100x10,0", 0.400000005960464), new Stalprofil("KKR100x100x3,0", 0.400000005960464), new Stalprofil("KKR100x100x4,0", 0.400000005960464), new Stalprofil("KKR100x100x5,0", 0.400000005960464), new Stalprofil("KKR100x100x6,0", 0.400000005960464), new Stalprofil("KKR100x100x6,3", 0.400000005960464), new Stalprofil("KKR100x100x8,0", 0.400000005960464), new Stalprofil("KKR100x40x4,0", 0.280000001192092), new Stalprofil("KKR100x50x3,0", 0.3000000119209289), new Stalprofil("KKR100x50x4,0", 0.3000000119209289), new Stalprofil("KKR100x50x5,0", 0.3000000119209289), new Stalprofil("KKR100x50x6,0", 0.3000000119209289), new Stalprofil("KKR100x50x6,3", 0.3000000119209289), new Stalprofil("KKR100x60x3,0", 0.319999992847442), new Stalprofil("KKR100x60x4,0", 0.319999992847442), new Stalprofil("KKR100x60x5,0", 0.319999992847442), new Stalprofil("KKR100x60x6,0", 0.319999992847442), new Stalprofil("KKR100x60x6,3", 0.319999992847442), new Stalprofil("KKR100x80x4,0", 0.3600000143051147), new Stalprofil("KKR100x80x5,0", 0.3600000143051147), new Stalprofil("KKR120x120x10,0", 0.4799999892711639), new Stalprofil("KKR120x120x4,0", 0.4799999892711639), new Stalprofil("KKR120x120x5,0", 0.4799999892711639), new Stalprofil("KKR120x120x6,0", 0.4799999892711639), new Stalprofil("KKR120x120x6,3", 0.4799999892711639), new Stalprofil("KKR120x120x8,0", 0.4799999892711639), new Stalprofil("KKR120x60x4,0", 0.3600000143051147), new Stalprofil("KKR120x60x5,0", 0.3600000143051147), new Stalprofil("KKR120x60x6,0", 0.3600000143051147), new Stalprofil("KKR120x60x6,3", 0.3600000143051147), new Stalprofil("KKR120x80x4,0", 0.400000005960464), new Stalprofil("KKR120x80x5,0", 0.400000005960464), new Stalprofil("KKR120x80x6,0", 0.400000005960464), new Stalprofil("KKR120x80x6,3", 0.400000005960464), new Stalprofil("KKR120x80x8,0", 0.400000005960464), new Stalprofil("KKR140x140x10,0", 0.560000002384185), new Stalprofil("KKR140x140x5,0", 0.560000002384185), new Stalprofil("KKR140x140x6,0", 0.560000002384185), new Stalprofil("KKR140x140x6,3", 0.560000002384185), new Stalprofil("KKR140x140x8,0", 0.560000002384185), new Stalprofil("KKR140x70x4,0", 0.4199999868869781), new Stalprofil("KKR140x70x5,0", 0.4199999868869781), new Stalprofil("KKR140x70x6,3", 0.4199999868869781), new Stalprofil("KKR140x80x4,0", 0.439999997615814), new Stalprofil("KKR140x80x6,0", 0.439999997615814), new Stalprofil("KKR140x80x6,3", 0.439999997615814), new Stalprofil("KKR150x100x10,0", 0.0), new Stalprofil("KKR150x100x4,0", 0.0), new Stalprofil("KKR150x100x5,0", 0.0), new Stalprofil("KKR150x100x6,0", 0.0), new Stalprofil("KKR150x100x6,3", 0.0), new Stalprofil("KKR150x100x8,0", 0.0), new Stalprofil("KKR150x150x10,0", 0.600000023841857), new Stalprofil("KKR150x150x5,0", 0.600000023841857), new Stalprofil("KKR150x150x6,0", 0.600000023841857), new Stalprofil("KKR150x150x6,3", 0.600000023841857), new Stalprofil("KKR150x150x8,0", 0.600000023841857), new Stalprofil("KKR160x160x10,0", 0.639999985694885), new Stalprofil("KKR160x160x6,0", 0.639999985694885), new Stalprofil("KKR160x160x6,3", 0.639999985694885), new Stalprofil("KKR160x160x8,0", 0.639999985694885), new Stalprofil("KKR160x80x4,0", 0.4799999892711639), new Stalprofil("KKR160x80x5,0", 0.4799999892711639), new Stalprofil("KKR160x80x6,0", 0.4799999892711639), new Stalprofil("KKR160x80x6,3", 0.4799999892711639), new Stalprofil("KKR160x80x8,0", 0.4799999892711639), new Stalprofil("KKR180x100x10,0", 0.560000002384185), new Stalprofil("KKR180x100x6,0", 0.560000002384185), new Stalprofil("KKR180x100x6,3", 0.560000002384185), new Stalprofil("KKR180x100x8,0", 0.560000002384185), new Stalprofil("KKR180x180x10,0", 0.720000028610229), new Stalprofil("KKR180x180x12,5", 0.720000028610229), new Stalprofil("KKR180x180x6,0", 0.720000028610229), new Stalprofil("KKR180x180x6,3", 0.720000028610229), new Stalprofil("KKR180x180x8,0", 0.720000028610229), new Stalprofil("KKR200x100x10,0", 0.600000023841857), new Stalprofil("KKR200x100x4,0", 0.600000023841857), new Stalprofil("KKR200x100x5,0", 0.600000023841857), new Stalprofil("KKR200x100x6,0", 0.600000023841857), new Stalprofil("KKR200x100x6,3", 0.600000023841857), new Stalprofil("KKR200x100x8,0", 0.600000023841857), new Stalprofil("KKR200x120x10,0", 0.639999985694885), new Stalprofil("KKR200x120x6,0", 0.639999985694885), new Stalprofil("KKR200x120x6,3", 0.639999985694885), new Stalprofil("KKR200x120x8,0", 0.639999985694885), new Stalprofil("KKR200x200x10,0", 0.80000001192092), new Stalprofil("KKR200x200x12,5", 0.80000001192092), new Stalprofil("KKR200x200x6,0", 0.80000001192092), new Stalprofil("KKR200x200x6,3", 0.80000001192092), new Stalprofil("KKR200x200x8,0", 0.80000001192092), new Stalprofil("KKR220x120x10,0", 0.680000007152557), new Stalprofil("KKR220x120x6,0", 0.680000007152557), new Stalprofil("KKR220x120x6,3", 0.680000007152557), new Stalprofil("KKR220x120x8,0", 0.680000007152557), new Stalprofil("KKR220x220x10,0", 0.879999995231628), new Stalprofil("KKR220x220x6,0", 0.879999995231628), new Stalprofil("KKR220x220x6,3", 0.879999995231628), new Stalprofil("KKR220x220x8,0", 0.879999995231628), new Stalprofil("KKR250x150x10,0", 0.80000001192092), new Stalprofil("KKR250x150x12,5", 0.80000001192092), new Stalprofil("KKR250x150x6,0", 0.80000001192092), new Stalprofil("KKR250x150x6,3", 0.80000001192092), new Stalprofil("KKR250x150x8,0", 0.80000001192092), new Stalprofil("KKR250x250x10,0", 1.0), new Stalprofil("KKR250x250x12,5", 1.0), new Stalprofil("KKR250x250x6,0", 1.0), new Stalprofil("KKR250x250x6,3", 1.0), new Stalprofil("KKR250x250x8,0", 1.0), new Stalprofil("KKR25x25x3,0", 0.1000000014901161), new Stalprofil("KKR300x200x10,0", 1.0), new Stalprofil("KKR300x200x12,5", 1.0), new Stalprofil("KKR300x200x6,0", 1.0), new Stalprofil("KKR300x200x6,3", 1.0), new Stalprofil("KKR300x200x8,0", 1.0), new Stalprofil("KKR300x300x10,0", 1.200000047683715), new Stalprofil("KKR300x300x12,5", 1.200000047683715), new Stalprofil("KKR300x300x8,0", 1.200000047683715), new Stalprofil("KKR30x30x3,0", 0.1199999973177909), new Stalprofil("KKR400x200x12,0", 1.200000047683715), new Stalprofil("KKR400x200x12,5", 1.200000047683715), new Stalprofil("KKR400x200x6,0", 1.200000047683715), new Stalprofil("KKR400x200x6,3", 1.200000047683715), new Stalprofil("KKR400x200x8,0", 1.200000047683715), new Stalprofil("KKR40x30x3,0", 0.1400000005960464), new Stalprofil("KKR40x40x2,5", 0.159999996423721), new Stalprofil("KKR40x40x3,0", 0.159999996423721), new Stalprofil("KKR40x40x4,0", 0.159999996423721), new Stalprofil("KKR50x25x3,0", 0.1500000059604644), new Stalprofil("KKR50x30x2,5", 0.159999996423721), new Stalprofil("KKR50x30x3,0", 0.159999996423721), new Stalprofil("KKR50x30x4,0", 0.159999996423721), new Stalprofil("KKR50x50x3,0", 0.2000000029802322), new Stalprofil("KKR50x50x4,0", 0.2000000029802322), new Stalprofil("KKR50x50x5,0", 0.2000000029802322), new Stalprofil("KKR60x40x3,0", 0.2000000029802322), new Stalprofil("KKR60x40x4,0", 0.2000000029802322), new Stalprofil("KKR60x40x5,0", 0.2000000029802322), new Stalprofil("KKR60x60x3,0", 0.2399999946355819), new Stalprofil("KKR60x60x4,0", 0.2399999946355819), new Stalprofil("KKR60x60x5,0", 0.2399999946355819), new Stalprofil("KKR70x40x4,0", 0.219999998807907), new Stalprofil("KKR70x70x3,0", 0.280000001192092), new Stalprofil("KKR70x70x4,0", 0.280000001192092), new Stalprofil("KKR70x70x5,0", 0.280000001192092), new Stalprofil("KKR80x40x3,0", 0.2399999946355819), new Stalprofil("KKR80x40x4,0", 0.2399999946355819), new Stalprofil("KKR80x40x5,0", 0.2399999946355819), new Stalprofil("KKR80x50x3,0", 0.2599999904632568), new Stalprofil("KKR80x50x4,0", 0.2599999904632568), new Stalprofil("KKR80x50x5,0", 0.2599999904632568), new Stalprofil("KKR80x60x3,0", 0.280000001192092), new Stalprofil("KKR80x60x4,0", 0.280000001192092), new Stalprofil("KKR80x60x5,0", 0.280000001192092), new Stalprofil("KKR80x80x3,0", 0.319999992847442), new Stalprofil("KKR80x80x4,0", 0.319999992847442), new Stalprofil("KKR80x80x5,0", 0.319999992847442), new Stalprofil("KKR80x80x6,3", 0.319999992847442), new Stalprofil("KKR90x50x4,0", 0.280000001192092), new Stalprofil("KKR90x50x5,0", 0.280000001192092), new Stalprofil("KKR90x90x3,0", 0.3600000143051147), new Stalprofil("KKR90x90x4,0", 0.3600000143051147), new Stalprofil("KKR90x90x5,0", 0.3600000143051147), new Stalprofil("KKR90x90x6,0", 0.3600000143051147), new Stalprofil("KKR90x90x6,3", 0.3600000143051147));
            }
            case L_ST\u00c5L: {
                return Arrays.asList(new Stalprofil("L100x100x10,0/3", 0.3000000119209289), new Stalprofil("L100x100x12,0/3", 0.3000000119209289), new Stalprofil("L100x100x14,0/3", 0.3000000119209289), new Stalprofil("L100x50x10,0/3", 0.2), new Stalprofil("L100x50x6,0/3", 0.2), new Stalprofil("L100x50x8,0/3", 0.2), new Stalprofil("L100x65x11,0/3", 0.2599999904632568), new Stalprofil("L100x65x8,0/3", 0.2599999904632568), new Stalprofil("L100x65x9,0/3", 0.2599999904632568), new Stalprofil("L100x75x10,0/3", 0.270000010728836), new Stalprofil("L100x75x12,0/3", 0.270000010728836), new Stalprofil("L100x75x8,0/3", 0.270000010728836), new Stalprofil("L110x110x10,0/3", 0.3300000131130218), new Stalprofil("L110x110x12,0/3", 0.3300000131130218), new Stalprofil("L120x120x11,0/3", 0.3600000143051147), new Stalprofil("L120x120x13,0/3", 0.3600000143051147), new Stalprofil("L120x120x15,0/3", 0.3600000143051147), new Stalprofil("L120x80x10,0/3", 0.319999992847442), new Stalprofil("L120x80x12,0/3", 0.319999992847442), new Stalprofil("L120x80x9,0/3", 0.319999992847442), new Stalprofil("L130x130x12,0/3", 0.3899999856948852), new Stalprofil("L130x130x14,0/3", 0.3899999856948852), new Stalprofil("L130x65x10,0/3", 0.319999992847442), new Stalprofil("L130x65x12,0/3", 0.319999992847442), new Stalprofil("L130x65x8,0/3", 0.319999992847442), new Stalprofil("L130x75x10,0/3", 0.3300000131130218), new Stalprofil("L130x75x12,0/3", 0.3300000131130218), new Stalprofil("L130x75x8,0/3", 0.3300000131130218), new Stalprofil("L130x90x10,0/3", 0.349999994039535), new Stalprofil("L130x90x12,0/3", 0.349999994039535), new Stalprofil("L140x140x13,0/3", 0.4199999868869781), new Stalprofil("L140x140x15,0/3", 0.4199999868869781), new Stalprofil("L150x100x10,0/3", 0.400000005960464), new Stalprofil("L150x100x12,0/3", 0.400000005960464), new Stalprofil("L150x100x14,0/3", 0.400000005960464), new Stalprofil("L150x150x12,0/3", 0.449999988079071), new Stalprofil("L150x150x14,0/3", 0.449999988079071), new Stalprofil("L150x150x16,0/3", 0.449999988079071), new Stalprofil("L150x75x11,0/3", 0.370000004768371), new Stalprofil("L150x75x13,0/3", 0.370000004768371), new Stalprofil("L150x75x9,0/3", 0.370000004768371), new Stalprofil("L150x90x10,0/3", 0.3899999856948852), new Stalprofil("L150x90x12,0/3", 0.3899999856948852), new Stalprofil("L15x15x3,0/3", 0.0399999991059303), new Stalprofil("L160x160x15,0/3", 0.4799999892711639), new Stalprofil("L160x80x12,0/3", 0.400000005960464), new Stalprofil("L180x180x16,0/3", 0.540000021457672), new Stalprofil("L180x180x18,0/3", 0.540000021457672), new Stalprofil("L180x90x10,0/3", 0.449999988079071), new Stalprofil("L180x90x12,0/3", 0.449999988079071), new Stalprofil("L180x90x14,0/3", 0.449999988079071), new Stalprofil("L200x100x12,0/3", 0.0), new Stalprofil("L200x100x14,0/3", 0.0), new Stalprofil("L200x100x16,0/3", 0.0), new Stalprofil("L200x200x16,0/3", 0.600000023841857), new Stalprofil("L200x200x18,0/3", 0.600000023841857), new Stalprofil("L20x20x3,0/3", 0.0599999986588954), new Stalprofil("L20x20x4,0/3", 0.0599999986588954), new Stalprofil("L25x25x3,0/3", 0.0700000002980232), new Stalprofil("L25x25x4,0/3", 0.0700000002980232), new Stalprofil("L25x25x5,0/3", 0.0700000002980232), new Stalprofil("L30x20x3,0/3", 0.0799999982118606), new Stalprofil("L30x20x4,0/3", 0.0799999982118606), new Stalprofil("L30x30x3,0/3", 0.0900000035762786), new Stalprofil("L30x30x4,0/3", 0.0900000035762786), new Stalprofil("L30x30x5,0/3", 0.0900000035762786), new Stalprofil("L30x30x6,0/3", 0.0900000035762786), new Stalprofil("L35x35x3,0/3", 0.1000000014901161), new Stalprofil("L35x35x4,0/3", 0.1000000014901161), new Stalprofil("L35x35x5,0/3", 0.1000000014901161), new Stalprofil("L35x35x6,0/3", 0.1000000014901161), new Stalprofil("L40x20x3,0/3", 0.1000000014901161), new Stalprofil("L40x20x4,0/3", 0.1000000014901161), new Stalprofil("L40x40x3,0/3", 0.1199999973177909), new Stalprofil("L40x40x4,0/3", 0.1199999973177909), new Stalprofil("L40x40x5,0/3", 0.1199999973177909), new Stalprofil("L40x40x6,0/3", 0.1199999973177909), new Stalprofil("L40x40x8,0/3", 0.1199999973177909), new Stalprofil("L45x30x3,0/3", 0.1199999973177909), new Stalprofil("L45x30x4,0/3", 0.1199999973177909), new Stalprofil("L45x45x5,0/3", 0.1299999952316284), new Stalprofil("L45x45x6,0/3", 0.1299999952316284), new Stalprofil("L45x45x7,0/3", 0.1299999952316284), new Stalprofil("L45x45x8,0/3", 0.1299999952316284), new Stalprofil("L50x30x5,0/3", 0.1299999952316284), new Stalprofil("L50x50x3,0/3", 0.1500000059604644), new Stalprofil("L50x50x4,0/3", 0.1500000059604644), new Stalprofil("L50x50x5,0/3", 0.1500000059604644), new Stalprofil("L50x50x6,0/3", 0.1500000059604644), new Stalprofil("L50x50x7,0/3", 0.1500000059604644), new Stalprofil("L50x50x8,0/3", 0.1500000059604644), new Stalprofil("L50x50x9,0/3", 0.1500000059604644), new Stalprofil("L55x55x10,0/3", 0.159999996423721), new Stalprofil("L55x55x6,0/3", 0.159999996423721), new Stalprofil("L60x30x5,0/3", 0.1500000059604644), new Stalprofil("L60x30x7,0/3", 0.1500000059604644), new Stalprofil("L60x40x5,0/3", 0.159999996423721), new Stalprofil("L60x40x7,0/3", 0.159999996423721), new Stalprofil("L60x60x10,0/3", 0.1800000071525573), new Stalprofil("L60x60x6,0/3", 0.1800000071525573), new Stalprofil("L60x60x8,0/3", 0.1800000071525573), new Stalprofil("L65x50x5,0/3", 0.1800000071525573), new Stalprofil("L65x50x6,0/3", 0.1800000071525573), new Stalprofil("L65x50x7,0/3", 0.1800000071525573), new Stalprofil("L65x65x7,0/3", 0.189999997615814), new Stalprofil("L65x65x9,0/3", 0.189999997615814), new Stalprofil("L70x70x7,0/3", 0.209999993443489), new Stalprofil("L70x70x9,0/3", 0.209999993443489), new Stalprofil("L75x50x5,0/3", 0.2000000029802322), new Stalprofil("L75x50x6,0/3", 0.2000000029802322), new Stalprofil("L75x50x7,0/3", 0.2000000029802322), new Stalprofil("L75x50x9,0/3", 0.2000000029802322), new Stalprofil("L75x55x7,0/3", 0.2000000029802322), new Stalprofil("L75x55x9,0/3", 0.2000000029802322), new Stalprofil("L75x75x10,0/3", 0.219999998807907), new Stalprofil("L75x75x12,0/3", 0.219999998807907), new Stalprofil("L75x75x6,0/3", 0.219999998807907), new Stalprofil("L75x75x7,0/3", 0.219999998807907), new Stalprofil("L75x75x8,0/3", 0.219999998807907), new Stalprofil("L80x40x6,0/3", 0.2000000029802322), new Stalprofil("L80x40x8,0/3", 0.2000000029802322), new Stalprofil("L80x80x10,0/3", 0.2399999946355819), new Stalprofil("L80x80x12,0/3", 0.2399999946355819), new Stalprofil("L80x80x8,0/3", 0.2399999946355819), new Stalprofil("L90x60x8,0/3", 0.2399999946355819), new Stalprofil("L90x75x10,0/3", 0.2), new Stalprofil("L90x75x8,0/3", 0.2), new Stalprofil("L90x90x11,0/3", 0.270000010728836), new Stalprofil("L90x90x9,0/3", 0.270000010728836), new Stalprofil("L100x100x10,0", 0.400000005960464), new Stalprofil("L100x100x12,0", 0.400000005960464), new Stalprofil("L100x100x14,0", 0.400000005960464), new Stalprofil("L100x50x10,0", 0.3000000119209289), new Stalprofil("L100x50x6,0", 0.3000000119209289), new Stalprofil("L100x50x8,0", 0.3000000119209289), new Stalprofil("L100x65x11,0", 0.3300000131130218), new Stalprofil("L100x65x8,0", 0.3300000131130218), new Stalprofil("L100x65x9,0", 0.3300000131130218), new Stalprofil("L100x75x10,0", 0.349999994039535), new Stalprofil("L100x75x12,0", 0.349999994039535), new Stalprofil("L100x75x8,0", 0.349999994039535), new Stalprofil("L110x110x10,0", 0.439999997615814), new Stalprofil("L110x110x12,0", 0.439999997615814), new Stalprofil("L120x120x11,0", 0.4799999892711639), new Stalprofil("L120x120x13,0", 0.4799999892711639), new Stalprofil("L120x120x15,0", 0.4799999892711639), new Stalprofil("L120x80x10,0", 0.400000005960464), new Stalprofil("L120x80x12,0", 0.400000005960464), new Stalprofil("L120x80x9,0", 0.400000005960464), new Stalprofil("L130x130x12,0", 0.519999980926513), new Stalprofil("L130x130x14,0", 0.519999980926513), new Stalprofil("L130x65x10,0", 0.3899999856948852), new Stalprofil("L130x65x12,0", 0.3899999856948852), new Stalprofil("L130x65x8,0", 0.3899999856948852), new Stalprofil("L130x75x10,0", 0.409999996423721), new Stalprofil("L130x75x12,0", 0.409999996423721), new Stalprofil("L130x75x8,0", 0.409999996423721), new Stalprofil("L130x90x10,0", 0.439999997615814), new Stalprofil("L130x90x12,0", 0.439999997615814), new Stalprofil("L140x140x13,0", 0.560000002384185), new Stalprofil("L140x140x15,0", 0.560000002384185), new Stalprofil("L150x100x10,0", 0.0), new Stalprofil("L150x100x12,0", 0.0), new Stalprofil("L150x100x14,0", 0.0), new Stalprofil("L150x150x12,0", 0.600000023841857), new Stalprofil("L150x150x14,0", 0.600000023841857), new Stalprofil("L150x150x16,0", 0.600000023841857), new Stalprofil("L150x75x11,0", 0.449999988079071), new Stalprofil("L150x75x13,0", 0.449999988079071), new Stalprofil("L150x75x9,0", 0.449999988079071), new Stalprofil("L150x90x10,0", 0.4799999892711639), new Stalprofil("L150x90x12,0", 0.4799999892711639), new Stalprofil("L15x15x3,0", 0.0599999986588954), new Stalprofil("L160x160x15,0", 0.639999985694885), new Stalprofil("L160x80x12,0", 0.4799999892711639), new Stalprofil("L180x180x16,0", 0.720000028610229), new Stalprofil("L180x180x18,0", 0.720000028610229), new Stalprofil("L180x90x10,0", 0.540000021457672), new Stalprofil("L180x90x12,0", 0.540000021457672), new Stalprofil("L180x90x14,0", 0.540000021457672), new Stalprofil("L200x100x12,0", 0.600000023841857), new Stalprofil("L200x100x14,0", 0.600000023841857), new Stalprofil("L200x100x16,0", 0.600000023841857), new Stalprofil("L200x200x16,0", 0.80000001192092), new Stalprofil("L200x200x18,0", 0.80000001192092), new Stalprofil("L20x20x3,0", 0.0799999982118606), new Stalprofil("L20x20x4,0", 0.0799999982118606), new Stalprofil("L25x25x3,0", 0.1000000014901161), new Stalprofil("L25x25x4,0", 0.1000000014901161), new Stalprofil("L25x25x5,0", 0.1000000014901161), new Stalprofil("L30x20x3,0", 0.1000000014901161), new Stalprofil("L30x20x4,0", 0.1000000014901161), new Stalprofil("L30x30x3,0", 0.1199999973177909), new Stalprofil("L30x30x4,0", 0.1199999973177909), new Stalprofil("L30x30x5,0", 0.1199999973177909), new Stalprofil("L30x30x6,0", 0.1199999973177909), new Stalprofil("L35x35x3,0", 0.1400000005960464), new Stalprofil("L35x35x4,0", 0.1400000005960464), new Stalprofil("L35x35x5,0", 0.1400000005960464), new Stalprofil("L35x35x6,0", 0.1400000005960464), new Stalprofil("L40x20x3,0", 0.1199999973177909), new Stalprofil("L40x20x4,0", 0.1199999973177909), new Stalprofil("L40x40x3,0", 0.159999996423721), new Stalprofil("L40x40x4,0", 0.159999996423721), new Stalprofil("L40x40x5,0", 0.159999996423721), new Stalprofil("L40x40x6,0", 0.159999996423721), new Stalprofil("L40x40x8,0", 0.159999996423721), new Stalprofil("L45x30x3,0", 0.1500000059604644), new Stalprofil("L45x30x4,0", 0.1500000059604644), new Stalprofil("L45x45x5,0", 0.1800000071525573), new Stalprofil("L45x45x6,0", 0.1800000071525573), new Stalprofil("L45x45x7,0", 0.1800000071525573), new Stalprofil("L45x45x8,0", 0.1800000071525573), new Stalprofil("L50x30x5,0", 0.159999996423721), new Stalprofil("L50x50x3,0", 0.2000000029802322), new Stalprofil("L50x50x4,0", 0.2000000029802322), new Stalprofil("L50x50x5,0", 0.2000000029802322), new Stalprofil("L50x50x6,0", 0.2000000029802322), new Stalprofil("L50x50x7,0", 0.2000000029802322), new Stalprofil("L50x50x8,0", 0.2000000029802322), new Stalprofil("L50x50x9,0", 0.2000000029802322), new Stalprofil("L55x55x10,0", 0.219999998807907), new Stalprofil("L55x55x6,0", 0.219999998807907), new Stalprofil("L60x30x5,0", 0.1800000071525573), new Stalprofil("L60x30x7,0", 0.1800000071525573), new Stalprofil("L60x40x5,0", 0.2000000029802322), new Stalprofil("L60x40x7,0", 0.2000000029802322), new Stalprofil("L60x60x10,0", 0.2399999946355819), new Stalprofil("L60x60x6,0", 0.2399999946355819), new Stalprofil("L60x60x8,0", 0.2399999946355819), new Stalprofil("L65x50x5,0", 0.2300000041723251), new Stalprofil("L65x50x6,0", 0.2300000041723251), new Stalprofil("L65x50x7,0", 0.2300000041723251), new Stalprofil("L65x65x7,0", 0.2599999904632568), new Stalprofil("L65x65x9,0", 0.2599999904632568), new Stalprofil("L70x70x7,0", 0.280000001192092), new Stalprofil("L70x70x9,0", 0.280000001192092), new Stalprofil("L75x50x5,0", 0.2), new Stalprofil("L75x50x6,0", 0.2), new Stalprofil("L75x50x7,0", 0.2), new Stalprofil("L75x50x9,0", 0.2), new Stalprofil("L75x55x7,0", 0.2599999904632568), new Stalprofil("L75x55x9,0", 0.2599999904632568), new Stalprofil("L75x75x10,0", 0.3000000119209289), new Stalprofil("L75x75x12,0", 0.3000000119209289), new Stalprofil("L75x75x6,0", 0.3000000119209289), new Stalprofil("L75x75x7,0", 0.3000000119209289), new Stalprofil("L75x75x8,0", 0.3000000119209289), new Stalprofil("L80x40x6,0", 0.2399999946355819), new Stalprofil("L80x40x8,0", 0.2399999946355819), new Stalprofil("L80x80x10,0", 0.319999992847442), new Stalprofil("L80x80x12,0", 0.319999992847442), new Stalprofil("L80x80x8,0", 0.319999992847442), new Stalprofil("L90x60x8,0", 0.3000000119209289), new Stalprofil("L90x75x10,0", 0.3300000131130218), new Stalprofil("L90x75x8,0", 0.3300000131130218), new Stalprofil("L90x90x11,0", 0.3600000143051147), new Stalprofil("L90x90x9,0", 0.3600000143051147));
            }
            case PLATTST\u00c5NG: {
                return Arrays.asList(new Stalprofil("Plattst\u00e5ng 20x2", 0.0399999991059303), new Stalprofil("Plattst\u00e5ng 40x2", 0.0799999982118606), new Stalprofil("Plattst\u00e5ng 12x3", 0.02999999932944774), new Stalprofil("Plattst\u00e5ng 15x3", 0.02999999932944774), new Stalprofil("Plattst\u00e5ng 18x3", 0.0399999991059303), new Stalprofil("Plattst\u00e5ng 20x3", 0.0399999991059303), new Stalprofil("Plattst\u00e5ng 25x3", 0.050000000745058), new Stalprofil("Plattst\u00e5ng 30x3", 0.0599999986588954), new Stalprofil("Plattst\u00e5ng 35x3", 0.0700000002980232), new Stalprofil("Plattst\u00e5ng 40x3", 0.0799999982118606), new Stalprofil("Plattst\u00e5ng 50x3", 0.1000000014901161), new Stalprofil("Plattst\u00e5ng 60x3", 0.1199999973177909), new Stalprofil("Plattst\u00e5ng 70x3", 0.1400000005960464), new Stalprofil("Plattst\u00e5ng 75x3", 0.1500000059604644), new Stalprofil("Plattst\u00e5ng 80x3", 0.159999996423721), new Stalprofil("Plattst\u00e5ng 100x3", 0.2000000029802322), new Stalprofil("Plattst\u00e5ng 120x3", 0.2399999946355819), new Stalprofil("Plattst\u00e5ng 150x3", 0.3000000119209289), new Stalprofil("Plattst\u00e5ng 15x4", 0.02999999932944774), new Stalprofil("Plattst\u00e5ng 18x4", 0.0399999991059303), new Stalprofil("Plattst\u00e5ng 20x4", 0.0399999991059303), new Stalprofil("Plattst\u00e5ng 25x4", 0.050000000745058), new Stalprofil("Plattst\u00e5ng 30x4", 0.0599999986588954), new Stalprofil("Plattst\u00e5ng 35x4", 0.0700000002980232), new Stalprofil("Plattst\u00e5ng 40x4", 0.0799999982118606), new Stalprofil("Plattst\u00e5ng 50x4", 0.1000000014901161), new Stalprofil("Plattst\u00e5ng 60x4", 0.1199999973177909), new Stalprofil("Plattst\u00e5ng 70x4", 0.1400000005960464), new Stalprofil("Plattst\u00e5ng 80x4", 0.159999996423721), new Stalprofil("Plattst\u00e5ng 150x4", 0.3000000119209289), new Stalprofil("Plattst\u00e5ng 12x5", 0.02999999932944774), new Stalprofil("Plattst\u00e5ng 15x5", 0.0399999991059303), new Stalprofil("Plattst\u00e5ng 18x5", 0.0399999991059303), new Stalprofil("Plattst\u00e5ng 20x5", 0.050000000745058), new Stalprofil("Plattst\u00e5ng 25x5", 0.0599999986588954), new Stalprofil("Plattst\u00e5ng 30x5", 0.0700000002980232), new Stalprofil("Plattst\u00e5ng 35x5", 0.0799999982118606), new Stalprofil("Plattst\u00e5ng 40x5", 0.0900000035762786), new Stalprofil("Plattst\u00e5ng 45x5", 0.1000000014901161), new Stalprofil("Plattst\u00e5ng 50x5", 0.1099999994039535), new Stalprofil("Plattst\u00e5ng 60x5", 0.1299999952316284), new Stalprofil("Plattst\u00e5ng 65x5", 0.1400000005960464), new Stalprofil("Plattst\u00e5ng 70x5", 0.1500000059604644), new Stalprofil("Plattst\u00e5ng 75x5", 0.159999996423721), new Stalprofil("Plattst\u00e5ng 80x5", 0.1700000017881393), new Stalprofil("Plattst\u00e5ng 90x5", 0.189999997615814), new Stalprofil("Plattst\u00e5ng 100x5", 0.209999993443489), new Stalprofil("Plattst\u00e5ng 110x5", 0.2300000041723251), new Stalprofil("Plattst\u00e5ng 120x5", 0.2), new Stalprofil("Plattst\u00e5ng 130x5", 0.270000010728836), new Stalprofil("Plattst\u00e5ng 150x5", 0.310000002384185), new Stalprofil("Plattst\u00e5ng 12x6", 0.02999999932944774), new Stalprofil("Plattst\u00e5ng 15x6", 0.0399999991059303), new Stalprofil("Plattst\u00e5ng 20x6", 0.050000000745058), new Stalprofil("Plattst\u00e5ng 25x6", 0.0599999986588954), new Stalprofil("Plattst\u00e5ng 30x6", 0.0700000002980232), new Stalprofil("Plattst\u00e5ng 35x6", 0.0799999982118606), new Stalprofil("Plattst\u00e5ng 40x6", 0.0900000035762786), new Stalprofil("Plattst\u00e5ng 45x6", 0.1000000014901161), new Stalprofil("Plattst\u00e5ng 50x6", 0.1099999994039535), new Stalprofil("Plattst\u00e5ng 55x6", 0.1199999973177909), new Stalprofil("Plattst\u00e5ng 60x6", 0.1299999952316284), new Stalprofil("Plattst\u00e5ng 65x6", 0.1400000005960464), new Stalprofil("Plattst\u00e5ng 70x6", 0.1500000059604644), new Stalprofil("Plattst\u00e5ng 75x6", 0.159999996423721), new Stalprofil("Plattst\u00e5ng 80x6", 0.1700000017881393), new Stalprofil("Plattst\u00e5ng 90x6", 0.189999997615814), new Stalprofil("Plattst\u00e5ng 100x6", 0.209999993443489), new Stalprofil("Plattst\u00e5ng 110x6", 0.2300000041723251), new Stalprofil("Plattst\u00e5ng 120x6", 0.2), new Stalprofil("Plattst\u00e5ng 130x6", 0.270000010728836), new Stalprofil("Plattst\u00e5ng 140x6", 0.2899999916553497), new Stalprofil("Plattst\u00e5ng 150x6", 0.310000002384185), new Stalprofil("Plattst\u00e5ng 215x6", 0.439999997615814), new Stalprofil("Plattst\u00e5ng 20x8", 0.050000000745058), new Stalprofil("Plattst\u00e5ng 25x8", 0.0599999986588954), new Stalprofil("Plattst\u00e5ng 30x8", 0.0700000002980232), new Stalprofil("Plattst\u00e5ng 35x8", 0.0799999982118606), new Stalprofil("Plattst\u00e5ng 40x8", 0.0900000035762786), new Stalprofil("Plattst\u00e5ng 45x8", 0.1000000014901161), new Stalprofil("Plattst\u00e5ng 50x8", 0.1099999994039535), new Stalprofil("Plattst\u00e5ng 55x8", 0.1199999973177909), new Stalprofil("Plattst\u00e5ng 60x8", 0.1299999952316284), new Stalprofil("Plattst\u00e5ng 65x8", 0.1400000005960464), new Stalprofil("Plattst\u00e5ng 70x8", 0.1500000059604644), new Stalprofil("Plattst\u00e5ng 75x8", 0.159999996423721), new Stalprofil("Plattst\u00e5ng 80x8", 0.1700000017881393), new Stalprofil("Plattst\u00e5ng 90x8", 0.189999997615814), new Stalprofil("Plattst\u00e5ng 100x8", 0.209999993443489), new Stalprofil("Plattst\u00e5ng 110x8", 0.2300000041723251), new Stalprofil("Plattst\u00e5ng 120x8", 0.2), new Stalprofil("Plattst\u00e5ng 130x8", 0.270000010728836), new Stalprofil("Plattst\u00e5ng 140x8", 0.2899999916553497), new Stalprofil("Plattst\u00e5ng 150x8", 0.310000002384185), new Stalprofil("Plattst\u00e5ng 15x10", 0.050000000745058), new Stalprofil("Plattst\u00e5ng 18x10", 0.050000000745058), new Stalprofil("Plattst\u00e5ng 20x10", 0.0599999986588954), new Stalprofil("Plattst\u00e5ng 25x10", 0.0700000002980232), new Stalprofil("Plattst\u00e5ng 30x10", 0.0799999982118606), new Stalprofil("Plattst\u00e5ng 35x10", 0.0900000035762786), new Stalprofil("Plattst\u00e5ng 40x10", 0.1000000014901161), new Stalprofil("Plattst\u00e5ng 45x10", 0.1099999994039535), new Stalprofil("Plattst\u00e5ng 50x10", 0.1199999973177909), new Stalprofil("Plattst\u00e5ng 55x10", 0.1299999952316284), new Stalprofil("Plattst\u00e5ng 60x10", 0.1400000005960464), new Stalprofil("Plattst\u00e5ng 65x10", 0.1500000059604644), new Stalprofil("Plattst\u00e5ng 70x10", 0.159999996423721), new Stalprofil("Plattst\u00e5ng 75x10", 0.1700000017881393), new Stalprofil("Plattst\u00e5ng 80x10", 0.1800000071525573), new Stalprofil("Plattst\u00e5ng 90x10", 0.2000000029802322), new Stalprofil("Plattst\u00e5ng 100x10", 0.219999998807907), new Stalprofil("Plattst\u00e5ng 110x10", 0.2399999946355819), new Stalprofil("Plattst\u00e5ng  120x10", 0.2599999904632568), new Stalprofil("Plattst\u00e5ng 130x10", 0.280000001192092), new Stalprofil("Plattst\u00e5ng 140x10", 0.3000000119209289), new Stalprofil("Plattst\u00e5ng 20x12", 0.0599999986588954), new Stalprofil("Plattst\u00e5ng 25x12", 0.0700000002980232), new Stalprofil("Plattst\u00e5ng 30x12", 0.0799999982118606), new Stalprofil("Plattst\u00e5ng 35x12", 0.0900000035762786), new Stalprofil("Plattst\u00e5ng 40x12", 0.1000000014901161), new Stalprofil("Plattst\u00e5ng 45x12", 0.1099999994039535), new Stalprofil("Plattst\u00e5ng 50x12", 0.1199999973177909), new Stalprofil("Plattst\u00e5ng 60x12", 0.1400000005960464), new Stalprofil("Plattst\u00e5ng 70x12", 0.159999996423721), new Stalprofil("Plattst\u00e5ng 75x12", 0.1700000017881393), new Stalprofil("Plattst\u00e5ng 80x12", 0.1800000071525573), new Stalprofil("Plattst\u00e5ng 90x12", 0.2000000029802322), new Stalprofil("Plattst\u00e5ng 100x12", 0.219999998807907), new Stalprofil("Plattst\u00e5ng 110x12", 0.2399999946355819), new Stalprofil("Plattst\u00e5ng 120x12", 0.2599999904632568), new Stalprofil("Plattst\u00e5ng 130x12", 0.280000001192092), new Stalprofil("Plattst\u00e5ng 140x12", 0.3000000119209289), new Stalprofil("Plattst\u00e5ng 150x12", 0.319999992847442), new Stalprofil("Plattst\u00e5ng 20x15", 0.0700000002980232), new Stalprofil("Plattst\u00e5ng 25x15", 0.0799999982118606), new Stalprofil("Plattst\u00e5ng 30x15", 0.0900000035762786), new Stalprofil("Plattst\u00e5ng 35x15", 0.1000000014901161), new Stalprofil("Plattst\u00e5ng 40x15", 0.1099999994039535), new Stalprofil("Plattst\u00e5ng 45x15", 0.1199999973177909), new Stalprofil("Plattst\u00e5ng 50x15", 0.1299999952316284), new Stalprofil("Plattst\u00e5ng 60x15", 0.1500000059604644), new Stalprofil("Plattst\u00e5ng 70x15", 0.1700000017881393), new Stalprofil("Plattst\u00e5ng 75x15", 0.1800000071525573), new Stalprofil("Plattst\u00e5ng 80x15", 0.189999997615814), new Stalprofil("Plattst\u00e5ng 90x15", 0.209999993443489), new Stalprofil("Plattst\u00e5ng 100x15", 0.2300000041723251), new Stalprofil("Plattst\u00e5ng 110x15", 0.2), new Stalprofil("Plattst\u00e5ng 120x15", 0.270000010728836), new Stalprofil("Plattst\u00e5ng 130x15", 0.2899999916553497), new Stalprofil("Plattst\u00e5ng 140x15", 0.310000002384185), new Stalprofil("Plattst\u00e5ng 150x15", 0.3300000131130218), new Stalprofil("Plattst\u00e5ng 25x20", 0.0900000035762786), new Stalprofil("Plattst\u00e5ng 30x20", 0.1000000014901161), new Stalprofil("Plattst\u00e5ng 35x20", 0.1099999994039535), new Stalprofil("Plattst\u00e5ng 40x20", 0.1199999973177909), new Stalprofil("Plattst\u00e5ng 50x20", 0.1400000005960464), new Stalprofil("Plattst\u00e5ng 60c20", 0.159999996423721), new Stalprofil("Plattst\u00e5ng 70x20", 0.1800000071525573), new Stalprofil("Plattst\u00e5ng 75 20", 0.189999997615814), new Stalprofil("Plattst\u00e5ng 80x20", 0.2000000029802322), new Stalprofil("Plattst\u00e5ng 90x20", 0.219999998807907), new Stalprofil("Plattst\u00e5ng 100x20", 0.2399999946355819), new Stalprofil("Plattst\u00e5ng 110x20", 0.2599999904632568), new Stalprofil("Plattst\u00e5ng 120x20", 0.280000001192092), new Stalprofil("Plattst\u00e5ng 130x20", 0.3000000119209289), new Stalprofil("Plattst\u00e5ng 140x20", 0.319999992847442), new Stalprofil("Plattst\u00e5ng 150x20", 0.340000003576278), new Stalprofil("Plattst\u00e5ng 35x25", 0.1199999973177909), new Stalprofil("Plattst\u00e5ng 40x25", 0.1299999952316284), new Stalprofil("Plattst\u00e5ng 45x25", 0.1400000005960464), new Stalprofil("Plattst\u00e5ng 50x25", 0.1500000059604644), new Stalprofil("Plattst\u00e5ng 60x25", 0.1700000017881393), new Stalprofil("Plattst\u00e5ng 70x25", 0.189999997615814), new Stalprofil("Plattst\u00e5ng 75x25", 0.2000000029802322), new Stalprofil("Plattst\u00e5ng 80x25", 0.209999993443489), new Stalprofil("Plattst\u00e5ng 90x25", 0.2300000041723251), new Stalprofil("Plattst\u00e5ng 100x25", 0.2), new Stalprofil("Plattst\u00e5ng 120x25", 0.2899999916553497), new Stalprofil("Plattst\u00e5ng 130x25", 0.310000002384185), new Stalprofil("Plattst\u00e5ng 140x25", 0.3300000131130218), new Stalprofil("Plattst\u00e5ng 150x25", 0.349999994039535), new Stalprofil("Plattst\u00e5ng 40x30", 0.1400000005960464), new Stalprofil("Plattst\u00e5ng 50x30", 0.159999996423721), new Stalprofil("Plattst\u00e5ng 55x30", 0.1700000017881393), new Stalprofil("Plattst\u00e5ng 60x30", 0.1800000071525573), new Stalprofil("Plattst\u00e5ng 70x30", 0.2000000029802322), new Stalprofil("Plattst\u00e5ng 80x30", 0.219999998807907), new Stalprofil("Plattst\u00e5ng 90x30", 0.2399999946355819), new Stalprofil("Plattst\u00e5ng 100x30", 0.2599999904632568), new Stalprofil("Plattst\u00e5ng 120x30", 0.3000000119209289), new Stalprofil("Plattst\u00e5ng 130x30", 0.319999992847442), new Stalprofil("Plattst\u00e5ng 150x30", 0.3600000143051147), new Stalprofil("Plattst\u00e5ng 50x35", 0.1700000017881393), new Stalprofil("Plattst\u00e5ng 100x35", 0.270000010728836), new Stalprofil("Plattst\u00e5ng 50x40", 0.1800000071525573), new Stalprofil("Plattst\u00e5ng 60x40", 0.2000000029802322), new Stalprofil("Plattst\u00e5ng 70x40", 0.219999998807907), new Stalprofil("Plattst\u00e5ng 80x70", 0.2399999946355819), new Stalprofil("Plattst\u00e5ng 100x70", 0.280000001192092), new Stalprofil("Plattst\u00e5ng 120x70", 0.319999992847442), new Stalprofil("Plattst\u00e5ng 130x70", 0.340000003576278), new Stalprofil("Plattst\u00e5ng 150x70", 0.379999995231628), new Stalprofil("Plattst\u00e5ng 60x50", 0.219999998807907), new Stalprofil("Plattst\u00e5ng 70x60", 0.2399999946355819), new Stalprofil("Plattst\u00e5ng 75x50", 0.2), new Stalprofil("Plattst\u00e5ng 80x50", 0.2599999904632568), new Stalprofil("Plattst\u00e5ng 100x50", 0.3000000119209289), new Stalprofil("Plattst\u00e5ng 120x50", 0.340000003576278), new Stalprofil("Plattst\u00e5ng 130x50", 0.3600000143051147), new Stalprofil("Plattst\u00e5ng 150x50", 0.400000005960464), new Stalprofil("Plattst\u00e5ng 100x60", 0.319999992847442), new Stalprofil("Plattst\u00e5ng 120x60", 0.3600000143051147));
            }
            case RHS_H\u00c5LPROFILER: {
                return Arrays.asList(new Stalprofil("RHS102x102x4,0", 0.400000005960464), new Stalprofil("RHS102x102x4,0/3", 0.3000000119209289), new Stalprofil("RHS102x102x4,9", 0.400000005960464), new Stalprofil("RHS102x102x4,9/3", 0.3000000119209289), new Stalprofil("RHS102x102x6,3", 0.400000005960464), new Stalprofil("RHS102x102x6,3/3", 0.3000000119209289), new Stalprofil("RHS102x102x9,5", 0.400000005960464), new Stalprofil("RHS102x102x9,5/3", 0.3000000119209289), new Stalprofil("RHS102x51x3,2", 0.3000000119209289), new Stalprofil("RHS102x51x3,2/3", 0.2), new Stalprofil("RHS102x51x4,0", 0.3000000119209289), new Stalprofil("RHS102x51x4,0/3", 0.2), new Stalprofil("RHS102x51x4,9", 0.3000000119209289), new Stalprofil("RHS102x51x4,9/3", 0.2), new Stalprofil("RHS102x51x6,3", 0.3000000119209289), new Stalprofil("RHS102x51x6,3/3", 0.2), new Stalprofil("RHS102x76x3,6", 0.349999994039535), new Stalprofil("RHS102x76x3,6/3", 0.280000001192092), new Stalprofil("RHS102x76x4,9", 0.349999994039535), new Stalprofil("RHS102x76x4,9/3", 0.280000001192092), new Stalprofil("RHS102x76x6,3", 0.349999994039535), new Stalprofil("RHS102x76x6,3/3", 0.280000001192092), new Stalprofil("RHS114x114x4,9", 0.449999988079071), new Stalprofil("RHS114x114x4,9/3", 0.340000003576278), new Stalprofil("RHS114x114x6,3", 0.449999988079071), new Stalprofil("RHS114x114x6,3/3", 0.340000003576278), new Stalprofil("RHS114x114x9,5", 0.449999988079071), new Stalprofil("RHS114x114x9,5/3", 0.340000003576278), new Stalprofil("RHS127x127x4,9", 0.0), new Stalprofil("RHS127x127x4,9/3", 0.379999995231628), new Stalprofil("RHS127x127x6,3", 0.0), new Stalprofil("RHS127x127x6,3/3", 0.379999995231628), new Stalprofil("RHS127x127x9,5", 0.0), new Stalprofil("RHS127x127x9,5/3", 0.379999995231628), new Stalprofil("RHS127x51x3,6", 0.349999994039535), new Stalprofil("RHS127x51x3,6/3", 0.3000000119209289), new Stalprofil("RHS127x51x4,9", 0.349999994039535), new Stalprofil("RHS127x51x4,9/3", 0.3000000119209289), new Stalprofil("RHS127x51x6,3", 0.349999994039535), new Stalprofil("RHS127x51x6,3/3", 0.3000000119209289), new Stalprofil("RHS127x64x4,0", 0.379999995231628), new Stalprofil("RHS127x64x4,0/3", 0.310000002384185), new Stalprofil("RHS127x64x4,9", 0.379999995231628), new Stalprofil("RHS127x64x4,9/3", 0.310000002384185), new Stalprofil("RHS127x64x6,3", 0.379999995231628), new Stalprofil("RHS127x64x6,3/3", 0.310000002384185), new Stalprofil("RHS127x76x4,9", 0.400000005960464), new Stalprofil("RHS127x76x4,9/3", 0.3300000131130218), new Stalprofil("RHS127x76x6,3", 0.400000005960464), new Stalprofil("RHS127x76x6,3/3", 0.3300000131130218), new Stalprofil("RHS127x76x9,5", 0.400000005960464), new Stalprofil("RHS127x76x9,5/3", 0.3300000131130218), new Stalprofil("RHS13x13x1,8", 0.050000000745058), new Stalprofil("RHS13x13x1,8/3", 0.02999999932944774), new Stalprofil("RHS152x102x4,9", 0.0), new Stalprofil("RHS152x102x4,9/3", 0.400000005960464), new Stalprofil("RHS152x102x6,3", 0.0), new Stalprofil("RHS152x102x6,3/3", 0.400000005960464), new Stalprofil("RHS152x102x9,5", 0.0), new Stalprofil("RHS152x102x9,5/3", 0.400000005960464), new Stalprofil("RHS152x152x4,9", 0.600000023841857), new Stalprofil("RHS152x152x4,9/3", 0.449999988079071), new Stalprofil("RHS152x152x6,3", 0.600000023841857), new Stalprofil("RHS152x152x6,3/3", 0.449999988079071), new Stalprofil("RHS152x152x9,5", 0.600000023841857), new Stalprofil("RHS152x152x9,5/3", 0.449999988079071), new Stalprofil("RHS152x76x4,9", 0.449999988079071), new Stalprofil("RHS152x76x4,9/3", 0.379999995231628), new Stalprofil("RHS152x76x6,3", 0.449999988079071), new Stalprofil("RHS152x76x6,3/3", 0.379999995231628), new Stalprofil("RHS152x76x9,5", 0.449999988079071), new Stalprofil("RHS152x76x9,5/3", 0.379999995231628), new Stalprofil("RHS16x16x1,8", 0.0599999986588954), new Stalprofil("RHS16x16x1,8/3", 0.0399999991059303), new Stalprofil("RHS178x178x5,9", 0.709999978542327), new Stalprofil("RHS178x178x5,9/3", 0.52999997138977), new Stalprofil("RHS178x178x6,3", 0.709999978542327), new Stalprofil("RHS178x178x6,3/3", 0.52999997138977), new Stalprofil("RHS178x178x7,1", 0.709999978542327), new Stalprofil("RHS178x178x7,1/3", 0.52999997138977), new Stalprofil("RHS178x178x9,5", 0.709999978542327), new Stalprofil("RHS178x178x9,5/3", 0.52999997138977), new Stalprofil("RHS19x19x2,0", 0.0700000002980232), new Stalprofil("RHS19x19x2,0/3", 0.050000000745058), new Stalprofil("RHS203x102x4,9", 0.610000014305114), new Stalprofil("RHS203x102x4,9/3", 0.0), new Stalprofil("RHS203x102x6,3", 0.610000014305114), new Stalprofil("RHS203x102x6,3/3", 0.0), new Stalprofil("RHS203x102x9,5", 0.610000014305114), new Stalprofil("RHS203x102x9,5/3", 0.0), new Stalprofil("RHS203x152x5,9", 0.709999978542327), new Stalprofil("RHS203x152x5,9/3", 0.55000001192092), new Stalprofil("RHS203x152x6,3", 0.709999978542327), new Stalprofil("RHS203x152x6,3/3", 0.55000001192092), new Stalprofil("RHS203x152x7,1", 0.709999978542327), new Stalprofil("RHS203x152x7,1/3", 0.55000001192092), new Stalprofil("RHS203x152x9,5", 0.709999978542327), new Stalprofil("RHS203x152x9,5/3", 0.55000001192092), new Stalprofil("RHS203x203x5,9", 0.810000002384185), new Stalprofil("RHS203x203x5,9/3", 0.600000023841857), new Stalprofil("RHS203x203x6,3", 0.810000002384185), new Stalprofil("RHS203x203x6,3/3", 0.600000023841857), new Stalprofil("RHS203x203x7,1", 0.810000002384185), new Stalprofil("RHS203x203x7,1/3", 0.600000023841857), new Stalprofil("RHS203x203x9,5", 0.810000002384185), new Stalprofil("RHS203x203x9,5/3", 0.600000023841857), new Stalprofil("RHS254x152x5,9", 0.810000002384185), new Stalprofil("RHS254x152x5,9/3", 0.660000026226043), new Stalprofil("RHS254x152x6,3", 0.810000002384185), new Stalprofil("RHS254x152x6,3/3", 0.660000026226043), new Stalprofil("RHS254x152x7,1", 0.810000002384185), new Stalprofil("RHS254x152x7,1/3", 0.660000026226043), new Stalprofil("RHS254x152x9,5", 0.810000002384185), new Stalprofil("RHS254x152x9,5/3", 0.660000026226043), new Stalprofil("RHS254x254x12,5", 1.009999990463256), new Stalprofil("RHS254x254x12,5/3", 0.759999990463256), new Stalprofil("RHS254x254x6,3", 1.009999990463256), new Stalprofil("RHS254x254x6,3/3", 0.759999990463256), new Stalprofil("RHS254x254x9,5", 1.009999990463256), new Stalprofil("RHS254x254x9,5/3", 0.759999990463256), new Stalprofil("RHS25x25x2,0", 0.1000000014901161), new Stalprofil("RHS25x25x2,0/3", 0.0700000002980232), new Stalprofil("RHS25x25x2,6", 0.1000000014901161), new Stalprofil("RHS25x25x2,6/3", 0.0700000002980232), new Stalprofil("RHS25x25x3,2", 0.1000000014901161), new Stalprofil("RHS25x25x3,2/3", 0.0700000002980232), new Stalprofil("RHS305x203x12,5", 1.009999990463256), new Stalprofil("RHS305x203x12,5/3", 0.810000002384185), new Stalprofil("RHS305x203x6,3", 1.009999990463256), new Stalprofil("RHS305x203x6,3/3", 0.810000002384185), new Stalprofil("RHS305x203x9,5", 1.009999990463256), new Stalprofil("RHS305x203x9,5/3", 0.810000002384185), new Stalprofil("RHS305x305x12,5", 1.220000028610229), new Stalprofil("RHS305x305x12,5/3", 0.910000026226043), new Stalprofil("RHS305x305x16,0", 1.220000028610229), new Stalprofil("RHS305x305x16,0/3", 0.910000026226043), new Stalprofil("RHS305x305x9,5", 1.220000028610229), new Stalprofil("RHS305x305x9,5/3", 0.910000026226043), new Stalprofil("RHS356x356x12,5", 1.419999957084655), new Stalprofil("RHS356x356x12,5/3", 1.05999994277954), new Stalprofil("RHS356x356x16,0", 1.419999957084655), new Stalprofil("RHS356x356x16,0/3", 1.05999994277954), new Stalprofil("RHS356x356x9,5", 1.419999957084655), new Stalprofil("RHS356x356x9,5/3", 1.05999994277954), new Stalprofil("RHS38x38x2,6", 0.1500000059604644), new Stalprofil("RHS38x38x2,6/3", 0.1099999994039535), new Stalprofil("RHS38x38x3,2", 0.1500000059604644), new Stalprofil("RHS38x38x3,2/3", 0.1099999994039535), new Stalprofil("RHS38x38x4,0", 0.1500000059604644), new Stalprofil("RHS38x38x4,0/3", 0.1099999994039535), new Stalprofil("RHS406x203x12,5", 1.210000038146972), new Stalprofil("RHS406x203x12,5/3", 1.009999990463256), new Stalprofil("RHS406x203x16,0", 1.210000038146972), new Stalprofil("RHS406x203x16,0/3", 1.009999990463256), new Stalprofil("RHS406x203x9,5", 1.210000038146972), new Stalprofil("RHS406x203x9,5/3", 1.009999990463256), new Stalprofil("RHS457x254x12,5", 1.419999957084655), new Stalprofil("RHS457x254x12,5/3", 1.15999996662139), new Stalprofil("RHS457x254x16,0", 1.419999957084655), new Stalprofil("RHS457x254x16,0/3", 1.15999996662139), new Stalprofil("RHS457x254x9,5", 1.419999957084655), new Stalprofil("RHS457x254x9,5/3", 1.15999996662139), new Stalprofil("RHS51x25x2,6", 0.1500000059604644), new Stalprofil("RHS51x25x2,6/3", 0.1199999973177909), new Stalprofil("RHS51x25x3,2", 0.1500000059604644), new Stalprofil("RHS51x25x3,2/3", 0.1199999973177909), new Stalprofil("RHS51x51x3,2", 0.2000000029802322), new Stalprofil("RHS51x51x3,2/3", 0.1500000059604644), new Stalprofil("RHS51x51x4,0", 0.2000000029802322), new Stalprofil("RHS51x51x4,0/3", 0.1500000059604644), new Stalprofil("RHS51x51x4,9", 0.2000000029802322), new Stalprofil("RHS51x51x4,9/3", 0.1500000059604644), new Stalprofil("RHS64x38x3,2", 0.2000000029802322), new Stalprofil("RHS64x38x3,2/3", 0.159999996423721), new Stalprofil("RHS64x38x4,0", 0.2000000029802322), new Stalprofil("RHS64x38x4,0/3", 0.159999996423721), new Stalprofil("RHS64x64x3,2", 0.2), new Stalprofil("RHS64x64x3,2/3", 0.189999997615814), new Stalprofil("RHS64x64x4,0", 0.2), new Stalprofil("RHS64x64x4,0/3", 0.189999997615814), new Stalprofil("RHS64x64x4,9", 0.2), new Stalprofil("RHS64x64x4,9/3", 0.189999997615814), new Stalprofil("RHS76x38x3,2", 0.219999998807907), new Stalprofil("RHS76x38x3,2/3", 0.189999997615814), new Stalprofil("RHS76x38x4,0", 0.219999998807907), new Stalprofil("RHS76x38x4,0/3", 0.189999997615814), new Stalprofil("RHS76x51x3,2", 0.2), new Stalprofil("RHS76x51x3,2/3", 0.2000000029802322), new Stalprofil("RHS76x51x4,0", 0.2), new Stalprofil("RHS76x51x4,0/3", 0.2000000029802322), new Stalprofil("RHS76x51x4,9", 0.2), new Stalprofil("RHS76x51x4,9/3", 0.2000000029802322), new Stalprofil("RHS76x51x6,3", 0.2), new Stalprofil("RHS76x51x6,3/3", 0.2000000029802322), new Stalprofil("RHS76x76x3,2", 0.3000000119209289), new Stalprofil("RHS76x76x3,2/3", 0.219999998807907), new Stalprofil("RHS76x76x4,0", 0.3000000119209289), new Stalprofil("RHS76x76x4,0/3", 0.219999998807907), new Stalprofil("RHS76x76x4,9", 0.3000000119209289), new Stalprofil("RHS76x76x4,9/3", 0.219999998807907), new Stalprofil("RHS76x76x6,3", 0.3000000119209289), new Stalprofil("RHS76x76x6,3/3", 0.219999998807907), new Stalprofil("RHS90x38x3,2", 0.2), new Stalprofil("RHS90x38x3,2/3", 0.209999993443489), new Stalprofil("RHS90x38x4,0", 0.2), new Stalprofil("RHS90x38x4,0/3", 0.209999993443489), new Stalprofil("RHS90x90x3,6", 0.3600000143051147), new Stalprofil("RHS90x90x3,6/3", 0.270000010728836), new Stalprofil("RHS90x90x4,9", 0.3600000143051147), new Stalprofil("RHS90x90x4,9/3", 0.270000010728836), new Stalprofil("RHS90x90x6,3", 0.3600000143051147), new Stalprofil("RHS90x90x6,3/3", 0.270000010728836));
            }
            case RUNDST\u00c5NG: {
                return Arrays.asList(new Stalprofil("Rund-\u00d8 6", 0.00999999977648258), new Stalprofil("Rund-\u00d8 8", 0.01999999955296516), new Stalprofil("Rund-\u00d8 9,5", 0.02999999932944774), new Stalprofil("Rund-\u00d8 10", 0.02999999932944774), new Stalprofil("Rund-\u00d8 11", 0.02999999932944774), new Stalprofil("Rund-\u00d8 12", 0.02999999932944774), new Stalprofil("Rund-\u00d8 12,7", 0.0399999991059303), new Stalprofil("Rund-\u00d8 14", 0.0399999991059303), new Stalprofil("Rund-\u00d8 15", 0.0399999991059303), new Stalprofil("Rund-\u00d8 16", 0.050000000745058), new Stalprofil("Rund-\u00d8 18", 0.050000000745058), new Stalprofil("Rund-\u00d8 19", 0.0599999986588954), new Stalprofil("Rund-\u00d8 20", 0.0599999986588954), new Stalprofil("Rund-\u00d8 20,8S", 0.0599999986588954), new Stalprofil("Rund-\u00d8 22", 0.0599999986588954), new Stalprofil("Rund-\u00d8 22,8S", 0.0700000002980232), new Stalprofil("Rund-\u00d8 24", 0.0700000002980232), new Stalprofil("Rund-\u00d8 25", 0.0700000002980232), new Stalprofil("Rund-\u00d8 25,8S", 0.0799999982118606), new Stalprofil("Rund-\u00d8 28", 0.0799999982118606), new Stalprofil("Rund-\u00d8 30", 0.0900000035762786), new Stalprofil("Rund-\u00d8 30,8S", 0.0900000035762786), new Stalprofil("Rund-\u00d8 32", 0.1000000014901161), new Stalprofil("Rund-\u00d8 35", 0.1099999994039535), new Stalprofil("Rund-\u00d8 36,0S", 0.1099999994039535), new Stalprofil("Rund-\u00d8 38", 0.1099999994039535), new Stalprofil("Rund-\u00d8 40", 0.1199999973177909), new Stalprofil("Rund-\u00d8 41,0S", 0.1199999973177909), new Stalprofil("Rund-\u00d8 42", 0.1299999952316284), new Stalprofil("Rund-\u00d8 45", 0.1400000005960464), new Stalprofil("Rund-\u00d8 46,0S", 0.1400000005960464), new Stalprofil("Rund-\u00d8 50", 0.1500000059604644), new Stalprofil("Rund-\u00d8 51,2S", 0.159999996423721), new Stalprofil("Rund-\u00d8 55", 0.1700000017881393), new Stalprofil("Rund-\u00d8 56,2S", 0.1700000017881393), new Stalprofil("Rund-\u00d8 60", 0.1800000071525573), new Stalprofil("Rund-\u00d8 60,0S", 0.1800000071525573), new Stalprofil("Rund-\u00d8 66,2S", 0.2000000029802322), new Stalprofil("Rund-\u00d8 70", 0.219999998807907), new Stalprofil("Rund-\u00d8 70,0S", 0.219999998807907), new Stalprofil("Rund-\u00d8 71,4S", 0.219999998807907), new Stalprofil("Rund-\u00d8 75", 0.2300000041723251), new Stalprofil("Rund-\u00d8 75,0S", 0.2300000041723251), new Stalprofil("Rund-\u00d8 76,4S", 0.2399999946355819), new Stalprofil("Rund-\u00d8 80", 0.2), new Stalprofil("Rund-\u00d8 80,0S", 0.2), new Stalprofil("Rund-\u00d8 81,4S", 0.2), new Stalprofil("Rund-\u00d8 85", 0.2599999904632568), new Stalprofil("Rund-\u00d8 85,0S", 0.2599999904632568), new Stalprofil("Rund-\u00d8 86,4S", 0.270000010728836), new Stalprofil("Rund-\u00d8 90", 0.280000001192092), new Stalprofil("Rund-\u00d8 91,4S", 0.280000001192092), new Stalprofil("Rund-\u00d8 95", 0.2899999916553497), new Stalprofil("Rund-\u00d8 96,4S", 0.3000000119209289), new Stalprofil("Rund-\u00d8 100", 0.310000002384185), new Stalprofil("Rund-\u00d8 105", 0.3300000131130218), new Stalprofil("Rund-\u00d8 107,0S", 0.3300000131130218), new Stalprofil("Rund-\u00d8 110", 0.340000003576278), new Stalprofil("Rund-\u00d8 112,0S", 0.349999994039535), new Stalprofil("Rund-\u00d8 115", 0.3600000143051147), new Stalprofil("Rund-\u00d8 120", 0.370000004768371), new Stalprofil("Rund-\u00d8 122,0S", 0.379999995231628), new Stalprofil("Rund-\u00d8 125", 0.3899999856948852), new Stalprofil("Rund-\u00d8 127,0S", 0.3899999856948852), new Stalprofil("Rund-\u00d8 130", 0.400000005960464), new Stalprofil("Rund-\u00d8 135", 0.4199999868869781), new Stalprofil("Rund-\u00d8 140", 0.439999997615814), new Stalprofil("Rund-\u00d8 145", 0.449999988079071), new Stalprofil("Rund-\u00d8 150", 0.469999998807907), new Stalprofil("Rund-\u00d8 160", 0.0), new Stalprofil("Rund-\u00d8 165", 0.509999990463256), new Stalprofil("Rund-\u00d8 170", 0.52999997138977), new Stalprofil("Rund-\u00d8 180", 0.560000002384185), new Stalprofil("Rund-\u00d8 190", 0.589999973773956), new Stalprofil("Rund-\u00d8 200", 0.620000004768371), new Stalprofil("Rund-\u00d8 210", 0.660000026226043), new Stalprofil("Rund-\u00d8 220", 0.689999997615814), new Stalprofil("Rund-\u00d8 220G", 0.689999997615814), new Stalprofil("Rund-\u00d8 224G", 0.69999998807907), new Stalprofil("Rund-\u00d8 230", 0.720000028610229), new Stalprofil("Rund-\u00d8 230G", 0.720000028610229), new Stalprofil("Rund-\u00d8 235G", 0.730000019073486), new Stalprofil("Rund-\u00d8 240", 0.7), new Stalprofil("Rund-\u00d8 240G", 0.7), new Stalprofil("Rund-\u00d8 245G", 0.769999980926513), new Stalprofil("Rund-\u00d8 250", 0.77999997138977), new Stalprofil("Rund-\u00d8 250G", 0.77999997138977), new Stalprofil("Rund-\u00d8 255G", 0.80000001192092), new Stalprofil("Rund-\u00d8 260", 0.810000002384185), new Stalprofil("Rund-\u00d8 270", 0.839999973773956), new Stalprofil("Rund-\u00d8 280", 0.879999995231628), new Stalprofil("Rund-\u00d8 280G", 0.879999995231628), new Stalprofil("Rund-\u00d8 285G", 0.889999985694885), new Stalprofil("Rund-\u00d8 290G", 0.910000026226043), new Stalprofil("Rund-\u00d8 305G", 0.94999998807907), new Stalprofil("Rund-\u00d8 330G", 1.02999997138977), new Stalprofil("Rund-\u00d8 355G", 1.110000014305114), new Stalprofil("Rund-\u00d8 380G", 1.19000005722045), new Stalprofil("Rund-\u00d8 405G", 1.269999980926513), new Stalprofil("Rund-\u00d8 430G", 1.35000002384185), new Stalprofil("Rund-\u00d8 455G", 1.419999957084655), new Stalprofil("Rund-\u00d8 480G", 1.0), new Stalprofil("Rund-\u00d8 505G", 1.580000042915344));
            }
            case R\u00d6R: {
                return Arrays.asList(new Stalprofil("R\u00d6R-\u00d8101,6/10,0", 0.319999992847442), new Stalprofil("R\u00d6R-\u00d8101,6/12,5", 0.319999992847442), new Stalprofil("R\u00d6R-\u00d8101,6/14,2", 0.319999992847442), new Stalprofil("R\u00d6R-\u00d8101,6/16,0", 0.319999992847442), new Stalprofil("R\u00d6R-\u00d8101,6/20,0", 0.319999992847442), new Stalprofil("R\u00d6R-\u00d8101,6/3,6", 0.319999992847442), new Stalprofil("R\u00d6R-\u00d8101,6/5,0", 0.319999992847442), new Stalprofil("R\u00d6R-\u00d8101,6/5,6", 0.319999992847442), new Stalprofil("R\u00d6R-\u00d8101,6/6,3", 0.319999992847442), new Stalprofil("R\u00d6R-\u00d8101,6/8,8", 0.319999992847442), new Stalprofil("R\u00d6R-\u00d8108/10,0", 0.340000003576278), new Stalprofil("R\u00d6R-\u00d8108/12,5", 0.340000003576278), new Stalprofil("R\u00d6R-\u00d8108/14,2", 0.340000003576278), new Stalprofil("R\u00d6R-\u00d8108/16,0", 0.340000003576278), new Stalprofil("R\u00d6R-\u00d8108/20,0", 0.340000003576278), new Stalprofil("R\u00d6R-\u00d8108/22,2", 0.340000003576278), new Stalprofil("R\u00d6R-\u00d8108/3,6", 0.340000003576278), new Stalprofil("R\u00d6R-\u00d8108/6,3", 0.340000003576278), new Stalprofil("R\u00d6R-\u00d8108/7,1", 0.340000003576278), new Stalprofil("R\u00d6R-\u00d8108/8,8", 0.340000003576278), new Stalprofil("R\u00d6R-\u00d8114,3/10,0", 0.3600000143051147), new Stalprofil("R\u00d6R-\u00d8114,3/11,0", 0.3600000143051147), new Stalprofil("R\u00d6R-\u00d8114,3/12,5", 0.3600000143051147), new Stalprofil("R\u00d6R-\u00d8114,3/14,2", 0.3600000143051147), new Stalprofil("R\u00d6R-\u00d8114,3/16,0", 0.3600000143051147), new Stalprofil("R\u00d6R-\u00d8114,3/20,0", 0.3600000143051147), new Stalprofil("R\u00d6R-\u00d8114,3/22,2", 0.3600000143051147), new Stalprofil("R\u00d6R-\u00d8114,3/3,6", 0.3600000143051147), new Stalprofil("R\u00d6R-\u00d8114,3/5,0", 0.3600000143051147), new Stalprofil("R\u00d6R-\u00d8114,3/5,6", 0.3600000143051147), new Stalprofil("R\u00d6R-\u00d8114,3/6,3", 0.3600000143051147), new Stalprofil("R\u00d6R-\u00d8114,3/7,1", 0.3600000143051147), new Stalprofil("R\u00d6R-\u00d8114,3/8,8", 0.3600000143051147), new Stalprofil("R\u00d6R-\u00d8121/10,0", 0.379999995231628), new Stalprofil("R\u00d6R-\u00d8121/14,2", 0.379999995231628), new Stalprofil("R\u00d6R-\u00d8121/17,8", 0.379999995231628), new Stalprofil("R\u00d6R-\u00d8121/25,0", 0.379999995231628), new Stalprofil("R\u00d6R-\u00d8121/5,6", 0.379999995231628), new Stalprofil("R\u00d6R-\u00d8121/6,3", 0.379999995231628), new Stalprofil("R\u00d6R-\u00d8121/8,8", 0.379999995231628), new Stalprofil("R\u00d6R-\u00d8127/10,0", 0.400000005960464), new Stalprofil("R\u00d6R-\u00d8127/12,5", 0.400000005960464), new Stalprofil("R\u00d6R-\u00d8127/14,2", 0.400000005960464), new Stalprofil("R\u00d6R-\u00d8127/16,0", 0.400000005960464), new Stalprofil("R\u00d6R-\u00d8127/20,0", 0.400000005960464), new Stalprofil("R\u00d6R-\u00d8127/25,0", 0.400000005960464), new Stalprofil("R\u00d6R-\u00d8127/6,3", 0.400000005960464), new Stalprofil("R\u00d6R-\u00d8127/8,8", 0.400000005960464), new Stalprofil("R\u00d6R-\u00d8133/10,0", 0.4199999868869781), new Stalprofil("R\u00d6R-\u00d8133/14,2", 0.4199999868869781), new Stalprofil("R\u00d6R-\u00d8133/17,5", 0.4199999868869781), new Stalprofil("R\u00d6R-\u00d8133/20,0", 0.4199999868869781), new Stalprofil("R\u00d6R-\u00d8133/25,0", 0.4199999868869781), new Stalprofil("R\u00d6R-\u00d8133/4,0", 0.4199999868869781), new Stalprofil("R\u00d6R-\u00d8133/6,3", 0.4199999868869781), new Stalprofil("R\u00d6R-\u00d8133/8,8", 0.4199999868869781), new Stalprofil("R\u00d6R-\u00d8139,7/10,0", 0.439999997615814), new Stalprofil("R\u00d6R-\u00d8139,7/11,0", 0.439999997615814), new Stalprofil("R\u00d6R-\u00d8139,7/12,5", 0.439999997615814), new Stalprofil("R\u00d6R-\u00d8139,7/14,2", 0.439999997615814), new Stalprofil("R\u00d6R-\u00d8139,7/16,0", 0.439999997615814), new Stalprofil("R\u00d6R-\u00d8139,7/17,5", 0.439999997615814), new Stalprofil("R\u00d6R-\u00d8139,7/20,0", 0.439999997615814), new Stalprofil("R\u00d6R-\u00d8139,7/22,2", 0.439999997615814), new Stalprofil("R\u00d6R-\u00d8139,7/25,0", 0.439999997615814), new Stalprofil("R\u00d6R-\u00d8139,7/3,2", 0.439999997615814), new Stalprofil("R\u00d6R-\u00d8139,7/4,0", 0.439999997615814), new Stalprofil("R\u00d6R-\u00d8139,7/5,0", 0.439999997615814), new Stalprofil("R\u00d6R-\u00d8139,7/6,3", 0.439999997615814), new Stalprofil("R\u00d6R-\u00d8139,7/7,1", 0.439999997615814), new Stalprofil("R\u00d6R-\u00d8139,7/8,8", 0.439999997615814), new Stalprofil("R\u00d6R-\u00d8152,4/10,0", 0.4799999892711639), new Stalprofil("R\u00d6R-\u00d8152,4/12,5", 0.4799999892711639), new Stalprofil("R\u00d6R-\u00d8152,4/14,2", 0.4799999892711639), new Stalprofil("R\u00d6R-\u00d8152,4/17,5", 0.4799999892711639), new Stalprofil("R\u00d6R-\u00d8152,4/22,2", 0.4799999892711639), new Stalprofil("R\u00d6R-\u00d8152,4/6,3", 0.4799999892711639), new Stalprofil("R\u00d6R-\u00d8152,4/8,8", 0.4799999892711639), new Stalprofil("R\u00d6R-\u00d8159/10,0", 0.0), new Stalprofil("R\u00d6R-\u00d8159/12,5", 0.0), new Stalprofil("R\u00d6R-\u00d8159/14,2", 0.0), new Stalprofil("R\u00d6R-\u00d8159/17,5", 0.0), new Stalprofil("R\u00d6R-\u00d8159/20,0", 0.0), new Stalprofil("R\u00d6R-\u00d8159/25,0", 0.0), new Stalprofil("R\u00d6R-\u00d8159/4,5", 0.0), new Stalprofil("R\u00d6R-\u00d8159/6,3", 0.0), new Stalprofil("R\u00d6R-\u00d8159/8,8", 0.0), new Stalprofil("R\u00d6R-\u00d8168,3/10,0", 0.52999997138977), new Stalprofil("R\u00d6R-\u00d8168,3/14,2", 0.52999997138977), new Stalprofil("R\u00d6R-\u00d8168,3/16,0", 0.52999997138977), new Stalprofil("R\u00d6R-\u00d8168,3/17,5", 0.52999997138977), new Stalprofil("R\u00d6R-\u00d8168,3/20,0", 0.52999997138977), new Stalprofil("R\u00d6R-\u00d8168,3/22,2", 0.52999997138977), new Stalprofil("R\u00d6R-\u00d8168,3/25,0", 0.52999997138977), new Stalprofil("R\u00d6R-\u00d8168,3/3,6", 0.52999997138977), new Stalprofil("R\u00d6R-\u00d8168,3/4,5", 0.52999997138977), new Stalprofil("R\u00d6R-\u00d8168,3/5,6", 0.52999997138977), new Stalprofil("R\u00d6R-\u00d8168,3/8,0", 0.52999997138977), new Stalprofil("R\u00d6R-\u00d8168,3/8,8", 0.52999997138977), new Stalprofil("R\u00d6R-\u00d817,2/1,8", 0.050000000745058), new Stalprofil("R\u00d6R-\u00d8177,8/10,0", 0.560000002384185), new Stalprofil("R\u00d6R-\u00d8177,8/14,2", 0.560000002384185), new Stalprofil("R\u00d6R-\u00d8177,8/17,5", 0.560000002384185), new Stalprofil("R\u00d6R-\u00d8177,8/20,0", 0.560000002384185), new Stalprofil("R\u00d6R-\u00d8177,8/25,0", 0.560000002384185), new Stalprofil("R\u00d6R-\u00d8177,8/8,8", 0.560000002384185), new Stalprofil("R\u00d6R-\u00d8193,7/10,0", 0.610000014305114), new Stalprofil("R\u00d6R-\u00d8193,7/12,5", 0.610000014305114), new Stalprofil("R\u00d6R-\u00d8193,7/16,0", 0.610000014305114), new Stalprofil("R\u00d6R-\u00d8193,7/17,5", 0.610000014305114), new Stalprofil("R\u00d6R-\u00d8193,7/20,0", 0.610000014305114), new Stalprofil("R\u00d6R-\u00d8193,7/22,2", 0.610000014305114), new Stalprofil("R\u00d6R-\u00d8193,7/25,0", 0.610000014305114), new Stalprofil("R\u00d6R-\u00d8193,7/5,4", 0.610000014305114), new Stalprofil("R\u00d6R-\u00d8193,7/8,8", 0.610000014305114), new Stalprofil("R\u00d6R-\u00d821,3/2,0", 0.0599999986588954), new Stalprofil("R\u00d6R-\u00d821,3/3,2", 0.0599999986588954), new Stalprofil("R\u00d6R-\u00d8219,1/10,0", 0.689999997615814), new Stalprofil("R\u00d6R-\u00d8219,1/14,2", 0.689999997615814), new Stalprofil("R\u00d6R-\u00d8219,1/16,0", 0.689999997615814), new Stalprofil("R\u00d6R-\u00d8219,1/17,5", 0.689999997615814), new Stalprofil("R\u00d6R-\u00d8219,1/20,0", 0.689999997615814), new Stalprofil("R\u00d6R-\u00d8219,1/22,2", 0.689999997615814), new Stalprofil("R\u00d6R-\u00d8219,1/25,0", 0.689999997615814), new Stalprofil("R\u00d6R-\u00d8219,1/3,6", 0.689999997615814), new Stalprofil("R\u00d6R-\u00d8219,1/4,5", 0.689999997615814), new Stalprofil("R\u00d6R-\u00d8219,1/5,6", 0.689999997615814), new Stalprofil("R\u00d6R-\u00d8219,1/8,0", 0.689999997615814), new Stalprofil("R\u00d6R-\u00d8219,1/8,8", 0.689999997615814), new Stalprofil("R\u00d6R-\u00d8244,5/10,0", 0.769999980926513), new Stalprofil("R\u00d6R-\u00d8244,5/12,5", 0.769999980926513), new Stalprofil("R\u00d6R-\u00d8244,5/14,2", 0.769999980926513), new Stalprofil("R\u00d6R-\u00d8244,5/16,0", 0.769999980926513), new Stalprofil("R\u00d6R-\u00d8244,5/20,0", 0.769999980926513), new Stalprofil("R\u00d6R-\u00d8244,5/22,2", 0.769999980926513), new Stalprofil("R\u00d6R-\u00d8244,5/25,0", 0.769999980926513), new Stalprofil("R\u00d6R-\u00d8244,5/6,3", 0.769999980926513), new Stalprofil("R\u00d6R-\u00d826,9/2,3", 0.0799999982118606), new Stalprofil("R\u00d6R-\u00d826,9/3,2", 0.0799999982118606), new Stalprofil("R\u00d6R-\u00d826,9/5,0", 0.0799999982118606), new Stalprofil("R\u00d6R-\u00d8267/12,5", 0.850000023841857), new Stalprofil("R\u00d6R-\u00d8267/14,2", 0.850000023841857), new Stalprofil("R\u00d6R-\u00d8267/17,5", 0.850000023841857), new Stalprofil("R\u00d6R-\u00d8267/20,0", 0.850000023841857), new Stalprofil("R\u00d6R-\u00d8267/22,2", 0.850000023841857), new Stalprofil("R\u00d6R-\u00d8267/25,0", 0.850000023841857), new Stalprofil("R\u00d6R-\u00d8273/10,0", 0.860000014305114), new Stalprofil("R\u00d6R-\u00d8273/12,5", 0.860000014305114), new Stalprofil("R\u00d6R-\u00d8273/14,2", 0.860000014305114), new Stalprofil("R\u00d6R-\u00d8273/16,0", 0.860000014305114), new Stalprofil("R\u00d6R-\u00d8273/17,5", 0.860000014305114), new Stalprofil("R\u00d6R-\u00d8273/20,0", 0.860000014305114), new Stalprofil("R\u00d6R-\u00d8273/4,5", 0.860000014305114), new Stalprofil("R\u00d6R-\u00d8273/6,3", 0.860000014305114), new Stalprofil("R\u00d6R-\u00d8273/8,0", 0.860000014305114), new Stalprofil("R\u00d6R-\u00d8298,5/12,5", 0.94999998807907), new Stalprofil("R\u00d6R-\u00d8298,5/14,2", 0.94999998807907), new Stalprofil("R\u00d6R-\u00d8298,5/16,0", 0.94999998807907), new Stalprofil("R\u00d6R-\u00d8298,5/17,5", 0.94999998807907), new Stalprofil("R\u00d6R-\u00d8298,5/20,0", 0.94999998807907), new Stalprofil("R\u00d6R-\u00d8298,5/25,0", 0.94999998807907), new Stalprofil("R\u00d6R-\u00d8298,5/7,1", 0.94999998807907), new Stalprofil("R\u00d6R-\u00d830,0/2,6", 0.0900000035762786), new Stalprofil("R\u00d6R-\u00d8323,9/10,0", 1.02999997138977), new Stalprofil("R\u00d6R-\u00d8323,9/12,5", 1.02999997138977), new Stalprofil("R\u00d6R-\u00d8323,9/14,2", 1.02999997138977), new Stalprofil("R\u00d6R-\u00d8323,9/16,0", 1.02999997138977), new Stalprofil("R\u00d6R-\u00d8323,9/17,5", 1.02999997138977), new Stalprofil("R\u00d6R-\u00d8323,9/20,0", 1.02999997138977), new Stalprofil("R\u00d6R-\u00d8323,9/22,2", 1.02999997138977), new Stalprofil("R\u00d6R-\u00d8323,9/25,0", 1.02999997138977), new Stalprofil("R\u00d6R-\u00d8323,9/4,5", 1.02999997138977), new Stalprofil("R\u00d6R-\u00d8323,9/7,1", 1.02999997138977), new Stalprofil("R\u00d6R-\u00d833,7/2,6", 0.1000000014901161), new Stalprofil("R\u00d6R-\u00d833,7/2,9", 0.1000000014901161), new Stalprofil("R\u00d6R-\u00d833,7/4,0", 0.1000000014901161), new Stalprofil("R\u00d6R-\u00d833,7/4,5", 0.1000000014901161), new Stalprofil("R\u00d6R-\u00d8355,6/12,5", 1.129999995231628), new Stalprofil("R\u00d6R-\u00d8355,6/16,0", 1.129999995231628), new Stalprofil("R\u00d6R-\u00d8355,6/20,0", 1.129999995231628), new Stalprofil("R\u00d6R-\u00d8355,6/25,0", 1.129999995231628), new Stalprofil("R\u00d6R-\u00d8355,6/8,0", 1.129999995231628), new Stalprofil("R\u00d6R-\u00d8368/12,5", 1.169999957084655), new Stalprofil("R\u00d6R-\u00d8368/14,5", 1.169999957084655), new Stalprofil("R\u00d6R-\u00d8368/17,5", 1.169999957084655), new Stalprofil("R\u00d6R-\u00d8368/20,0", 1.169999957084655), new Stalprofil("R\u00d6R-\u00d8368/22,2", 1.169999957084655), new Stalprofil("R\u00d6R-\u00d8368/8,0", 1.169999957084655), new Stalprofil("R\u00d6R-\u00d838/2,6", 0.1199999973177909), new Stalprofil("R\u00d6R-\u00d838/4,0", 0.1199999973177909), new Stalprofil("R\u00d6R-\u00d838/5,6", 0.1199999973177909), new Stalprofil("R\u00d6R-\u00d838/6,3", 0.1199999973177909), new Stalprofil("R\u00d6R-\u00d838/7,1", 0.1199999973177909), new Stalprofil("R\u00d6R-\u00d8406,4/16,0", 1.289999961853027), new Stalprofil("R\u00d6R-\u00d8406,4/5,6", 1.289999961853027), new Stalprofil("R\u00d6R-\u00d8406,4/8,8", 1.289999961853027), new Stalprofil("R\u00d6R-\u00d8419/16,0", 1.330000042915344), new Stalprofil("R\u00d6R-\u00d842,4/2,6", 0.1299999952316284), new Stalprofil("R\u00d6R-\u00d842,4/4,0", 0.1299999952316284), new Stalprofil("R\u00d6R-\u00d842,4/5,0", 0.1299999952316284), new Stalprofil("R\u00d6R-\u00d842,4/5,6", 0.1299999952316284), new Stalprofil("R\u00d6R-\u00d842,4/6,3", 0.1299999952316284), new Stalprofil("R\u00d6R-\u00d842,4/8,0", 0.1299999952316284), new Stalprofil("R\u00d6R-\u00d844,5/2,6", 0.1400000005960464), new Stalprofil("R\u00d6R-\u00d844,5/4,0", 0.1400000005960464), new Stalprofil("R\u00d6R-\u00d844,5/5,6", 0.1400000005960464), new Stalprofil("R\u00d6R-\u00d844,5/6,3", 0.1400000005960464), new Stalprofil("R\u00d6R-\u00d844,5/8,0", 0.1400000005960464), new Stalprofil("R\u00d6R-\u00d8457,2/10,0", 1.450000047683715), new Stalprofil("R\u00d6R-\u00d848,3/2,6", 0.1500000059604644), new Stalprofil("R\u00d6R-\u00d848,3/3,6", 0.1500000059604644), new Stalprofil("R\u00d6R-\u00d848,3/4,0", 0.1500000059604644), new Stalprofil("R\u00d6R-\u00d848,3/5,0", 0.1500000059604644), new Stalprofil("R\u00d6R-\u00d848,3/6,3", 0.1500000059604644), new Stalprofil("R\u00d6R-\u00d848,3/7,1", 0.1500000059604644), new Stalprofil("R\u00d6R-\u00d848,3/8,0", 0.1500000059604644), new Stalprofil("R\u00d6R-\u00d8508/11,0", 1.610000014305114), new Stalprofil("R\u00d6R-\u00d851,3/4,0", 0.159999996423721), new Stalprofil("R\u00d6R-\u00d851,3/5,0", 0.159999996423721), new Stalprofil("R\u00d6R-\u00d851,3/6,3", 0.159999996423721), new Stalprofil("R\u00d6R-\u00d851,3/7,1", 0.159999996423721), new Stalprofil("R\u00d6R-\u00d851,3/8,0", 0.159999996423721), new Stalprofil("R\u00d6R-\u00d857/10,0", 0.1800000071525573), new Stalprofil("R\u00d6R-\u00d857/2,9", 0.1800000071525573), new Stalprofil("R\u00d6R-\u00d857/4,5", 0.1800000071525573), new Stalprofil("R\u00d6R-\u00d857/5,6", 0.1800000071525573), new Stalprofil("R\u00d6R-\u00d857/6,3", 0.1800000071525573), new Stalprofil("R\u00d6R-\u00d857/7,1", 0.1800000071525573), new Stalprofil("R\u00d6R-\u00d857/8,0", 0.1800000071525573), new Stalprofil("R\u00d6R-\u00d860,3/10,0", 0.189999997615814), new Stalprofil("R\u00d6R-\u00d860,3/2,9", 0.189999997615814), new Stalprofil("R\u00d6R-\u00d860,3/4,0", 0.189999997615814), new Stalprofil("R\u00d6R-\u00d860,3/4,5", 0.189999997615814), new Stalprofil("R\u00d6R-\u00d860,3/5,0", 0.189999997615814), new Stalprofil("R\u00d6R-\u00d860,3/5,6", 0.189999997615814), new Stalprofil("R\u00d6R-\u00d860,3/6,3", 0.189999997615814), new Stalprofil("R\u00d6R-\u00d860,3/7,1", 0.189999997615814), new Stalprofil("R\u00d6R-\u00d860,3/8,0", 0.189999997615814), new Stalprofil("R\u00d6R-\u00d863,5/10,0", 0.2000000029802322), new Stalprofil("R\u00d6R-\u00d863,5/12,5", 0.2000000029802322), new Stalprofil("R\u00d6R-\u00d863,5/2,9", 0.2000000029802322), new Stalprofil("R\u00d6R-\u00d863,5/5,6", 0.2000000029802322), new Stalprofil("R\u00d6R-\u00d863,5/6,3", 0.2000000029802322), new Stalprofil("R\u00d6R-\u00d863,5/7,1", 0.2000000029802322), new Stalprofil("R\u00d6R-\u00d863,5/8,8", 0.2000000029802322), new Stalprofil("R\u00d6R-\u00d870/10,0", 0.219999998807907), new Stalprofil("R\u00d6R-\u00d870/12,5", 0.219999998807907), new Stalprofil("R\u00d6R-\u00d870/2,9", 0.219999998807907), new Stalprofil("R\u00d6R-\u00d870/5,0", 0.219999998807907), new Stalprofil("R\u00d6R-\u00d870/6,3", 0.219999998807907), new Stalprofil("R\u00d6R-\u00d870/7,1", 0.219999998807907), new Stalprofil("R\u00d6R-\u00d870/8,0", 0.219999998807907), new Stalprofil("R\u00d6R-\u00d870/8,8", 0.219999998807907), new Stalprofil("R\u00d6R-\u00d876,1/10,0", 0.2399999946355819), new Stalprofil("R\u00d6R-\u00d876,1/11,0", 0.2399999946355819), new Stalprofil("R\u00d6R-\u00d876,1/12,5", 0.2399999946355819), new Stalprofil("R\u00d6R-\u00d876,1/14,2", 0.2399999946355819), new Stalprofil("R\u00d6R-\u00d876,1/16,0", 0.2399999946355819), new Stalprofil("R\u00d6R-\u00d876,1/2,9", 0.2399999946355819), new Stalprofil("R\u00d6R-\u00d876,1/4,0", 0.2399999946355819), new Stalprofil("R\u00d6R-\u00d876,1/4,5", 0.2399999946355819), new Stalprofil("R\u00d6R-\u00d876,1/5,0", 0.2399999946355819), new Stalprofil("R\u00d6R-\u00d876,1/5,6", 0.2399999946355819), new Stalprofil("R\u00d6R-\u00d876,1/6,3", 0.2399999946355819), new Stalprofil("R\u00d6R-\u00d876,1/7,1", 0.2399999946355819), new Stalprofil("R\u00d6R-\u00d876,1/8,8", 0.2399999946355819), new Stalprofil("R\u00d6R-\u00d882,5/10,0", 0.2599999904632568), new Stalprofil("R\u00d6R-\u00d882,5/12,5", 0.2599999904632568), new Stalprofil("R\u00d6R-\u00d882,5/14,2", 0.2599999904632568), new Stalprofil("R\u00d6R-\u00d882,5/17,5", 0.2599999904632568), new Stalprofil("R\u00d6R-\u00d882,5/6,3", 0.2599999904632568), new Stalprofil("R\u00d6R-\u00d882,5/8,8", 0.2599999904632568), new Stalprofil("R\u00d6R-\u00d888,9/10,0", 0.280000001192092), new Stalprofil("R\u00d6R-\u00d888,9/12,5", 0.280000001192092), new Stalprofil("R\u00d6R-\u00d888,9/14,2", 0.280000001192092), new Stalprofil("R\u00d6R-\u00d888,9/16,0", 0.280000001192092), new Stalprofil("R\u00d6R-\u00d888,9/17,5", 0.280000001192092), new Stalprofil("R\u00d6R-\u00d888,9/3,2", 0.280000001192092), new Stalprofil("R\u00d6R-\u00d888,9/4,0", 0.280000001192092), new Stalprofil("R\u00d6R-\u00d888,9/5,0", 0.280000001192092), new Stalprofil("R\u00d6R-\u00d888,9/6,3", 0.280000001192092), new Stalprofil("R\u00d6R-\u00d888,9/7,1", 0.280000001192092), new Stalprofil("R\u00d6R-\u00d888,9/8,8", 0.280000001192092));
            }
            case T_ST\u00c5NG: {
                return Arrays.asList(new Stalprofil("T100x100x11,0", 0.3000000119209289), new Stalprofil("T100x50x8,5", 0.2), new Stalprofil("T120x120x13,0", 0.3600000143051147), new Stalprofil("T120x60x10,0", 0.3000000119209289), new Stalprofil("T140x140x15,0", 0.4199999868869781), new Stalprofil("T20x20x3,0", 0.0599999986588954), new Stalprofil("T25x25x3,0", 0.0700000002980232), new Stalprofil("T30x30x4,0", 0.0900000035762786), new Stalprofil("T35x35x4,5", 0.1000000014901161), new Stalprofil("T40x40x5,0", 0.1199999973177909), new Stalprofil("T45x45x5,5", 0.1299999952316284), new Stalprofil("T50x50x6,0", 0.1500000059604644), new Stalprofil("T60x30x5,5", 0.1500000059604644), new Stalprofil("T60x60x7,0", 0.1800000071525573), new Stalprofil("T70x35x6,0", 0.1700000017881393), new Stalprofil("T70x70x8,0", 0.209999993443489), new Stalprofil("T80x40x7,0", 0.2000000029802322), new Stalprofil("T80x80x9,0", 0.2399999946355819), new Stalprofil("T90x90x10,0", 0.270000010728836), new Stalprofil("T100x100x11,0/3", 0.400000005960464), new Stalprofil("T100x50x8,5/3", 0.3000000119209289), new Stalprofil("T120x120x13,0/3", 0.4799999892711639), new Stalprofil("T120x60x10,0/3", 0.3600000143051147), new Stalprofil("T140x140x15,0/3", 0.560000002384185), new Stalprofil("T20x20x3,0/3", 0.0799999982118606), new Stalprofil("T25x25x3,0/3", 0.1000000014901161), new Stalprofil("T30x30x4,0/3", 0.1199999973177909), new Stalprofil("T35x35x4,5/3", 0.1400000005960464), new Stalprofil("T40x40x5,0/3", 0.1000000014901161), new Stalprofil("T45x45x5,5/3", 0.1800000071525573), new Stalprofil("T50x50x6,0/3", 0.2000000029802322), new Stalprofil("T60x30x5,5/3", 0.1800000071525573), new Stalprofil("T60x60x7,0/3", 0.2399999946355819), new Stalprofil("T70x35x6,0/3", 0.209999993443489), new Stalprofil("T70x70x8,0/3", 0.280000001192092), new Stalprofil("T80x40x7,0/3", 0.2399999946355819), new Stalprofil("T80x80x9,0/3", 0.319999992847442), new Stalprofil("T90x90x10,0/3", 0.3600000143051147));
            }
            case UNP_BALK: {
                return Arrays.asList(new Stalprofil("UNP80", 0.319999992847442), new Stalprofil("UNP100", 0.379999995231628), new Stalprofil("UNP120", 0.439999997615814), new Stalprofil("UNP140", 0.0), new Stalprofil("UNP160", 0.560000002384185), new Stalprofil("UNP180", 0.620000004768371), new Stalprofil("UNP200", 0.680000007152557), new Stalprofil("UNP220", 0.740000009536743), new Stalprofil("UNP240", 0.80000001192092), new Stalprofil("UNP260", 0.860000014305114), new Stalprofil("UNP280", 0.9200000166893), new Stalprofil("UNP300", 0.980000019073486), new Stalprofil("UNP320", 1.009999990463256), new Stalprofil("UNP350", 1.070000052452087), new Stalprofil("UNP380", 1.139999985694885), new Stalprofil("UNP400", 1.210000038146972), new Stalprofil("UNP80/3", 0.280000001192092), new Stalprofil("UNP100/3", 0.3300000131130218), new Stalprofil("UNP120/3", 0.3899999856948852), new Stalprofil("UNP140/3", 0.439999997615814), new Stalprofil("UNP160/3", 0.0), new Stalprofil("UNP180/3", 0.55000001192092), new Stalprofil("UNP200/3", 0.600000023841857), new Stalprofil("UNP220/3", 0.660000026226043), new Stalprofil("UNP240/3", 0.709999978542327), new Stalprofil("UNP260/3", 0.769999980926513), new Stalprofil("UNP280/3", 0.819999992847442), new Stalprofil("UNP300/3", 0.879999995231628), new Stalprofil("UNP320/3", 0.910000026226043), new Stalprofil("UNP350/3", 0.970000028610229), new Stalprofil("UNP380/3", 1.02999997138977), new Stalprofil("UNP400/3", 1.10000002384185));
            }
            case UPE_BALK: {
                return Arrays.asList(new Stalprofil("UPE80", 0.349999994039535), new Stalprofil("UPE100", 0.409999996423721), new Stalprofil("UPE120", 0.469999998807907), new Stalprofil("UPE140", 0.52999997138977), new Stalprofil("UPE160", 0.579999983310699), new Stalprofil("UPE180", 0.639999985694885), new Stalprofil("UPE200", 0.69999998807907), new Stalprofil("UPE220", 0.759999990463256), new Stalprofil("UPE240", 0.819999992847442), new Stalprofil("UPE270", 0.899999976158142), new Stalprofil("UPE300", 0.980000019073486), new Stalprofil("UPE330", 1.049999952316284), new Stalprofil("UPE360", 1.129999995231628), new Stalprofil("UPE400", 1.230000019073486), new Stalprofil("UPE80/3", 0.3000000119209289), new Stalprofil("UPE100/3", 0.349999994039535), new Stalprofil("UPE120/3", 0.409999996423721), new Stalprofil("UPE140/3", 0.4600000083446502), new Stalprofil("UPE160/3", 0.509999990463256), new Stalprofil("UPE180/3", 0.569999992847442), new Stalprofil("UPE200/3", 0.620000004768371), new Stalprofil("UPE220/3", 0.680000007152557), new Stalprofil("UPE240/3", 0.730000019073486), new Stalprofil("UPE270/3", 0.810000002384185), new Stalprofil("UPE300/3", 0.879999995231628), new Stalprofil("UPE330/3", 0.94999998807907), new Stalprofil("UPE360/3", 1.019999980926513), new Stalprofil("UPE400/3", 1.110000014305114));
            }
            case VKR_H\u00c5LPROFILER: {
                return Arrays.asList(new Stalprofil("VKR40x40x2,5/3", 0.1199999973177909), new Stalprofil("VKR40x40x3,0/3", 0.1199999973177909), new Stalprofil("VKR40x40x3,2/3", 0.1199999973177909), new Stalprofil("VKR40x40x4,0/3", 0.1199999973177909), new Stalprofil("VKR50x30x2,5/3", 0.1299999952316284), new Stalprofil("VKR50x30x3,0/3", 0.1299999952316284), new Stalprofil("VKR50x30x3,2/3", 0.1299999952316284), new Stalprofil("VKR50x50x3,0/3", 0.1500000059604644), new Stalprofil("VKR50x50x3,2/3", 0.1500000059604644), new Stalprofil("VKR50x50x4,0/3", 0.1500000059604644), new Stalprofil("VKR50x50x5,0/3", 0.1500000059604644), new Stalprofil("VKR60x40x3,0/3", 0.159999996423721), new Stalprofil("VKR60x40x3,2/3", 0.159999996423721), new Stalprofil("VKR60x40x4,0/3", 0.159999996423721), new Stalprofil("VKR60x60x3,0/3", 0.1800000071525573), new Stalprofil("VKR60x60x3,2/3", 0.1800000071525573), new Stalprofil("VKR60x60x4,0/3", 0.1800000071525573), new Stalprofil("VKR60x60x5,0/3", 0.1800000071525573), new Stalprofil("VKR70x70x3,0/3", 0.209999993443489), new Stalprofil("VKR70x70x3,6/3", 0.209999993443489), new Stalprofil("VKR70x70x4,0/3", 0.209999993443489), new Stalprofil("VKR70x70x5,0/3", 0.209999993443489), new Stalprofil("VKR80x40x3,0/3", 0.2000000029802322), new Stalprofil("VKR80x40x3,2/3", 0.2000000029802322), new Stalprofil("VKR80x40x4,0/3", 0.2000000029802322), new Stalprofil("VKR80x40x5,0/3", 0.2000000029802322), new Stalprofil("VKR80x80x3,6/3", 0.2399999946355819), new Stalprofil("VKR80x80x4,0/3", 0.2399999946355819), new Stalprofil("VKR80x80x5,0/3", 0.2399999946355819), new Stalprofil("VKR80x80x6,0/3", 0.2399999946355819), new Stalprofil("VKR80x80x6,3/3", 0.2399999946355819), new Stalprofil("VKR80x80x8,0/3", 0.2399999946355819), new Stalprofil("VKR90x50x3,6/3", 0.2300000041723251), new Stalprofil("VKR90x50x4,0/3", 0.2300000041723251), new Stalprofil("VKR90x50x5,0/3", 0.2300000041723251), new Stalprofil("VKR90x90x3,6/3", 0.270000010728836), new Stalprofil("VKR90x90x4,0/3", 0.270000010728836), new Stalprofil("VKR90x90x5,0/3", 0.270000010728836), new Stalprofil("VKR90x90x6,0/3", 0.270000010728836), new Stalprofil("VKR90x90x6,3/3", 0.270000010728836), new Stalprofil("VKR90x90x8,0/3", 0.270000010728836), new Stalprofil("VKR100x100x10,0/3", 0.3000000119209289), new Stalprofil("VKR100x100x4,0/3", 0.3000000119209289), new Stalprofil("VKR100x100x5,0/3", 0.3000000119209289), new Stalprofil("VKR100x100x6,0/3", 0.3000000119209289), new Stalprofil("VKR100x100x6,3/3", 0.3000000119209289), new Stalprofil("VKR100x100x8,0/3", 0.3000000119209289), new Stalprofil("VKR100x50x3,0/3", 0.2), new Stalprofil("VKR100x50x3,2/3", 0.2), new Stalprofil("VKR100x50x4,0/3", 0.2), new Stalprofil("VKR100x50x5,0/3", 0.2), new Stalprofil("VKR100x50x6,0/3", 0.2), new Stalprofil("VKR100x50x6,3/3", 0.2), new Stalprofil("VKR100x50x8,0/3", 0.2), new Stalprofil("VKR100x60x3,6/3", 0.2599999904632568), new Stalprofil("VKR100x60x4,0/3", 0.2599999904632568), new Stalprofil("VKR100x60x5,0/3", 0.2599999904632568), new Stalprofil("VKR100x60x6,0/3", 0.2599999904632568), new Stalprofil("VKR100x60x6,3/3", 0.2599999904632568), new Stalprofil("VKR100x60x8,0/3", 0.2599999904632568), new Stalprofil("VKR120x120x10,0/3", 0.3600000143051147), new Stalprofil("VKR120x120x5,0/3", 0.3600000143051147), new Stalprofil("VKR120x120x6,0/3", 0.3600000143051147), new Stalprofil("VKR120x120x6,3/3", 0.3600000143051147), new Stalprofil("VKR120x120x8,0/3", 0.3600000143051147), new Stalprofil("VKR120x60x3,6/3", 0.3000000119209289), new Stalprofil("VKR120x60x4,0/3", 0.3000000119209289), new Stalprofil("VKR120x60x5,0/3", 0.3000000119209289), new Stalprofil("VKR120x60x6,0/3", 0.3000000119209289), new Stalprofil("VKR120x60x6,3/3", 0.3000000119209289), new Stalprofil("VKR120x60x8,0/3", 0.3000000119209289), new Stalprofil("VKR120x80x10,0/3", 0.319999992847442), new Stalprofil("VKR120x80x4,0/3", 0.319999992847442), new Stalprofil("VKR120x80x5,0/3", 0.319999992847442), new Stalprofil("VKR120x80x6,0/3", 0.319999992847442), new Stalprofil("VKR120x80x6,3/3", 0.319999992847442), new Stalprofil("VKR120x80x8,0/3", 0.319999992847442), new Stalprofil("VKR140x140x10,0/3", 0.4199999868869781), new Stalprofil("VKR140x140x12,5/3", 0.4199999868869781), new Stalprofil("VKR140x140x5,0/3", 0.4199999868869781), new Stalprofil("VKR140x140x6,0/3", 0.4199999868869781), new Stalprofil("VKR140x140x6,3/3", 0.4199999868869781), new Stalprofil("VKR140x140x8,0/3", 0.4199999868869781), new Stalprofil("VKR140x70x4,0/3", 0.349999994039535), new Stalprofil("VKR140x70x5,0/3", 0.349999994039535), new Stalprofil("VKR140x70x6,0/3", 0.349999994039535), new Stalprofil("VKR140x80x4,0/3", 0.3600000143051147), new Stalprofil("VKR140x80x6,3/3", 0.3600000143051147), new Stalprofil("VKR150x100x10,0/3", 0.400000005960464), new Stalprofil("VKR150x100x4,0/3", 0.400000005960464), new Stalprofil("VKR150x100x5,0/3", 0.400000005960464), new Stalprofil("VKR150x100x6,0/3", 0.400000005960464), new Stalprofil("VKR150x100x6,3/3", 0.400000005960464), new Stalprofil("VKR150x100x8,0/3", 0.400000005960464), new Stalprofil("VKR150x150x10,0/3", 0.449999988079071), new Stalprofil("VKR150x150x12,5/3", 0.449999988079071), new Stalprofil("VKR150x150x5,0/3", 0.449999988079071), new Stalprofil("VKR150x150x6,0/3", 0.449999988079071), new Stalprofil("VKR150x150x6,3/3", 0.449999988079071), new Stalprofil("VKR150x150x8,0/3", 0.449999988079071), new Stalprofil("VKR160x160x10,0/3", 0.4799999892711639), new Stalprofil("VKR160x160x12,5/3", 0.4799999892711639), new Stalprofil("VKR160x160x6,0/3", 0.4799999892711639), new Stalprofil("VKR160x160x6,3/3", 0.4799999892711639), new Stalprofil("VKR160x160x8,0/3", 0.4799999892711639), new Stalprofil("VKR160x80x10,0/3", 0.400000005960464), new Stalprofil("VKR160x80x4,0/3", 0.400000005960464), new Stalprofil("VKR160x80x5,0/3", 0.400000005960464), new Stalprofil("VKR160x80x6,0/3", 0.400000005960464), new Stalprofil("VKR160x80x6,3/3", 0.400000005960464), new Stalprofil("VKR160x80x8,0/3", 0.400000005960464), new Stalprofil("VKR160x90x5,0/3", 0.409999996423721), new Stalprofil("VKR160x90x8,0/3", 0.409999996423721), new Stalprofil("VKR180x180x10,0/3", 0.540000021457672), new Stalprofil("VKR180x180x12,5/3", 0.540000021457672), new Stalprofil("VKR180x180x6,0/3", 0.540000021457672), new Stalprofil("VKR180x180x6,3/3", 0.540000021457672), new Stalprofil("VKR180x180x8,0/3", 0.540000021457672), new Stalprofil("VKR200x100x10,0/3", 0.0), new Stalprofil("VKR200x100x12,5/3", 0.0), new Stalprofil("VKR200x100x16,0/3", 0.0), new Stalprofil("VKR200x100x5,0/3", 0.0), new Stalprofil("VKR200x100x6,0/3", 0.0), new Stalprofil("VKR200x100x6,3/3", 0.0), new Stalprofil("VKR200x100x8,0/3", 0.0), new Stalprofil("VKR200x120x10,0/3", 0.519999980926513), new Stalprofil("VKR200x120x6,0/3", 0.519999980926513), new Stalprofil("VKR200x120x6,3/3", 0.519999980926513), new Stalprofil("VKR200x120x8,0/3", 0.519999980926513), new Stalprofil("VKR200x200x10,0/3", 0.600000023841857), new Stalprofil("VKR200x200x12,5/3", 0.600000023841857), new Stalprofil("VKR200x200x16,0/3", 0.600000023841857), new Stalprofil("VKR200x200x6,0/3", 0.600000023841857), new Stalprofil("VKR200x200x6,3/3", 0.600000023841857), new Stalprofil("VKR200x200x8,0/3", 0.600000023841857), new Stalprofil("VKR220x120x10,0/3", 0.560000002384185), new Stalprofil("VKR220x120x6,0/3", 0.560000002384185), new Stalprofil("VKR220x120x6,3/3", 0.560000002384185), new Stalprofil("VKR220x120x8,0/3", 0.560000002384185), new Stalprofil("VKR220x220x10,0/3", 0.660000026226043), new Stalprofil("VKR220x220x6,0/3", 0.660000026226043), new Stalprofil("VKR250x150x10,0/3", 0.649999976158142), new Stalprofil("VKR250x150x12,5/3", 0.649999976158142), new Stalprofil("VKR250x150x16,0/3", 0.649999976158142), new Stalprofil("VKR250x150x6,0/3", 0.649999976158142), new Stalprofil("VKR250x150x6,3/3", 0.649999976158142), new Stalprofil("VKR250x150x8,0/3", 0.649999976158142), new Stalprofil("VKR250x250x10,0/3", 0.7), new Stalprofil("VKR250x250x12,5/3", 0.7), new Stalprofil("VKR250x250x16,0/3", 0.7), new Stalprofil("VKR250x250x6,0/3", 0.7), new Stalprofil("VKR250x250x6,3/3", 0.7), new Stalprofil("VKR250x250x8,0/3", 0.7), new Stalprofil("VKR260x140x6,0/3", 0.660000026226043), new Stalprofil("VKR260x140x6,3/3", 0.660000026226043), new Stalprofil("VKR260x140x8,0/3", 0.660000026226043), new Stalprofil("VKR300x200x10,0/3", 0.80000001192092), new Stalprofil("VKR300x200x12,5/3", 0.80000001192092), new Stalprofil("VKR300x200x16,0/3", 0.80000001192092), new Stalprofil("VKR300x200x6,0/3", 0.80000001192092), new Stalprofil("VKR300x200x6,3/3", 0.80000001192092), new Stalprofil("VKR300x200x8,0/3", 0.80000001192092), new Stalprofil("VKR300x300x10,0/3", 0.899999976158142), new Stalprofil("VKR300x300x12,5/3", 0.899999976158142), new Stalprofil("VKR300x300x16,0/3", 0.899999976158142), new Stalprofil("VKR350x350x10,0/3", 1.049999952316284), new Stalprofil("VKR350x350x12,5/3", 1.049999952316284), new Stalprofil("VKR350x350x16,0/3", 1.049999952316284), new Stalprofil("VKR400x200x10,0/3", 1.0), new Stalprofil("VKR400x200x12,5/3", 1.0), new Stalprofil("VKR400x200x16,0/3", 1.0), new Stalprofil("VKR400x400x10,0/3", 1.200000047683715), new Stalprofil("VKR400x400x12,5/3", 1.200000047683715), new Stalprofil("VKR400x400x16,0/3", 1.200000047683715), new Stalprofil("VKR450x250x10,0/3", 1.14999997615814), new Stalprofil("VKR450x250x12,5/3", 1.14999997615814), new Stalprofil("VKR450x250x16,0/3", 1.14999997615814), new Stalprofil("VKR500x300x12,5/3", 1.299999952316284), new Stalprofil("VKR500x300x16,0/3", 1.299999952316284), new Stalprofil("VKR500x300x20,0/3", 1.299999952316284), new Stalprofil("VKR1100x100x10,0/3", 2.29999995231628), new Stalprofil("VKR1100x100x6,0/3", 2.29999995231628), new Stalprofil("VKR1100x100x6,3/3", 2.29999995231628), new Stalprofil("VKR1100x100x8,0/3", 2.29999995231628), new Stalprofil("VKR40x40x2,5", 0.159999996423721), new Stalprofil("VKR40x40x3,0", 0.159999996423721), new Stalprofil("VKR40x40x3,2", 0.159999996423721), new Stalprofil("VKR40x40x4,0", 0.159999996423721), new Stalprofil("VKR50x30x2,5", 0.159999996423721), new Stalprofil("VKR50x30x3,0", 0.159999996423721), new Stalprofil("VKR50x30x3,2", 0.159999996423721), new Stalprofil("VKR50x50x3,0", 0.2000000029802322), new Stalprofil("VKR50x50x3,2", 0.2000000029802322), new Stalprofil("VKR50x50x4,0", 0.2000000029802322), new Stalprofil("VKR50x50x5,0", 0.2000000029802322), new Stalprofil("VKR60x40x3,0", 0.2000000029802322), new Stalprofil("VKR60x40x3,2", 0.2000000029802322), new Stalprofil("VKR60x40x4,0", 0.2000000029802322), new Stalprofil("VKR60x60x3,0", 0.2399999946355819), new Stalprofil("VKR60x60x3,2", 0.2399999946355819), new Stalprofil("VKR60x60x4,0", 0.2399999946355819), new Stalprofil("VKR60x60x5,0", 0.2399999946355819), new Stalprofil("VKR70x70x3,0", 0.280000001192092), new Stalprofil("VKR70x70x3,6", 0.280000001192092), new Stalprofil("VKR70x70x4,0", 0.280000001192092), new Stalprofil("VKR70x70x5,0", 0.280000001192092), new Stalprofil("VKR80x40x3,0", 0.2399999946355819), new Stalprofil("VKR80x40x3,2", 0.2399999946355819), new Stalprofil("VKR80x40x4,0", 0.2399999946355819), new Stalprofil("VKR80x40x5,0", 0.2399999946355819), new Stalprofil("VKR80x80x3,6", 0.319999992847442), new Stalprofil("VKR80x80x4,0", 0.319999992847442), new Stalprofil("VKR80x80x5,0", 0.319999992847442), new Stalprofil("VKR80x80x6,0", 0.319999992847442), new Stalprofil("VKR80x80x6,3", 0.319999992847442), new Stalprofil("VKR80x80x8,0", 0.319999992847442), new Stalprofil("VKR90x50x3,6", 0.280000001192092), new Stalprofil("VKR90x50x4,0", 0.280000001192092), new Stalprofil("VKR90x50x5,0", 0.280000001192092), new Stalprofil("VKR90x90x3,6", 0.3600000143051147), new Stalprofil("VKR90x90x4,0", 0.3600000143051147), new Stalprofil("VKR90x90x5,0", 0.3600000143051147), new Stalprofil("VKR90x90x6,0", 0.3600000143051147), new Stalprofil("VKR90x90x6,3", 0.3600000143051147), new Stalprofil("VKR90x90x8,0", 0.3600000143051147), new Stalprofil("VKR100x100x10,0", 0.400000005960464), new Stalprofil("VKR100x100x4,0", 0.400000005960464), new Stalprofil("VKR100x100x5,0", 0.400000005960464), new Stalprofil("VKR100x100x6,0", 0.400000005960464), new Stalprofil("VKR100x100x6,3", 0.400000005960464), new Stalprofil("VKR100x100x8,0", 0.400000005960464), new Stalprofil("VKR100x50x3,0", 0.3000000119209289), new Stalprofil("VKR100x50x3,2", 0.3000000119209289), new Stalprofil("VKR100x50x4,0", 0.3000000119209289), new Stalprofil("VKR100x50x5,0", 0.3000000119209289), new Stalprofil("VKR100x50x6,0", 0.3000000119209289), new Stalprofil("VKR100x50x6,3", 0.3000000119209289), new Stalprofil("VKR100x50x8,0", 0.3000000119209289), new Stalprofil("VKR100x60x3,6", 0.319999992847442), new Stalprofil("VKR100x60x4,0", 0.319999992847442), new Stalprofil("VKR100x60x5,0", 0.319999992847442), new Stalprofil("VKR100x60x6,0", 0.319999992847442), new Stalprofil("VKR100x60x6,3", 0.319999992847442), new Stalprofil("VKR100x60x8,0", 0.319999992847442), new Stalprofil("VKR120x120x10,0", 0.4799999892711639), new Stalprofil("VKR120x120x5,0", 0.4799999892711639), new Stalprofil("VKR120x120x6,0", 0.4799999892711639), new Stalprofil("VKR120x120x6,3", 0.4799999892711639), new Stalprofil("VKR120x120x8,0", 0.4799999892711639), new Stalprofil("VKR120x60x3,6", 0.3600000143051147), new Stalprofil("VKR120x60x4,0", 0.3600000143051147), new Stalprofil("VKR120x60x5,0", 0.3600000143051147), new Stalprofil("VKR120x60x6,0", 0.3600000143051147), new Stalprofil("VKR120x60x6,3", 0.3600000143051147), new Stalprofil("VKR120x60x8,0", 0.3600000143051147), new Stalprofil("VKR120x80x10,0", 0.400000005960464), new Stalprofil("VKR120x80x4,0", 0.400000005960464), new Stalprofil("VKR120x80x5,0", 0.400000005960464), new Stalprofil("VKR120x80x6,0", 0.400000005960464), new Stalprofil("VKR120x80x6,3", 0.400000005960464), new Stalprofil("VKR120x80x8,0", 0.400000005960464), new Stalprofil("VKR140x140x10,0", 0.560000002384185), new Stalprofil("VKR140x140x12,5", 0.560000002384185), new Stalprofil("VKR140x140x5,0", 0.560000002384185), new Stalprofil("VKR140x140x6,0", 0.560000002384185), new Stalprofil("VKR140x140x6,3", 0.560000002384185), new Stalprofil("VKR140x140x8,0", 0.560000002384185), new Stalprofil("VKR140x70x4,0", 0.4199999868869781), new Stalprofil("VKR140x70x5,0", 0.4199999868869781), new Stalprofil("VKR140x70x6,0", 0.4199999868869781), new Stalprofil("VKR140x80x4,0", 0.439999997615814), new Stalprofil("VKR140x80x6,3", 0.439999997615814), new Stalprofil("VKR150x100x10,0", 0.0), new Stalprofil("VKR150x100x4,0", 0.0), new Stalprofil("VKR150x100x5,0", 0.0), new Stalprofil("VKR150x100x6,0", 0.0), new Stalprofil("VKR150x100x6,3", 0.0), new Stalprofil("VKR150x100x8,0", 0.0), new Stalprofil("VKR150x150x10,0", 0.600000023841857), new Stalprofil("VKR150x150x12,5", 0.600000023841857), new Stalprofil("VKR150x150x5,0", 0.600000023841857), new Stalprofil("VKR150x150x6,0", 0.600000023841857), new Stalprofil("VKR150x150x6,3", 0.600000023841857), new Stalprofil("VKR150x150x8,0", 0.600000023841857), new Stalprofil("VKR160x160x10,0", 0.639999985694885), new Stalprofil("VKR160x160x12,5", 0.639999985694885), new Stalprofil("VKR160x160x6,0", 0.639999985694885), new Stalprofil("VKR160x160x6,3", 0.639999985694885), new Stalprofil("VKR160x160x8,0", 0.639999985694885), new Stalprofil("VKR160x80x10,0", 0.4799999892711639), new Stalprofil("VKR160x80x4,0", 0.4799999892711639), new Stalprofil("VKR160x80x5,0", 0.4799999892711639), new Stalprofil("VKR160x80x6,0", 0.4799999892711639), new Stalprofil("VKR160x80x6,3", 0.4799999892711639), new Stalprofil("VKR160x80x8,0", 0.4799999892711639), new Stalprofil("VKR160x90x5,0", 0.0), new Stalprofil("VKR160x90x8,0", 0.0), new Stalprofil("VKR180x180x10,0", 0.720000028610229), new Stalprofil("VKR180x180x12,5", 0.720000028610229), new Stalprofil("VKR180x180x6,0", 0.720000028610229), new Stalprofil("VKR180x180x6,3", 0.720000028610229), new Stalprofil("VKR180x180x8,0", 0.720000028610229), new Stalprofil("VKR200x100x10,0", 0.600000023841857), new Stalprofil("VKR200x100x12,5", 0.600000023841857), new Stalprofil("VKR200x100x16,0", 0.600000023841857), new Stalprofil("VKR200x100x5,0", 0.600000023841857), new Stalprofil("VKR200x100x6,0", 0.600000023841857), new Stalprofil("VKR200x100x6,3", 0.600000023841857), new Stalprofil("VKR200x100x8,0", 0.600000023841857), new Stalprofil("VKR200x120x10,0", 0.639999985694885), new Stalprofil("VKR200x120x6,0", 0.639999985694885), new Stalprofil("VKR200x120x6,3", 0.639999985694885), new Stalprofil("VKR200x120x8,0", 0.639999985694885), new Stalprofil("VKR200x200x10,0", 0.80000001192092), new Stalprofil("VKR200x200x12,5", 0.80000001192092), new Stalprofil("VKR200x200x16,0", 0.80000001192092), new Stalprofil("VKR200x200x6,0", 0.80000001192092), new Stalprofil("VKR200x200x6,3", 0.80000001192092), new Stalprofil("VKR200x200x8,0", 0.80000001192092), new Stalprofil("VKR220x120x10,0", 0.680000007152557), new Stalprofil("VKR220x120x6,0", 0.680000007152557), new Stalprofil("VKR220x120x6,3", 0.680000007152557), new Stalprofil("VKR220x120x8,0", 0.680000007152557), new Stalprofil("VKR220x220x10,0", 0.879999995231628), new Stalprofil("VKR220x220x6,0", 0.879999995231628), new Stalprofil("VKR250x150x10,0", 0.80000001192092), new Stalprofil("VKR250x150x12,5", 0.80000001192092), new Stalprofil("VKR250x150x16,0", 0.80000001192092), new Stalprofil("VKR250x150x6,0", 0.80000001192092), new Stalprofil("VKR250x150x6,3", 0.80000001192092), new Stalprofil("VKR250x150x8,0", 0.80000001192092), new Stalprofil("VKR250x250x10,0", 1.0), new Stalprofil("VKR250x250x12,5", 1.0), new Stalprofil("VKR250x250x16,0", 1.0), new Stalprofil("VKR250x250x6,0", 1.0), new Stalprofil("VKR250x250x6,3", 1.0), new Stalprofil("VKR250x250x8,0", 1.0), new Stalprofil("VKR260x140x6,0", 0.80000001192092), new Stalprofil("VKR260x140x6,3", 0.80000001192092), new Stalprofil("VKR260x140x8,0", 0.80000001192092), new Stalprofil("VKR300x200x10,0", 1.0), new Stalprofil("VKR300x200x12,5", 1.0), new Stalprofil("VKR300x200x16,0", 1.0), new Stalprofil("VKR300x200x6,0", 1.0), new Stalprofil("VKR300x200x6,3", 1.0), new Stalprofil("VKR300x200x8,0", 1.0), new Stalprofil("VKR300x300x10,0", 1.200000047683715), new Stalprofil("VKR300x300x12,5", 1.200000047683715), new Stalprofil("VKR300x300x16,0", 1.200000047683715), new Stalprofil("VKR350x350x10,0", 1.39999997615814), new Stalprofil("VKR350x350x12,5", 1.39999997615814), new Stalprofil("VKR350x350x16,0", 1.39999997615814), new Stalprofil("VKR400x200x10,0", 1.200000047683715), new Stalprofil("VKR400x200x12,5", 1.200000047683715), new Stalprofil("VKR400x200x16,0", 1.200000047683715), new Stalprofil("VKR400x400x10,0", 1.60000002384185), new Stalprofil("VKR400x400x12,5", 1.60000002384185), new Stalprofil("VKR400x400x16,0", 1.60000002384185), new Stalprofil("VKR450x250x10,0", 1.39999997615814), new Stalprofil("VKR450x250x12,5", 1.39999997615814), new Stalprofil("VKR450x250x16,0", 1.39999997615814), new Stalprofil("VKR500x300x12,5", 1.60000002384185), new Stalprofil("VKR500x300x16,0", 1.60000002384185), new Stalprofil("VKR500x300x20,0", 1.60000002384185), new Stalprofil("VKR1100x100x10,0", 2.400000095367431), new Stalprofil("VKR1100x100x6,0", 2.400000095367431), new Stalprofil("VKR1100x100x6,3", 2.400000095367431), new Stalprofil("VKR1100x100x8,0", 2.400000095367431));
            }
        }
        throw new IllegalArgumentException("Bad category");
    }

    private static Shape createBalk(float height, float width, float t, float d, float r) {
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(width, 0.0f);
        path.lineTo(width, t);
        path.lineTo((width + d) / 2.0f + r, t);
        path.curveTo((width + d) / 2.0f, t, (width + d) / 2.0f, t, (width + d) / 2.0f, t + r);
        path.lineTo((width + d) / 2.0f, height - t - r);
        path.curveTo((width + d) / 2.0f, height - t, (width + d) / 2.0f, height - t, (width + d) / 2.0f + r, height - t);
        path.lineTo(width, height - t);
        path.lineTo(width, height);
        path.lineTo(0.0f, height);
        path.lineTo(0.0f, height - t);
        path.lineTo((width - d) / 2.0f - r, height - t);
        path.curveTo((width - d) / 2.0f, height - t, (width - d) / 2.0f, height - t, (width - d) / 2.0f, height - t - r);
        path.lineTo((width - d) / 2.0f, t + r);
        path.curveTo((width - d) / 2.0f, t, (width - d) / 2.0f, t, (width - d) / 2.0f - r, t);
        path.lineTo((width - d) / 2.0f, t);
        path.lineTo(0.0f, t);
        path.closePath();
        return path;
    }

    private static enum Kategori {
        FYRKANTST\u00c5NG,
        HEA_BALK,
        HEB_BALK,
        HEM_BALK,
        I_BALK,
        IPE_BALK,
        KKR_H\u00c5LPROFILER,
        L_ST\u00c5L,
        PLATTST\u00c5NG,
        RHS_H\u00c5LPROFILER,
        RUNDST\u00c5NG,
        R\u00d6R,
        T_ST\u00c5NG,
        UNP_BALK,
        UPE_BALK,
        VKR_H\u00c5LPROFILER;

    }
}

