/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;

public class ShapeIcon
implements Icon {
    private int iconWidth;
    private int iconHeight;
    private Shape shape;
    private transient GeneralPath normalizedPath;
    private boolean fill;
    private RenderingHints hints;

    public ShapeIcon(Shape shape, int iconWidth, int iconHeight, boolean fill) {
        this.fill = fill;
        this.shape = shape;
        this.iconHeight = iconHeight;
        this.iconWidth = iconWidth;
        this.hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(Color.black);
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints temp = g2.getRenderingHints();
        g2.setRenderingHints(this.hints);
        if (this.fill) {
            g2.fill(this.getNormalizedShape(x, y));
        } else {
            g2.draw(this.getNormalizedShape(x, y));
        }
        g2.setRenderingHints(temp);
    }

    private Shape getNormalizedShape(int x, int y) {
        Rectangle2D bounds = this.shape.getBounds2D();
        AffineTransform ret = AffineTransform.getTranslateInstance(-bounds.getX(), -bounds.getY());
        double scale = Math.min((double)this.iconWidth / bounds.getWidth(), (double)this.iconHeight / bounds.getHeight());
        ret.preConcatenate(AffineTransform.getScaleInstance(scale, scale));
        ret.preConcatenate(AffineTransform.getTranslateInstance((double)x + ((double)this.iconWidth - scale * bounds.getWidth()) / 2.0, (double)y + ((double)this.iconHeight - scale * bounds.getHeight()) / 2.0));
        return ret.createTransformedShape(this.shape);
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    public void setIconWidth(int iconWidth) {
        this.iconWidth = iconWidth;
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    public void setIconHeight(int iconHeight) {
        this.iconHeight = iconHeight;
    }
}

