/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.digitizer.serial;

import se.sjobeck.digitizer.DigitizerEvent;
import se.sjobeck.digitizer.IPDigitizerEvent;
import se.sjobeck.digitizer.serial.SerialPortDigitizer;

public class RollUp
implements SerialPortDigitizer {
    @Override
    public byte[] getIdentifierCommand() {
        return new byte[]{1, 86, 82, 27};
    }

    @Override
    public boolean identifyDigitizer(byte[] identifier) {
        return new String(identifier).indexOf("GTCO STANDARD SOFTWARE") > 0;
    }

    @Override
    public byte[] setupCommand() {
        return null;
    }

    @Override
    public int getFrameSize() {
        return 6;
    }

    @Override
    public DigitizerEvent generateEvent(byte[] frame) {
        if ((frame[0] & 0x80) == 0 || (frame[1] & 0x80) > 0 || (frame[2] & 0x80) > 0 || (frame[3] & 0x80) > 0 || (frame[3] & 0x20) > 0 || (frame[4] & 0x80) > 0 || (frame[5] & 0x80) > 0) {
            return null;
        }
        int cursor = 0;
        if ((frame[0] & 0x40) > 0) {
            cursor |= 1;
        }
        if ((frame[0] & 0x20) > 0) {
            cursor |= 0x10;
        }
        if ((frame[0] & 0x10) > 0) {
            cursor |= 8;
        }
        if ((frame[0] & 8) > 0) {
            cursor |= 4;
        }
        if ((frame[0] & 4) > 0) {
            cursor |= 2;
        }
        long x = 0L;
        x |= (long)((frame[0] & 2) << 14);
        x |= (long)((frame[0] & 1) << 14);
        x |= (long)((frame[1] & 0x40) << 7);
        x |= (long)((frame[1] & 0x20) << 7);
        x |= (long)((frame[1] & 0x10) << 7);
        x |= (long)((frame[1] & 8) << 7);
        x |= (long)((frame[1] & 4) << 7);
        x |= (long)((frame[1] & 2) << 7);
        x |= (long)((frame[1] & 1) << 7);
        x |= (long)(frame[2] & 0x40);
        x |= (long)(frame[2] & 0x20);
        x |= (long)(frame[2] & 0x10);
        x |= (long)(frame[2] & 8);
        x |= (long)(frame[2] & 4);
        x |= (long)(frame[2] & 2);
        x |= (long)(frame[2] & 1);
        long y = 0L;
        y |= (long)((frame[3] & 2) << 14);
        y |= (long)((frame[3] & 1) << 14);
        y |= (long)((frame[4] & 0x40) << 7);
        y |= (long)((frame[4] & 0x20) << 7);
        y |= (long)((frame[4] & 0x10) << 7);
        y |= (long)((frame[4] & 8) << 7);
        y |= (long)((frame[4] & 4) << 7);
        y |= (long)((frame[4] & 2) << 7);
        y |= (long)((frame[4] & 1) << 7);
        y |= (long)(frame[5] & 0x40);
        y |= (long)(frame[5] & 0x20);
        y |= (long)(frame[5] & 0x10);
        y |= (long)(frame[5] & 8);
        y |= (long)(frame[5] & 4);
        y |= (long)(frame[5] & 2);
        return new IPDigitizerEvent(x, y |= (long)(frame[5] & 1), 1000, cursor);
    }

    @Override
    public String getDescription() {
        return "Generic Roll-Up";
    }
}

