/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.digitizer;

import java.util.Vector;
import se.sjobeck.digitizer.DigitizerEvent;
import se.sjobeck.digitizer.DigitizerEventListener;
import se.sjobeck.digitizer.ReaderThread;
import se.sjobeck.digitizer.TestSerialPorts;
import se.sjobeck.digitizer.TestUSB;

public class DigitizerDriver {
    private Vector<DigitizerEventListener> listeners = new Vector();
    private ReaderThread readerThread = TestUSB.getReaderThread();
    private String digitizerDescription = null;
    private static DigitizerDriver ob = null;

    public DigitizerDriver() {
        if (this.readerThread == null) {
            this.readerThread = TestSerialPorts.getReaderThread();
        }
        if (this.readerThread == null) {
            System.out.println("No digitizers found!!!");
        } else if (!this.readerThread.isAlive()) {
            this.readerThread.setDaemon(true);
            this.readerThread.start();
        }
    }

    private void relayEvent(DigitizerEvent ev) {
        if (ev != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).handleEvent(ev);
            }
        }
    }

    protected static void postEvent(DigitizerEvent ev) {
        DigitizerDriver.getInstance().relayEvent(ev);
    }

    private static DigitizerDriver getInstance() {
        if (ob == null) {
            ob = new DigitizerDriver();
        }
        return ob;
    }

    public static void addDigitizerEventListener(DigitizerEventListener listener) {
        DigitizerDriver.getInstance().listeners.add(listener);
    }

    public static void removeDigitizerEventListener(DigitizerEventListener listener) {
        DigitizerDriver.getInstance().listeners.remove(listener);
    }

    public static boolean digitizerIsConnected() {
        return DigitizerDriver.getInstance().readerThread != null;
    }

    public static String getDescriptor() {
        return DigitizerDriver.getInstance().readerThread.getDescription();
    }
}

