/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures.kalkylering;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import se.sjobeck.database.Database;
import se.sjobeck.datastructures.DimStruct;
import se.sjobeck.datastructures.TlgStruct;
import se.sjobeck.datastructures.kalkylering.AckordsPunkt;
import se.sjobeck.datastructures.kalkylering.Behandling;
import se.sjobeck.datastructures.kalkylering.BehandlingsTyp;
import se.sjobeck.datastructures.kalkylering.Byggdel;
import se.sjobeck.datastructures.kalkylering.PrisStruct;
import se.sjobeck.datastructures.kalkylering.ProjektInfo;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.datastructures.kalkylering.RowHandlerStrategy;

public class RadHanterare {
    private Map<RadStruct, PrisStruct> prisInfo;
    private Map<String, String> produktNamn;
    private ProjektInfo currentProject;

    public RadHanterare(ProjektInfo p) {
        this.currentProject = p;
        this.prisInfo = new ConcurrentHashMap<RadStruct, PrisStruct>();
    }

    public void conditionsChanged() {
        this.prisInfo.clear();
    }

    public void pricesChanged() {
        this.prisInfo.clear();
    }

    public void forceRecalculate(RadStruct rad) {
        this.prisInfo.remove(rad);
    }

    private PrisStruct getPrisStruct(RadStruct r) {
        PrisStruct ps = this.prisInfo.get(r);
        if (ps == null) {
            ps = new PrisStruct();
            this.uppdateraPris(r, ps);
            this.prisInfo.put(r.copy(), ps);
        }
        return ps;
    }

    public double getPrisPerEnh(RadStruct r) {
        return this.getPrisStruct(r).getPrisPerEnh();
    }

    public double getTidPerEnh(RadStruct r) {
        return this.getPrisStruct(r).getTidPerEnh();
    }

    public double getVinstPerEnh(RadStruct r) {
        return this.getPrisStruct(r).getVinstPerEnh();
    }

    public double getMaterialPerEnh(RadStruct r) {
        return this.getPrisStruct(r).getMaterialPerEnh();
    }

    public Map<String, Double> getMaterialLista(RadStruct r) {
        return this.getPrisStruct(r).getMaterial();
    }

    public double getArbetskostnadPerEnh(RadStruct r) {
        return this.getPrisStruct(r).getArbskostPerEnh();
    }

    public double getFastaKostnaderPerEnh(RadStruct r) {
        return this.getPrisStruct(r).getFastkostPerEnh();
    }

    public static String getAmaKod(RadStruct b) {
        if (b.getBehKod() != null) {
            return b.getBehKod();
        }
        String behKod = "";
        behKod = b.getUnderlagID() != null ? b.getUnderlagID() : "#";
        behKod = b.getYtmaterialID() != null ? behKod + b.getYtmaterialID() + " - " : behKod + "# - ";
        behKod = b.getF\u00f6rbehandlingID() != null ? behKod + b.getF\u00f6rbehandlingID() + " " : behKod + "## ";
        behKod = b.getUnderbehandlingID() != null ? behKod + b.getUnderbehandlingID() + " " : behKod + "## ";
        behKod = b.getF\u00e4rdigbehandlingID() != null ? behKod + b.getF\u00e4rdigbehandlingID() + " " : behKod + "## ";
        return behKod;
    }

    public String getEnhet(RadStruct currentRow, RowHandlerStrategy rhs) {
        return rhs.getEnhetFromRow(currentRow, this.currentProject);
    }

    public static void setDefaults(RadStruct blad) {
        blad.setByggdel(Byggdel.\u00d6vriga);
        blad.setDescription(Byggdel.\u00d6vriga.getDefaultBeskrivning());
        blad.setDim(new DimStruct("0", "Enl AMA", null, null, 1.0, 1.0));
        blad.setF\u00e4rdigbehandlingID(null);
        blad.setUnderbehandlingID(null);
        blad.setF\u00f6rbehandlingID(null);
        blad.setUnderlagID("0");
        blad.setYtmaterialID("0");
        blad.setProduktKod(null);
        blad.setAntalEnh(1.0);
        blad.setAntalFormel("1");
        blad.setKulor(null);
    }

    public synchronized double raknaUtBehandling(Behandling behandling, RadStruct rad) {
        if (behandling != null) {
            AckordsPunkt tlg_ackpunkt;
            Database db = this.currentProject.getDatabaseInstance();
            double ackpris = behandling.getAckpris();
            Map<String, Double> behandling_ap = behandling.getAckordspunkter();
            TlgStruct[] tillagg = rad.getTillagg();
            TlgStruct[] globala_tlg = this.currentProject.getGlobalaTillagg();
            double _procent = 1.0;
            for (TlgStruct radTlg : tillagg) {
                tlg_ackpunkt = db.getAckordsPunkt(radTlg.getAckpunkt());
                if (!tlg_ackpunkt.getEnhet().equals("%a") && !tlg_ackpunkt.getEnhet().equals("%k")) continue;
                Vector<String> sieve = radTlg.getSieve();
                if (!sieve.isEmpty()) {
                    for (String tlg_sieve : sieve) {
                        for (String behandlingsAckordsPunkt : behandling_ap.keySet()) {
                            if (!tlg_sieve.equals(behandlingsAckordsPunkt)) continue;
                            AckordsPunkt be_ap = db.getAckordsPunkt(behandlingsAckordsPunkt);
                            double antal = behandling_ap.get(behandlingsAckordsPunkt);
                            ackpris += be_ap.getPris() * tlg_ackpunkt.getPris() * 0.01 * antal;
                        }
                    }
                    continue;
                }
                _procent *= 1.0 + tlg_ackpunkt.getPris() * 0.01;
            }
            ackpris *= _procent;
            for (TlgStruct globTlg : globala_tlg) {
                tlg_ackpunkt = db.getAckordsPunkt(globTlg.getAckpunkt());
                if (tlg_ackpunkt == null) continue;
                ackpris += ackpris * tlg_ackpunkt.getPris() * 0.01;
            }
            return ackpris;
        }
        return 0.0;
    }

    private void uppdateraPris(RadStruct rad, PrisStruct pris) {
        TlgStruct[] globala_tlg;
        Logger.getLogger("se.sjobeck").entering("RadHanterare", "uppdateraPris", rad);
        double ackpris = 0.0;
        double matpris = 0.0;
        if (rad.getBehKod() != null) {
            ackpris = this.currentProject.getCustomAckpris(rad.getBehKod());
            matpris = this.currentProject.getCustomMatpris(rad.getBehKod());
        } else {
            Behandling f\u00f6rbehandling = this.currentProject.getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00f6rbehandling, rad);
            Behandling underbehandling = this.currentProject.getDatabaseInstance().getBehandling(BehandlingsTyp.Underbehandling, rad);
            Behandling f\u00e4rdigbehandling = this.currentProject.getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00e4rdigbehandling, rad);
            ackpris += this.raknaUtBehandling(f\u00f6rbehandling, rad);
            ackpris += this.raknaUtBehandling(underbehandling, rad);
            ackpris += this.raknaUtBehandling(f\u00e4rdigbehandling, rad);
            matpris = this.getMaterialPris(rad, pris);
        }
        if (rad.getDim() != null) {
            ackpris = ackpris * rad.getDim().getAckMod() + rad.getDim().getMiscSum();
            matpris *= rad.getDim().getMtrlMod();
        }
        double t_procent = 1.0;
        for (TlgStruct ts : globala_tlg = this.currentProject.getGlobalaTillagg()) {
            if (!ts.isProcent()) continue;
            t_procent *= 1.0 + ts.getPris() * 0.01;
        }
        TlgStruct[] ts = rad.getTillagg();
        double t212_213_214 = 0.0;
        for (int i = 0; i < ts.length; ++i) {
            if (!ts[i].isProcent()) {
                t212_213_214 += ts[i].getPris();
                continue;
            }
            if (!ts[i].getSieve().isEmpty()) continue;
            t_procent *= 1.0 + ts[i].getPris() * 0.01;
        }
        ackpris += t212_213_214 * t_procent;
        ackpris *= this.currentProject.getAckprisProcent();
        double d = this.currentProject.getTimprisStruct().getMatpristlg();
        matpris *= 1.0 + d / 100.0;
        double antal = rad.getAntalEnh();
        double egenTid = this.currentProject.getEgenTid(rad);
        double tidPerEnh = egenTid > 0.0 ? egenTid : (ackpris *= 1.0 + this.currentProject.getTimprisStruct().getTidlonPct() / 100.0) / this.currentProject.getTimprisStruct().getTimlon();
        double arbetskostnad = tidPerEnh * this.currentProject.getTimprisStruct().getArbskostSumma();
        double fastakostnader = tidPerEnh * this.currentProject.getTimprisStruct().getFastkostSumma();
        pris.setFastkostPerEnh(fastakostnader);
        pris.setArbskostPerEnh(arbetskostnad);
        pris.setMaterialPerEnh(matpris);
        pris.setPrisPerEnh(1.0 / (1.0 - this.currentProject.getTimprisStruct().getVinst() * 0.01) * (matpris + arbetskostnad + fastakostnader + this.currentProject.getTimprisStruct().getResorochtraktamente() * tidPerEnh));
        pris.setVinstPerEnh(pris.getPrisPerEnh() - pris.getArbskostPerEnh() - pris.getFastkostPerEnh() - pris.getMaterialPerEnh() - this.currentProject.getTimprisStruct().getResorochtraktamente() * tidPerEnh);
        pris.setTidPerEnh(tidPerEnh);
        Logger.getLogger("se.sjobeck").exiting("RadHanterare", "uppdateraPris");
    }

    public String getProduktNamn(RadStruct rad) {
        if (rad.getProduktKod() == null) {
            return "";
        }
        return this.currentProject.getDatabaseInstance().getProduktNamn(this.currentProject.getFabrikat(), rad.getProduktKod());
    }

    private double getMaterialPris(RadStruct rad, PrisStruct ps) {
        String fabrikat = this.currentProject.getFabrikat().getDBAlias();
        HashMap<String, Double> allaMaterial = new HashMap<String, Double>();
        this.buildMtrlTable(allaMaterial, this.currentProject.getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00f6rbehandling, rad));
        this.buildMtrlTable(allaMaterial, this.currentProject.getDatabaseInstance().getBehandling(BehandlingsTyp.Underbehandling, rad));
        this.buildMtrlTable(allaMaterial, this.currentProject.getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00e4rdigbehandling, rad));
        if (rad.getProduktKod() != null) {
            double antal_f = 0.0;
            if (allaMaterial.containsKey("__f")) {
                antal_f = allaMaterial.get("__f");
            }
            double antal_1 = 0.0;
            if (allaMaterial.containsKey("__1")) {
                antal_1 = allaMaterial.get("__1");
            }
            double antal_2 = 0.0;
            if (allaMaterial.containsKey("__2")) {
                antal_2 = allaMaterial.get("__2");
            }
            allaMaterial.remove("__f");
            allaMaterial.remove("__1");
            allaMaterial.remove("__2");
            String mm = this.currentProject.getDatabaseInstance().getMellanm\u00e5lning(rad.getProduktKod());
            String gm = this.currentProject.getDatabaseInstance().getGrundm\u00e5lning(rad.getProduktKod());
            if (gm != null && mm != null && gm.equals(mm)) {
                allaMaterial.put(gm, antal_1 + antal_2);
            } else {
                if (mm != null) {
                    allaMaterial.put(mm, antal_1);
                } else {
                    antal_f += antal_1;
                }
                if (gm != null) {
                    allaMaterial.put(gm, antal_2);
                } else {
                    antal_f += antal_2;
                }
            }
            allaMaterial.put(rad.getProduktKod(), antal_f);
        }
        ps.setMaterial(allaMaterial);
        double materialpris = 0.0;
        for (String key : allaMaterial.keySet()) {
            materialpris += allaMaterial.get(key) * this.currentProject.getDatabaseInstance().getProduktPris(this.currentProject.getFabrikat(), key);
        }
        return materialpris;
    }

    private void buildMtrlTable(Map<String, Double> allaMaterial, Behandling behandling) {
        if (behandling == null) {
            return;
        }
        Map<String, Double> map = behandling.getMaterial().get((Object)this.currentProject.getFabrikat());
        for (Map.Entry<String, Double> e : map.entrySet()) {
            if (allaMaterial.containsKey(e.getKey())) {
                double antal = allaMaterial.get(e.getKey());
                allaMaterial.put(e.getKey(), e.getValue() + antal);
                continue;
            }
            allaMaterial.put(e.getKey(), e.getValue());
        }
    }
}

