/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.database;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import se.sjobeck.datastructures.DimStruct;
import se.sjobeck.datastructures.TlgStruct;
import se.sjobeck.datastructures.kalkylering.AckordsPunkt;
import se.sjobeck.datastructures.kalkylering.ArbetsTyp;
import se.sjobeck.datastructures.kalkylering.Behandling;
import se.sjobeck.datastructures.kalkylering.BehandlingsAttribut;
import se.sjobeck.datastructures.kalkylering.BehandlingsTyp;
import se.sjobeck.datastructures.kalkylering.Byggdel;
import se.sjobeck.datastructures.kalkylering.Fabrikat;
import se.sjobeck.datastructures.kalkylering.Produkt;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.datastructures.kalkylering.TillaggsKategori;
import se.sjobeck.datastructures.kalkylering.Underlag;
import se.sjobeck.datastructures.kalkylering.Ytmaterial;
import se.sjobeck.network2.ClientThread;
import se.sjobeck.network2.FromServerMessage;
import se.sjobeck.network2.Message;

public class Database {
    protected List<DimStruct> dimensioner;
    protected double restidKrPerKm;
    protected double reskostnadKrPerKm;
    protected double helgl\u00f6n;
    protected double arbetstidsF\u00f6rkortning;
    protected double sjukl\u00f6n;
    protected double internaL\u00f6neBikostnader;
    protected double semesterL\u00f6n;
    protected double arbetsgivarAvgift;
    protected double l\u00f6neskatt;
    protected double mkaAvgift;
    protected double m\u00e4tavgift;
    protected Map<Fabrikat, List<Produkt>> produktTabell;
    protected Map<String, String> korstabell_1;
    protected Map<String, String> korstabell_2;
    protected transient Map<ArbetsTyp, Map<Byggdel, Map<Underlag, Map<Ytmaterial, Map<BehandlingsTyp, List<Behandling>>>>>> behandlingsTabell;
    protected Map<BehandlingsAttribut, Behandling> attributTabell;
    protected Map<String, Ytmaterial> allaYtmaterial;
    protected Map<String, Underlag> allaUnderlag;
    protected Map<String, AckordsPunkt> allaAckordsPunkter;
    protected List<TlgStruct> procentA;
    protected Map<String, List<TlgStruct>> till\u00e4ggsTabell;
    protected Map<String, List<List<TlgStruct>>> byggdelsTabell;
    protected Map<String, List<List<TlgStruct>>> inomhusTabell;
    protected Map<String, List<List<TlgStruct>>> utomhusTabell;
    private static Map<Long, Database> dbMap = new TreeMap<Long, Database>();
    private static long today = -1L;

    public static Database getLatest() {
        if (today == -1L) {
            today = ((FromServerMessage)ClientThread.sendMessage(Message.LookupDatabaseDate, Long.MAX_VALUE)).getLong();
        }
        return Database.getInstance(today);
    }

    public static Database getInstance(byte[] rawData) {
        Database db = null;
        try {
            db = (Database)Database.setupXStream().fromXML((InputStream)new GZIPInputStream(new ByteArrayInputStream(rawData)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (db != null);
        return db;
    }

    public static Database getInstance(long date) {
        Database d = dbMap.get(date);
        if (d == null) {
            Logger log = Logger.getLogger("se.sjobeck.database.Database");
            log.info("H\u00e4mtar databas...");
            long time = System.currentTimeMillis();
            byte[] rawData = ((FromServerMessage)ClientThread.sendMessage(Message.FetchDatabase, date)).getByteArray();
            d = Database.getInstance(rawData);
            dbMap.put(date, d);
            time = System.currentTimeMillis() - time;
            log.finest("Klar p\u00e5 " + time + " ms!");
            log.info("Klar.");
        }
        return d;
    }

    private Object readResolve() {
        Logger log = Logger.getLogger("se.sjobeck.database.Database");
        log.info("Rekonstruerar behandlingslistor...");
        this.behandlingsTabell = new TreeMap<ArbetsTyp, Map<Byggdel, Map<Underlag, Map<Ytmaterial, Map<BehandlingsTyp, List<Behandling>>>>>>();
        for (Map.Entry<BehandlingsAttribut, Behandling> entry : this.attributTabell.entrySet()) {
            log.finest("Behandlar " + entry.getKey());
            for (Underlag u : this.allaUnderlag.values()) {
                assert (u != null);
                for (Ytmaterial yt : this.allaYtmaterial.values()) {
                    assert (yt != null);
                    if (!entry.getKey().getGrupp().contains("," + u.getId() + yt.getId() + ",")) continue;
                    Database.insertValue(this.behandlingsTabell, ArbetsTyp.Egalt, entry.getKey().getByggdel(), u, yt, entry.getKey().getBehandlingsTyp(), entry.getValue());
                }
            }
        }
        for (ArbetsTyp typ : this.behandlingsTabell.keySet()) {
            for (Underlag u : this.behandlingsTabell.get((Object)typ).get((Object)Byggdel.\u00d6vriga).keySet()) {
                for (Ytmaterial yt : this.behandlingsTabell.get((Object)typ).get((Object)Byggdel.\u00d6vriga).get(u).keySet()) {
                    for (BehandlingsTyp bTyp : this.behandlingsTabell.get((Object)typ).get((Object)Byggdel.\u00d6vriga).get(u).get(yt).keySet()) {
                        for (Behandling beh : this.behandlingsTabell.get((Object)typ).get((Object)Byggdel.\u00d6vriga).get(u).get(yt).get((Object)bTyp)) {
                            block11: for (Byggdel byggdel : Byggdel.values()) {
                                switch (byggdel) {
                                    case \u00d6vriga: 
                                    case Fl\u00e4nsr\u00f6r: 
                                    case R\u00f6rledningM2: 
                                    case Radiatorer: 
                                    case Utomhus: 
                                    case R\u00f6rledningLpm: {
                                        continue block11;
                                    }
                                    default: {
                                        Database.insertValue(this.behandlingsTabell, typ, byggdel, u, yt, bTyp, beh, true, log);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        log.finest("readResolve() klar");
        return this;
    }

    private static void insertValue(Map<ArbetsTyp, Map<Byggdel, Map<Underlag, Map<Ytmaterial, Map<BehandlingsTyp, List<Behandling>>>>>> targetMap, ArbetsTyp at, Byggdel byggdel, Underlag u, Ytmaterial y, BehandlingsTyp bt, Behandling b) {
        Database.insertValue(targetMap, at, byggdel, u, y, bt, b, false, Logger.getLogger("se.sjobeck.database.Database"));
    }

    private static void insertValue(Map<ArbetsTyp, Map<Byggdel, Map<Underlag, Map<Ytmaterial, Map<BehandlingsTyp, List<Behandling>>>>>> targetMap, ArbetsTyp at, Byggdel byggdel, Underlag u, Ytmaterial y, BehandlingsTyp bt, Behandling b, boolean ignoreDuplicates, Logger log) {
        if (!targetMap.containsKey((Object)at)) {
            targetMap.put(at, new TreeMap());
        }
        if (!targetMap.get((Object)at).containsKey((Object)byggdel)) {
            targetMap.get((Object)at).put(byggdel, new TreeMap());
        }
        if (!targetMap.get((Object)at).get((Object)byggdel).containsKey(u)) {
            targetMap.get((Object)at).get((Object)byggdel).put(u, new TreeMap());
        }
        if (!targetMap.get((Object)at).get((Object)byggdel).get(u).containsKey(y)) {
            targetMap.get((Object)at).get((Object)byggdel).get(u).put(y, new TreeMap());
        }
        if (!targetMap.get((Object)at).get((Object)byggdel).get(u).get(y).containsKey((Object)bt)) {
            targetMap.get((Object)at).get((Object)byggdel).get(u).get(y).put(bt, new ArrayList());
        }
        if (targetMap.get((Object)at).get((Object)byggdel).get(u).get(y).get((Object)bt).contains(b)) {
            if (!ignoreDuplicates) {
                Behandling existing = targetMap.get((Object)at).get((Object)byggdel).get(u).get(y).get((Object)bt).get(targetMap.get((Object)at).get((Object)byggdel).get(u).get(y).get((Object)bt).indexOf(b));
                log.warning("Anm\u00e4rkning: " + (Object)((Object)at) + "." + (Object)((Object)byggdel) + "." + u.getId() + "." + y.getId() + "." + (Object)((Object)bt) + ", behandlingen " + b + " finns redan");
                targetMap.get((Object)at).get((Object)byggdel).get(u).get(y).get((Object)bt).add(b);
            }
        } else {
            targetMap.get((Object)at).get((Object)byggdel).get(u).get(y).get((Object)bt).add(b);
        }
        Collections.sort(targetMap.get((Object)at).get((Object)byggdel).get(u).get(y).get((Object)bt));
    }

    protected static XStream setupXStream() {
        XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
        stream.alias("db", Database.class);
        stream.alias("b", Behandling.class);
        stream.alias("dim", DimStruct.class);
        stream.alias("b_typ", BehandlingsTyp.class);
        stream.alias("a_typ", ArbetsTyp.class);
        stream.alias("t_kat", TillaggsKategori.class);
        stream.alias("Ytmaterial", Ytmaterial.class);
        stream.alias("Underlag", Underlag.class);
        stream.alias("Produkt", Produkt.class);
        stream.alias("Attribut", BehandlingsAttribut.class);
        stream.setMode(1002);
        return stream;
    }

    protected Database() {
    }

    public List<DimStruct> getDimensioner() {
        return this.dimensioner;
    }

    public double getRestidKrPerKm() {
        return this.restidKrPerKm;
    }

    public double getReskostnadKrPerKm() {
        return this.reskostnadKrPerKm;
    }

    public double getHelgl\u00f6n() {
        return this.helgl\u00f6n;
    }

    public double getArbetstidsF\u00f6rkortning() {
        return this.arbetstidsF\u00f6rkortning;
    }

    public double getSjukl\u00f6n() {
        return this.sjukl\u00f6n;
    }

    public double getInternaL\u00f6neBikostnader() {
        return this.internaL\u00f6neBikostnader;
    }

    public double getSemesterL\u00f6n() {
        return this.semesterL\u00f6n;
    }

    public double getArbetsgivarAvgift() {
        return this.arbetsgivarAvgift;
    }

    public double getL\u00f6neskatt() {
        return this.l\u00f6neskatt;
    }

    public double getMkaAvgift() {
        return this.mkaAvgift;
    }

    public double getM\u00e4tavgift() {
        return this.m\u00e4tavgift;
    }

    public List<TlgStruct> getProcentA() {
        return this.procentA;
    }

    public Map<String, List<List<TlgStruct>>> getByggdelsTabell() {
        return this.byggdelsTabell;
    }

    public Map<String, List<List<TlgStruct>>> getInomhusTabell() {
        return this.inomhusTabell;
    }

    public Map<String, List<List<TlgStruct>>> getUtomhusTabell() {
        return this.utomhusTabell;
    }

    public Map<String, List<TlgStruct>> getTill\u00e4ggsTabell() {
        return this.till\u00e4ggsTabell;
    }

    public TlgStruct getTill\u00e4gg(String key) {
        for (List<TlgStruct> list : this.till\u00e4ggsTabell.values()) {
            for (TlgStruct tlg : list) {
                if (!tlg.getAckpunkt().trim().equalsIgnoreCase(key.trim())) continue;
                return tlg;
            }
        }
        for (TlgStruct tlgStruct : this.procentA) {
            if (!tlgStruct.getAckpunkt().trim().equalsIgnoreCase(key.trim())) continue;
            return tlgStruct;
        }
        for (List list : this.byggdelsTabell.values()) {
            for (List list1 : list) {
                for (TlgStruct tlg : list1) {
                    if (!tlg.getAckpunkt().trim().equalsIgnoreCase(key.trim())) continue;
                    return tlg;
                }
            }
        }
        for (List list : this.inomhusTabell.values()) {
            for (List list1 : list) {
                for (TlgStruct tlg : list1) {
                    if (!tlg.getAckpunkt().trim().equalsIgnoreCase(key.trim())) continue;
                    return tlg;
                }
            }
        }
        for (List list : this.utomhusTabell.values()) {
            for (List list1 : list) {
                for (TlgStruct tlg : list1) {
                    if (!tlg.getAckpunkt().trim().equalsIgnoreCase(key.trim())) continue;
                    return tlg;
                }
            }
        }
        return null;
    }

    public Behandling getBehandling(BehandlingsTyp typ, RadStruct rad) {
        String id;
        List<Behandling> list = this.getBehandlingar(typ, rad);
        switch (typ) {
            case F\u00f6rbehandling: {
                id = rad.getF\u00f6rbehandlingID();
                break;
            }
            case Underbehandling: {
                id = rad.getUnderbehandlingID();
                break;
            }
            case F\u00e4rdigbehandling: {
                id = rad.getF\u00e4rdigbehandlingID();
                break;
            }
            default: {
                return null;
            }
        }
        for (Behandling b : list) {
            if (!b.getId().equals(id)) continue;
            return b;
        }
        return null;
    }

    public List<Behandling> getBehandlingar(BehandlingsTyp typ, RadStruct rad) {
        try {
            Underlag u = this.allaUnderlag.get(rad.getUnderlagID());
            Ytmaterial y = this.allaYtmaterial.get(rad.getYtmaterialID());
            List<Behandling> list = this.behandlingsTabell.get((Object)ArbetsTyp.Egalt).get((Object)rad.getByggdel()).get(u).get(y).get((Object)typ);
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }
        catch (NullPointerException e) {
            return Collections.emptyList();
        }
    }

    public Collection<Ytmaterial> getAllaYtmaterial() {
        return this.allaYtmaterial.values();
    }

    public Collection<Underlag> getAllaUnderlag() {
        return this.allaUnderlag.values();
    }

    public String getSelectedUnderlag(RadStruct r) {
        Collection<Underlag> us = this.getUnderlag(r);
        for (Underlag u : us) {
            if (!u.getId().equals(r.getUnderlagID())) continue;
            return u.toString();
        }
        return "Inget underlag";
    }

    public String getSelectedYtmaterial(RadStruct r) {
        Collection<Ytmaterial> ys = this.getYtmaterial(r);
        for (Ytmaterial y : ys) {
            if (!y.getId().equals(r.getYtmaterialID())) continue;
            return y.toString();
        }
        return "Inget ytmaterial";
    }

    public Collection<Underlag> getUnderlag(RadStruct r) {
        return this.behandlingsTabell.get((Object)ArbetsTyp.Egalt).get((Object)r.getByggdel()).keySet();
    }

    public Collection<Ytmaterial> getYtmaterial(RadStruct rad) {
        if (rad.getUnderlagID() == null) {
            return Collections.emptyList();
        }
        Underlag u = this.allaUnderlag.get(rad.getUnderlagID());
        if (u == null) {
            return Collections.emptyList();
        }
        if (rad.getByggdel() == null) {
            return Collections.emptyList();
        }
        try {
            return this.behandlingsTabell.get((Object)ArbetsTyp.Egalt).get((Object)rad.getByggdel()).get(u).keySet();
        }
        catch (NullPointerException e) {
            return Collections.emptyList();
        }
    }

    public List<TillaggsKategori> getTill\u00e4ggsKategorier(RadStruct rad) {
        if (rad == null || rad.getYtmaterialID() == null || this.allaYtmaterial.get(rad.getYtmaterialID()) == null) {
            return Collections.emptyList();
        }
        return this.allaYtmaterial.get(rad.getYtmaterialID()).getTill\u00e4ggsKategorier(rad.getInomhus());
    }

    public List<Produkt> getYtprodukter(RadStruct r, Fabrikat f) {
        if (r.getYtmaterialID() == null) {
            throw new IllegalArgumentException("material == null!");
        }
        List<Produkt> kandidater = this.produktTabell.get((Object)f);
        ArrayList<Produkt> ret = new ArrayList<Produkt>();
        for (Produkt p : kandidater) {
            if (p.getYtmaterial() == null || !p.getYtmaterial().equals(r.getYtmaterialID())) continue;
            if (r.getInomhus()) {
                if (!p.isInomhus() || p.getNamn().isEmpty() || p.getNamn().equals(" ")) continue;
                ret.add(p);
                continue;
            }
            if (!p.isUtomhus() || p.getNamn().isEmpty() || p.getNamn().equals(" ")) continue;
            ret.add(p);
        }
        Collections.sort(ret);
        return ret;
    }

    public boolean validYtprodukt(RadStruct rad, Fabrikat f) {
        for (Produkt p : this.getYtprodukter(rad, f)) {
            if (!p.getProduktKod().equals(rad.getProduktKod())) continue;
            return true;
        }
        return false;
    }

    public AckordsPunkt getAckordsPunkt(String id) {
        return this.allaAckordsPunkter.get(id);
    }

    public String getProduktNamn(Fabrikat f, String produktKod) {
        for (Produkt p : this.produktTabell.get((Object)f)) {
            if (!p.getProduktKod().equals(produktKod)) continue;
            return p.getNamn();
        }
        return "Ingen f\u00e4rg/tapet";
    }

    public double getProduktPris(Fabrikat f, String produktKod) {
        for (Produkt p : this.produktTabell.get((Object)f)) {
            if (!p.getProduktKod().equals(produktKod)) continue;
            return p.getPrisPerEnhet();
        }
        return 0.0;
    }

    public String getProduktEnhet(Fabrikat f, String produktKod) {
        for (Produkt p : this.produktTabell.get((Object)f)) {
            if (!p.getProduktKod().equals(produktKod)) continue;
            return p.getEnhet();
        }
        return "st";
    }

    public String getMellanm\u00e5lning(String produktKod) {
        return this.korstabell_1.get(produktKod);
    }

    public String getGrundm\u00e5lning(String produktKod) {
        return this.korstabell_2.get(produktKod);
    }
}

