/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util.content;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.graphics.GlyphOutlineClip;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.ImageReference;
import org.icepdf.core.pobjects.graphics.ImageReferenceFactory;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.commands.DrawCmd;
import org.icepdf.core.pobjects.graphics.commands.GlyphOutlineDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ImageDrawCmd;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.content.AbstractContentParser;
import org.icepdf.core.util.content.ContentParser;
import org.icepdf.core.util.content.TextMetrics;
import org.icepdf.core.util.content.a;

public class NContentParser
extends AbstractContentParser {
    private static final Logger logger = Logger.getLogger(NContentParser.class.toString());

    public NContentParser(Library library, Resources resources) {
        super(library, resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentParser parse(byte[][] byArray) {
        if (this.shapes == null) {
            this.shapes = new Shapes();
            if (this.graphicState == null) {
                this.graphicState = new GraphicsState(this.shapes);
            } else {
                this.graphicState.setCTM(new AffineTransform());
                this.graphicState.setClip(null);
                NContentParser.setStroke((Shapes)this.shapes, (GraphicsState)this.graphicState);
                this.graphicState.setShapes(this.shapes);
            }
        }
        if (this.oCGs == null && this.library.getCatalog() != null && this.library.getCatalog().getOptionalContent() != null) {
            this.oCGs = new LinkedList();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.fine("Parsing page content streams: " + byArray.length);
            for (Object object : (a)byArray) {
                if (object == null) continue;
                String string = new String((byte[])object, "ISO-8859-1");
                logger.finer("Content = " + string);
            }
        }
        a a2 = new a();
        a2.a(byArray);
        float f2 = 0.0f;
        try {
            Object object;
            block75: while ((object = a2.a()) != null) {
                if (!(object instanceof Integer)) {
                    this.stack.push(object);
                    continue;
                }
                int n2 = (Integer)object;
                switch (n2) {
                    case 2: {
                        this.geometricPath = NContentParser.consume_L((Stack)this.stack, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 1: {
                        this.geometricPath = NContentParser.consume_m((Stack)this.stack, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 3: {
                        this.geometricPath = NContentParser.consume_c((Stack)this.stack, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 8: {
                        this.geometricPath = NContentParser.consume_S((GraphicsState)this.graphicState, (Shapes)this.shapes, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 46: {
                        NContentParser.consume_Tf((GraphicsState)this.graphicState, (Stack)this.stack, (Resources)this.resources);
                        break;
                    }
                    case 32: {
                        try {
                            f2 = this.parseText(a2, this.shapes, f2);
                        }
                        catch (Exception exception) {
                            logger.log(Level.FINEST, "Error parsing text block", exception);
                        }
                        continue block75;
                    }
                    case 11: {
                        this.geometricPath = NContentParser.consume_F((GraphicsState)this.graphicState, (Shapes)this.shapes, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 10: {
                        this.geometricPath = NContentParser.consume_f((GraphicsState)this.graphicState, (Shapes)this.shapes, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 61: {
                        this.graphicState = NContentParser.consume_q((GraphicsState)this.graphicState);
                        break;
                    }
                    case 62: {
                        this.graphicState = this.consume_Q(this.graphicState, this.shapes);
                        break;
                    }
                    case 7: {
                        this.geometricPath = NContentParser.consume_re((Stack)this.stack, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 63: {
                        NContentParser.consume_cm((GraphicsState)this.graphicState, (Stack)this.stack, (boolean)this.inTextBlock, (AffineTransform)this.textBlockBase);
                        break;
                    }
                    case 6: {
                        NContentParser.consume_h((GeneralPath)this.geometricPath);
                        break;
                    }
                    case 23: {
                        NContentParser.consume_BDC((Stack)this.stack, (Shapes)this.shapes, (LinkedList)this.oCGs, (Resources)this.resources);
                        break;
                    }
                    case 25: {
                        NContentParser.consume_EMC((Shapes)this.shapes, (LinkedList)this.oCGs);
                        break;
                    }
                    case 24: {
                        NContentParser.consume_BMC((Stack)this.stack, (Shapes)this.shapes, (LinkedList)this.oCGs, (Resources)this.resources);
                        break;
                    }
                    case 17: {
                        this.graphicState = NContentParser.consume_Do((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)this.shapes, (Resources)this.resources, (boolean)true);
                        break;
                    }
                    case 12: {
                        this.geometricPath = NContentParser.consume_f_star((GraphicsState)this.graphicState, (Shapes)this.shapes, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 71: {
                        NContentParser.consume_gs((GraphicsState)this.graphicState, (Stack)this.stack, (Resources)this.resources);
                        break;
                    }
                    case 18: {
                        this.geometricPath = NContentParser.consume_n((GeneralPath)this.geometricPath);
                        break;
                    }
                    case 68: {
                        NContentParser.consume_w((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)this.shapes, (float)this.glyph2UserSpaceScale);
                        break;
                    }
                    case 69: {
                        NContentParser.consume_w((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)this.shapes, (float)this.glyph2UserSpaceScale);
                        break;
                    }
                    case 19: {
                        NContentParser.consume_W((GraphicsState)this.graphicState, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 59: {
                        NContentParser.consume_sc((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library, (Resources)this.resources, (boolean)false);
                        break;
                    }
                    case 60: {
                        NContentParser.consume_sc((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library, (Resources)this.resources, (boolean)true);
                        break;
                    }
                    case 14: {
                        this.geometricPath = NContentParser.consume_b((GraphicsState)this.graphicState, (Shapes)this.shapes, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 54: {
                        NContentParser.consume_k((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library);
                        break;
                    }
                    case 50: {
                        NContentParser.consume_g((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library);
                        break;
                    }
                    case 64: {
                        NContentParser.consume_i((Stack)this.stack);
                        break;
                    }
                    case 70: {
                        NContentParser.consume_M((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)this.shapes);
                        break;
                    }
                    case 65: {
                        NContentParser.consume_J((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)this.shapes);
                        break;
                    }
                    case 52: {
                        NContentParser.consume_rg((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library);
                        break;
                    }
                    case 67: {
                        NContentParser.consume_d((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)this.shapes);
                        break;
                    }
                    case 4: {
                        NContentParser.consume_v((Stack)this.stack, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 66: {
                        NContentParser.consume_j((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)this.shapes);
                        break;
                    }
                    case 5: {
                        NContentParser.consume_y((Stack)this.stack, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 56: {
                        NContentParser.consume_cs((GraphicsState)this.graphicState, (Stack)this.stack, (Resources)this.resources);
                        break;
                    }
                    case 28: {
                        this.stack.pop();
                        break;
                    }
                    case 57: {
                        NContentParser.consume_SC((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library, (Resources)this.resources, (boolean)false);
                        break;
                    }
                    case 58: {
                        NContentParser.consume_SC((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library, (Resources)this.resources, (boolean)true);
                        break;
                    }
                    case 13: {
                        this.geometricPath = NContentParser.consume_B((GraphicsState)this.graphicState, (Shapes)this.shapes, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 53: {
                        NContentParser.consume_K((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library);
                        break;
                    }
                    case 30: {
                        this.graphicState = NContentParser.consume_d0((GraphicsState)this.graphicState, (Stack)this.stack);
                        break;
                    }
                    case 9: {
                        this.geometricPath = NContentParser.consume_s((GraphicsState)this.graphicState, (Shapes)this.shapes, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 49: {
                        NContentParser.consume_G((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library);
                        break;
                    }
                    case 16: {
                        this.geometricPath = NContentParser.consume_b_star((GraphicsState)this.graphicState, (Shapes)this.shapes, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 51: {
                        NContentParser.consume_RG((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library);
                        break;
                    }
                    case 55: {
                        NContentParser.consume_CS((GraphicsState)this.graphicState, (Stack)this.stack, (Resources)this.resources);
                        break;
                    }
                    case 31: {
                        this.graphicState = NContentParser.consume_d1((GraphicsState)this.graphicState, (Stack)this.stack);
                        break;
                    }
                    case 15: {
                        this.geometricPath = NContentParser.consume_B_star((GraphicsState)this.graphicState, (Shapes)this.shapes, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 72: {
                        this.parseInlineImage(a2, this.shapes);
                        break;
                    }
                    case 21: {
                        break;
                    }
                    case 22: {
                        break;
                    }
                    case 20: {
                        NContentParser.consume_W_star((GraphicsState)this.graphicState, (GeneralPath)this.geometricPath);
                        break;
                    }
                    case 26: {
                        NContentParser.consume_DP((Stack)this.stack);
                        break;
                    }
                    case 27: {
                        NContentParser.consume_MP((Stack)this.stack);
                        break;
                    }
                    case 29: {
                        NContentParser.consume_sh((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)this.shapes, (Resources)this.resources);
                        break;
                    }
                    case 39: {
                        NContentParser.consume_Tc((GraphicsState)this.graphicState, (Stack)this.stack);
                        break;
                    }
                    case 41: {
                        NContentParser.consume_Tw((GraphicsState)this.graphicState, (Stack)this.stack);
                        break;
                    }
                    case 43: {
                        NContentParser.consume_TL((GraphicsState)this.graphicState, (Stack)this.stack);
                        break;
                    }
                    case 42: {
                        NContentParser.consume_Tr((GraphicsState)this.graphicState, (Stack)this.stack);
                        break;
                    }
                    case 40: {
                        NContentParser.consume_Tz((GraphicsState)this.graphicState, (Stack)this.stack);
                        break;
                    }
                    case 44: {
                        NContentParser.consume_Ts((GraphicsState)this.graphicState, (Stack)this.stack);
                    }
                }
            }
        }
        catch (IOException iOException) {
            logger.finer("End of Content Stream");
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Error parsing content stream. ", throwable);
        }
        finally {
            NContentParser.setAlpha((Shapes)this.shapes, (int)3, (float)1.0f);
        }
        return this;
    }

    public Shapes parseTextBlocks(byte[][] byArray) {
        a a2 = new a();
        a2.a(byArray);
        Shapes shapes = new Shapes();
        if (this.graphicState == null) {
            this.graphicState = new GraphicsState(shapes);
        }
        try {
            Object object = a2.a();
            Stack<Object> stack = new Stack<Object>();
            double d2 = 0.0;
            while (object != null) {
                if (object instanceof Integer) {
                    int n2 = (Integer)object;
                    switch (n2) {
                        case 32: {
                            d2 = this.parseText(a2, shapes, d2);
                            stack.clear();
                            break;
                        }
                        case 46: {
                            NContentParser.consume_Tf((GraphicsState)this.graphicState, stack, (Resources)this.resources);
                            stack.clear();
                            break;
                        }
                        case 17: {
                            NContentParser.consume_Do((GraphicsState)this.graphicState, stack, (Shapes)shapes, (Resources)this.resources, (boolean)false);
                            stack.clear();
                            break;
                        }
                        case 72: {
                            this.parseInlineImage(a2, shapes);
                        }
                    }
                } else {
                    stack.push(object);
                }
                object = a2.a();
            }
            stack.clear();
        }
        catch (IOException iOException) {
            logger.finer("End of Content Stream");
        }
        shapes.contract();
        return shapes;
    }

    private float parseText(a a2, Shapes shapes, double d2) {
        this.inTextBlock = true;
        TextMetrics textMetrics = new TextMetrics();
        this.textBlockBase = new AffineTransform(this.graphicState.getCTM());
        this.graphicState.getTextState().tmatrix = new AffineTransform();
        this.graphicState.getTextState().tlmatrix = new AffineTransform();
        this.graphicState.scale(1.0, -1.0);
        PageText pageText = shapes.getPageText();
        GlyphOutlineClip glyphOutlineClip = new GlyphOutlineClip();
        Object object = a2.a();
        while (!(object instanceof Integer) || (Integer)object != 33) {
            if (object instanceof Integer) {
                int n2 = (Integer)object;
                switch (n2) {
                    case 38: {
                        NContentParser.consume_Tj((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)shapes, (TextMetrics)textMetrics, (GlyphOutlineClip)glyphOutlineClip, (LinkedList)this.oCGs);
                        break;
                    }
                    case 39: {
                        NContentParser.consume_Tc((GraphicsState)this.graphicState, (Stack)this.stack);
                        break;
                    }
                    case 41: {
                        NContentParser.consume_Tw((GraphicsState)this.graphicState, (Stack)this.stack);
                        break;
                    }
                    case 35: {
                        NContentParser.consume_Td((GraphicsState)this.graphicState, (Stack)this.stack, (TextMetrics)textMetrics, (PageText)pageText, (double)d2, (LinkedList)this.oCGs);
                        break;
                    }
                    case 34: {
                        NContentParser.consume_tm((GraphicsState)this.graphicState, (Stack)this.stack, (TextMetrics)textMetrics, (PageText)pageText, (double)d2, (AffineTransform)this.textBlockBase, (LinkedList)this.oCGs);
                        break;
                    }
                    case 46: {
                        NContentParser.consume_Tf((GraphicsState)this.graphicState, (Stack)this.stack, (Resources)this.resources);
                        break;
                    }
                    case 45: {
                        NContentParser.consume_TJ((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)shapes, (TextMetrics)textMetrics, (GlyphOutlineClip)glyphOutlineClip, (LinkedList)this.oCGs);
                        break;
                    }
                    case 36: {
                        NContentParser.consume_TD((GraphicsState)this.graphicState, (Stack)this.stack, (TextMetrics)textMetrics, (PageText)pageText, (LinkedList)this.oCGs);
                        break;
                    }
                    case 43: {
                        NContentParser.consume_TL((GraphicsState)this.graphicState, (Stack)this.stack);
                        break;
                    }
                    case 61: {
                        this.graphicState = NContentParser.consume_q((GraphicsState)this.graphicState);
                        break;
                    }
                    case 62: {
                        this.graphicState = this.consume_Q(this.graphicState, shapes);
                        break;
                    }
                    case 63: {
                        NContentParser.consume_cm((GraphicsState)this.graphicState, (Stack)this.stack, (boolean)this.inTextBlock, (AffineTransform)this.textBlockBase);
                        break;
                    }
                    case 37: {
                        NContentParser.consume_T_star((GraphicsState)this.graphicState, (TextMetrics)textMetrics, (PageText)pageText, (LinkedList)this.oCGs);
                        break;
                    }
                    case 23: {
                        NContentParser.consume_BDC((Stack)this.stack, (Shapes)shapes, (LinkedList)this.oCGs, (Resources)this.resources);
                        break;
                    }
                    case 25: {
                        NContentParser.consume_EMC((Shapes)shapes, (LinkedList)this.oCGs);
                        break;
                    }
                    case 71: {
                        NContentParser.consume_gs((GraphicsState)this.graphicState, (Stack)this.stack, (Resources)this.resources);
                        break;
                    }
                    case 68: {
                        NContentParser.consume_w((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)shapes, (float)this.glyph2UserSpaceScale);
                        break;
                    }
                    case 69: {
                        NContentParser.consume_w((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)shapes, (float)this.glyph2UserSpaceScale);
                        break;
                    }
                    case 59: {
                        NContentParser.consume_sc((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library, (Resources)this.resources, (boolean)false);
                        break;
                    }
                    case 60: {
                        NContentParser.consume_sc((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library, (Resources)this.resources, (boolean)true);
                        break;
                    }
                    case 54: {
                        NContentParser.consume_k((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library);
                        break;
                    }
                    case 50: {
                        NContentParser.consume_g((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library);
                        break;
                    }
                    case 64: {
                        NContentParser.consume_i((Stack)this.stack);
                        break;
                    }
                    case 70: {
                        NContentParser.consume_M((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)shapes);
                        break;
                    }
                    case 65: {
                        NContentParser.consume_J((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)shapes);
                        break;
                    }
                    case 52: {
                        NContentParser.consume_rg((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library);
                        break;
                    }
                    case 67: {
                        NContentParser.consume_d((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)shapes);
                        break;
                    }
                    case 66: {
                        NContentParser.consume_j((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)shapes);
                        break;
                    }
                    case 56: {
                        NContentParser.consume_cs((GraphicsState)this.graphicState, (Stack)this.stack, (Resources)this.resources);
                        break;
                    }
                    case 28: {
                        NContentParser.consume_ri((Stack)this.stack);
                        break;
                    }
                    case 57: {
                        NContentParser.consume_SC((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library, (Resources)this.resources, (boolean)false);
                        break;
                    }
                    case 58: {
                        NContentParser.consume_SC((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library, (Resources)this.resources, (boolean)true);
                        break;
                    }
                    case 53: {
                        NContentParser.consume_K((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library);
                        break;
                    }
                    case 49: {
                        NContentParser.consume_G((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library);
                        break;
                    }
                    case 51: {
                        NContentParser.consume_RG((GraphicsState)this.graphicState, (Stack)this.stack, (Library)this.library);
                        break;
                    }
                    case 55: {
                        NContentParser.consume_CS((GraphicsState)this.graphicState, (Stack)this.stack, (Resources)this.resources);
                        break;
                    }
                    case 42: {
                        NContentParser.consume_Tr((GraphicsState)this.graphicState, (Stack)this.stack);
                        break;
                    }
                    case 40: {
                        NContentParser.consume_Tz((GraphicsState)this.graphicState, (Stack)this.stack);
                        break;
                    }
                    case 44: {
                        NContentParser.consume_Ts((GraphicsState)this.graphicState, (Stack)this.stack);
                        break;
                    }
                    case 21: {
                        break;
                    }
                    case 22: {
                        break;
                    }
                    case 47: {
                        NContentParser.consume_single_quote((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)shapes, (TextMetrics)textMetrics, (GlyphOutlineClip)glyphOutlineClip, (LinkedList)this.oCGs);
                        break;
                    }
                    case 48: {
                        NContentParser.consume_double_quote((GraphicsState)this.graphicState, (Stack)this.stack, (Shapes)shapes, (TextMetrics)textMetrics, (GlyphOutlineClip)glyphOutlineClip, (LinkedList)this.oCGs);
                    }
                }
            } else {
                this.stack.push(object);
            }
            if ((object = a2.a()) != null) continue;
        }
        if (!glyphOutlineClip.isEmpty()) {
            this.graphicState.setClip(glyphOutlineClip.getGlyphOutlineClip());
            shapes.add((DrawCmd)new GlyphOutlineDrawCmd(glyphOutlineClip));
        }
        this.graphicState.set(this.textBlockBase);
        if (object instanceof Integer && (Integer)object == 33) {
            this.inTextBlock = false;
        }
        return textMetrics.getyBTStart();
    }

    private void parseInlineImage(a a2, Shapes shapes) {
        try {
            Object object;
            HashMap<Object, byte[]> hashMap = new HashMap<Object, byte[]>();
            Object object2 = a2.a();
            while (!object2.equals(74)) {
                if (ImageStream.BPC_KEY.equals(object2)) {
                    object2 = ImageStream.BITSPERCOMPONENT_KEY;
                } else if (ImageStream.CS_KEY.equals(object2)) {
                    object2 = ImageStream.COLORSPACE_KEY;
                } else if (ImageStream.D_KEY.equals(object2)) {
                    object2 = ImageStream.DECODE_KEY;
                } else if (ImageStream.DP_KEY.equals(object2)) {
                    object2 = ImageStream.DECODEPARMS_KEY;
                } else if (ImageStream.F_KEY.equals(object2)) {
                    object2 = ImageStream.FILTER_KEY;
                } else if (ImageStream.H_KEY.equals(object2)) {
                    object2 = ImageStream.HEIGHT_KEY;
                } else if (ImageStream.IM_KEY.equals(object2)) {
                    object2 = ImageStream.IMAGEMASK_KEY;
                } else if (ImageStream.I_KEY.equals(object2)) {
                    object2 = ImageStream.INDEXED_KEY;
                } else if (ImageStream.W_KEY.equals(object2)) {
                    object2 = ImageStream.WIDTH_KEY;
                }
                object = a2.a();
                hashMap.put(object2, (byte[])object);
                object2 = a2.a();
            }
            object = a2.a();
            ImageStream imageStream = new ImageStream(this.library, hashMap, object);
            ImageReference imageReference = ImageReferenceFactory.getImageReference((ImageStream)imageStream, (Resources)this.resources, (Color)this.graphicState.getFillColor());
            AffineTransform affineTransform = new AffineTransform(this.graphicState.getCTM());
            this.graphicState.scale(1.0, -1.0);
            this.graphicState.translate(0.0, -1.0);
            shapes.add((DrawCmd)new ImageDrawCmd(imageReference));
            this.graphicState.set(affineTransform);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Error parsing inline image.", exception);
        }
    }
}

