/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import org.icepdf.core.io.CountingOutputStream;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.HexStringObject;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.util.Utils;
import org.icepdf.core.util.a;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class IncrementalUpdater {
    private static final Logger a = Logger.getLogger(IncrementalUpdater.class.getName());
    private static final boolean a = false;
    private static final byte[] a = " ".getBytes();
    private static final byte[] b = "\r\n".getBytes();
    private static final byte[] c = "true".getBytes();
    private static final byte[] d = "false".getBytes();
    private static final byte[] e = "/".getBytes();
    private static final byte[] f = "R".getBytes();
    private static final byte[] g = "\\".getBytes();
    private static final byte[] h = "obj\r\n".getBytes();
    private static final byte[] i = "\r\nendobj\r\n".getBytes();
    private static final byte[] j = "stream\r\n".getBytes();
    private static final byte[] k = "\r\nendstream\r\n".getBytes();
    private static final byte[] l = "<<".getBytes();
    private static final byte[] m = ">>".getBytes();
    private static final byte[] n = "[".getBytes();
    private static final byte[] o = "]".getBytes();
    private static final byte[] p = "(".getBytes();
    private static final byte[] q = ")".getBytes();
    private static final byte[] r = "<".getBytes();
    private static final byte[] s = ">".getBytes();
    private static final byte[] t = "xref\r\n".getBytes();
    private static final byte[] u = "trailer\r\n".getBytes();
    private static final byte[] v = "\r\n\r\nstartxref\r\n".getBytes();
    private static final byte[] w = "\r\n%%EOF\r\n".getBytes();
    private static ArrayList a = new ArrayList(3);
    private CountingOutputStream a;
    private long a;
    private long b;
    private List a;

    public static long appendIncrementalUpdate(Document document, OutputStream outputStream, long l2) {
        if (a.isLoggable(Level.FINE)) {
            if (document.getStateManager().isChanged()) {
                a.fine("Have changes, will append incremental update");
            } else {
                a.fine("No changes, will not append incremental update");
            }
        }
        if (!document.getStateManager().isChanged()) {
            return 0L;
        }
        IncrementalUpdater incrementalUpdater = new IncrementalUpdater(outputStream, l2);
        incrementalUpdater.begin();
        Iterator iterator = document.getStateManager().iteratorSortedByObjectNumber();
        while (iterator.hasNext()) {
            PObject pObject = (PObject)iterator.next();
            incrementalUpdater.writeObject(pObject.getReference(), pObject.getObject());
        }
        if (!document.getStateManager().getTrailer().getDictionary().containsKey(new Name("Type"))) {
            incrementalUpdater.writeXRefTable();
            incrementalUpdater.writeTrailer(document.getStateManager().getTrailer());
        } else {
            incrementalUpdater.writeCompressedXRefTable(document.getStateManager().getTrailer());
        }
        return incrementalUpdater.getIncrementalUpdateLength();
    }

    public static byte[][] getUpdatedDocumentObjects(Document document) {
        if (a.isLoggable(Level.FINE)) {
            if (document.getStateManager().isChanged()) {
                a.fine("Have changes, will append incremental update");
            } else {
                a.fine("No changes, will not append incremental update");
            }
        }
        if (!document.getStateManager().isChanged()) {
            return null;
        }
        Iterator iterator = document.getStateManager().iteratorSortedByObjectNumber();
        byte[][] byArrayArray = new byte[document.getStateManager().getChangedSize()][];
        int n2 = 0;
        while (iterator.hasNext()) {
            PObject pObject = (PObject)iterator.next();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IncrementalUpdater incrementalUpdater = new IncrementalUpdater(byteArrayOutputStream, 0L);
            incrementalUpdater.writeObject(pObject.getReference(), pObject.getObject());
            byArrayArray[n2] = byteArrayOutputStream.toByteArray();
            ++n2;
        }
        return byArrayArray;
    }

    private IncrementalUpdater(OutputStream outputStream, long l2) {
        this.a = new CountingOutputStream(outputStream);
        this.a = l2;
        this.a = new ArrayList(32);
    }

    private void begin() {
        this.a.write(b);
    }

    private void writeObject(Reference reference, Object object) {
        if (object instanceof Stream) {
            this.writeObjectStream((Stream)object);
        } else if (object instanceof Dictionary) {
            this.writeObjectDictionary((Dictionary)object);
        } else {
            this.writeObjectValue(reference, object);
        }
    }

    private void writeXRefTable() {
        int n2 = 0;
        for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
            a a2 = (a)this.a.get(i2);
            if (!a2.a()) continue;
            a2.a(n2);
            n2 = a2.a().getObjectNumber();
        }
        a a3 = new a(new Reference(0, 65534));
        a3.a(n2);
        this.a.add(0, a3);
        this.a.write(b);
        this.b = this.a + this.a.getCount();
        this.a.write(t);
        for (int i3 = 0; i3 < this.a.size(); i3 += this.writeXrefSubSection(i3)) {
        }
        this.a.write(b);
    }

    private int writeXrefSubSection(int n2) {
        int n3;
        int n4 = ((a)this.a.get(n2)).a().getObjectNumber();
        int n5 = n4 + 1;
        for (n3 = n2 + 1; n3 < this.a.size() && ((a)this.a.get(n3)).a().getObjectNumber() == n5; ++n5, ++n3) {
        }
        n3 = n5 - n4;
        this.writeInteger(n4);
        this.a.write(a);
        this.writeInteger(n3);
        this.a.write(b);
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            a a2 = (a)this.a.get(i2);
            if (a2.a()) {
                this.writeZeroPaddedLong(a2.a(), 10);
                this.a.write(32);
                this.writeZeroPaddedLong(a2.a().getGenerationNumber() + 1, 5);
                this.a.write(32);
                this.a.write(102);
                this.a.write(13);
                this.a.write(10);
                continue;
            }
            this.writeZeroPaddedLong(a2.a(), 10);
            this.a.write(32);
            this.writeZeroPaddedLong(a2.a().getGenerationNumber(), 5);
            this.a.write(32);
            this.a.write(110);
            this.a.write(13);
            this.a.write(10);
        }
        return n3;
    }

    private byte[] createXrefDataStream() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (a a2 : this.a) {
            Utils.writeInteger((OutputStream)byteArrayOutputStream, (int)1);
            Utils.writeLong((OutputStream)byteArrayOutputStream, (long)a2.a());
            Utils.writeInteger((OutputStream)byteArrayOutputStream, (int)0);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private int createIndexArray(int n2, ArrayList arrayList) {
        int n3;
        int n4 = ((a)this.a.get(n2)).a().getObjectNumber();
        int n5 = n4 + 1;
        for (n3 = n2 + 1; n3 < this.a.size() && ((a)this.a.get(n3)).a().getObjectNumber() == n5; ++n5, ++n3) {
        }
        n3 = n5 - n4;
        arrayList.add(n4);
        arrayList.add(n3);
        return n3;
    }

    private void writeTrailer(PTrailer pTrailer) {
        HashMap hashMap = (HashMap)pTrailer.getDictionary().clone();
        int n2 = pTrailer.getNumberOfObjects();
        int n3 = this.getGreatestObjectNumberWritten();
        int n4 = Math.max(n2, n3 + 1);
        hashMap.put(new Name("Size"), n4);
        long l2 = pTrailer.getPosition();
        hashMap.put(new Name("Prev"), l2);
        long l3 = this.b;
        if (l2 == 0L) {
            l3 = -1L;
        }
        this.a.write(u);
        this.writeDictionary(hashMap);
        this.a.write(v);
        this.writeLong(l3);
        this.a.write(b);
        this.a.write(w);
    }

    public void writeCompressedXRefTable(PTrailer pTrailer) {
        HashMap hashMap = (HashMap)pTrailer.getDictionary().clone();
        int n2 = pTrailer.getNumberOfObjects();
        int n3 = this.getGreatestObjectNumberWritten();
        int n4 = n3 + 1;
        int n5 = Math.max(n2, n4 + 1);
        hashMap.put(new Name("Size"), n5);
        long l2 = pTrailer.getPosition();
        hashMap.put(new Name("Prev"), l2);
        long l3 = this.a + this.a.getCount();
        hashMap.remove(Stream.DECODEPARAM_KEY);
        hashMap.put(Stream.FILTER_KEY, new Name("FlateDecode"));
        int n6 = 0;
        for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
            a a2 = (a)this.a.get(i2);
            if (!a2.a()) continue;
            a2.a(n6);
            n6 = a2.a().getObjectNumber();
        }
        hashMap.put(new Name("W"), a);
        ArrayList arrayList = new ArrayList();
        for (int i3 = 0; i3 < this.a.size(); i3 += this.createIndexArray(i3, arrayList)) {
        }
        hashMap.put(new Name("Index"), arrayList);
        Stream stream = new Stream(null, hashMap, new byte[0]);
        stream.setPObjectReference(new Reference(n4, 0));
        byte[] byArray = this.createXrefDataStream();
        stream.setRawBytes(byArray);
        this.writeObjectStream(stream);
        this.a.write(v);
        this.writeLong(l3);
        this.a.write(b);
        this.a.write(w);
    }

    private void flush() {
        this.a.flush();
    }

    private long getIncrementalUpdateLength() {
        return this.a.getCount();
    }

    private void writeObjectDictionary(Dictionary dictionary) {
        a.log(Level.FINER, "writeObjectDictionary()  obj: {0}", dictionary);
        if (dictionary == null) {
            throw new IllegalArgumentException("Object must be non-null");
        }
        Reference reference = dictionary.getPObjectReference();
        a.log(Level.FINER, "writeObjectDictionary()  ref: {0}", reference);
        if (reference == null) {
            throw new IllegalArgumentException("Reference must be non-null for object: " + dictionary);
        }
        if (dictionary.isDeleted()) {
            this.addEntry(new a(reference));
            return;
        }
        this.addEntry(new a(reference, this.a + this.a.getCount()));
        this.writeInteger(reference.getObjectNumber());
        this.a.write(a);
        this.writeInteger(reference.getGenerationNumber());
        this.a.write(a);
        this.a.write(h);
        this.writeDictionary(dictionary, 0);
        this.a.write(i);
    }

    private void writeObjectStream(Stream stream) {
        byte[] byArray;
        a.log(Level.FINER, "writeObjectStream()  obj: {0}", stream);
        if (stream == null) {
            throw new IllegalArgumentException("Object must be non-null");
        }
        Reference reference = stream.getPObjectReference();
        a.log(Level.FINER, "writeObjectStream()  ref: {0}", reference);
        if (reference == null) {
            throw new IllegalArgumentException("Reference must be non-null for object: " + stream);
        }
        if (stream.isDeleted()) {
            this.addEntry(new a(reference));
            return;
        }
        this.addEntry(new a(reference, this.a + this.a.getCount()));
        if (!stream.isRawBytesCompressed() && stream.getEntries().containsKey(Stream.FILTER_KEY)) {
            byte[] byArray2 = stream.getRawBytes();
            byte[] byArray3 = new byte[byArray2.length];
            Deflater deflater = new Deflater();
            deflater.setInput(byArray2);
            deflater.finish();
            int n2 = deflater.deflate(byArray3);
            byArray = new byte[n2];
            System.arraycopy(byArray3, 0, byArray, 0, n2);
        } else {
            byArray = stream.getRawBytes();
        }
        this.writeInteger(reference.getObjectNumber());
        this.a.write(a);
        this.writeInteger(reference.getGenerationNumber());
        this.a.write(a);
        this.a.write(h);
        this.writeDictionary((Dictionary)stream, byArray.length);
        this.a.write(j);
        this.writeStreamBytes(byArray);
        this.a.write(k);
        this.a.write(i);
    }

    private void writeObjectValue(Reference reference, Object object) {
        a.log(Level.FINER, "writeObjectValue()  obj: {0}", object);
        if (reference == null) {
            throw new IllegalArgumentException("Reference must be non-null for object: " + object);
        }
        if (object == null) {
            throw new IllegalArgumentException("Object must be non-null");
        }
        this.addEntry(new a(reference, this.a + this.a.getCount()));
        this.writeInteger(reference.getObjectNumber());
        this.a.write(a);
        this.writeInteger(reference.getGenerationNumber());
        this.a.write(a);
        this.a.write(h);
        this.writeValue(object);
        this.a.write(i);
    }

    private void writeDictionary(Dictionary dictionary, int n2) {
        a.log(Level.FINER, "writeDictionary()  dict: {0}", dictionary);
        try {
            if (dictionary instanceof Stream) {
                dictionary.getEntries().put(Stream.LENGTH_KEY, n2);
                dictionary.getEntries().put(Stream.FORM_TYPE_KEY, 1);
            }
            this.writeDictionary(dictionary.getEntries());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = dictionary.getPObjectReference() != null ? dictionary.getPObjectReference().toString() : dictionary.toString();
            throw new IllegalArgumentException(illegalArgumentException.getMessage() + " in dictionary: " + string, illegalArgumentException);
        }
    }

    private void writeDictionary(HashMap hashMap) {
        a.log(Level.FINER, "writeDictionary()  dictEntries: {0}", hashMap);
        this.a.write(l);
        Set set = hashMap.keySet();
        for (Object k2 : set) {
            Object v2 = hashMap.get(k2);
            this.writeName(k2.toString());
            this.a.write(a);
            try {
                this.writeValue(v2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(illegalArgumentException.getMessage() + " for key: " + k2, illegalArgumentException);
            }
            this.a.write(a);
        }
        this.a.write(m);
    }

    private void writeValue(Object object) {
        if (object == null) {
            this.writeByteString("null");
        } else if (object instanceof Name) {
            this.writeName((Name)object);
        } else if (object instanceof Reference) {
            this.writeReference((Reference)object);
        } else if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Integer) {
            this.writeInteger((Integer)object);
        } else if (object instanceof Long) {
            this.writeLong((Long)object);
        } else if (object instanceof Number) {
            this.writeReal((Number)object);
        } else {
            if (object instanceof String) {
                a.severe("Found invalid java.lang.String being written out: " + object.toString());
                throw new IllegalArgumentException("invalid type of java.lang.String. Should use LiteralStringObject or HexStringObject");
            }
            if (object instanceof LiteralStringObject) {
                this.writeLiteralString((LiteralStringObject)object);
            } else if (object instanceof HexStringObject) {
                this.writeHexString((HexStringObject)object);
            } else if (object instanceof List) {
                this.writeArray((List)object);
            } else if (object instanceof Dictionary) {
                this.writeDictionary((Dictionary)object, 0);
            } else if (object instanceof HashMap) {
                this.writeDictionary((HashMap)object);
            } else if (object instanceof AffineTransform) {
                this.writeAffineTransform((AffineTransform)object);
            } else {
                throw new IllegalArgumentException("unknown value type of: " + object.getClass().getName());
            }
        }
    }

    private void writeName(Name name) {
        this.writeName(name.getName());
    }

    private void writeName(String string) {
        byte[] byArray;
        this.a.write(e);
        int n2 = 35;
        for (int n3 : byArray = string.getBytes("UTF-8")) {
            if ((n3 &= 0xFF) == 35 || n3 < 33 || n3 > 126) {
                this.a.write(35);
                int n4 = n3 >> 4 & 0xF;
                int n5 = n4 + (n4 >= 10 ? 65 : 48);
                this.a.write(n5);
                n4 = n3 & 0xF;
                n5 = n4 + (n4 >= 10 ? 65 : 48);
                this.a.write(n5);
                continue;
            }
            this.a.write(n3);
        }
    }

    private void writeReference(Reference reference) {
        this.writeInteger(reference.getObjectNumber());
        this.a.write(a);
        this.writeInteger(reference.getGenerationNumber());
        this.a.write(a);
        this.a.write(f);
    }

    private void writeArray(List list) {
        this.a.write(n);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeValue(list.get(i2));
            if (i2 >= n2 - 1) continue;
            this.a.write(a);
        }
        this.a.write(o);
    }

    private void writeAffineTransform(AffineTransform affineTransform) {
        this.a.write(n);
        this.writeLong((long)affineTransform.getScaleX());
        this.a.write(a);
        this.writeLong((long)affineTransform.getShearX());
        this.a.write(a);
        this.writeLong((long)affineTransform.getTranslateX());
        this.a.write(a);
        this.writeLong((long)affineTransform.getScaleY());
        this.a.write(a);
        this.writeLong((long)affineTransform.getShearY());
        this.a.write(a);
        this.writeLong((long)affineTransform.getTranslateY());
        this.a.write(o);
    }

    private void writeBoolean(boolean bl2) {
        if (bl2) {
            this.a.write(c);
        } else {
            this.a.write(d);
        }
    }

    private void writeInteger(int n2) {
        String string = Integer.toString(n2);
        this.writeByteString(string);
    }

    private void writeLong(long l2) {
        String string = Long.toString(l2);
        this.writeByteString(string);
    }

    private void writeReal(float f2) {
        String string = Float.toString(f2);
        this.writeByteString(string);
    }

    private void writeReal(Number number) {
        String string = number.toString();
        this.writeByteString(string);
    }

    private void writeLiteralString(LiteralStringObject literalStringObject) {
        this.a.write(p);
        this.writeByteString(literalStringObject.getLiteralString());
        this.a.write(q);
    }

    private void writeHexString(HexStringObject hexStringObject) {
        this.a.write(r);
        this.writeByteString(hexStringObject.getHexString());
        this.a.write(s);
    }

    private void writeStreamBytes(byte[] byArray) {
        this.a.write(byArray);
    }

    private void writeByteString(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = string.charAt(i2) & 0xFF;
            this.a.write(n3);
        }
    }

    private void writeZeroPaddedLong(long l2, int n2) {
        String string = Long.toString(l2);
        if (string.length() > n2) {
            string = string.substring(string.length() - n2);
        }
        int n3 = n2 - string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.a.write(48);
        }
        this.writeByteString(string);
    }

    private void addEntry(a a2) {
        int n2;
        int n3 = a2.a().getObjectNumber();
        for (n2 = this.a.size(); n2 > 0; --n2) {
            a a3 = (a)this.a.get(n2 - 1);
            int n4 = a3.a().getObjectNumber();
            if (n4 == n3) {
                throw new IllegalArgumentException("Multiple entries with same object number: " + n3);
            }
            if (n4 < n3) break;
        }
        this.a.add(n2, a2);
    }

    private int getGreatestObjectNumberWritten() {
        return this.a.isEmpty() ? 0 : ((a)this.a.get(this.a.size() - 1)).a().getObjectNumber();
    }

    static {
        a.add(4);
        a.add(8);
        a.add(4);
    }
}

