/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.nfont;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.fonts.nfont.CMap;
import org.icepdf.core.pobjects.fonts.nfont.Encoding;
import org.icepdf.core.pobjects.fonts.nfont.NFont;
import org.icepdf.core.pobjects.fonts.nfont.b.k;
import org.icepdf.core.pobjects.fonts.nfont.c.d;
import org.icepdf.core.pobjects.fonts.nfont.c.e;
import org.icepdf.core.pobjects.fonts.nfont.c.g;
import org.icepdf.core.pobjects.fonts.nfont.i;
import org.icepdf.core.pobjects.fonts.nfont.instructions.a;
import org.icepdf.core.pobjects.fonts.nfont.instructions.hn;
import org.icepdf.core.pobjects.fonts.nfont.instructions.ho;
import org.icepdf.core.pobjects.fonts.nfont.j;
import org.icepdf.core.pobjects.fonts.nfont.m;
import org.icepdf.core.pobjects.fonts.nfont.n;

public class NFontTrueType
extends j
implements Cloneable {
    private static final Logger logger = Logger.getLogger(NFontTrueType.class.toString());
    public static final String FORMAT = "TrueType";
    public static final String SUBFORMAT_DFONT = "dfont";
    public static final String SUBFORMAT_TTC = "TTC";
    public static final String SUBFORMAT_BITMAP = "bitmap";
    public static final int PID_UNICODE = 0;
    public static final int PID_MACINTOSH = 1;
    public static final int PID_MICROSOFT = 3;
    private static final GeneralPath GLYPH_ZERO_CONTOUR = new GeneralPath(1, 1);
    private static final String[] MAP_MAC_STANDARD = new String[]{".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"};
    private static final Encoding ENCODING_MAC_STANDARD = new Encoding("TrueType-1", MAP_MAC_STANDARD);
    private static final int RGB_MASK = 0xFFFFFF;
    private static final int ALPHA_MASK = -16777216;
    public static final Color COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    public boolean hinting;
    private NFontTrueType[] urs_;
    private long[] ttfoffset_;
    NFontTrueType ur_;
    private String subformat_;
    private boolean fdfont_;
    private int ascent_;
    private int descent_;
    private int glyphcnt_;
    private int fontDirectionHint_;
    private int indexToLocFormat_;
    private int[] loca_;
    private String[] names_;
    private boolean[] subset_;
    private AffineTransform u_;
    private int[] cvp_;
    private int[] fpgm_;
    private a mCvtTable;
    private ho mMaxpTable;
    protected CMap c2g_;
    float FUnit_;
    private int macStyle_;
    private int rights_ = -1;
    private int hint_ = -1;
    private SoftReference[] paths_;
    protected float[] widths_;
    protected float[] lsb_;
    private Shape notdef_ = null;
    private int flags_;
    private int weight_;
    private int spacech_ = Integer.MIN_VALUE;
    private String name_;
    private String family_;
    private Color color_ = Color.black;
    private List instances_ = new ArrayList(10);
    private Map gid2bitmap_ = null;
    private static final Map NONE = new HashMap(1);
    private double imgx_;
    private double imgy_;
    private int imgw_;
    private int imgh_;
    private int[] buf_;
    private final Object parseGlyphLock = new Object();
    protected static final int ARG_1_AND_2_ARE_WORDS_BIT_0 = 1;
    protected static final int ARGS_ARE_XY_VALUES_BIT_1 = 2;
    protected static final int ROUND_XY_TO_GRID_BIT_2 = 4;
    protected static final int WE_HAVE_A_SCALE_BIT_3 = 8;
    protected static final int MORE_COMPONENTS_BIT_5 = 32;
    protected static final int WE_HAVE_AN_X_AND_Y_SCALE_BIT_6 = 64;
    protected static final int WE_HAVE_A_TWO_BY_TWO_BIT_7 = 128;
    public static final int WE_HAVE_INSTRUCTIONS_BIT_8 = 256;
    public static final int USE_MY_METRICS_BIT_9 = 512;
    private n mGlyphData;
    private hn mInterpreter;
    public static final boolean ultraVerbose = false;
    private final double d = 1.0;

    public NFontTrueType(URL uRL) {
        super(uRL);
    }

    public NFontTrueType(byte[] byArray) {
        super(byArray);
    }

    public NFont deriveFont(float f2) {
        NFontTrueType nFontTrueType = (NFontTrueType)super.deriveFont(f2);
        nFontTrueType.u_ = new AffineTransform(this.m_);
        nFontTrueType.u_.concatenate(nFontTrueType.at_);
        nFontTrueType.u_.scale(f2, f2);
        nFontTrueType.gid2bitmap_ = null;
        return nFontTrueType;
    }

    public NFont deriveFont(AffineTransform affineTransform) {
        NFontTrueType nFontTrueType = (NFontTrueType)super.deriveFont(affineTransform);
        nFontTrueType.u_ = new AffineTransform(this.m_);
        nFontTrueType.u_.concatenate(affineTransform);
        nFontTrueType.u_.scale(nFontTrueType.size_, nFontTrueType.size_);
        return nFontTrueType;
    }

    public FontFile deriveFont(float f2, ArrayList arrayList) {
        NFontTrueType nFontTrueType = (NFontTrueType)super.deriveFont(this.size_);
        if (arrayList == null && f2 > 0.0f) {
            nFontTrueType.pdfbad_ = new boolean[this.widths_.length];
            f2 = (float)((double)f2 * 0.001 / this.m_.getScaleX());
            int n2 = this.widths_.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!(this.widths_[i2] > 0.0f)) continue;
                nFontTrueType.widths_[i2] = f2;
            }
        }
        return nFontTrueType;
    }

    public org.icepdf.core.pobjects.fonts.nfont.k deriveFont(Encoding encoding, CMap cMap) {
        NFontTrueType nFontTrueType = (NFontTrueType)super.deriveFont(encoding, cMap);
        CMap cMap2 = null;
        if (encoding == null) {
            cMap2 = this.getCmap(1, -1);
            if (cMap2 == null) {
                cMap2 = this.ur_.c2g_;
            }
        } else if (Encoding.MAC_ROMAN == encoding) {
            cMap2 = this.getCmap(1, 0);
        } else if (Encoding.IDENTITY == encoding) {
            cMap2 = CMap.IDENTITY;
        } else if (Encoding.WIN_ANSI == encoding || (cMap2 = this.getCmap(3, 0)) != null) {
            // empty if block
        }
        if (cMap2 == null) {
            this.readPostTable();
            if (this.intrinsic_ != null) {
                cMap2 = encoding.mapTo(this.intrinsic_);
            } else if (this.ur_.c2g_ == null) {
                cMap2 = CMap.IDENTITY;
            } else {
                char[] cArray = new char[256];
                for (int i2 = 0; i2 < 256; ++i2) {
                    String string = encoding.getName((char)i2);
                    char c2 = Encoding.UNICODE.getChar(string);
                    cArray[i2] = this.ur_.c2g_.toSelector(c2);
                }
                cMap2 = new CMap(cArray);
            }
        }
        nFontTrueType.setCID(cMap2, nFontTrueType.touni_);
        return nFontTrueType;
    }

    public NFontTrueType deriveFont(CMap cMap, CMap cMap2) {
        NFontTrueType nFontTrueType = null;
        try {
            nFontTrueType = (NFontTrueType)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        nFontTrueType.setCID(cMap, cMap2);
        return nFontTrueType;
    }

    private void setCID(CMap cMap, CMap cMap2) {
        this.c2g_ = cMap != null ? cMap : this.ur_.c2g_;
        this.touni_ = cMap2 != null ? cMap2 : CMap.IDENTITY;
        this.spacech_ = Integer.MIN_VALUE;
    }

    protected void parseFile() {
        this.subformat_ = "none";
        this.loca_ = null;
        boolean bl2 = this.fdfont_ = this.checkDfont();
        this.raoff_ = this.ra_.getFilePointer();
        this.subset_ = null;
        super.parseFile();
        if (!bl2) {
            bl2 = this.checkTTC();
        }
        if (!bl2) {
            this.ttfoffset_ = new long[]{0L};
        }
        this.urs_ = new NFontTrueType[this.ttfoffset_.length];
        this.urs_[0] = this.ur_ = this;
        this.raoff_ = this.ttfoffset_[0];
    }

    private boolean checkDfont() {
        long l2 = this.ra_.getFilePointer();
        this.data_ = this.readRaw(l2, 16);
        this.setOffset(0);
        long l3 = this.readUint32();
        if (l3 != 256L) {
            this.ra_.seek(l2);
            return false;
        }
        k k2 = null;
        try {
            k2 = new k(this.ra_, l2);
        }
        catch (IOException iOException) {
            this.ra_.seek(l2);
            return false;
        }
        long[] lArray = k2.a(e.a("sfnt"));
        int n2 = lArray.length / 2;
        if (n2 == 0) {
            return false;
        }
        this.ttfoffset_ = new long[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            this.ttfoffset_[n3] = lArray[n4];
            ++n3;
            n4 += 2;
        }
        this.subformat_ = SUBFORMAT_DFONT;
        this.ra_.seek(this.ttfoffset_[0]);
        return true;
    }

    private boolean checkTTC() {
        if (TAG_TTCF != this.version_) {
            return false;
        }
        float f2 = this.readFixed();
        int n2 = this.readUint32();
        this.data_ = this.readRaw(this.raoff_, 12 + n2 * 4);
        this.setOffset(12);
        this.ttfoffset_ = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.ttfoffset_[i2] = this.readUint32();
        }
        this.subformat_ = SUBFORMAT_TTC;
        return true;
    }

    protected void parse() {
        super.parse();
        this.readNameTable();
        if (this.getTable(1751474532).length == 0) {
            if (this.getTableDirectory(1650745716) == null) {
                throw new IllegalStateException();
            }
            this.subformat_ = SUBFORMAT_BITMAP;
            this.m_ = this.u_ = new AffineTransform();
            return;
        }
        float f2 = this.readFixed();
        if ((double)f2 >= 2.0) {
            throw new IllegalStateException(f2 + "");
        }
        int n2 = this.readUint32();
        this.readUint32();
        int n3 = this.readUint32();
        if (n3 != 1594834165) {
            throw new IllegalStateException(n3 + "");
        }
        int n4 = this.readUint16();
        int n5 = this.readUint16();
        this.FUnit_ = 1.0f / (float)n5;
        long l2 = this.readDateTime();
        long l3 = this.readDateTime();
        float f3 = this.readInt16();
        float f4 = this.readInt16();
        float f5 = this.readInt16();
        float f6 = this.readInt16();
        this.bbox_ = new Rectangle2D.Double(f3, f4, f5, f6);
        this.macStyle_ = this.readUint16();
        int n6 = this.readUint16();
        this.fontDirectionHint_ = this.readInt16();
        this.indexToLocFormat_ = this.readInt16();
        if (this.indexToLocFormat_ != 0 && this.indexToLocFormat_ != 1) {
            throw new IllegalStateException(this.indexToLocFormat_ + "");
        }
        int n7 = this.readInt16();
        this.readMaxpTable();
        this.readMetricsTables();
        this.paths_ = new SoftReference[this.mMaxpTable.a];
        this.u_ = this.m_ = new AffineTransform((double)this.FUnit_, 0.0, 0.0, (double)(-this.FUnit_), 0.0, 0.0);
        this.flags_ = this.computeFlags();
        CMap cMap = null;
        if (cMap == null && (cMap = this.getCmap(3, 0)) != null) {
            this.encoding_ = Encoding.SYMBOL;
        }
        if (cMap == null && (cMap = this.getCmap(3, 1)) != null) {
            this.encoding_ = Encoding.WIN_ANSI;
        }
        if (cMap == null) {
            cMap = this.getCmap(0, -1);
        }
        if (cMap == null && (cMap = this.getCmap(1, 0)) != null) {
            this.encoding_ = Encoding.MAC_ROMAN;
        }
        if (cMap == null) {
            cMap = this.getCmap(-1, -1);
        }
        if (cMap == null) {
            cMap = CMap.IDENTITY;
        }
        this.setCID(cMap, CMap.IDENTITY);
    }

    float readFWord() {
        return (float)this.readInt16() * this.FUnit_;
    }

    float readUFWord() {
        return (float)this.readUint16() * this.FUnit_;
    }

    private int computeFlags() {
        int n2;
        int n3 = Integer.MIN_VALUE;
        if (this.getTable(1886352244, 0, 14).length >= 14) {
            this.setOffset(12);
            n2 = this.readUint16();
            if (n2 == 1) {
                n3 |= 1;
            }
        }
        if (this.getTable(1330851634).length >= 56) {
            n2 = this.readUint16();
            int n4 = this.readInt16();
            int n5 = this.readUint16();
            if (1 <= n5 && n5 <= 9) {
                n5 *= 100;
            }
            String string = this.getName();
            if (400 == n5 && string != null && string.indexOf(45) > 0) {
                n5 = i.a(this.getName());
            }
            int n6 = this.readUint16();
            this.rights_ = this.readUint16();
            this.skip(20);
            int n7 = this.readInt16();
            int n8 = this.readUint8();
            int n9 = this.readUint8();
            int n10 = this.readUint8();
            int n11 = this.readUint8();
            int n12 = this.readUint8();
            int n13 = this.readUint8();
            int n14 = this.readUint8();
            int n15 = this.readUint8();
            int n16 = this.readUint8();
            int n17 = this.readUint8();
            this.skip(16);
            this.skip(4);
            int n18 = this.readUint16();
            int n19 = this.readUint16();
            this.skip(2);
            this.weight_ = n5;
            int n20 = n7 >> 8;
            if (n20 == 10) {
                n3 |= 8;
            } else if (n20 == 12) {
                n3 |= 4;
            } else if (n20 != 8 && n20 != 0) {
                n3 |= 2;
            }
            if (n8 == 2 && n11 == 9) {
                n3 |= 1;
            }
            if (n6 <= 4) {
                n3 |= 0x10000000;
            }
            if ((n18 & 1) != 0) {
                n3 |= 0x40;
            }
            if (2 <= n8 && n8 <= 5 && 0 < n19 && n19 < 128) {
                n3 |= 0x20;
            }
        } else {
            String string;
            int n21 = this.rights_ = this.names_ != null ? i.b(this.names_[0] + " || " + this.names_[7] + " || " + this.names_[8] + " || " + this.names_[13]) : 4;
            if ((this.macStyle_ & 2) != 0) {
                n3 |= 0x40;
            }
            if ((string = this.getName()).indexOf("Cond") > 0) {
                n3 |= 0x10000000;
            }
            this.weight_ = string.indexOf("Light") > 0 ? 300 : ((this.macStyle_ & 1) != 0 ? 700 : 400);
            String string2 = this.getFamily();
            if (string2.startsWith("Helvetica") || string2.startsWith("Arial") || string2.indexOf("Sans") > 0) {
                n3 |= 2;
            }
            if (string2.indexOf("Script") > 0 || string2.indexOf("Handwr") > 0) {
                n3 |= 8;
            }
            n3 = string2.startsWith("Symbol") || string2.startsWith("ZapfDingbats") || string2.startsWith("Dingbats") || string2.startsWith("Wingdings") || string2.startsWith("Webdings") || string2.indexOf("Bats") > 0 ? (n3 |= 4) : (n3 |= 0x20);
        }
        return n3;
    }

    public String getName() {
        return this.name_;
    }

    public String getFamily() {
        return this.family_;
    }

    public String getDesigner() {
        return this.names_ != null ? this.names_[9] : null;
    }

    public String getCopyright() {
        return this.names_ != null ? this.names_[0] : null;
    }

    public String getVersion() {
        return this.names_ != null && this.names_[5] != null ? this.names_[5] : super.getVersion();
    }

    public int getID() {
        return this.version_;
    }

    public int getRights() {
        return this.rights_;
    }

    public NFontTrueType getSubfont(int n2) {
        NFontTrueType nFontTrueType;
        if (n2 < 0 || n2 > this.getCount()) {
            return null;
        }
        if (this.urs_[n2] != null) {
            return this.urs_[n2];
        }
        nFontTrueType.ur_ = nFontTrueType = (NFontTrueType)this.deriveFont(this.size_);
        nFontTrueType.raoff_ = this.ttfoffset_[n2];
        nFontTrueType.getRA();
        nFontTrueType.parse();
        if (this.fdfont_) {
            nFontTrueType.loca_ = null;
            nFontTrueType.intrinsic_ = null;
        }
        nFontTrueType.releaseRA();
        this.urs_[n2] = nFontTrueType;
        return nFontTrueType;
    }

    public int getCount() {
        return this.urs_.length;
    }

    public String getFormat() {
        return FORMAT;
    }

    public String getSubformat() {
        return this.subformat_;
    }

    public int getFlags() {
        return this.flags_;
    }

    public int getWeight() {
        return this.weight_;
    }

    public boolean isHinted() {
        if (this.hint_ == -1) {
            this.hint_ = 0;
            if (SUBFORMAT_BITMAP != this.getSubformat()) {
                int n2 = this.getMaxGlyphNum();
                for (int i2 = 1; i2 < n2 && this.hint_ != 1; ++i2) {
                    this.getGlyph(i2);
                }
                this.releaseRA();
            }
        }
        return this.hint_ == 1;
    }

    public int getMaxGlyphNum() {
        return this.mMaxpTable.a;
    }

    public int getNumGlyphs() {
        this.readLocaTable();
        return this.glyphcnt_;
    }

    public boolean canDisplayEchar(char c2) {
        return this.canDisplayGID(this.c2g_.toSelector(c2));
    }

    private boolean canDisplayGID(int n2) {
        return n2 < this.getMaxGlyphNum();
    }

    public char getSpaceEchar() {
        if (this.spacech_ == Integer.MIN_VALUE) {
            char c2;
            if (Encoding.SYMBOL == this.encoding_) {
                this.spacech_ = 65534;
            } else if (this.encoding_ != null && "space".equals(this.encoding_.getName(32)) && this.canDisplayEchar(' ')) {
                this.spacech_ = 32;
            } else if (this.touni_ != null) {
                this.spacech_ = this.touni_.fromSelector(' ');
            } else if (this.encoding_ != null && (c2 = this.encoding_.getChar("space")) != '\u0000' && this.canDisplayEchar(c2)) {
                this.spacech_ = c2;
            } else {
                char c3 = this.c2g_.toSelector(' ');
                if (c3 != '\u0000' && this.canDisplayGID(c3)) {
                    boolean bl2 = this.ra_ == null;
                    int n2 = this.spacech_ = ((GeneralPath)this.getGlyph(c3)).getPathIterator(new AffineTransform()).isDone() ? 32 : 0;
                    if (bl2) {
                        this.releaseRA();
                    }
                } else {
                    this.spacech_ = 65534;
                }
            }
        }
        return (char)this.spacech_;
    }

    private void readLocaTable() {
        int n2;
        int n3;
        if (this.loca_ != null) {
            return;
        }
        if (this != this.ur_) {
            this.ur_.readLocaTable();
            this.loca_ = this.ur_.loca_;
            this.glyphcnt_ = this.ur_.glyphcnt_;
            return;
        }
        this.getTable(1819239265);
        this.glyphcnt_ = 0;
        if (this.data_.length == 0) {
            this.loca_ = new int[0];
            return;
        }
        this.loca_ = new int[this.mMaxpTable.a + 1];
        if (this.indexToLocFormat_ == 0) {
            n3 = this.mMaxpTable.a + 1;
            for (n2 = 0; n2 < n3; ++n2) {
                this.loca_[n2] = this.readUint16() * 2;
            }
        } else {
            if (this.indexToLocFormat_ != 1) {
                throw new IllegalStateException();
            }
            n3 = this.mMaxpTable.a + 1;
            int n4 = this.data_.length;
            for (n2 = 0; n2 < n3 && this.getOffset() + 2 < n4; ++n2) {
                this.loca_[n2] = this.readUint32();
            }
        }
        n3 = this.mMaxpTable.a;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.loca_[n2] >= this.loca_[n2 + 1]) continue;
            ++this.glyphcnt_;
        }
    }

    private void readPostTable() {
        Encoding encoding;
        if (this.intrinsic_ != null) {
            return;
        }
        if (this != this.ur_) {
            this.ur_.readPostTable();
            this.intrinsic_ = this.ur_.intrinsic_;
            return;
        }
        try {
            if (this.getTable(1886352244).length < 10) {
                return;
            }
        }
        catch (Exception exception) {
            logger.fine("Error processing POST table.");
        }
        float f2 = this.readFixed();
        float f3 = this.readFixed();
        float f4 = this.readFWord();
        float f5 = this.readFWord();
        int n2 = this.readUint16();
        this.skip(18);
        if (f2 == 1.0f) {
            encoding = ENCODING_MAC_STANDARD;
        } else if (f2 == 2.0f) {
            int n3;
            int n4 = this.readUint16();
            int[] nArray = new int[n4];
            int n5 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = this.readUint16();
                int n6 = nArray[n3];
                if (n6 <= n5) continue;
                n5 = n6;
            }
            n3 = Math.max(0, n5 - 257);
            String[] stringArray = new String[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                stringArray[i2] = this.readStringPascal();
            }
            String[] stringArray2 = new String[n4];
            for (int i3 = 0; i3 < n3; ++i3) {
                int n7 = nArray[i3];
                stringArray2[i3] = n7 <= 257 ? MAP_MAC_STANDARD[n7] : stringArray[n7 - 258];
            }
            encoding = new Encoding("TrueType-2", stringArray2);
        } else if (f2 == 2.5f) {
            int n8 = this.readUint16();
            String[] stringArray = new String[n8];
            for (int i4 = 0; i4 < n8; ++i4) {
                int n9 = this.readInt8();
                stringArray[i4] = MAP_MAC_STANDARD[i4 + n9];
            }
            encoding = new Encoding("TrueType-2.5", stringArray);
        } else {
            encoding = f2 == 3.0f ? null : null;
        }
        this.intrinsic_ = encoding;
    }

    private void readNameTable() {
        int n2 = this.getTable(1851878757).length;
        if (n2 < 6) {
            this.name_ = "[no name]";
            this.family_ = "[no family]";
            return;
        }
        int n3 = this.readUint16();
        int n4 = this.readUint16();
        int n5 = this.readUint16();
        String[] stringArray = new String[20];
        int[] nArray = new int[stringArray.length];
        Arrays.fill(nArray, -1);
        int n6 = Math.min(n4, (n2 - 6) / 12);
        for (int i2 = 0; i2 < n6; ++i2) {
            String string;
            boolean bl2;
            int n7 = this.readUint16();
            int n8 = this.readUint16();
            int n9 = this.readUint16();
            int n10 = this.readUint16();
            int n11 = this.readUint16();
            int n12 = this.readUint16() + n5;
            if (n10 >= stringArray.length || n12 + n11 > n2) continue;
            boolean bl3 = bl2 = 0 == n7 || 3 == n7;
            if (nArray[n10] != -1 && n9 != 0 && (0 != n7 || nArray[n10] == 0) || (string = (bl2 ? this.readString16(n12, n11) : this.readString(n12, n11)).trim()).length() <= 0) continue;
            stringArray[n10] = string;
            nArray[n10] = n7;
        }
        this.name_ = stringArray[6] != null ? stringArray[6] : (stringArray[4] != null ? (this.name_ = stringArray[4]) : "[no name]");
        this.family_ = stringArray[1] != null ? stringArray[1] : i.a(this.name_);
        this.names_ = stringArray;
    }

    private void readMaxpTable() {
        this.getTable(1835104368);
        if (this.data_.length < 4) {
            throw new IllegalStateException();
        }
        float f2 = this.readFixed();
        if ((double)f2 >= 2.0) {
            throw new IllegalStateException(f2 + "");
        }
        this.mMaxpTable = new ho();
        this.mMaxpTable.a = this.readUint16();
        if (this.data_.length > 6) {
            this.mMaxpTable.b = this.readUint16();
            this.mMaxpTable.c = this.readUint16();
            this.mMaxpTable.d = this.readUint16();
            this.mMaxpTable.e = this.readUint16();
            this.mMaxpTable.f = this.readUint16();
            this.mMaxpTable.g = this.readUint16();
            this.mMaxpTable.h = this.readUint16();
            this.mMaxpTable.i = this.readUint16();
            this.mMaxpTable.j = this.readUint16();
            this.mMaxpTable.k = this.readUint16();
        }
    }

    private void readMetricsTables() {
        int n2;
        this.getTable(1751672161);
        if (this.data_.length < 36) {
            throw new IllegalStateException();
        }
        float f2 = this.readFixed();
        if ((double)f2 >= 2.0) {
            throw new IllegalStateException(f2 + "");
        }
        this.ascent_ = this.readInt16();
        this.descent_ = this.readInt16();
        float f3 = this.readFWord();
        float f4 = this.readUFWord();
        float f5 = this.readFWord();
        float f6 = this.readFWord();
        float f7 = this.readFWord();
        int n3 = this.readInt16();
        int n4 = this.readInt16();
        float f8 = this.readFWord();
        this.readInt16();
        this.readInt16();
        this.readInt16();
        this.readInt16();
        int n5 = this.readInt16();
        int n6 = this.readUint16();
        this.getTable(1752003704);
        this.widths_ = new float[n6];
        this.lsb_ = new float[this.mMaxpTable.a];
        for (n2 = 0; n2 < n6 && n2 < this.mMaxpTable.a; ++n2) {
            this.widths_[n2] = this.readUint16();
            this.lsb_[n2] = this.readInt16();
        }
        for (n2 = n6; n2 < this.mMaxpTable.a && this.getOffset() + 2 <= this.data_.length; ++n2) {
            this.lsb_[n2] = this.readInt16();
        }
    }

    private short getLeftSideBearing(int n2) {
        if (n2 < this.widths_.length) {
            return (short)((int)this.widths_[n2] & 0xFFFF);
        }
        if (this.lsb_ == null) {
            return 0;
        }
        return (short)this.lsb_[n2 - this.widths_.length];
    }

    public CMap getCmap() {
        return this.c2g_;
    }

    public CMap getCmap(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        char[][] cArrayArray;
        int n10;
        int n11;
        int n12;
        int n13;
        m m2 = this.getTableDirectory(1668112752);
        if (m2 == null) {
            return CMap.IDENTITY;
        }
        this.getTable(m2, 0, 4);
        int n14 = this.readUint16();
        int n15 = this.readUint16();
        this.getTable(m2, 0, 4 + n15 * 8);
        this.setOffset(4);
        boolean bl2 = false;
        int n16 = -1;
        int n17 = -1;
        int n18 = -1;
        if (n14 < 10 && this.data_.length >= 12) {
            for (n13 = 0; n13 < n15; ++n13) {
                n16 = this.readUint16();
                n17 = this.readUint16();
                n18 = this.readUint32();
                if (!(n2 != n16 && n2 != -1 || n3 != n17 && n3 != -1)) {
                    byte[] byArray = this.data_;
                    n12 = this.getOffset();
                    if (this.getTable(m2, n18, 12).length >= 6) {
                        int n19;
                        int n20 = this.readUint16();
                        if (n20 <= 6) {
                            n19 = this.readUint16();
                        } else {
                            this.skip(2);
                            n19 = this.readUint32();
                        }
                        n11 = n20 <= 6 ? this.readUint16() : this.readUint32();
                        this.getTable(m2, n18, m2.d - n18);
                        bl2 = true;
                        break;
                    }
                    this.data_ = byArray;
                    this.setOffset(n12);
                    continue;
                }
                if (n2 < n16 || n2 == n16 && n3 < n17) break;
            }
        }
        if (!bl2) {
            return null;
        }
        n13 = this.readUint16();
        if (n13 <= 6) {
            n10 = this.readUint16();
            n12 = this.readUint16();
            cArrayArray = new char[256][];
        } else {
            this.skip(-2);
            float f2 = this.readFixed();
            n10 = this.readUint32();
            n12 = this.readUint32();
            cArrayArray = new char[4352][];
        }
        if (n13 == 0) {
            char[] cArray = new char[256];
            int n21 = cArray.length;
            for (n11 = 0; n11 < n21; ++n11) {
                cArray[n11] = (char)this.readUint8();
            }
            cArrayArray[0] = cArray;
        } else if (n13 == 2) {
            int[] nArray = new int[256];
            n11 = 1;
            boolean[] blArray = new boolean[256];
            int n22 = nArray.length;
            for (int i2 = 0; i2 < n22; ++i2) {
                nArray[i2] = this.readUint16() / 8;
                int n23 = nArray[i2];
                if (n23 <= 0 || blArray[n23]) continue;
                ++n11;
                blArray[n23] = true;
            }
            int[] nArray2 = new int[n11];
            int[] nArray3 = new int[n11];
            int[] nArray4 = new int[n11];
            int[] nArray5 = new int[n11];
            for (n9 = 0; n9 < n11; ++n9) {
                nArray2[n9] = this.readUint16();
                nArray3[n9] = this.readUint16();
                nArray4[n9] = this.readInt16();
                nArray5[n9] = this.readUint16();
            }
            n9 = this.getOffset();
            if (n9 != 518 + 8 * n11) {
                throw new IllegalStateException();
            }
            if (524 + nArray5[0] != n9) {
                throw new IllegalStateException();
            }
            cArrayArray[0] = new char[256];
            for (n8 = 0; n8 < 256; ++n8) {
                n7 = nArray[n8];
                if (n7 != 0 || !blArray[n7]) {
                    throw new IllegalStateException(n8 + " => " + n7);
                }
                if (n7 >= n11) {
                    throw new IllegalStateException(n7 + "");
                }
                if (n7 == 0) {
                    if (nArray4[0] != 0) {
                        throw new IllegalStateException();
                    }
                    this.setOffset(n9 + n8 * 2);
                    cArrayArray[0][n8] = (char)this.readUint16();
                    continue;
                }
                this.setOffset(518 + n7 * 8 - 2 + nArray5[n7]);
                n5 = n6 + nArray3[n7];
                for (n6 = nArray2[n7]; n6 < n5; ++n6) {
                    n4 = this.readUint16();
                    if (n4 != 0) {
                        n4 += nArray4[n7];
                    }
                    n4 &= 0xFFFF;
                    if (cArrayArray[n8] == null) {
                        cArrayArray[n8] = new char[256];
                    }
                    cArrayArray[n8][n6] = (char)n4;
                }
            }
        } else if (n13 == 4) {
            int n24;
            int n25;
            int n26 = this.readUint16() / 2;
            this.skip(6);
            int[] nArray = new int[n26];
            for (n25 = 0; n25 < n26; ++n25) {
                nArray[n25] = this.readUint16();
            }
            n25 = this.readUint16();
            int[] nArray6 = new int[n26];
            for (int i3 = 0; i3 < n26; ++i3) {
                nArray6[i3] = this.readUint16();
            }
            int[] nArray7 = new int[n26];
            for (n24 = 0; n24 < n26; ++n24) {
                nArray7[n24] = this.readInt16();
            }
            for (n24 = 0; n24 < n26; ++n24) {
                int n27 = this.readUint16();
                n8 = n9 = nArray6[n24];
                n7 = nArray[n24];
                n6 = nArray7[n24];
                while (n9 <= n7) {
                    if (n9 != 65535) {
                        if (n27 == 0) {
                            n5 = n9 + n6 & 0xFFFF;
                        } else {
                            n4 = (n9 - n8) * 2 + this.getOffset() - 2 + n27;
                            n5 = n4 + 1 < this.data_.length ? (this.data_[n4] & 0xFF) << 8 | this.data_[n4 + 1] & 0xFF : 0;
                            if (n5 != 0) {
                                n5 -= nArray7[n24];
                            }
                        }
                        n4 = n9 >> 8;
                        if (cArrayArray[n4] == null) {
                            cArrayArray[n4] = new char[256];
                        }
                        cArrayArray[n4][n9 & 0xFF] = (char)n5;
                    }
                    ++n9;
                }
            }
        } else if (n13 == 6 || n13 == 10) {
            int n28 = n13 == 6 ? this.readUint16() : this.readUint32();
            int n29 = n11 = n13 == 6 ? this.readUint16() : this.readUint32();
            if (n28 + n11 > 0x100000) {
                throw new IllegalStateException();
            }
            int n30 = n28;
            for (int i4 = 0; i4 < n11; ++i4) {
                int n31 = this.readUint16();
                int n32 = n30 >> 8;
                if (cArrayArray[n32] == null) {
                    cArrayArray[n32] = new char[256];
                }
                cArrayArray[n32][n30 & 0xFF] = (char)n31;
                ++n30;
            }
        } else {
            if (n13 == 8) {
                throw new IllegalStateException("format 8 " + this.getName());
            }
            if (n13 == 12) {
                int n33 = this.readUint32();
                for (n11 = 0; n11 < n33; ++n11) {
                    int n34 = this.readUint32();
                    int n35 = this.readUint32();
                    int n36 = this.readUint32();
                    while (n34 <= n35) {
                        int n37 = n34 >> 8;
                        if (n37 >= cArrayArray.length) {
                            throw new IllegalStateException(Integer.toHexString(n34) + " => " + n37);
                        }
                        if (cArrayArray[n37] == null) {
                            cArrayArray[n37] = new char[256];
                        }
                        cArrayArray[n37][n34 & 0xFF] = (char)n36;
                        ++n34;
                        ++n36;
                    }
                }
            } else {
                return CMap.IDENTITY;
            }
        }
        if (3 == n16 && n17 == 0) {
            int n38 = 240;
            int n39 = 0;
            while (n38 <= 240) {
                char[] cArray = cArrayArray[n38];
                if (cArray != null && cArrayArray[n39] == null) {
                    cArrayArray[n39] = cArray;
                    cArrayArray[n38] = null;
                }
                ++n38;
                ++n39;
            }
        }
        return new CMap(cArrayArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Shape getGlyph(int n2) {
        Shape shape;
        if (!this.canDisplayGID(n2)) {
            if (this.notdef_ == null) {
                this.notdef_ = this.canDisplayGID(0) ? this.getGlyph(0) : GLYPH_ZERO_CONTOUR;
            }
            return this.notdef_;
        }
        SoftReference softReference = this.paths_[n2];
        Shape shape2 = shape = softReference != null ? (Shape)softReference.get() : null;
        if (shape == null) {
            Object object = this.parseGlyphLock;
            synchronized (object) {
                softReference = this.paths_[n2];
                Shape shape3 = shape = softReference != null ? (Shape)softReference.get() : null;
                if (shape != null) {
                    return shape;
                }
                this.mGlyphData = new n(this.mMaxpTable);
                this.parseGlyph(n2);
                short s2 = this.getLeftSideBearing(n2);
                this.mGlyphData.a((int)s2, 1.0);
                if (this.mGlyphData.a() == 0) {
                    return GLYPH_ZERO_CONTOUR;
                }
                shape = this.buildPathFromGlyphDefinition();
                this.paths_[n2] = new SoftReference<Shape>(shape);
            }
        }
        return shape;
    }

    private void parseGlyph(int n2) {
        this.readLocaTable();
        if (n2 < 0 || n2 + 1 >= this.loca_.length) {
            return;
        }
        if (this.ra_ == null) {
            try {
                this.getRA();
            }
            catch (IOException iOException) {
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        if (this.getTable(1735162214, this.loca_[n2], this.loca_[n2 + 1] - this.loca_[n2]).length < 10) {
            return;
        }
        int n3 = this.readInt16();
        this.mGlyphData.a(n3);
        float f2 = this.readFWord();
        float f3 = this.readFWord();
        float f4 = this.readFWord();
        float f5 = this.readFWord();
        if (n3 == 0) {
            return;
        }
        if (n3 > 0) {
            this.parseSimpleGlyph(n2, n3);
        } else {
            if (n3 != -1) {
                throw new IllegalStateException(n3 + "");
            }
            this.parseCompositeGlyph(n2);
        }
        this.releaseRA();
    }

    private void parseSimpleGlyph(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        byte by2;
        int n7;
        int n8;
        int n9;
        int[] nArray = new int[n3];
        int n10 = 0;
        for (n9 = 0; n9 < n3; ++n9) {
            int n11;
            nArray[n9] = n11 = this.readUint16();
        }
        n9 = this.readUint16();
        if (n9 > 1) {
            this.hint_ = 1;
        }
        int[] nArray2 = new int[n9];
        for (n8 = 0; n8 < n9; ++n8) {
            nArray2[n8] = this.readUint8() & 0xFF;
        }
        n8 = nArray[nArray.length - 1] + 1;
        byte[] byArray = new byte[n8];
        for (n7 = 0; n7 < n8; ++n7) {
            by2 = this.data_[this.getOffset()];
            this.skip(1);
            byArray[n7] = by2;
            if ((by2 & 1) != 0) {
                ++n10;
            }
            if ((by2 & 8) == 0) continue;
            n6 = this.readUint8();
            n5 = n7 + n6;
            while (n7 < n5) {
                byArray[n7 + 1] = by2;
                ++n7;
            }
            if ((by2 & 1) == 0) continue;
            n10 += n6;
        }
        n7 = 0;
        int[] nArray3 = new int[n8];
        for (n6 = 0; n6 < n8; ++n6) {
            by2 = byArray[n6];
            if ((by2 & 2) != 0) {
                n5 = this.readUint8();
                if ((by2 & 0x10) == 0) {
                    n5 = -n5;
                }
            } else {
                n5 = (by2 & 0x10) != 0 ? 0 : this.readInt16();
            }
            nArray3[n6] = n7 += n5;
        }
        n6 = 0;
        int[] nArray4 = new int[n8];
        for (n5 = 0; n5 < n8; ++n5) {
            int n12;
            by2 = byArray[n5];
            if ((by2 & 4) != 0) {
                n12 = this.readUint8();
                if ((by2 & 0x20) == 0) {
                    n12 = -n12;
                }
            } else {
                n12 = (by2 & 0x20) != 0 ? 0 : this.readInt16();
            }
            nArray4[n5] = n6 += n12;
        }
        int[] nArray5 = new int[n8];
        int[] nArray6 = new int[n8];
        byte[] byArray2 = new byte[n8];
        int[] nArray7 = new int[n3];
        int n13 = this.mGlyphData.a[this.mGlyphData.a];
        int n14 = this.mGlyphData.b[this.mGlyphData.a];
        if (logger.isLoggable(Level.FINEST)) {
            System.out.println("  SimpleGlyph has: " + n8 + " points - flags, X, and Y follow: ");
            System.out.print("     ");
            for (n4 = 0; n4 < n8; ++n4) {
                System.out.print(" 0x" + Integer.toHexString(byArray[n4]));
            }
            System.out.println();
            System.out.print("    ");
            for (n4 = 0; n4 < n8; ++n4) {
                System.out.print("  " + Integer.toString(nArray3[n4] + n13));
            }
            System.out.println();
            System.out.print("    ");
            for (n4 = 0; n4 < n8; ++n4) {
                System.out.print("  " + Integer.toString(nArray4[n4] + n14));
            }
            System.out.println();
        }
        ++this.mGlyphData.a;
        for (n4 = 0; n4 < n8; ++n4) {
            int n15 = nArray3[n4] + n13;
            nArray5[n4] = (int)(1.0 * (double)n15 + 0.5);
            n15 = nArray4[n4] + n14;
            nArray6[n4] = (int)(1.0 * (double)n15 + 0.5);
            byArray2[n4] = byArray[n4];
        }
        for (n4 = 0; n4 < n3; ++n4) {
            nArray7[n4] = nArray[n4];
        }
        this.mGlyphData.a(nArray5, nArray6, nArray7, n10, nArray2, byArray2, n2);
    }

    private void parseCompositeGlyph(int n2) {
        int n3 = 0;
        int n4 = 0;
        m m2 = this.getTableDirectory(1735162214);
        int n5 = 0;
        int n6 = 0;
        while (this.getOffset() + 4 <= this.data_.length) {
            int n7;
            int n8;
            int n9;
            n5 = this.readUint16();
            int n10 = this.readUint16();
            if (!this.canDisplayGID(n10)) {
                throw new IllegalStateException(n10 + "");
            }
            if ((n5 & 2) == 2) {
                if ((n5 & 1) == 1) {
                    n9 = this.readInt16();
                    n8 = this.readInt16();
                } else {
                    n9 = this.readInt8();
                    n8 = this.readInt8();
                }
            } else {
                if ((n5 & 1) == 0) {
                    this.mGlyphData.b = this.readUint8();
                    this.mGlyphData.c = this.readUint8();
                } else {
                    this.mGlyphData.b = this.readUint16();
                    this.mGlyphData.c = this.readUint16();
                }
                int n11 = this.mGlyphData.a(1, this.mGlyphData.b);
                int n12 = this.mGlyphData.b(1, this.mGlyphData.b);
                int n13 = this.mGlyphData.a(1, this.mGlyphData.c);
                int n14 = this.mGlyphData.b(1, this.mGlyphData.c);
                int n15 = n11 - n13;
                n7 = n12 - n14;
                n9 = n15;
                n8 = n7;
            }
            if ((n5 & 4) == 4) {
                // empty if block
            }
            float f2 = 1.0f;
            float f3 = 1.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            if ((n5 & 0x40) == 64) {
                f2 = this.readF2Dot14();
                f3 = this.readF2Dot14();
            } else if ((n5 & 8) == 8) {
                f2 = f3 = this.readF2Dot14();
            } else if ((n5 & 0x80) == 128) {
                f2 = this.readF2Dot14();
                f5 = this.readF2Dot14();
                f4 = this.readF2Dot14();
                f3 = this.readF2Dot14();
            }
            if ((n5 & 0x200) != 0) {
                if (n2 < this.widths_.length && n10 < this.widths_.length) {
                    this.widths_[n2] = this.widths_[n10];
                } else if (n10 < this.widths_.length) {
                    // empty if block
                }
            }
            byte[] byArray = this.data_;
            n7 = this.getOffset();
            m m3 = this.getTableDirectory(1718642541);
            this.getTable(m2, 0, 41250);
            int n16 = n9;
            int n17 = n8;
            n9 += n3;
            n8 += n4;
            if ((n5 & 0x800) != 0) {
                float f6 = Math.max(f2, f3);
                n9 = (int)((float)n9 * f6);
                n8 = (int)((float)n8 * f6);
            }
            f2 = (float)((double)f2 / 1.0);
            f3 = (float)((double)f3 / 1.0);
            AffineTransform affineTransform = this.paths_[n10] != null ? new AffineTransform(f2, f4, f5, f3, n9, n8) : new AffineTransform(f2, f4, f5, f3, 0.0f, 0.0f);
            this.mGlyphData.a(affineTransform);
            this.mGlyphData.a[n6] = n9;
            this.mGlyphData.b[n6] = n8;
            n3 = n9;
            n4 = n8;
            this.parseGlyph(n10);
            n3 -= n16;
            n4 -= n17;
            this.data_ = byArray;
            this.setOffset(n7);
            int[] nArray = null;
            if ((n5 & 0x20) == 0 && (n5 & 0x100) == 256) {
                int n18 = this.readUint16();
                nArray = new int[n18 + 5];
                int n19 = 0;
                while (this.getOffset() < this.data_.length) {
                    nArray[n19] = this.readUint8() & 0xFF;
                    ++n19;
                }
                this.mGlyphData.a(nArray);
            }
            ++n6;
        }
    }

    private GeneralPath buildPathFromGlyphDefinition() {
        GeneralPath generalPath = null;
        int n2 = this.mGlyphData.b();
        generalPath = n2 > 0 ? this.interpretSimpleGlyph() : this.interpretCompositeGlyph();
        return generalPath;
    }

    private GeneralPath interpretSimpleGlyph() {
        int[] nArray = this.mGlyphData.a();
        if (nArray != null && nArray.length > 0 && this.isHinting()) {
            try {
                this.executeHintingSetup();
                if (this.isHinting()) {
                    this.mInterpreter.a(this.mGlyphData);
                }
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "Error applying glyph hints.", throwable);
            }
        }
        if (this.mGlyphData.a() == 0) {
            return GLYPH_ZERO_CONTOUR;
        }
        GeneralPath generalPath = this.buildPathFromGlyph(this.mGlyphData.a(1, 0), this.mGlyphData.b(1, 0), this.mGlyphData.b(0), this.mGlyphData.b(0), this.mGlyphData.b(0));
        return generalPath;
    }

    private GeneralPath interpretCompositeGlyph() {
        GeneralPath generalPath = new GeneralPath(1);
        int[] nArray = this.mGlyphData.a();
        if (nArray.length > 0 && this.isHinting()) {
            this.executeHintingSetup();
            try {
                if (this.isHinting()) {
                    this.mInterpreter.a(this.mGlyphData);
                }
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "Error applying glyph hints.", throwable);
            }
        }
        for (int i2 = 0; i2 < this.mGlyphData.a(); ++i2) {
            AffineTransform affineTransform = this.mGlyphData.a(i2);
            int n2 = this.mGlyphData.a(i2);
            SoftReference softReference = this.paths_[n2];
            GeneralPath generalPath2 = softReference != null ? (softReference != null ? (GeneralPath)softReference.get() : null) : this.buildPathFromGlyph(this.mGlyphData.a(1, i2), this.mGlyphData.b(1, i2), this.mGlyphData.b(i2), this.mGlyphData.b(i2), this.mGlyphData.b(i2));
            if (affineTransform.isIdentity()) {
                generalPath.append(generalPath2.getPathIterator(null), false);
                continue;
            }
            generalPath.append(generalPath2.getPathIterator(affineTransform), false);
        }
        return generalPath;
    }

    private GeneralPath buildPathFromGlyph(int[] nArray, int[] nArray2, int[] nArray3, byte[] byArray, int n2) {
        boolean bl2 = true;
        GeneralPath generalPath = new GeneralPath(1, n2 * 2 + 5);
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        int n3 = byArray.length;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 < n3) {
            float f2;
            int n7;
            int n8;
            int n9;
            if (bl4) {
                bl4 = false;
                n9 = n5;
                ++n6;
                bl5 = true;
            } else if (bl5) {
                bl5 = false;
                bl3 = false;
                n5 = n4;
                n8 = nArray[n4];
                n7 = nArray2[n4];
                if ((byArray[n4] & 1) != 0) {
                    generalPath.moveTo(n8, n7);
                } else {
                    if (++n4 == n3) break;
                    float f3 = nArray[n4];
                    f2 = nArray2[n4];
                    if ((byArray[n4] & 1) == 0) {
                        generalPath.moveTo(((float)n8 + f3) / 2.0f, ((float)n7 + f2) / 2.0f);
                    } else {
                        generalPath.moveTo(f3, f2);
                    }
                }
                n9 = n4;
                if (n4 == nArray3[n6]) {
                    bl4 = true;
                } else {
                    ++n4;
                }
            } else {
                n9 = n4;
                if (n4 == nArray3[n6]) {
                    bl4 = true;
                } else {
                    ++n4;
                }
            }
            boolean bl6 = (byArray[n9] & 1) != 0;
            n8 = nArray[n9];
            n7 = nArray2[n9];
            if (bl6) {
                if (bl3) {
                    generalPath.lineTo(n8, n7);
                } else {
                    bl3 = true;
                }
            } else {
                n9 = bl4 || n9 + 1 >= n3 ? n5 : n9 + 1;
                f2 = nArray[n9];
                float f4 = nArray2[n9];
                boolean bl7 = bl6 = (byArray[n9] & 1) != 0;
                if (!bl6) {
                    f2 = ((float)n8 + f2) / 2.0f;
                    f4 = ((float)n7 + f4) / 2.0f;
                }
                generalPath.quadTo(n8, n7, f2, f4);
                bl3 = false;
            }
            if (!bl5) continue;
            ++n4;
        }
        return generalPath;
    }

    private boolean isBitmap() {
        if (this.gid2bitmap_ == null) {
            if (NFont.getUseBitmaps() && this.at_.getShearY() == 0.0 && this.at_.getShearX() == 0.0 && (double)this.size_ * this.at_.getScaleX() <= 18.0 && (double)this.size_ * this.at_.getScaleY() <= 18.0) {
                int n2;
                Rectangle2D rectangle2D = this.getMaxCharBounds();
                this.imgx_ = rectangle2D.getX();
                this.imgy_ = rectangle2D.getY();
                this.imgw_ = (int)Math.ceil(rectangle2D.getWidth());
                this.imgh_ = (int)Math.ceil(rectangle2D.getHeight());
                int n3 = this.instances_.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    NFontTrueType nFontTrueType = (NFontTrueType)((SoftReference)this.instances_.get(n2)).get();
                    if (nFontTrueType == null || this == nFontTrueType || nFontTrueType.gid2bitmap_ == null || nFontTrueType.gid2bitmap_ == NONE || !this.getName().equals(nFontTrueType.getName()) || !((double)Math.abs(this.size_ - nFontTrueType.size_) < 0.01) || !this.at_.equals(nFontTrueType.at_) || !Arrays.equals(this.newwidths_, nFontTrueType.newwidths_)) continue;
                    this.gid2bitmap_ = nFontTrueType.gid2bitmap_;
                    this.buf_ = nFontTrueType.buf_;
                    break;
                }
                if (this.gid2bitmap_ == null) {
                    this.gid2bitmap_ = new HashMap(100);
                    this.buf_ = new int[this.imgw_ * this.imgh_];
                    n2 = 0;
                    int n4 = this.instances_.size();
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (((SoftReference)this.instances_.get(n3)).get() != null) continue;
                        this.instances_.set(n3, new SoftReference<NFontTrueType>(this));
                        n2 = 1;
                    }
                    if (n2 == 0) {
                        this.instances_.add(new SoftReference<NFontTrueType>(this));
                    }
                }
            } else {
                this.gid2bitmap_ = NONE;
            }
        }
        return this.gid2bitmap_ != NONE;
    }

    private Image getBitmap(Shape shape, int n2, double d2) {
        Map map = this.gid2bitmap_;
        Integer n3 = org.icepdf.core.pobjects.fonts.nfont.c.d.a(n2);
        BufferedImage bufferedImage = (BufferedImage)map.get(n3);
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(this.imgw_, this.imgh_, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics2D.setColor(COLOR_TRANSPARENT);
            graphics2D.fillRect(0, 0, this.imgw_, this.imgh_);
            graphics2D.setColor(this.color_);
            graphics2D.fillRect(0, 0, 1, 1);
            graphics2D.translate(-this.imgx_, -this.imgy_);
            graphics2D.transform(this.u_);
            graphics2D.scale(d2, 1.0);
            graphics2D.setColor(this.color_);
            graphics2D.fill(shape);
            if (bufferedImage.getRGB(0, 0) == 0) {
                bufferedImage.setRGB(0, 0, this.color_.getRGB() & 0xFFFFFF);
            }
            graphics2D.dispose();
            map.put(n3, bufferedImage);
        } else {
            int n4 = this.color_.getRGB() & 0xFFFFFF;
            if (n4 != (bufferedImage.getRGB(0, 0) & 0xFFFFFF)) {
                int[] nArray = this.buf_;
                bufferedImage.getRGB(0, 0, this.imgw_, this.imgh_, nArray, 0, this.imgw_);
                int n5 = nArray.length;
                for (int i2 = 0; i2 < n5; ++i2) {
                    if (nArray[i2] == 0) continue;
                    nArray[i2] = nArray[i2] & 0xFF000000 | n4;
                }
                bufferedImage.setRGB(0, 0, this.imgw_, this.imgh_, nArray, 0, this.imgw_);
                if (bufferedImage.getRGB(0, 0) == 0) {
                    bufferedImage.setRGB(0, 0, n4);
                }
            }
        }
        return bufferedImage;
    }

    public Point2D echarAdvance(char c2) {
        char c3 = this.c2g_.toSelector(c2);
        double d2 = !this.canDisplayGID(c3) ? 0.0 : (this.newwidths_ != null && c2 >= this.firstch_ && c2 <= this.lastch_ && this.newwidths_[c2 - this.firstch_] > 1.0f ? (double)this.newwidths_[c2 - this.firstch_] * 0.001 : (this.newwidths_ != null && c2 >= this.firstch_ && c2 <= this.lastch_ && this.newwidths_[c2 - this.firstch_] <= 1.0f ? (double)this.newwidths_[c2 - this.firstch_] : (double)this.widths_[Math.min(c3, this.widths_.length - 1)] * this.m_.getScaleX()));
        double d3 = d2 * (double)this.size_ * this.at_.getScaleX();
        double d4 = d2 * (double)this.size_ * this.at_.getShearY();
        return new Point2D.Double(d3, d4);
    }

    public Rectangle2D getEstringBounds(String string, int n2, int n3) {
        Cloneable cloneable;
        Rectangle2D rectangle2D = new Rectangle2D.Double();
        double d2 = 0.0;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0000' || c2 >= this.getMaxGlyphNum()) continue;
            cloneable = this.getGlyph(c2).getBounds2D();
            ((Rectangle2D)cloneable).setRect(d2 + ((RectangularShape)cloneable).getX(), ((RectangularShape)cloneable).getY(), ((RectangularShape)cloneable).getWidth(), ((RectangularShape)cloneable).getHeight());
            rectangle2D = rectangle2D.createUnion((Rectangle2D)cloneable);
            d2 += (double)this.widths_[Math.min(c2, this.widths_.length - 1)];
        }
        this.releaseRA();
        AffineTransform affineTransform = new AffineTransform(this.m_);
        affineTransform.concatenate(this.at_);
        affineTransform.scale(this.size_, -this.size_);
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
        cloneable = new Point2D.Double(rectangle2D.getWidth(), rectangle2D.getHeight());
        affineTransform.transform(double_, double_);
        affineTransform.transform((Point2D)cloneable, (Point2D)cloneable);
        rectangle2D.setRect(((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Point2D)cloneable).getX(), ((Point2D)cloneable).getY());
        return rectangle2D;
    }

    public void drawEstring(Graphics2D graphics2D, String string, float f2, float f3, long l2, int n2, Color color) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (SUBFORMAT_BITMAP == this.getSubformat()) {
            return;
        }
        boolean bl2 = (0x40L & l2) != 0L;
        AffineTransform affineTransform = graphics2D.getTransform();
        boolean bl3 = 0 == n2 && this.isBitmap() && affineTransform.getScaleX() == 1.0 && affineTransform.getShearY() == 0.0 && affineTransform.getShearX() == 0.0 && affineTransform.getScaleY() == 1.0;
        Color color2 = graphics2D.getColor();
        BasicStroke basicStroke = null;
        if (bl3) {
            this.color_ = color2;
        } else {
            graphics2D.translate(f2, f3);
            graphics2D.transform(this.u_);
            if (1 == n2 || 2 == n2 || 5 == n2 || 6 == n2) {
                basicStroke = (BasicStroke)graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke((float)((double)basicStroke.getLineWidth() / Math.sqrt(Math.abs(this.u_.getDeterminant()))), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase()));
            }
        }
        double d2 = (double)f2 + this.imgx_;
        int n3 = (int)Math.round((double)f3 + this.imgy_);
        int n4 = string.length();
        for (int i2 = 0; i2 < n4; ++i2) {
            double d3;
            Shape shape;
            char c2 = string.charAt(i2);
            char c3 = this.c2g_.toSelector(c2);
            if ('\u0000' == c3) {
                c3 = this.ur_.c2g_.toSelector(c2);
            }
            if ((shape = this.getGlyph(c3)) == this.notdef_) {
                c3 = '\u0000';
            }
            double d4 = this.widths_[Math.min(c3, this.widths_.length - 1)];
            int n5 = c2 - this.firstch_;
            double d5 = this.newwidths_ != null && 0 <= n5 && n5 < this.newwidths_.length && this.newwidths_[n5] > 1.0f ? (double)this.newwidths_[n5] * 0.001 / this.m_.getScaleX() : 0.0;
            double d6 = d3 = d5 <= 1.0 || Math.abs(d4 - d5) <= 2.0 || this.pdfbad_[n5] ? 1.0 : d5 / d4;
            if (bl3) {
                Image image = this.getBitmap(shape, c3, d3);
                if (image != null) {
                    graphics2D.drawImage(image, (int)(d2 + 0.5), n3, null);
                }
                d2 += (d5 != 0.0 ? d5 : d4) * this.u_.getScaleX();
                continue;
            }
            if (d3 != 1.0) {
                graphics2D.scale(d3, 1.0);
            }
            if (0 == n2 || 2 == n2 || 4 == n2 || 6 == n2) {
                graphics2D.fill(shape);
            }
            if (1 == n2 || 2 == n2 || 5 == n2 || 6 == n2) {
                if (color == null || color.equals(color2)) {
                    graphics2D.draw(shape);
                } else {
                    graphics2D.setColor(color);
                    graphics2D.draw(shape);
                    graphics2D.setColor(color2);
                }
            }
            if (d3 != 1.0) {
                graphics2D.scale(1.0 / d3, 1.0);
            }
            graphics2D.translate(d5 != 0.0 ? d5 : d4, 0.0);
        }
        if (!bl3) {
            graphics2D.setTransform(affineTransform);
        }
        if (basicStroke != null) {
            graphics2D.setStroke(basicStroke);
        }
        this.releaseRA();
    }

    public Shape getEstringOutline(String string, float f2, float f3) {
        char c2 = string.charAt(0);
        char c3 = this.c2g_.toSelector(c2);
        if ('\u0000' == c3) {
            c3 = this.ur_.c2g_.toSelector(c2);
        }
        Shape shape = this.getGlyph(c3);
        Area area = new Area(shape);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(f2, f3);
        affineTransform.concatenate(this.u_);
        area = area.createTransformedArea(affineTransform);
        return area;
    }

    public Rectangle2D getCharBounds(char c2) {
        return this.getEstringBounds(String.valueOf(c2), 0, 1);
    }

    public boolean isOneByteEncoding() {
        return this.c2g_.isOneByte(32);
    }

    void readCVT_(a a2) {
        this.getTable(1668707360);
        int n2 = this.data_.length / 2;
        a2.a = new short[n2];
        a2.a = new int[a2.a.length];
        a2.a = new int[a2.a.length];
        for (int i2 = 0; i2 < n2; ++i2) {
            a2.a[i2] = (short)this.readInt16();
        }
    }

    public void debugPosteriors(n n2) {
        int n3 = 0;
        System.out.println("After hinting");
        System.out.println("\t\tp.n.\tNew X\t\tNew Y\t\tOrg X\t\tOrg Y\t\tx tch\t\ty tch");
        for (int i2 = 0; i2 < n2.a(); ++i2) {
            int[] nArray = n2.a(1, i2);
            int[] nArray2 = n2.b(1, i2);
            int[] nArray3 = n2.a(3, i2);
            int[] nArray4 = n2.b(3, i2);
            boolean[] blArray = n2.a(1, i2);
            boolean[] blArray2 = n2.b(1, i2);
            byte[] byArray = n2.a(i2);
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                System.out.println("\t\t" + n3++ + "\t\t" + nArray[i3] + "\t\t" + nArray2[i3] + "\t\t" + nArray3[i3] + "\t\t" + nArray4[i3] + "\t\t" + blArray[i3] + "\t\t" + blArray2[i3]);
            }
        }
    }

    public boolean isHinting() {
        return this.hinting;
    }

    public void setHinting(boolean bl2) {
        this.hinting = bl2;
    }

    private void executeHintingSetup() {
        if (this.mInterpreter == null) {
            this.getTable(1718642541);
            byte[] byArray = this.data_;
            this.fpgm_ = new int[byArray.length];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                this.fpgm_[i2] = byArray[i2] & 0xFF;
            }
            this.getTable(1668707360);
            this.mCvtTable = new a();
            this.readCVT_(this.mCvtTable);
            this.mInterpreter = new hn(this.mMaxpTable, this);
            this.mInterpreter.a().a(this.mCvtTable);
            this.mInterpreter.a(this.mCvtTable);
            org.icepdf.core.pobjects.fonts.nfont.instructions.d d2 = new org.icepdf.core.pobjects.fonts.nfont.instructions.d();
            d2.a(this.mCvtTable);
            n n2 = new n(this.mMaxpTable);
            g g2 = new g();
            hn.a(n2, this.fpgm_, g2, d2);
            if (1.0 != this.mCvtTable.a) {
                this.mCvtTable.a = 1.0;
                this.mCvtTable.a(1.0);
                this.getTable(1886545264);
                byte[] byArray2 = this.data_;
                this.cvp_ = new int[byArray2.length];
                for (int i3 = 0; i3 < byArray2.length; ++i3) {
                    this.cvp_[i3] = byArray2[i3] & 0xFF;
                }
                hn.a(n2, this.cvp_, g2, d2);
                this.mInterpreter.a(d2);
            }
        }
    }
}

