/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.nfont;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.fonts.nfont.CMap;
import org.icepdf.core.pobjects.fonts.nfont.c.i;
import org.icepdf.core.pobjects.fonts.nfont.h;

public class Encoding {
    protected static final Logger logger = Logger.getLogger(Encoding.class.toString());
    public static final Encoding UNICODE = new h();
    public static final Encoding ADOBE_STANDARD;
    public static final Encoding MAC_ROMAN;
    public static final Encoding MAC_EXPERT;
    public static final Encoding WIN_ANSI;
    public static final Encoding PDF_DOC;
    public static final Encoding ZAPF_DINGBATS;
    public static final Encoding SYMBOL;
    public static final Encoding IDENTITY;
    private String name_;
    private String[] map_;
    private CMap toUni_ = null;
    private boolean hasUni_;
    private Encoding base_ = IDENTITY;

    private static void readEncodings(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Encoding.class.getResourceAsStream("/org/icepdf/core/pobjects/fonts/nfont/encoding/Encoding" + string + ".txt")));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (!string2.startsWith("#")) {
                char c2;
                int n2;
                int n3 = 0;
                int n4 = string2.length();
                while (string2.charAt(n3) != ' ') {
                    ++n3;
                }
                String string3 = i.a(string2.substring(0, n3));
                ++n3;
                if (stringArray != null) {
                    n2 = 0;
                    while ((c2 = string2.charAt(n3++)) != ' ') {
                        if (c2 == '-') continue;
                        n2 = n2 * 8 + c2 - 48;
                    }
                    stringArray[n2] = string3;
                    n2 = 0;
                    while ((c2 = string2.charAt(n3++)) != ' ') {
                        if (c2 == '-') continue;
                        n2 = n2 * 8 + c2 - 48;
                    }
                    stringArray2[n2] = string3;
                    n2 = 0;
                    while ((c2 = string2.charAt(n3++)) != ' ') {
                        if (c2 == '-') continue;
                        n2 = n2 * 8 + c2 - 48;
                    }
                    stringArray3[n2] = string3;
                }
                n2 = 0;
                while (n3 < n4) {
                    if ((c2 = string2.charAt(n3++)) == '-') continue;
                    n2 = n2 * 8 + c2 - 48;
                }
                stringArray4[n2] = string3;
            }
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        if (stringArray != null) {
            stringArray3[0] = ".notdef";
            stringArray2[0] = ".notdef";
            stringArray[0] = ".notdef";
        }
        stringArray4[0] = ".notdef";
    }

    public Encoding(String string, String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException(string);
        }
        this.name_ = string;
        this.map_ = stringArray;
        boolean bl2 = true;
        for (String string2 : stringArray) {
            if (string2 == null) continue;
            if (".notdef".equals(string2)) {
                stringArray[var4_4] = ".notdef";
                continue;
            }
            if (!bl2 || UNICODE.getChar(string2) != '\u0000') continue;
            bl2 = false;
        }
        this.hasUni_ = bl2;
    }

    public Encoding(Encoding encoding, Object[] objectArray) {
        if (encoding == null) {
            encoding = IDENTITY;
        }
        this.base_ = encoding;
        String[] stringArray = encoding.map_;
        boolean bl2 = encoding.hasUni_;
        if (objectArray != null) {
            stringArray = (String[])stringArray.clone();
            int n2 = objectArray.length;
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = objectArray[i2];
                if (object instanceof Number) {
                    n3 = ((Number)object).intValue();
                    continue;
                }
                if (!(object instanceof String)) {
                    throw new IllegalStateException();
                }
                if (!".notdef".equals(object)) {
                    String string;
                    stringArray[n3] = string = (String)object;
                    if (bl2 && UNICODE.getChar(string) == '\u0000') {
                        bl2 = false;
                    }
                }
                ++n3;
            }
        }
        this.name_ = encoding.name_ + "+diffs";
        this.map_ = stringArray;
        this.hasUni_ = bl2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.map_.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(i2).append(" -> ").append(this.map_[i2]).append("\n");
        }
        return stringBuilder.toString();
    }

    public static Encoding getInstance(String string) {
        Encoding encoding = string == null || "Identity".equals(string) ? IDENTITY : ("StandardEncoding".equals(string) ? ADOBE_STANDARD : ("MacRomanEncoding".equals(string) ? MAC_ROMAN : ("MacExpertEncoding".equals(string) ? MAC_EXPERT : ("WinAnsiEncoding".equals(string) ? WIN_ANSI : ("PDFDocEncoding".equals(string) ? PDF_DOC : ("ZapfDingbatsEncoding".equals(string) ? ZAPF_DINGBATS : ("SymbolEncoding".equals(string) ? SYMBOL : null)))))));
        return encoding;
    }

    public String getName() {
        return this.name_;
    }

    public Encoding getBase() {
        return this.base_;
    }

    public String getName(int n2) {
        String string = 0 <= n2 && n2 < this.map_.length ? this.map_[n2] : null;
        return string != null ? string : ".notdef";
    }

    public char getChar(String string) {
        char c2 = '\u0000';
        int n2 = this.map_.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equals(this.map_[i2])) continue;
            c2 = (char)i2;
            break;
        }
        return c2;
    }

    public CMap mapTo(Encoding encoding) {
        CMap cMap;
        if (encoding == this || IDENTITY == this || IDENTITY == encoding) {
            cMap = CMap.IDENTITY;
        } else {
            char[] cArray = new char[this.map_.length];
            int n2 = this.map_.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string;
                char c2 = (char)i2;
                String string2 = string = '\u0000' <= c2 && c2 <= this.map_.length ? this.map_[c2] : null;
                if (string == null) continue;
                cArray[i2] = string.equals(encoding.getName(c2)) ? c2 : encoding.getChar(string);
            }
            cMap = new CMap(cArray);
        }
        return cMap;
    }

    public CMap guessToUnicode() {
        if (this.toUni_ == null) {
            int n2;
            char[] cArray = new char[256];
            for (n2 = 0; n2 < 256; ++n2) {
                cArray[n2] = UNICODE.getChar(this.getName((char)n2));
            }
            n2 = 1;
            for (int i2 = 0; i2 < 256; ++i2) {
                int n3 = cArray[i2];
                if (n3 == i2 || this.map_[i2] == null || !this.map_[i2].equals(".notdef")) continue;
                n2 = 0;
                break;
            }
            this.toUni_ = n2 != 0 ? new CMap(cArray) : CMap.IDENTITY;
        }
        return this.toUni_;
    }

    public boolean hasUnicode() {
        return this.hasUni_;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Encoding && object != IDENTITY && object != UNICODE && Arrays.equals(this.map_, ((Encoding)object).map_);
    }

    static {
        Encoding.UNICODE.toUni_ = CMap.IDENTITY;
        Encoding.UNICODE.hasUni_ = true;
        String[] stringArray = new String[256];
        String[] stringArray2 = new String[256];
        String[] stringArray3 = new String[256];
        String[] stringArray4 = new String[256];
        try {
            Encoding.readEncodings("Latin", stringArray, stringArray2, stringArray3, stringArray4);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Error reading encoding.", iOException);
        }
        stringArray3[127] = "bullet";
        ADOBE_STANDARD = new Encoding("Standard", stringArray);
        MAC_ROMAN = new Encoding("MacRoman", stringArray2);
        WIN_ANSI = new Encoding("WinAnsi", stringArray3);
        PDF_DOC = new Encoding("PDFDoc", stringArray4);
        String[] stringArray5 = new String[256];
        try {
            Encoding.readEncodings("Expert", null, null, null, stringArray5);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Error reading encoding.", iOException);
        }
        MAC_EXPERT = new Encoding("MacExpert", stringArray5);
        String[] stringArray6 = new String[256];
        try {
            Encoding.readEncodings("Symbol", null, null, null, stringArray6);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Error reading encoding.", iOException);
        }
        SYMBOL = new Encoding("Symbol", stringArray6);
        String[] stringArray7 = new String[256];
        try {
            Encoding.readEncodings("Zapf", null, null, null, stringArray7);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Error reading encoding.", iOException);
        }
        ZAPF_DINGBATS = new Encoding("ZapfDingbats", stringArray7);
        IDENTITY = new Encoding("Identity", new String[256]);
        Encoding.IDENTITY.toUni_ = CMap.IDENTITY;
        Encoding.IDENTITY.hasUni_ = false;
    }
}

