/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.network2;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import se.sjobeck.datastructures.utilities.Pair;
import se.sjobeck.gui.DialogCreator;
import se.sjobeck.gui.StartupScreen;
import se.sjobeck.network2.ApplicationType;
import se.sjobeck.network2.ClientStatus;
import se.sjobeck.network2.FromServerMessage;
import se.sjobeck.network2.KeyGenerator;
import se.sjobeck.network2.Message;
import se.sjobeck.network2.ShutDownProgram;
import se.sjobeck.rmi.encoded.EncodedInputStream;
import se.sjobeck.rmi.encoded.EncodedOutputStream;

public class ClientThread {
    public static ShutDownProgram program;
    private static final String SERVER = "ekalkyl.3kametrics.se";
    public static final int PORT;
    private static Socket s;
    private static ApplicationType type;
    private static volatile transient byte[] id;
    private static volatile transient byte[] sharedSecret;
    private static Pair<String, Date> me;
    private static ObjectOutputStream oout;
    private static ObjectInputStream oin;
    private static ClientStatus status;
    private static EncodedOutputStream encodedOut;
    private static EncodedInputStream encodedIn;

    public static synchronized String getUserFullName() {
        return (String)ClientThread.whoAmI().first;
    }

    public static synchronized Date getLicenseExpiryDate() {
        return (Date)ClientThread.whoAmI().second;
    }

    public static synchronized Pair<String, Date> whoAmI() {
        if (me == null) {
            Object obj = ClientThread.sendMessage(Message.WhoAmI, new Object[0]);
            if (obj instanceof FromServerMessage) {
                FromServerMessage fsm = (FromServerMessage)obj;
                me = fsm.getPair();
            } else {
                System.out.println("Server sends wrong object, contact support");
            }
        }
        return me;
    }

    public static synchronized void setApplicationType(ApplicationType _type) {
        type = _type;
        ClientThread.closeConnection();
    }

    public static synchronized void setCredentials(byte[] _id, byte[] _sharedSecret) {
        id = _id;
        sharedSecret = _sharedSecret;
        ClientThread.closeConnection();
    }

    public static synchronized ClientStatus getStatus() {
        if (type == null) {
            throw new IllegalArgumentException("Application type must be set before attempting to log in!");
        }
        return status;
    }

    public static synchronized ApplicationType getApplicationType() {
        return type;
    }

    public static synchronized Object sendMessage(Message type, Object ... arg) {
        Object t = null;
        switch (type) {
            case ChangePassword: {
                return ClientThread.send(type, arg);
            }
            case ConnectBridgeMount: {
                return ClientThread.send(type, arg);
            }
            case CopyFile: {
                return ClientThread.send(type, arg);
            }
            case CreateBridgeMount: {
                return ClientThread.send(type, arg);
            }
            case CreateFile: {
                return ClientThread.send(type, arg);
            }
            case CreateGeometraDirectory: {
                return ClientThread.send(type, arg);
            }
            case DeleteFile: {
                return ClientThread.send(type, arg);
            }
            case DeleteGeometraProjects: {
                return ClientThread.send(type, arg);
            }
            case FetchDatabase: {
                ClientThread.send(Message.EncryptMessage, false);
                encodedOut.setEncrypt(false);
                encodedIn.setEncrypt(false);
                t = ClientThread.send(type, arg);
                ClientThread.send(Message.EncryptMessage, true);
                encodedOut.setEncrypt(true);
                encodedIn.setEncrypt(true);
                return t;
            }
            case GetAllDatabaseDate: {
                return ClientThread.send(type, arg);
            }
            case GetCRC: {
                return ClientThread.send(type, arg);
            }
            case GetEkalkylCRC: {
                return ClientThread.send(type, arg);
            }
            case GetEkalkylFileContent: {
                ClientThread.send(Message.EncryptMessage, false);
                encodedOut.setEncrypt(false);
                encodedIn.setEncrypt(false);
                t = ClientThread.send(type, arg);
                ClientThread.send(Message.EncryptMessage, true);
                encodedOut.setEncrypt(true);
                encodedIn.setEncrypt(true);
                return t;
            }
            case GetEkalkylFileNamesInProject: {
                ClientThread.send(Message.EncryptMessage, false);
                encodedOut.setEncrypt(false);
                encodedIn.setEncrypt(false);
                t = ClientThread.send(type, arg);
                ClientThread.send(Message.EncryptMessage, true);
                encodedOut.setEncrypt(true);
                encodedIn.setEncrypt(true);
                return t;
            }
            case GetGeoemtraFilesFromProject: {
                ClientThread.send(Message.EncryptMessage, false);
                encodedOut.setEncrypt(false);
                encodedIn.setEncrypt(false);
                t = ClientThread.send(type, arg);
                ClientThread.send(Message.EncryptMessage, true);
                encodedOut.setEncrypt(true);
                encodedIn.setEncrypt(true);
                return t;
            }
            case GetGeometraCRC: {
                return ClientThread.send(type, arg);
            }
            case GetGeometraFileContent: {
                ClientThread.send(Message.EncryptMessage, false);
                encodedOut.setEncrypt(false);
                encodedIn.setEncrypt(false);
                t = ClientThread.send(type, arg);
                ClientThread.send(Message.EncryptMessage, true);
                encodedOut.setEncrypt(true);
                encodedIn.setEncrypt(true);
                return t;
            }
            case GetGeometraProjects: {
                return ClientThread.send(type, arg);
            }
            case GetGeometraVersionTracker: {
                return ClientThread.send(type, arg);
            }
            case GetNetWorkStatus: {
                return ClientThread.send(type, arg);
            }
            case GetVirtualFile: {
                ClientThread.send(Message.EncryptMessage, false);
                encodedOut.setEncrypt(false);
                encodedIn.setEncrypt(false);
                t = ClientThread.send(type, arg);
                ClientThread.send(Message.EncryptMessage, true);
                encodedOut.setEncrypt(true);
                encodedIn.setEncrypt(true);
                return t;
            }
            case HasActiveGeometraLisence: {
                return ClientThread.send(type, arg);
            }
            case HashToUser: {
                return ClientThread.send(type, arg);
            }
            case KeepAlive: {
                return ClientThread.send(type, arg);
            }
            case LookAtMyBridges: {
                return ClientThread.send(type, arg);
            }
            case LookupDatabaseDate: {
                return ClientThread.send(type, arg);
            }
            case ReadFile: {
                ClientThread.send(Message.EncryptMessage, false);
                encodedOut.setEncrypt(false);
                encodedIn.setEncrypt(false);
                t = ClientThread.send(type, arg);
                ClientThread.send(Message.EncryptMessage, true);
                encodedOut.setEncrypt(true);
                encodedIn.setEncrypt(true);
                return t;
            }
            case RemoveBridgeFriend: {
                return ClientThread.send(type, arg);
            }
            case RenameFile: {
                ClientThread.send(Message.EncryptMessage, false);
                encodedOut.setEncrypt(false);
                encodedIn.setEncrypt(false);
                t = ClientThread.send(type, arg);
                ClientThread.send(Message.EncryptMessage, true);
                encodedOut.setEncrypt(true);
                encodedIn.setEncrypt(true);
                return t;
            }
            case ReverseDeleteFile: {
                ClientThread.send(Message.EncryptMessage, false);
                encodedOut.setEncrypt(false);
                encodedIn.setEncrypt(false);
                t = ClientThread.send(type, arg);
                ClientThread.send(Message.EncryptMessage, true);
                encodedOut.setEncrypt(true);
                encodedIn.setEncrypt(true);
                return t;
            }
            case SendEkalkylFileContent: {
                ClientThread.send(Message.EncryptMessage, false);
                encodedOut.setEncrypt(false);
                encodedIn.setEncrypt(false);
                t = ClientThread.send(type, arg);
                ClientThread.send(Message.EncryptMessage, true);
                encodedOut.setEncrypt(true);
                encodedIn.setEncrypt(true);
                return t;
            }
            case SendFile: {
                ClientThread.send(Message.EncryptMessage, false);
                encodedOut.setEncrypt(false);
                encodedIn.setEncrypt(false);
                t = ClientThread.send(type, arg);
                ClientThread.send(Message.EncryptMessage, true);
                encodedOut.setEncrypt(true);
                encodedIn.setEncrypt(true);
                return t;
            }
            case SendGeometraFile: {
                ClientThread.send(Message.EncryptMessage, false);
                encodedOut.setEncrypt(false);
                encodedIn.setEncrypt(false);
                t = ClientThread.send(type, arg);
                ClientThread.send(Message.EncryptMessage, true);
                encodedOut.setEncrypt(true);
                encodedIn.setEncrypt(true);
                return t;
            }
            case WhoAmI: {
                return ClientThread.send(type, arg);
            }
            case WriteFile: {
                ClientThread.send(Message.EncryptMessage, false);
                encodedOut.setEncrypt(false);
                encodedIn.setEncrypt(false);
                t = ClientThread.send(type, arg);
                ClientThread.send(Message.EncryptMessage, true);
                encodedOut.setEncrypt(true);
                encodedIn.setEncrypt(true);
                return t;
            }
        }
        System.out.println("message som inte \u00e4r hanterat! " + (Object)((Object)type));
        return ClientThread.send(type, arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object send(Message type, Object ... arg) {
        System.out.println("Sender meddellande: " + (Object)((Object)type));
        if (type == null) {
            return null;
        }
        ClientThread.loopConnectAttemps();
        Object ret = null;
        do {
            try {
                oout.writeObject((Object)type);
                oout.flush();
                oout.writeObject(arg);
                oout.flush();
                if (oin == null) {
                    System.out.println("oin == null");
                }
                Object object = ret = oin.readObject();
                return object;
            }
            catch (Exception e) {
                e.printStackTrace();
                ClientThread.closeConnection();
                ClientThread.loopConnectAttemps();
            }
        } while (ret == null);
        return ret;
    }

    private static void loopConnectAttemps() {
        int tries = 0;
        while (s == null) {
            if (tries < 3 || ClientThread.askReconnect(tries)) {
                ClientThread.reconnect();
            } else {
                if (program != null) {
                    program.safeShutDown();
                }
                System.exit(1);
            }
            System.out.println("anslutningsf\u00f6rs\u00f6k: " + ++tries);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ClientThread.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static boolean askReconnect(int tries) {
        StartupScreen.temporaryHide();
        Object[] options = new Object[]{ResourceBundle.getBundle("se/sjobeck/Bibliotek").getString("CONTINUE"), ResourceBundle.getBundle("se/sjobeck/Bibliotek").getString("QUIT")};
        int n = JOptionPane.showOptionDialog(null, ResourceBundle.getBundle("se/sjobeck/Bibliotek").getString("COULD_NOT_CONNECT_QUESTION"), ResourceBundle.getBundle("se/sjobeck/Bibliotek").getString("COULD_NOT_CONNECT") + tries, 0, 0, null, options, options[1]);
        StartupScreen.temporaryUnhide();
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void closeConnection() {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ClientThread.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            s = null;
        }
        try {
            if (encodedOut != null) {
                encodedOut.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ClientThread.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            encodedOut = null;
        }
        try {
            if (encodedIn != null) {
                encodedIn.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ClientThread.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            encodedIn = null;
        }
        try {
            if (oout != null) {
                oout.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ClientThread.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            oout = null;
        }
        try {
            if (oin != null) {
                oin.close();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ClientThread.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            oin = null;
        }
        me = null;
        status = ClientStatus.NotConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientStatus reconnect() {
        ClientStatus tempStat = ClientStatus.NotConnected;
        boolean errorHappened = false;
        try {
            System.out.println("s Connecting to ekalkyl.3kametrics.se:" + PORT);
            s = new Socket(SERVER, PORT);
            s.setSoTimeout(20000);
            if (!s.isBound()) {
                System.out.println("s is NOT bound");
            }
            if (!s.isConnected()) {
                System.out.println("s is NOT connected");
            }
        }
        catch (SecurityException se) {
            errorHappened = true;
            System.out.println(se.getMessage());
            status = ClientStatus.NotConnected;
            ClientStatus clientStatus = tempStat;
            return clientStatus;
        }
        catch (UnknownHostException e) {
            errorHappened = true;
            System.out.println(e.getMessage());
            status = ClientStatus.NotConnected;
            ClientStatus clientStatus = tempStat;
            return clientStatus;
        }
        catch (IOException e) {
            errorHappened = true;
            System.out.println(e.getMessage());
            status = ClientStatus.NotConnected;
            ClientStatus clientStatus = tempStat;
            return clientStatus;
        }
        finally {
            if (errorHappened) {
                System.out.println("det blev fel i connect");
                ClientThread.closeConnection();
            }
        }
        errorHappened = false;
        try {
            Provider provider = Security.getProvider("SUN");
            provider.put("SecureRandom.SHA1PRNG", "sun.security.provider.SecureRandom");
        }
        catch (Exception e) {
            errorHappened = true;
            e.printStackTrace();
            DialogCreator.showError("couldnt load suns security provider", "network error");
            ClientStatus clientStatus = tempStat;
            return clientStatus;
        }
        finally {
            if (errorHappened) {
                ClientThread.closeConnection();
                System.out.println("fel n\u00e5nstans det funka inte");
            }
        }
        errorHappened = false;
        try {
            ClientThread.performHandshake();
            oout = new ObjectOutputStream(encodedOut);
            oout.writeObject(type);
            oin = new ObjectInputStream(encodedIn);
            tempStat = status = (ClientStatus)((Object)oin.readObject());
        }
        catch (EOFException e) {
            e.printStackTrace();
            status = ClientStatus.BadCredentials;
            errorHappened = true;
        }
        catch (SocketException e) {
            e.printStackTrace();
            tempStat = status = ClientStatus.BadCredentials;
            errorHappened = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            tempStat = status = ClientStatus.NotConnected;
            errorHappened = true;
        }
        finally {
            if (errorHappened) {
                ClientThread.closeConnection();
            }
        }
        return tempStat;
    }

    private static void performHandshake() throws IOException {
        System.out.println("Client starting handshake.");
        OutputStream unencodedOut = s.getOutputStream();
        InputStream unencodedIn = s.getInputStream();
        unencodedOut.write(id.length);
        unencodedOut.write(id);
        unencodedOut.flush();
        byte[] keyBytes = new byte[sharedSecret.length];
        byte[] peerKey = new byte[sharedSecret.length];
        int read_bytes = 0;
        while ((read_bytes += unencodedIn.read(keyBytes)) < sharedSecret.length) {
        }
        assert (read_bytes == sharedSecret.length);
        for (int i = 0; i < sharedSecret.length; ++i) {
            peerKey[i] = (byte)(sharedSecret[i] ^ keyBytes[i]);
        }
        encodedOut = new EncodedOutputStream(unencodedOut, peerKey);
        byte[] myKey = KeyGenerator.nextBytes(sharedSecret.length);
        encodedOut.write(myKey);
        encodedOut.flush();
        encodedIn = new EncodedInputStream(unencodedIn, myKey);
    }

    static {
        PORT = Integer.valueOf(System.getProperty("jnlp.se.sjobeck.server-port", "3700"));
        type = null;
        me = null;
        oout = null;
        oin = null;
        status = ClientStatus.NotConnected;
    }
}

