/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.digitizer;

import se.sjobeck.digitizer.DigitizerDriver;
import se.sjobeck.digitizer.DigitizerEvent;
import se.sjobeck.digitizer.ReaderThread;
import se.sjobeck.digitizer.usb.HidData;
import se.sjobeck.digitizer.usb.HidDevice;
import se.sjobeck.digitizer.usb.USBDigitizer;

public class UsbReaderThread
extends ReaderThread {
    private HidDevice Device;
    private USBDigitizer Digitizer;

    public UsbReaderThread(HidDevice device, USBDigitizer digitizer) {
        super("UsbReaderThread");
        this.Device = device;
        this.Digitizer = digitizer;
    }

    @Override
    public String getDescription() {
        return this.Digitizer.getDescription();
    }

    @Override
    public void run() {
        if (!this.Device.openDevice()) {
            throw new IllegalArgumentException("Failed to open device!");
        }
        while (true) {
            HidData[] data = this.Device.readData();
            DigitizerEvent ev = this.Digitizer.generateEvent(data);
            DigitizerDriver.postEvent(ev);
        }
    }
}

