/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import se.sjobeck.gui.DialogCreator;
import se.sjobeck.network2.ClientThread;
import se.sjobeck.network2.FromServerMessage;
import se.sjobeck.network2.Message;

public class FileTableModel
extends AbstractTableModel {
    public static final long serialVersionUID = 0L;
    File currentDir;
    File currentFile;
    List<File> fileList;
    JFrame frame;

    public FileTableModel(JFrame frame) {
        this.frame = frame;
        this.fileList = new ArrayList<File>();
        this.currentFile = null;
        this.refresh();
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return String.class;
        }
        return Date.class;
    }

    @Override
    public int getRowCount() {
        return this.fileList.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public File getFile(int row) {
        return this.fileList.get(row);
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row >= this.fileList.size()) {
            return "Error";
        }
        File f = this.fileList.get(row);
        switch (column) {
            case 0: {
                return f.getName();
            }
            case 1: {
                return new Date(f.lastModified());
            }
        }
        return "Error";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int colIndex) {
        if (colIndex == 0 && !this.fileList.get(rowIndex).getName().equals(value.toString())) {
            File oldName = this.fileList.get(rowIndex);
            String newName = value.toString();
            if (this.findLargest(newName) == -1 || JOptionPane.showConfirmDialog(this.frame, "Vill du skriva \u00f6ver filen '" + newName + "'?", "Bekr\u00e4fta \u00f6verskrivning", 0, 3) == 0) {
                boolean fnurr = false;
                try {
                    fnurr = ((FromServerMessage)ClientThread.sendMessage(Message.RenameFile, oldName, newName)).getBoolean();
                }
                catch (Exception e) {
                    fnurr = false;
                }
                if (!fnurr) {
                    DialogCreator.showError("byta namn p\u00e5 fil gick fel, ring support " + oldName, "byta namn p\u00e5 fil fel");
                }
                if (this.currentFile != null && this.currentFile.equals(oldName)) {
                    this.currentFile = ((FromServerMessage)ClientThread.sendMessage(Message.GetVirtualFile, newName)).getVirtualFile();
                }
                this.refresh();
            }
        }
    }

    public void refresh() {
        this.currentDir = ((FromServerMessage)ClientThread.sendMessage(Message.GetVirtualFile, new Object[0])).getVirtualFile();
        File[] list = this.currentDir.listFiles();
        this.fileList.clear();
        for (File f : list) {
            if (f.isHidden() || f.isDirectory()) continue;
            this.fileList.add(f);
        }
        Collections.sort(this.fileList);
        this.fireTableStructureChanged();
    }

    public int indexOf(File f) {
        return this.fileList.indexOf(f);
    }

    public int findLargest(String indexer) {
        int num = -1;
        for (File f : this.fileList) {
            String s = f.getName();
            if (!s.startsWith(indexer)) continue;
            if (num == -1) {
                num = 0;
            }
            try {
                int temp = Integer.parseInt(s.substring(indexer.length()).trim());
                if (temp <= num) continue;
                num = temp;
            }
            catch (Exception e) {}
        }
        return num;
    }

    public File getDirectory() {
        return this.currentDir;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(File f) {
        this.currentFile = f;
    }
}

