/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels.sun;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import se.sjobeck.GeometraConfiguration;
import se.sjobeck.geometra.gui.panels.sun.CenterLayout;
import se.sjobeck.geometra.gui.panels.sun.MainSwatchPanel;
import se.sjobeck.geometra.gui.panels.sun.RecentSwatchPanel;
import se.sjobeck.geometra.gui.panels.sun.SwatchPanel;

public class DefaultSwatchChooserPanel
extends AbstractColorChooserPanel {
    private static final long serialVersionUID = 1L;
    SwatchPanel swatchPanel;
    RecentSwatchPanel recentSwatchPanel;
    MouseListener mainSwatchListener;
    MouseListener recentSwatchListener;
    private static String recentStr = UIManager.getString("ColorChooser.swatchesRecentText");

    @Override
    public String getDisplayName() {
        return UIManager.getString("ColorChooser.swatchesNameText");
    }

    public void setRecentColors(Color[] colors) {
        this.recentSwatchPanel.colors = colors;
    }

    public Color[] getRecentColors() {
        return this.recentSwatchPanel.colors;
    }

    @Override
    public int getMnemonic() {
        return -1;
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return -1;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
    }

    @Override
    protected void buildChooser() {
        JPanel superHolder = new JPanel(new BorderLayout());
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.getAccessibleContext().setAccessibleName(this.getDisplayName());
        this.recentSwatchPanel = new RecentSwatchPanel();
        this.recentSwatchPanel.getAccessibleContext().setAccessibleName(recentStr);
        this.recentSwatchPanel.setMostRecentColor(GeometraConfiguration.getProjectColor());
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.recentSwatchListener = new RecentSwatchListener();
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        JPanel mainHolder = new JPanel(new BorderLayout());
        CompoundBorder border = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        mainHolder.setBorder(border);
        mainHolder.add((Component)this.swatchPanel, "Center");
        superHolder.add((Component)mainHolder, "Center");
        JPanel recentHolder = new JPanel(new BorderLayout());
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        recentHolder.setBorder(border);
        recentHolder.add((Component)this.recentSwatchPanel, "Center");
        JPanel recentLabelHolder = new JPanel(new BorderLayout());
        recentLabelHolder.add((Component)recentHolder, "Center");
        JLabel l = new JLabel(recentStr);
        l.setLabelFor(this.recentSwatchPanel);
        recentLabelHolder.add((Component)l, "North");
        JPanel recentHolderHolder = new JPanel(new CenterLayout());
        if (this.getComponentOrientation().isLeftToRight()) {
            recentHolderHolder.setBorder(new EmptyBorder(2, 10, 2, 2));
        } else {
            recentHolderHolder.setBorder(new EmptyBorder(2, 2, 2, 10));
        }
        recentHolderHolder.add(recentLabelHolder);
        superHolder.add((Component)recentHolderHolder, "After");
        this.add(superHolder);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.recentSwatchPanel.removeMouseListener(this.recentSwatchListener);
        this.swatchPanel = null;
        this.recentSwatchPanel = null;
        this.mainSwatchListener = null;
        this.recentSwatchListener = null;
        this.removeAll();
    }

    @Override
    public void updateChooser() {
    }

    class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        private static final long serialVersionUID = 1L;

        MainSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = DefaultSwatchChooserPanel.this.swatchPanel.getColorForLocation(e.getX(), e.getY());
            DefaultSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
            DefaultSwatchChooserPanel.this.recentSwatchPanel.setMostRecentColor(color);
        }
    }

    class RecentSwatchListener
    extends MouseAdapter
    implements Serializable {
        private static final long serialVersionUID = 1L;

        RecentSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = DefaultSwatchChooserPanel.this.recentSwatchPanel.getColorForLocation(e.getX(), e.getY());
            DefaultSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

