/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.export;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import se.sjobeck.geometra.datastructures.ClipboardSender;
import se.sjobeck.geometra.export.ExportListener;
import se.sjobeck.geometra.export.ExportSchema;
import se.sjobeck.geometra.gui.panels.export.TextExporter;

public class DefaultExportListeners {
    public static ClipboardSender sender = new ClipboardSender();

    public static List<ExportListener> createDefaultListeners() {
        LinkedList list = new LinkedList();
        Collections.addAll(list, DefaultExportListeners.createClipboardListener(), DefaultExportListeners.createTextRobotListener(), DefaultExportListeners.createExcelRobotListener(), DefaultExportListeners.createHorizontalExcelRobotListener(), DefaultExportListeners.createToFile());
        return Collections.unmodifiableList(list);
    }

    public static ExportListener createToFile() {
        return TextExporter.getInstance();
    }

    public static ExportListener createClipboardListener() {
        ExportSchema.Row[] row = new ExportSchema.Row[]{ExportSchema.Row.DRAWING_NAMES, ExportSchema.Row.AREA, ExportSchema.Row.LENGTH, ExportSchema.Row.VOLUME, ExportSchema.Row.WALLSURFACE, ExportSchema.Row.HEIGHT, ExportSchema.Row.NUMBER_OF_DRAWING};
        String string = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("EXPORTSCHEMA_COPYVALUES");
        return new ExportSchema(string, "", ",", row, ExportSchema.CopyPaste.COPY_TO_CLIPBOARD, false, false, true, true, true, true);
    }

    public static ExportListener createTextRobotListener() {
        ExportSchema.Row[] row = new ExportSchema.Row[]{ExportSchema.Row.DRAWING_NAMES, ExportSchema.Row.AREA, ExportSchema.Row.LENGTH, ExportSchema.Row.VOLUME, ExportSchema.Row.WALLSURFACE, ExportSchema.Row.HEIGHT, ExportSchema.Row.NUMBER_OF_DRAWING};
        String string = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("EXPORTSCHEMA_COPYVALUES_SEND_TEXT");
        return new ExportSchema(string, "", ",", row, ExportSchema.CopyPaste.WINDOWS, false, false, true, true, true, true);
    }

    public static ExportListener createExcelRobotListener() {
        ExportSchema.Row[] row = new ExportSchema.Row[]{ExportSchema.Row.DRAWING_NAMES, ExportSchema.Row.AREA, ExportSchema.Row.LENGTH, ExportSchema.Row.VOLUME, ExportSchema.Row.WALLSURFACE, ExportSchema.Row.HEIGHT, ExportSchema.Row.NUMBER_OF_DRAWING};
        String string = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("EXPORTSCHEMA_COPYVALUES_SEND_EXCEL");
        return new ExportSchema(string, "=", ",", row, ExportSchema.CopyPaste.WINDOWS, false, true, true, true, true, true);
    }

    public static ExportListener createHorizontalExcelRobotListener() {
        ExportSchema.Row[] row = new ExportSchema.Row[]{ExportSchema.Row.DRAWING_NAMES, ExportSchema.Row.AREA, ExportSchema.Row.LENGTH, ExportSchema.Row.VOLUME, ExportSchema.Row.WALLSURFACE, ExportSchema.Row.HEIGHT, ExportSchema.Row.NUMBER_OF_DRAWING};
        String string = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("EXPORTSCHEMA_COPYVALUES_SEND_L_EXCEL");
        return new ExportSchema(string, "=", ",", row, ExportSchema.CopyPaste.WINDOWS, true, true, true, true, true, true);
    }
}

