/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.drawings;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.io.ObjectStreamException;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.core.GeometraCollection;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.drawings.ContainerDrawing;

public class SmartDrawing
extends ContainerDrawing {
    private static final long serialVersionUID = 1L;
    private Color smartDrawingColor = Color.BLUE;
    private GeometraCollection<GeometraDrawing> smartCollection = null;
    private boolean visitedPaintAssSmartDrawing = false;
    private boolean visitedSetColor = false;
    private Integer hashCode = null;

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.smartCollection != null) {
            this.collection = this.smartCollection;
        }
        return this;
    }

    private Object writeReplace() throws ObjectStreamException {
        this.smartCollection = this.collection;
        return this;
    }

    public SmartDrawing() {
    }

    public SmartDrawing(String name) {
        super.setDescription(name);
        this.collection = new GeometraCollection();
    }

    public int getChildCount() {
        return this.collection.size();
    }

    public int indexOf(Object ob) {
        if (ob instanceof GeometraDrawing) {
            return this.collection.indexOf((GeometraDrawing)ob);
        }
        return 0;
    }

    public SmartDrawing(String name, GeometraCollection<GeometraDrawing> smartCollection) {
        this.collection = new GeometraCollection();
        this.collection.addAll(smartCollection);
        super.setDescription(name);
        this.setParent(smartCollection.get(0).getParent());
    }

    @Override
    public BlueprintPage getParent() {
        if (super.getParent() == null && this.collection.size() > 0) {
            super.setParent(((GeometraDrawing)this.collection.get(0)).getParent());
        }
        return super.getParent();
    }

    public String getAreaString() {
        return "hello";
    }

    @Override
    public Point getCenterPoint() {
        return null;
    }

    @Override
    public Color getColor() {
        return this.smartDrawingColor;
    }

    public String getDistanceString() {
        return "hello";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintAsSmartDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
        if (this.visitedPaintAssSmartDrawing) {
            return;
        }
        try {
            this.visitedPaintAssSmartDrawing = true;
            for (GeometraDrawing gd : this.collection) {
                gd.setSmartDrawingColor(this.smartDrawingColor);
                gd.paintAsSmartDrawing(g, base, clip);
            }
        }
        finally {
            this.visitedPaintAssSmartDrawing = false;
        }
    }

    @Override
    public void paintVertices(Graphics2D g, BlueprintPage base) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setColor(Color newColor) {
        if (this.visitedSetColor) {
            return;
        }
        try {
            this.visitedSetColor = true;
            for (GeometraDrawing gd : this.collection) {
                gd.setSmartDrawingColor(newColor);
            }
            this.smartDrawingColor = newColor;
        }
        finally {
            this.visitedSetColor = false;
        }
    }

    @Override
    public void setSmartDrawingColor(Color c) {
        this.setColor(c);
    }

    @Override
    public String toString() {
        return super.getDescription();
    }

    @Override
    public void init() {
        this.path = new GeneralPath();
        this.altPath = new GeneralPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        if (this.hashCode != null) {
            return Integer.MAX_VALUE;
        }
        try {
            int prime = 31;
            this.hashCode = super.hashCode();
            this.hashCode = prime * this.hashCode + (this.collection == null ? 0 : this.collection.hashCode());
            int n = this.hashCode;
            return n;
        }
        finally {
            this.hashCode = null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SmartDrawing other = (SmartDrawing)obj;
        return !(this.collection == null ? other.collection != null : !this.collection.equals(other.collection));
    }
}

