/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.drawings;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.drawings.DotDrawing;
import se.sjobeck.geometra.datastructures.drawings.GeometraContainer;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;

public class DotDrawingContainer
extends GeometraDrawingImpl
implements GeometraContainer {
    private static final long serialVersionUID = 1L;
    private DotDrawing activeDrawing;
    private final List<DotDrawing> dotDrawingVector = new ArrayList<DotDrawing>();

    public DotDrawingContainer() {
    }

    public DotDrawingContainer(BlueprintPage page) {
        this.setParent(page);
        super.setDescription(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_DOT"));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public void init() {
        for (DotDrawing cd : this.dotDrawingVector) {
            cd.init(this);
        }
    }

    @Override
    public void addPoint(Point2D point) {
        this.activeDrawing.addPoint(point);
    }

    @Override
    public void buildPath() {
    }

    @Override
    public void setStrokeWidth(float width) {
    }

    @Override
    public double getArea() {
        return 0.0;
    }

    public String getAreaString() {
        return "0";
    }

    @Override
    public double getDistance() {
        return 0.0;
    }

    public String getDistanceString() {
        return "";
    }

    @Override
    public Line2D getLine(Point2D coord) {
        return null;
    }

    public int getNumberOfDotDrawings() {
        return this.dotDrawingVector.size();
    }

    @Override
    public Rectangle getRectangle() {
        return null;
    }

    @Override
    public boolean isFilled() {
        return false;
    }

    @Override
    public void paintAsSmartDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
        this.paintDrawing(g, base, clip);
    }

    @Override
    public void paintDistances(Graphics2D g, BlueprintPage base, BlueprintPage.ViewingState state) {
    }

    @Override
    public void paintDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
        for (DotDrawing dd : this.dotDrawingVector) {
            dd.paintDrawing(g, base, clip);
        }
    }

    @Override
    public void setClosed(boolean b) {
        this.isClosed = b;
    }

    @Override
    public void setColor(Color c) {
        for (DotDrawing d : this.dotDrawingVector) {
            d.setColor(c);
        }
    }

    @Override
    public void setFilled(boolean b) {
    }

    @Override
    public String toString() {
        return super.getDescription();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dotDrawingVector == null ? 0 : ((Object)this.dotDrawingVector).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public void addChild(GeometraDrawing gd) {
        if (gd instanceof DotDrawing) {
            DotDrawing dd = (DotDrawing)gd;
            this.dotDrawingVector.add(dd);
            this.activeDrawing = dd;
        }
    }

    @Override
    public GeometraDrawing getActiveChild() {
        return this.activeDrawing;
    }

    @Override
    public GeometraDrawing getChild(int index) {
        return this.dotDrawingVector.get(index);
    }

    @Override
    public int getChildCount() {
        return this.dotDrawingVector.size();
    }

    public List<DotDrawing> getChildren() {
        return this.dotDrawingVector;
    }

    @Override
    public int indexOfChild(GeometraDrawing cd) {
        return this.dotDrawingVector.indexOf(cd);
    }

    @Override
    public void removeChild(GeometraDrawing toBeRemoved) {
        this.dotDrawingVector.remove(toBeRemoved);
    }

    @Override
    public int numberOfDrawings() {
        return this.getChildCount();
    }
}

