/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.drawings;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import se.sjobeck.geometra.datastructures.PaintingStateMachine;
import se.sjobeck.geometra.datastructures.drawings.DotDrawingContainer;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;

public class DotDrawing
extends GeometraDrawingImpl {
    private static final long serialVersionUID = 1L;
    private Point centerPoint;
    private final int DOTSIZE = 8;
    private transient BasicStroke dottedStroke = this.getStroke();
    private final int id = 0;
    private DotDrawingContainer owner;

    public DotDrawing() {
    }

    public DotDrawing(BlueprintPage page, DotDrawingContainer owner) {
        this.owner = owner;
        this.setParent(page);
        this.setVisible(true);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public String toString() {
        return this.owner.getDescription();
    }

    private BasicStroke getStroke() {
        if (this.dottedStroke == null) {
            this.dottedStroke = new BasicStroke();
        }
        return this.dottedStroke;
    }

    @Override
    public BlueprintPage getParent() {
        return this.owner.getParent();
    }

    public void init(DotDrawingContainer owner) {
        this.owner = owner;
        this.init();
    }

    @Override
    public void init() {
        if (this.dottedStroke == null) {
            this.dottedStroke = this.getStroke();
        }
        this.path = new GeneralPath();
        this.altPath = new GeneralPath();
        this.buildPath();
    }

    public DotDrawing(DotDrawing dd, BlueprintPage page) {
        this.isClosed = false;
        this.setParent(page);
    }

    @Override
    public String getDescription() {
        return this.owner.getDescription();
    }

    @Override
    public void addPoint(Point2D inPoint) {
        DotState dotState = PaintingStateMachine.getInstance().getDotState();
        switch (dotState) {
            case SQUARE: {
                this.addPointSquare(inPoint);
                break;
            }
            case CROSS: {
                this.addPointCross(inPoint);
                break;
            }
            case TRIANGLE: {
                this.addPointTriangle(inPoint);
                break;
            }
            case ROMB: {
                this.addPointRomb(inPoint);
                break;
            }
            case HEXAGON: {
                this.addPointHexagon(inPoint);
                break;
            }
            default: {
                this.addPointSquare(inPoint);
            }
        }
    }

    public void addPointHexagon(Point2D inPoint) {
        Point2D point = this.componentToBlueprint(inPoint);
        double x = point.getX();
        double y = point.getY();
        if (!this.points.isEmpty()) {
            return;
        }
        double d2 = 4.0;
        double d4 = 2.0;
        Point2D.Double p1 = new Point2D.Double(x - d4, y + d2);
        this.points.add(p1);
        p1 = new Point2D.Double(x + d4, y + d2);
        this.points.add(p1);
        p1 = new Point2D.Double(x + d2, y);
        this.points.add(p1);
        p1 = new Point2D.Double(x + d4, y - d2);
        this.points.add(p1);
        p1 = new Point2D.Double(x - d4, y - d2);
        this.points.add(p1);
        p1 = new Point2D.Double(x - d2, y);
        this.points.add(p1);
        this.centerPoint = this.createCenterPoint();
        this.buildPath();
    }

    public void addPointSquare(Point2D inPoint) {
        Point2D point = this.componentToBlueprint(inPoint);
        double x = point.getX();
        double y = point.getY();
        Point2D.Double startPoint = new Point2D.Double(x - 4.0, y - 4.0);
        if (!this.points.isEmpty()) {
            return;
        }
        this.points.add(startPoint);
        x = ((Point2D)startPoint).getX();
        y = ((Point2D)startPoint).getY();
        Point2D.Double upperRight = new Point2D.Double(x + 8.0, y);
        Point2D.Double lowerRight = new Point2D.Double(x + 8.0, y + 8.0);
        Point2D.Double lowerLeft = new Point2D.Double(x, y + 8.0);
        this.points.add(upperRight);
        this.points.add(lowerRight);
        this.points.add(lowerLeft);
        this.centerPoint = this.createCenterPoint();
        this.buildPath();
    }

    public void addPointCross(Point2D inPoint) {
        Point2D point = this.componentToBlueprint(inPoint);
        double x = point.getX();
        double y = point.getY();
        if (!this.points.isEmpty()) {
            return;
        }
        double d2 = 4.0;
        double d6 = 1.3333333333333333;
        Point2D.Double p1 = new Point2D.Double(x - d2, y + d6);
        this.points.add(p1);
        p1 = new Point2D.Double(x - d6, y + d6);
        this.points.add(p1);
        p1 = new Point2D.Double(x - d6, y + d2);
        this.points.add(p1);
        p1 = new Point2D.Double(x + d6, y + d2);
        this.points.add(p1);
        p1 = new Point2D.Double(x + d6, y + d6);
        this.points.add(p1);
        p1 = new Point2D.Double(x + d2, y + d6);
        this.points.add(p1);
        Point2D.Double p7 = new Point2D.Double(x + d2, y - d6);
        this.points.add(p7);
        p1 = new Point2D.Double(x + d6, y - d6);
        this.points.add(p1);
        p1 = new Point2D.Double(x + d6, y - d2);
        this.points.add(p1);
        p1 = new Point2D.Double(x - d6, y - d2);
        this.points.add(p1);
        p1 = new Point2D.Double(x - d6, y - d6);
        this.points.add(p1);
        p1 = new Point2D.Double(x - d2, y - d6);
        this.points.add(p1);
        this.centerPoint = this.createCenterPoint();
        this.buildPath();
    }

    public void addPointRomb(Point2D inPoint) {
        Point2D point = this.componentToBlueprint(inPoint);
        double x = point.getX();
        double y = point.getY();
        if (!this.points.isEmpty()) {
            return;
        }
        double d2 = 4.0;
        Point2D.Double p1 = new Point2D.Double(x, y + d2);
        this.points.add(p1);
        p1 = new Point2D.Double(x + d2, y);
        this.points.add(p1);
        p1 = new Point2D.Double(x, y - d2);
        this.points.add(p1);
        p1 = new Point2D.Double(x - d2, y);
        this.points.add(p1);
        this.centerPoint = this.createCenterPoint();
        this.buildPath();
    }

    public void addPointTriangle(Point2D inPoint) {
        Point2D point = this.componentToBlueprint(inPoint);
        double x = point.getX();
        double y = point.getY();
        if (!this.points.isEmpty()) {
            return;
        }
        double d2 = 4.0;
        Point2D.Double p1 = new Point2D.Double(x, y + d2);
        this.points.add(p1);
        p1 = new Point2D.Double(x + d2, y - d2);
        this.points.add(p1);
        p1 = new Point2D.Double(x - d2, y - d2);
        this.points.add(p1);
        this.centerPoint = this.createCenterPoint();
        this.buildPath();
    }

    @Override
    public void buildPath() {
        this.path.reset();
        if (this.points.size() > 0) {
            this.path.moveTo((float)((Point2D)this.points.get(0)).getX(), (float)((Point2D)this.points.get(0)).getY());
        }
        for (Point2D point : this.points) {
            this.path.lineTo((float)point.getX(), (float)point.getY());
        }
        if (this.isClosed()) {
            this.path.closePath();
        }
    }

    @Override
    public void setStrokeWidth(float width) {
    }

    private Point createCenterPoint() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = 0.0;
        double maxY = 0.0;
        for (Point2D point : this.points) {
            if (point.getX() < minX) {
                minX = point.getX();
            }
            if (point.getY() < minY) {
                minY = point.getY();
            }
            if (point.getX() > maxX) {
                maxX = point.getX();
            }
            if (!(point.getY() > maxY)) continue;
            maxY = point.getY();
        }
        double xDistance = maxX - minX;
        double yDistance = maxY - minY;
        Double xCor = new Double(minX + xDistance / 2.0);
        Double yCor = new Double(minY + yDistance / 2.0);
        return new Point(xCor.intValue(), yCor.intValue());
    }

    public GeneralPath getAltPath() {
        return null;
    }

    @Override
    public double getArea() {
        return 0.0;
    }

    public String getAreaString() {
        return "0";
    }

    @Override
    public Point getCenterPoint() {
        if (this.centerPoint == null) {
            this.createCenterPoint();
        }
        return this.centerPoint;
    }

    @Override
    public double getDistance() {
        return 0.0;
    }

    public String getDistanceString() {
        return "";
    }

    public int getID() {
        return 0;
    }

    @Override
    public Line2D getLine(Point2D coord) {
        return null;
    }

    public DotDrawingContainer getOwner() {
        return this.owner;
    }

    @Override
    public Rectangle getRectangle() {
        return null;
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public boolean isFilled() {
        return true;
    }

    @Override
    public void paintAsSmartDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
    }

    @Override
    public void paintDistances(Graphics2D g, BlueprintPage base, BlueprintPage.ViewingState state) {
    }

    @Override
    public void paintDrawing(Graphics2D g, BlueprintPage base, Rectangle clip) {
        g.setColor(this.getColor());
        g.setStroke(this.getStroke());
        if (this.path == null) {
            this.path = new GeneralPath();
            this.buildPath();
        }
        GeneralPath p = (GeneralPath)this.path.clone();
        p.transform(base.getAffineTransform());
        if (this.isFilled()) {
            g.fill(p);
        } else {
            g.draw(p);
        }
    }

    @Override
    public void paintVertices(Graphics2D g, BlueprintPage base) {
    }

    @Override
    public void setClosed(boolean b) {
    }

    @Override
    public void setFilled(boolean b) {
    }

    @Override
    public void setDescription(String str) {
    }

    public void setOwner(DotDrawingContainer owner) {
        this.owner = owner;
    }

    public static enum DotState {
        SQUARE,
        CROSS,
        TRIANGLE,
        ROMB,
        HEXAGON;

    }
}

