/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint;

import java.util.LinkedList;
import se.sjobeck.geometra.datastructures.blueprint.Command;
import se.sjobeck.geometra.datastructures.blueprint.GeometraPaintCommand;
import se.sjobeck.geometra.datastructures.blueprint.observer.BlueprintSubject;

public class UndoRedoManager
implements Command {
    private final LinkedList<GeometraPaintCommand> commandStack = new LinkedList();
    private final LinkedList<GeometraPaintCommand> redoStack = new LinkedList();

    public void execute(GeometraPaintCommand command) {
        GeometraPaintCommand gpc;
        if (command instanceof GeometraPaintCommand && (gpc = command).getAction().equals((Object)BlueprintSubject.Action.CLOSE)) {
            for (GeometraPaintCommand c : this.commandStack) {
                if (!c.getDrawing().equals(gpc.getDrawing())) continue;
                c.setClosed(true);
                return;
            }
        }
        this.commandStack.addFirst(command);
        this.redoStack.clear();
    }

    @Override
    public void undo() {
        if (this.commandStack.isEmpty()) {
            return;
        }
        GeometraPaintCommand command = this.commandStack.removeFirst();
        command.undo();
        this.redoStack.addFirst(command);
    }

    @Override
    public void redo() {
        if (this.redoStack.isEmpty()) {
            return;
        }
        GeometraPaintCommand command = this.redoStack.removeFirst();
        command.redo();
        this.commandStack.addFirst(command);
    }
}

