/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import se.sjobeck.geometra.datastructures.FileDescription;
import se.sjobeck.geometra.datastructures.GeometraProperties;
import se.sjobeck.geometra.datastructures.PaintingStateMachine;
import se.sjobeck.geometra.datastructures.blueprint.BlueprintList;
import se.sjobeck.geometra.datastructures.blueprint.GeometraManager;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFBlueprint;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFPage;
import se.sjobeck.geometra.datastructures.blueprint.PDFController;
import se.sjobeck.geometra.datastructures.blueprint.ProjectWorker;
import se.sjobeck.geometra.datastructures.blueprint.ProjectWorkerListener;
import se.sjobeck.geometra.datastructures.blueprint.ViewProperties;
import se.sjobeck.geometra.datastructures.blueprint.observer.BlueprintSubject;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.datastructures.blueprint.observer.Observer;
import se.sjobeck.geometra.datastructures.drawings.DotDrawingContainer;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.panels.BlueprintTab;
import se.sjobeck.geometra.gui.panels.ButtonPane;
import se.sjobeck.geometra.gui.panels.InfoPanel;

public class TabManager
implements Observer {
    private static TabManager instance = new TabManager();
    private BlueprintPage currentPage;
    private int currentIndex = 1;
    private Blueprint currentBlueprint;
    private GeometraDrawing currentDrawing;
    private ViewProperties currentProperties;
    private int currentPageIndex;
    private int currentRotation;
    private PDFController currentController;
    private final ProjectWorker projectWorker = new ProjectWorker();
    private final GeometraSubject geoSubject = GeometraSubject.getInstance();
    private final GeometraManager geometraManager = GeometraManager.getInstance();
    private final List<PDFController> controllVector = new ArrayList<PDFController>();
    private BlueprintTab tab;
    private final Runnable tabSwitch = new Runnable(){

        @Override
        public void run() {
            TabManager.this.setSelectedIndex(TabManager.this.currentIndex);
        }
    };
    private final Runnable centerDrawing = new Runnable(){

        @Override
        public void run() {
            TabManager.this.centerDrawing(TabManager.this.currentDrawing);
            GeometraSubject.getInstance().select(TabManager.this.currentDrawing, this);
        }

        public String toString() {
            return "centerDrawing";
        }
    };
    private final Runnable setZoom = new Runnable(){

        @Override
        public void run() {
            TabManager.this.currentController.setZoom(TabManager.this.currentProperties.getViewScale());
        }

        public String toString() {
            return "setZoom";
        }
    };
    private final Runnable setViewPosition = new Runnable(){

        @Override
        public void run() {
            TabManager.this.currentController.setViewPosition(TabManager.this.currentProperties.getViewPoint());
        }

        public String toString() {
            return "setViewPosition";
        }
    };
    private final Runnable setRotation = new Runnable(){

        @Override
        public void run() {
            TabManager.this.currentController.setRotation(TabManager.this.currentRotation);
        }

        public String toString() {
            return "setRotation";
        }
    };
    private final Runnable setPage = new Runnable(){

        @Override
        public void run() {
            if (TabManager.this.currentController != null) {
                TabManager.this.currentController.setPageNumber(TabManager.this.currentPageIndex);
            }
        }

        public String toString() {
            return "setPage";
        }
    };
    private final Runnable controllerRotateLeft = new Runnable(){

        @Override
        public void run() {
            PDFController cont = TabManager.this.getActiveController();
            if (cont != null) {
                cont.setRotateLeft();
            }
        }
    };
    private final Runnable managerRotateLeft = new Runnable(){

        @Override
        public void run() {
            TabManager.this.geometraManager.rotateLeft();
        }
    };
    private final Runnable controllerRotateRight = new Runnable(){

        @Override
        public void run() {
            PDFController cont = TabManager.this.getActiveController();
            if (cont != null) {
                cont.setRotateRight();
            }
        }
    };
    private final Runnable managerRotateRight = new Runnable(){

        @Override
        public void run() {
            TabManager.this.geometraManager.rotateRight();
        }
    };

    public static TabManager getInstance() {
        return instance;
    }

    private TabManager() {
        this.geoSubject.addObserver(this);
    }

    public void setActiveProjectWorkerListener(ProjectWorkerListener pl) {
        this.projectWorker.setActiveProjectWorkerListener(pl);
    }

    public void updateSettings() {
        this.projectWorker.updateSettings();
    }

    public void disableAutoSave() {
        this.projectWorker.CancelThread();
    }

    public void clearProjectWorker() {
        this.projectWorker.clear();
    }

    public void dispose(Blueprint bp) {
        int toBeRemoved = Integer.MIN_VALUE;
        for (int i = 0; i < this.controllVector.size(); ++i) {
            if (!this.controllVector.get(i).getBlueprint().equals(bp)) continue;
            toBeRemoved = i;
            break;
        }
        if (toBeRemoved != Integer.MIN_VALUE) {
            this.tab.removeFromTab(toBeRemoved);
            this.controllVector.get(toBeRemoved).dispose();
            this.controllVector.remove(toBeRemoved);
            BlueprintList instance1 = BlueprintList.getInstance();
            if (instance1 != null) {
                instance1.remove(bp);
            }
            System.gc();
        }
    }

    private PDFController getController(Blueprint blueprint) {
        for (int i = 0; i < this.controllVector.size(); ++i) {
            if (!this.controllVector.get(i).getBlueprint().equals(blueprint)) continue;
            return this.controllVector.get(i);
        }
        return null;
    }

    private void switchObject(Object ob) {
        BlueprintPage page;
        ArrayList<Runnable> tempList = new ArrayList<Runnable>();
        Object objectToSwitch = ob;
        if (objectToSwitch instanceof Blueprint && !this.gotBlueprintFocus((Blueprint)objectToSwitch)) {
            IcePDFBlueprint pdf = (IcePDFBlueprint)objectToSwitch;
            this.currentBlueprint = pdf;
            this.prepareBlueprintSwitch(this.currentBlueprint);
            objectToSwitch = ((IcePDFBlueprint)this.currentBlueprint).getActivePage();
            tempList.add(this.tabSwitch);
            this.currentBlueprint = pdf;
            this.preparePageSwitch((BlueprintPage)objectToSwitch);
            tempList.add(this.setPage);
            tempList.add(this.setZoom);
            tempList.add(this.setRotation);
            tempList.add(this.setViewPosition);
        } else if (objectToSwitch instanceof BlueprintPage && !this.gotPageFocus((BlueprintPage)objectToSwitch)) {
            page = (BlueprintPage)objectToSwitch;
            if (!page.getParent().equals(this.currentBlueprint)) {
                this.prepareBlueprintSwitch(page.getParent());
                if (!tempList.contains(this.tabSwitch)) {
                    tempList.add(this.tabSwitch);
                }
            }
            this.preparePageSwitch(page);
            tempList.add(this.setPage);
            tempList.add(this.setZoom);
            tempList.add(this.setRotation);
            tempList.add(this.setViewPosition);
            this.currentPage = page;
        } else if (objectToSwitch instanceof GeometraDrawing) {
            this.currentDrawing = (GeometraDrawing)objectToSwitch;
            page = this.currentDrawing.getParent();
            Blueprint bp = page.getParent();
            if (!this.gotBlueprintFocus(bp)) {
                this.prepareBlueprintSwitch(bp);
                tempList.add(this.tabSwitch);
            }
            if (!this.gotPageFocus(page)) {
                this.preparePageSwitch(page);
                tempList.add(this.setPage);
                tempList.add(this.setZoom);
                tempList.add(this.setRotation);
                tempList.add(this.setViewPosition);
                this.currentPage = page;
            }
            tempList.add(this.centerDrawing);
        }
        final ArrayList<Runnable> executionList = tempList;
        Thread executionThread = new Thread(){

            @Override
            public void run() {
                for (Runnable r : executionList) {
                    try {
                        SwingUtilities.invokeAndWait(r);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                PaintingStateMachine machine = PaintingStateMachine.getInstance();
                machine.switchPage();
            }
        };
        executionThread.start();
    }

    public boolean isLastProject() {
        return this.projectWorker.isLastProject();
    }

    private boolean gotPageFocus(BlueprintPage page) {
        return this.currentPage != null && this.currentPage.equals(page);
    }

    private boolean gotBlueprintFocus(Blueprint bp) {
        return this.currentBlueprint != null && this.currentBlueprint.equals(bp);
    }

    private void prepareBlueprintSwitch(Blueprint bp) {
        for (int i = 0; i < this.controllVector.size(); ++i) {
            Blueprint temp = this.controllVector.get(i).getBlueprint();
            if (!temp.equals(bp)) continue;
            this.currentIndex = i;
            this.currentBlueprint = temp;
            break;
        }
    }

    private void setSelectedIndex(int index) {
        if (index <= this.tab.getTabCount() - 1) {
            this.tab.setSelectedIndex(index);
        }
    }

    private void disposeAllResources() {
        this.projectWorker.disposeThread();
        BlueprintList list = BlueprintList.getInstance();
        ArrayList<Blueprint> toBeRemoved = new ArrayList<Blueprint>();
        for (int i = 0; i < list.size(); ++i) {
            toBeRemoved.add(list.getBlueprint(i));
        }
        for (Blueprint bp : toBeRemoved) {
            this.geoSubject.remove(bp, this);
        }
        for (int i = 0; i < list.totalDrawingSize(); ++i) {
            this.geoSubject.remove(list.getTotalDrawing(i), this);
        }
        Geometra.GEOMETRA_POPUP_MENU.clearMenus();
        System.gc();
    }

    private void preparePageSwitch(BlueprintPage page) {
        PDFController switchToController = this.getController(page.getParent());
        if (this.currentPage != null && this.currentPage instanceof IcePDFPage) {
            IcePDFPage gp = (IcePDFPage)this.currentPage;
            ViewProperties vp = gp.getViewProperties();
            JScrollPane scrollPane = (JScrollPane)this.currentController.getViewContainer();
            vp.setViewPoint(scrollPane.getViewport().getViewPosition());
            vp.setViewScale(this.currentController.getUserZoom());
        }
        this.currentPage = page;
        this.currentPageIndex = this.currentBlueprint.indexOf(this.currentPage);
        IcePDFPage geoPage = (IcePDFPage)this.currentPage;
        geoPage.getViewProperties();
        this.currentProperties = geoPage.getViewProperties();
        this.currentRotation = geoPage.getRotation();
        this.currentController = switchToController;
    }

    public PDFController getActiveController() {
        int index;
        if (this.tab != null && (index = this.tab.getActiveControllerIndex()) > -1) {
            return this.controllVector.get(index);
        }
        return null;
    }

    public void setViewCursor(int cursor) {
        PDFController cont = this.getActiveController();
        if (cont != null) {
            cont.setViewCursor(cursor);
        }
    }

    public void setDrawingState(BlueprintPage.DrawingState ds) {
        PDFController cont = this.getActiveController();
        if (cont != null) {
            Blueprint bp = cont.getBlueprint();
            this.geometraManager.setDrawingState(bp, ds);
            this.repaintTab();
        }
    }

    public void setViewingState(BlueprintPage.ViewingState viewingState) {
        PDFController cont = this.getActiveController();
        if (cont != null) {
            Blueprint bp = cont.getBlueprint();
            this.geometraManager.setViewingState(bp, viewingState);
            this.repaintTab();
        }
    }

    public void addToTab(PDFController controller) {
        this.tab.addToTab(controller);
    }

    public void addController(PDFController controller) {
        this.controllVector.add(controller);
    }

    public void centerDrawing(GeometraDrawing gd) {
        if (!(gd instanceof DotDrawingContainer)) {
            gd.getParent();
            PDFController cont = this.getActiveController();
            if (cont != null) {
                cont.centerViewport(gd);
            }
        }
    }

    public float getScale() {
        PDFController activeController = this.getActiveController();
        if (activeController != null) {
            return activeController.getUserZoom();
        }
        return 1.0f;
    }

    public float getScale(BlueprintPage page) {
        IcePDFPage gp = (IcePDFPage)page;
        ViewProperties vp = gp.getViewProperties();
        return vp.getViewScale();
    }

    public void repaintTab() {
        if (this.tab.getSelectedComponent() != null) {
            this.tab.getSelectedComponent().repaint();
        }
    }

    public void rotateLeft() {
        SwingUtilities.invokeLater(this.controllerRotateLeft);
        SwingUtilities.invokeLater(this.managerRotateLeft);
    }

    public void setPage(int pageIndex) {
        this.getActiveController().setPageNumber(pageIndex);
    }

    public void rotateRight() {
        SwingUtilities.invokeLater(this.controllerRotateRight);
        SwingUtilities.invokeLater(this.managerRotateRight);
    }

    public void setMouseCursor(int cursorType) {
        PDFController cont = this.getActiveController();
        if (cont != null) {
            cont.setViewCursor(cursorType);
        }
    }

    public void setTab(BlueprintTab tab) {
        this.tab = tab;
    }

    public void setUserZoom(float scale) {
        float temp = scale / 100.0f;
        PDFController cont = this.getActiveController();
        if (cont != null) {
            cont.setZoom(temp);
        }
    }

    @Override
    public void update(BlueprintSubject.Action action, Object ob, Object source) {
        if (action.equals((Object)BlueprintSubject.Action.REPAINT) || action.equals((Object)BlueprintSubject.Action.SELECT) || action.equals((Object)BlueprintSubject.Action.CLOSE) || action.equals((Object)BlueprintSubject.Action.UPDATE) || action.equals((Object)BlueprintSubject.Action.ADD_POINT) || action.equals((Object)BlueprintSubject.Action.SCALEDRAWING_UPDATE)) {
            this.repaintTab();
        } else if (action.equals((Object)BlueprintSubject.Action.DISPOSE_ALL)) {
            this.disposeAllResources();
        } else if (action.equals((Object)BlueprintSubject.Action.PAGE_SWITCH)) {
            this.switchObject(ob);
        } else if (action.equals((Object)BlueprintSubject.Action.REMOVE)) {
            if (ob instanceof Blueprint) {
                this.dispose((Blueprint)ob);
            }
            this.repaintTab();
        } else if (!action.equals((Object)BlueprintSubject.Action.ADD) || ob instanceof Blueprint) {
            // empty if block
        }
    }

    public void renameTab(Blueprint ob) {
        for (int i = 0; i < this.controllVector.size(); ++i) {
            PDFController cont = this.controllVector.get(i);
            if (cont == null || !cont.getBlueprint().equals(ob) || i >= this.tab.getTabCount()) continue;
            this.tab.setTitleAt(i, ob.getDescription());
        }
    }

    public void zoomDecrease() {
        PDFController cont = this.getActiveController();
        if (cont != null) {
            cont.setZoomOut();
        }
    }

    public void setZoomIn() {
        PDFController cont = this.getActiveController();
        if (cont != null) {
            cont.setZoomIn();
        }
    }

    public void setZoomOut() {
        PDFController cont = this.getActiveController();
        if (cont != null) {
            cont.setZoomOut();
        }
    }

    public void setZoom(float zoomFloat) {
        PDFController cont = this.getActiveController();
        if (cont != null) {
            cont.setZoom(zoomFloat);
        }
    }

    public void zoomIncrease() {
        PDFController cont = this.getActiveController();
        if (cont != null) {
            cont.setZoomIn();
        }
    }

    public void setFitView(int view, Fit fit) {
        PDFController cont = this.getActiveController();
        if (cont != null) {
            cont.setFitMode(view);
        }
    }

    public FileDescription getFileDescription(Blueprint bp) {
        for (PDFController cont : this.controllVector) {
            if (!cont.getBlueprint().equals(bp)) continue;
            return cont.getFileDescription();
        }
        return null;
    }

    public void updateBlueprint() {
        if (this.getActiveController() != null) {
            IcePDFBlueprint pdf = (IcePDFBlueprint)this.getActiveController().getBlueprint();
            this.geoSubject.pageSwitch(pdf, this);
        }
    }

    public void openPDF(File[] files, ButtonPane buttonPane, InfoPanel infoPane) {
        this.projectWorker.openPDF(buttonPane, infoPane, files);
    }

    public void openPDF(File file, ButtonPane buttonPane, InfoPanel infoPane) {
        this.projectWorker.openPDF(buttonPane, infoPane, file);
    }

    public String getProjectName() {
        if (this.projectWorker != null) {
            return this.projectWorker.getProjectName();
        }
        return null;
    }

    public void startSaving(ButtonPane buttonPane, InfoPanel infoPane) {
        if (this.projectWorker.isProjectActive()) {
            this.projectWorker.startSaving();
        }
    }

    public void startSavingAs(String projectName, ButtonPane buttonPane, InfoPanel infoPane) throws IOException {
        if (this.projectWorker.isProjectActive()) {
            this.projectWorker.startSavingAs(projectName, buttonPane, infoPane);
        }
    }

    private void clearProgram() {
        this.disposeAllResources();
    }

    public void openProject(File file, ButtonPane buttonPane, InfoPanel infoPane) {
        if (this.projectWorker.isProjectActive()) {
            this.clearProgram();
        }
        this.projectWorker.startLoadingProject(file, buttonPane, infoPane);
        GeometraProperties.setColor(GeometraProperties.getProjectColor());
    }

    public static enum Fit {
        SINGLE_FIT,
        MULTIPLE_FIT;

    }
}

