/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.icepdf.ri.common.KeyListenerPageChanger;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.DocumentView;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.DocumentViewModelImpl;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.PageViewDecorator;

public class OnePagePDFView
extends AbstractDocumentView {
    private PageViewComponent comp;
    protected boolean disposing;
    protected JScrollPane documentScrollpane;
    private final DocumentViewModelImpl documentViewModel;
    protected KeyListenerPageChanger keyListenerPageChanger;
    protected JPanel pagesPanel;

    public OnePagePDFView(DocumentViewController documentDocumentViewController, JScrollPane documentScrollpane, DocumentViewModelImpl documentViewModel) {
        super(documentDocumentViewController, documentScrollpane, (DocumentViewModel)documentViewModel);
        this.documentScrollpane = documentScrollpane;
        this.documentViewModel = documentViewModel;
        this.buildGUI();
    }

    private void buildGUI() {
        this.pagesPanel = new JPanel();
        this.pagesPanel.setBackground(Color.gray);
        GridLayout gridLayout = new GridLayout(0, 1, horizontalSpace, verticalSpace);
        this.pagesPanel.setLayout(gridLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(layoutInserts, layoutInserts, layoutInserts, layoutInserts);
        gbc.gridwidth = 0;
        this.updateDocumentView();
        this.setLayout(new GridBagLayout());
        this.add(this.pagesPanel, gbc);
    }

    public void dispose() {
        this.disposing = true;
        if (this.keyListenerPageChanger != null) {
            this.keyListenerPageChanger.uninstall();
        }
        this.pagesPanel.removeAll();
        this.pagesPanel.invalidate();
        super.dispose();
    }

    PageViewComponent getComp() {
        return this.comp;
    }

    public Dimension getDocumentSize() {
        Dimension documentSize = new Dimension();
        if (this.pagesPanel != null) {
            documentSize.setSize(this.pagesPanel.getBounds().getSize());
        }
        return documentSize;
    }

    public int getNextPageIncrement() {
        return 1;
    }

    public int getPreviousPageIncrement() {
        return 1;
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
    }

    public void paintComponent(Graphics g) {
        Rectangle clipBounds = g.getClipBounds();
        g.setColor(Color.gray);
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
    }

    public void updateDocumentView() {
        List pageComponents = this.documentViewModel.getPageComponents();
        if (pageComponents != null) {
            Object tmp = pageComponents.get(this.documentViewModel.getViewCurrentPageIndex());
            if (tmp != null && tmp instanceof PageViewComponent) {
                this.pagesPanel.removeAll();
                PageViewComponent pageViewComponentImpl = (PageViewComponent)tmp;
                pageViewComponentImpl.setDocumentViewCallback((DocumentView)this);
                this.pagesPanel.add((Component)new PageViewDecorator((JComponent)pageViewComponentImpl));
                ((JComponent)pageViewComponentImpl).invalidate();
                this.comp = pageViewComponentImpl;
            }
            this.documentScrollpane.revalidate();
        }
    }
}

