/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures;

import java.text.NumberFormat;
import se.sjobeck.geometra.parser.Evaluator;
import se.sjobeck.geometra.parser.Value;

public class GeometraUtilities {
    public static final String COS_ = "cos";
    public static final String SIN_ = "sin";
    public static final String legalEnd = "0123456789ns";
    public static final String TAN_ = "tan";
    private static final char[] ILLEGAL_CHARS = new char[]{'?', '/', '\\', '|', ':', '*', '\"', '<', '>'};

    public static String formatStrForAngle(String inputString) {
        String tempString;
        String angleType;
        int index;
        String lowerCaseString = inputString.toLowerCase();
        if (!(lowerCaseString.contains(COS_) || lowerCaseString.contains(SIN_) || lowerCaseString.contains(TAN_))) {
            return lowerCaseString;
        }
        if (lowerCaseString.contains(COS_)) {
            index = lowerCaseString.indexOf(COS_);
            angleType = COS_;
        } else if (lowerCaseString.contains(SIN_)) {
            index = lowerCaseString.indexOf(SIN_);
            angleType = SIN_;
        } else {
            index = lowerCaseString.indexOf(TAN_);
            angleType = TAN_;
        }
        String stringBeforeAngle = lowerCaseString.substring(0, index);
        String angleTemp = lowerCaseString.substring(index);
        int stopIndex = angleTemp.indexOf(")");
        String angleString = angleTemp.substring(0, stopIndex + 1);
        String stringAfterAngle = angleTemp.substring(stopIndex + 1);
        int numberStart = angleString.indexOf("(");
        int numberEnds = angleString.indexOf(")");
        String number = angleString.substring(numberStart + 1, numberEnds);
        Double d = new Double(number.replace(',', '.'));
        double result = angleType.equals(COS_) ? Math.cos(Math.toRadians(d)) : (angleType.equals(SIN_) ? Math.sin(Math.toRadians(d)) : Math.tan(Math.toRadians(d)));
        lowerCaseString = tempString = stringBeforeAngle + result + stringAfterAngle;
        return GeometraUtilities.formatStrForAngle(lowerCaseString);
    }

    public static String removeWhitespace(String s) {
        char[] str;
        String temp = "";
        for (char c : str = s.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            temp = temp + c;
        }
        return temp;
    }

    public static String scaleToString(double d) {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMaximumIntegerDigits(6);
        nf.setMaximumFractionDigits(0);
        String doubleStr = nf.format(d);
        return doubleStr;
    }

    public static double solveExpression(String string) throws NumberFormatException, NullPointerException {
        String formattedString = string.replace(',', '.');
        String tempString = GeometraUtilities.formatStrForAngle(formattedString);
        String newString = GeometraUtilities.removeWhitespace(tempString);
        Evaluator e = new Evaluator(newString);
        Value v = e.getExprValue();
        return v.getValue();
    }

    public static String toDecimal(String value) {
        String replaceStr = value.replace('.', ',');
        return replaceStr;
    }

    private static boolean isValidString(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isLegalFilename(String filename) {
        if (!GeometraUtilities.isValidString(filename)) {
            return false;
        }
        for (int i = 0; i < ILLEGAL_CHARS.length; ++i) {
            if (filename.indexOf(ILLEGAL_CHARS[i]) < 0) continue;
            return false;
        }
        return true;
    }

    private GeometraUtilities() {
    }
}

