/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.ICC_Profile;
import com.itextpdf.text.pdf.PdfAConformanceException;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfATtfUnicodeWriter;
import com.itextpdf.text.pdf.PdfAWriter;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfDocument;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamperImp;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.TtfUnicodeWriter;
import com.itextpdf.text.pdf.interfaces.PdfAConformance;
import com.itextpdf.text.pdf.interfaces.PdfIsoConformance;
import com.itextpdf.text.pdf.internal.PdfAConformanceImp;
import com.itextpdf.text.xml.xmp.PdfAXmpWriter;
import com.itextpdf.text.xml.xmp.XmpWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PdfAStamperImp
extends PdfStamperImp {
    PdfAStamperImp(PdfReader reader, OutputStream os, char pdfVersion, boolean append, PdfAConformanceLevel conformanceLevel) throws DocumentException, IOException {
        super(reader, os, pdfVersion, append);
        ((PdfAConformance)this.pdfIsoConformance).setConformanceLevel(conformanceLevel);
        PdfAWriter.setPdfVersion((PdfWriter)this, conformanceLevel);
    }

    public void setOutputIntents(String outputConditionIdentifier, String outputCondition, String registryName, String info, ICC_Profile colorProfile) throws IOException {
        PdfDictionary d;
        super.setOutputIntents(outputConditionIdentifier, outputCondition, registryName, info, colorProfile);
        PdfArray a = this.extraCatalog.getAsArray(PdfName.OUTPUTINTENTS);
        if (a != null && (d = a.getAsDict(0)) != null) {
            d.put(PdfName.S, (PdfObject)PdfName.GTS_PDFA1);
        }
    }

    public boolean isPdfIso() {
        return this.pdfIsoConformance.isPdfIso();
    }

    public void setPDFXConformance(int pdfx) {
        throw new PdfAConformanceException(MessageLocalization.getComposedMessage((String)"pdfx.conformance.cannot.be.set.for.PdfAStamperImp.instance", (Object[])new Object[0]));
    }

    protected TtfUnicodeWriter getTtfUnicodeWriter() {
        if (this.ttfUnicodeWriter == null) {
            this.ttfUnicodeWriter = new PdfATtfUnicodeWriter((PdfWriter)this);
        }
        return null;
    }

    protected XmpWriter getXmpWriter(ByteArrayOutputStream baos, PdfDocument.PdfInfo info) throws IOException {
        if (this.xmpWriter == null) {
            this.xmpWriter = new PdfAXmpWriter((OutputStream)baos, (PdfDictionary)info, ((PdfAConformance)this.pdfIsoConformance).getConformanceLevel());
        }
        return this.xmpWriter;
    }

    protected void checkPdfIsoConformance(int key, Object obj1) {
        PdfAConformanceImp.checkPdfAConformance((PdfWriter)this, key, obj1);
    }

    protected PdfIsoConformance getPdfIsoConformance() {
        return new PdfAConformanceImp();
    }
}

