/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.util.pdf.file_network_tracking;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.sjobeck.network2.ClientThread;
import se.sjobeck.network2.FromServerMessage;
import se.sjobeck.network2.Message;
import se.sjobeck.network2.NetWorkFileSender;
import se.sjobeck.util.StaticHelpers;
import se.sjobeck.util.pdf.file_network_tracking.EkalkylPDFConfiguration;

public class NetworkCommunicator {
    private static NetworkCommunicator nc = null;

    private NetworkCommunicator() {
    }

    public static NetworkCommunicator getNetworkCommunicator() {
        if (nc != null) {
            return nc;
        }
        nc = new NetworkCommunicator();
        return nc;
    }

    public synchronized long getCRC(String projectName, String fileName) {
        Vector<String> fudo = new Vector<String>();
        fudo.add(projectName);
        fudo.add(fileName);
        return ((FromServerMessage)ClientThread.sendMessage(Message.GetEkalkylCRC, fudo)).getLong();
    }

    public synchronized boolean sendFile(String projectName, String fileName, byte[] content) {
        Vector<String> fudo = new Vector<String>();
        fudo.add(projectName);
        fudo.add(fileName);
        boolean result = NetWorkFileSender.sendMessage(Message.SendEkalkylFileContent, fudo, content).getBoolean();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getFile(String projectName, String fileName) {
        Vector<String> fudo = new Vector<String>();
        fudo.add(projectName);
        fudo.add(fileName);
        long crc_server = ((FromServerMessage)ClientThread.sendMessage(Message.GetEkalkylCRC, fudo)).getLong();
        if (crc_server > -1L) {
            RandomAccessFile raf = null;
            try {
                File file;
                byte[] data = ((FromServerMessage)ClientThread.sendMessage(Message.GetEkalkylFileContent, fudo)).getByteArray();
                File dir = new File(EkalkylPDFConfiguration.getSavePath() + File.separator + projectName);
                if (!dir.exists()) {
                    dir.mkdirs();
                    if (!dir.exists()) {
                        boolean bl = false;
                        return bl;
                    }
                }
                if ((file = new File(EkalkylPDFConfiguration.getSavePath() + File.separator + projectName + File.separator + fileName)).exists()) {
                    file.delete();
                }
                if (!file.createNewFile()) {
                    boolean ex = false;
                    return ex;
                }
                raf = new RandomAccessFile(file, "rw");
                raf.write(data);
                long crc_local = StaticHelpers.getCRC(file);
                if (crc_local == crc_server) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(NetworkCommunicator.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(NetworkCommunicator.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(NetworkCommunicator.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        return false;
    }

    public synchronized Vector<String> getFilesOnServer(String projectName) {
        return ((FromServerMessage)ClientThread.sendMessage(Message.GetEkalkylFileNamesInProject, projectName)).getVectorWithStrings();
    }
}

