/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import se.sjobeck.datastructures.EditableRadTable;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.util.StaticHelpers;

class TidEditor
extends JTextField
implements TableCellEditor {
    private Vector<CellEditorListener> listeners = new Vector();
    private boolean isEdited = false;

    TidEditor() {
        super.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TidEditor.this.isEdited = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TidEditor.this.isEdited = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TidEditor.this.isEdited = true;
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        RadStruct rad = (RadStruct)value;
        EditableRadTable model = (EditableRadTable)table.getModel();
        Double time = model.getCurrentNode().getProject().getEgenTid(rad);
        this.setText(StaticHelpers.tidFormat(time));
        this.selectAll();
        this.isEdited = false;
        return this;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void cancelCellEditing() {
        ChangeEvent e = new ChangeEvent(this);
        Vector<CellEditorListener> list = new Vector<CellEditorListener>(this.listeners);
        for (CellEditorListener listener : list) {
            listener.editingCanceled(e);
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.getText();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        JTable t = (JTable)anEvent.getSource();
        return !t.isRowSelected(t.getEditingRow());
    }

    @Override
    public boolean stopCellEditing() {
        if (!this.isEdited) {
            this.cancelCellEditing();
            return true;
        }
        ChangeEvent e = new ChangeEvent(this);
        Vector<CellEditorListener> list = new Vector<CellEditorListener>(this.listeners);
        for (CellEditorListener listener : list) {
            listener.editingStopped(e);
        }
        return true;
    }
}

