/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class OrderedMouseListener
implements MouseListener {
    private MouseListener[] listeners;

    public OrderedMouseListener(MouseListener ... iListeners) {
        this.listeners = iListeners;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.processCall("mouseEntered", e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.processCall("mouseExited", e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.processCall("mousePressed", e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.processCall("mouseReleased", e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.processCall("mouseClicked", e);
    }

    private void processCall(String name, MouseEvent e) {
        try {
            Method m = MouseListener.class.getMethod(name, MouseEvent.class);
            for (int i = 0; i < this.listeners.length; ++i) {
                try {
                    m.invoke((Object)this.listeners[i], e);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
    }
}

