/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import se.sjobeck.gui.SettingsDialog;
import se.sjobeck.network2.NetWorkCommunicator;

public class FileRestorer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreFile() {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(0);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Bakfiler", "bak");
        jfc.addChoosableFileFilter(filter);
        jfc.setAcceptAllFileFilterUsed(false);
        int showDialog = jfc.showDialog(null, "V\u00e4lj lokal s\u00e4kerhetskopia");
        if (showDialog == 0) {
            FileInputStream input = null;
            ByteArrayOutputStream baos = null;
            DeflaterOutputStream goz = null;
            GZIPInputStream giz = null;
            try {
                File fileToConvert = jfc.getSelectedFile();
                String fileName = fileToConvert.getName();
                if (fileName != null && !fileName.isEmpty()) {
                    byte[] tempData = new byte[(int)fileToConvert.length()];
                    input = new FileInputStream(fileToConvert);
                    giz = new GZIPInputStream(input);
                    baos = new ByteArrayOutputStream();
                    goz = new GZIPOutputStream(baos);
                    int read = 0;
                    while ((read = giz.read(tempData)) > 0) {
                        ((GZIPOutputStream)goz).write(tempData, 0, read);
                    }
                    ((GZIPOutputStream)goz).finish();
                    byte[] outData = baos.toByteArray();
                    if (fileName.indexOf(".") > 0) {
                        fileName = fileName.substring(0, fileName.lastIndexOf("."));
                    }
                    NetWorkCommunicator.writeFile(fileName, outData);
                }
            }
            catch (IOException err) {
                Logger.getLogger(SettingsDialog.class.getName()).log(Level.SEVERE, null, err);
            }
            finally {
                if (goz != null) {
                    try {
                        goz.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(FileRestorer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (giz != null) {
                    try {
                        giz.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(FileRestorer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(FileRestorer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(FileRestorer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }
}

