/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.sjobeck.datastructures.KommentarNod;
import se.sjobeck.gui.AntialiasedJLabel;

public class CommentPane
extends JPanel {
    KommentarNod currentNode;
    private Observer treeObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            if (arg != null && arg.equals(CommentPane.this.currentNode)) {
                CommentPane.this.kommentarLabel.setText(CommentPane.this.currentNode.getBeskrivning());
            }
        }
    };
    DocumentListener kommentarListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            Logger.getLogger("se.sjobeck").entering("KalkylGUI.documentListener", "changedUpdate", e);
            this.updateDescription();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            Logger.getLogger("se.sjobeck").entering("KalkylGUI.documentListener", "insertUpdate", e);
            this.updateDescription();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            Logger.getLogger("se.sjobeck").entering("KalkylGUI.documentListener", "removeUpdate", e);
            this.updateDescription();
        }

        private void updateDescription() {
            CommentPane.this.currentNode.kommentar = CommentPane.this.kommentarText.getText();
        }
    };
    private JScrollPane kommentar;
    private JLabel kommentarLabel;
    private JTextArea kommentarText;

    public CommentPane() {
        this.initComponents();
        this.kommentarText.getDocument().addDocumentListener(this.kommentarListener);
    }

    public void setKommentar(KommentarNod n) {
        this.currentNode = n;
        this.currentNode.getProject().setTreeObserver(this.treeObserver);
        this.kommentarLabel.setText(this.currentNode.getBeskrivning());
        this.kommentarText.setText(this.currentNode.kommentar);
    }

    private void initComponents() {
        this.kommentar = new JScrollPane();
        this.kommentarText = new JTextArea();
        this.kommentarLabel = new AntialiasedJLabel();
        this.setLayout(new GridBagLayout());
        this.kommentarText.setLineWrap(true);
        this.kommentar.setViewportView(this.kommentarText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 24, 5, 5);
        this.add((Component)this.kommentar, gridBagConstraints);
        this.kommentarLabel.setFont(new Font("SansSerif", 1, 24));
        this.kommentarLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/tangoProject/large/emblem-important.png")));
        this.kommentarLabel.setText("Kommentar");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 24, 20, 5);
        this.add((Component)this.kommentarLabel, gridBagConstraints);
    }
}

