/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Vector;
import se.sjobeck.datastructures.Drawing;
import se.sjobeck.datastructures.DrawingLine;
import se.sjobeck.parser2.Function;

public abstract class VertexDrawing
extends Drawing {
    protected String description;
    private transient Rectangle cachedConstraints = null;
    private transient Area cachedArea;
    protected transient AffineTransform areaTransform;

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void makeVariables(Vector<Function> variables, List<Point2D> vertices, GeneralPath path) {
        String omkrets = "";
        String totalV\u00e4ggYta = "";
        String add = " + ";
        int size = vertices.size();
        for (int i = 1; i <= size; ++i) {
            variables.add(new Function("L" + i, "" + vertices.get(i - 1).distance(vertices.get(i < size ? i : 0)), "L\u00e4ngd, v\u00e4gg #" + i));
            variables.add(new Function("V" + i, "L" + i + " * H", "V\u00e4ggyta #" + i));
            omkrets = omkrets + " L" + i;
            totalV\u00e4ggYta = totalV\u00e4ggYta + "V" + i;
            if (i >= vertices.size()) continue;
            omkrets = omkrets + " + ";
            totalV\u00e4ggYta = totalV\u00e4ggYta + " + ";
        }
        variables.add(new Function("O", omkrets, "Omkrets"));
        variables.add(new Function("V", totalV\u00e4ggYta, "Total V\u00e4ggyta"));
    }

    public abstract Shape getShape();

    public abstract Rectangle2D getBounds();

    @Override
    public abstract Vector<Function> getVariables();

    public abstract int getLabelCount();

    public abstract String getLabel(int var1);

    public abstract Point2D getLabelPosition(int var1);

    @Override
    public abstract Drawing copy();

    @Override
    public void paintDrawing(Graphics2D g2, Rectangle constraints) {
        if (!constraints.equals(this.cachedConstraints)) {
            Rectangle2D bounds = this.getBounds();
            double scale = Math.min((double)constraints.width / bounds.getWidth(), (double)constraints.height / bounds.getHeight());
            this.areaTransform = AffineTransform.getTranslateInstance(-bounds.getX(), -bounds.getY());
            this.areaTransform.preConcatenate(AffineTransform.getScaleInstance(scale, scale));
            this.areaTransform.preConcatenate(AffineTransform.getTranslateInstance((double)constraints.x + ((double)constraints.width - scale * bounds.getWidth()) / 2.0, (double)constraints.y + ((double)constraints.height - scale * bounds.getHeight()) / 2.0));
            this.cachedArea = new Area(this.getShape());
            this.cachedArea.transform(this.areaTransform);
        }
        g2.draw(this.cachedArea);
        Point2D.Double center = new Point2D.Double();
        for (int i = 0; i < this.getLabelCount(); ++i) {
            if (this.getLabel(i) == null || this.getLabel(i).equals("")) continue;
            Point2D original = this.getLabelPosition(i);
            this.areaTransform.transform(original, center);
            FontRenderContext context = g2.getFontRenderContext();
            Rectangle2D fontBounds = g2.getFont().getStringBounds(this.getLabel(i), context);
            g2.drawString(this.getLabel(i), (float)(((Point2D)center).getX() - fontBounds.getWidth() / 2.0), (float)(((Point2D)center).getY() + fontBounds.getHeight() / 2.0));
        }
    }

    @Override
    public DrawingLine getLine(Point2D p) {
        return this.getLine(p, this.areaTransform);
    }

    protected abstract DrawingLine getLine(Point2D var1, AffineTransform var2);
}

